/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.global;

import com.flurry.javame.FlurryAgent;
import com.youversion.ApiBase;
import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.events.core.Event;
import com.youversion.objects.Bookmark;
import com.youversion.objects.BookmarkCollection;
import com.youversion.objects.Reference;
import com.youversion.objects.User;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Debug;
import de.enough.polish.util.Locale;
import java.io.InputStream;
import java.util.Hashtable;

public class OPTIONS {
    public static final String PERSISTENCE_KEY = "options://";
    public static final String FALLBACK_LOCALE = "en";
    public static Object[] options = new Object[30];
    public static final int KEY_FONT_SIZE = 0;
    public static final int KEY_USERNAME_PASSWORD_USER = 1;
    public static final int KEY_SHOW_LOGIN_FORM_AT_STARTUP = 2;
    public static final int KEY_LAST_READER_BOOKMARK = 3;
    public static final int KEY_LOW_LIGHT = 4;
    public static final int KEY_LANGUAGE = 5;
    public static final int KEY_BOOKMARKS = 6;
    public static final int KEY_UNIQUE_ID = 7;
    public static final int KEY_DO_NOT_SHOW_AGAIN = 8;
    public static final int FONT_SIZE_SMALL = 1;
    public static final int FONT_SIZE_MEDIUM = 2;
    public static final int FONT_SIZE_LARGE = 3;

    public static void setOption(int optionKey, Object value) {
        if (optionKey == 3) {
            Bookmark thisBookmark = (Bookmark)value;
            Bookmark previousBookmark = (Bookmark)OPTIONS.getOption(3);
            if (previousBookmark == null || !thisBookmark.getVersion().equals(previousBookmark.getVersion())) {
                String curVer = thisBookmark.getVersion();
                String prevVer = "none";
                if (previousBookmark != null) {
                    prevVer = previousBookmark.getVersion();
                }
                try {
                    Debug.debug("debug", "com.youversion.application.global.OPTIONS", 77, (Object)("Switched bible versions: " + prevVer + " -> "), curVer);
                    Hashtable<String, String> params = new Hashtable<String, String>();
                    params.put("from", prevVer);
                    params.put("to", curVer);
                    FlurryAgent.onEvent("SwitchBibleVersions", params);
                }
                catch (Throwable t) {
                    Debug.debug("debug", "com.youversion.application.global.OPTIONS", 85, t.getMessage());
                }
            }
        }
        OPTIONS.options[optionKey] = value;
        OPTIONS.save();
    }

    public static Object getOption(int optionKey) {
        Object result = options[optionKey];
        return result;
    }

    public static void load(Object[] optsArray) {
        if (optsArray != null) {
            options = optsArray;
        } else {
            OPTIONS.setOption(0, new Integer(2));
            OPTIONS.setOption(1, new Object[]{null, null, null});
            OPTIONS.setOption(4, Boolean.FALSE);
            OPTIONS.setOption(2, Boolean.TRUE);
            OPTIONS.setLanguageAndBibleDefaults();
            BookmarkCollection bookmarks = new BookmarkCollection();
            bookmarks.setTotal(1);
            OPTIONS.setOption(6, bookmarks);
            OPTIONS.setOption(7, new Integer(1));
            OPTIONS.setOption(8, new ArrayList());
        }
    }

    public static int getNextUniqueID() {
        Integer value = (Integer)OPTIONS.getOption(7);
        int result = value;
        OPTIONS.setOption(7, new Integer(result + 1));
        return result;
    }

    public static String getLanguage() {
        String language = (String)options[5];
        return language;
    }

    public static boolean isLowLightMode() {
        Boolean lowLightMode = (Boolean)options[4];
        return lowLightMode == null ? false : lowLightMode;
    }

    public static void save() {
        EVENT_SYSTEM.queueEvent(880001, new Object[]{PERSISTENCE_KEY, options});
    }

    public static boolean isLoggedIn() {
        return OPTIONS.getUser() != null;
    }

    public static User getUser() {
        Object[] object = (Object[])OPTIONS.getOption(1);
        return (User)object[2];
    }

    public static boolean handleLogin(Event onLoggedInEvent) {
        if (OPTIONS.getUser() == null) {
            Event loginEvent = new Event(990008, onLoggedInEvent);
            EVENT_SYSTEM.queueEvent(990014, new Object[]{Locale.get(142), Locale.get(150), loginEvent});
            return false;
        }
        return true;
    }

    public static void setLanguageAndBibleDefaults() {
        String locale = OPTIONS.getLanguageFileForCurrentLocale();
        OPTIONS.setLanguageAndBibleDefaults(locale);
    }

    public static void setLanguageAndBibleDefaults(String locale) {
        OPTIONS.setOption(5, locale);
        Hashtable<String, String> versions = new Hashtable<String, String>();
        versions.put("de", "delut");
        versions.put("fi", "finpr");
        versions.put("hu", "kar");
        versions.put("id", "idbar");
        versions.put("it", "itriv");
        versions.put("ja", "ja1955");
        versions.put("ko", "korvb");
        versions.put("nl", "sv1750");
        versions.put("pt", "aa");
        versions.put("ru", "rursv");
        versions.put("sv", "sven");
        versions.put("vi", "vi1934");
        versions.put("zh_CN", "cuvs");
        versions.put("zh_TW", "cuv");
        versions.put(FALLBACK_LOCALE, "kjv");
        versions.put("ro", "vdc");
        versions.put("es", "rvr60");
        String versionToUse = (String)versions.get(locale);
        Reference defaultReference = new Reference("Gen", 1, "Genesis");
        Bookmark defaultBookmark = new Bookmark(versionToUse, defaultReference);
        OPTIONS.setOption(3, defaultBookmark);
        ApiBase.setLocale(locale);
    }

    public static String getLanguageFileForCurrentLocale() {
        try {
            String meLocale = System.getProperty("microedition.locale");
            String loc = null;
            String res = null;
            InputStream in = null;
            if (meLocale != null) {
                loc = "/" + meLocale + ".loc";
                in = loc.getClass().getResourceAsStream(loc);
                res = meLocale;
                if (in == null && meLocale.length() > 2) {
                    loc = "/" + meLocale.substring(0, 2) + ".loc";
                    in = loc.getClass().getResourceAsStream(loc);
                    res = meLocale.substring(0, 2);
                }
            }
            if (in == null) {
                return FALLBACK_LOCALE;
            }
            return res;
        }
        catch (Exception ex) {
            return FALLBACK_LOCALE;
        }
    }

    public static String getAppVersion() {
        String version = "";
        version = "1.0.3.2239";
        return version;
    }

    public static Integer getAppIteration() {
        return new Integer(1);
    }

    public static boolean getDoNotShowAgainStatus(String itemID) {
        ArrayList items = (ArrayList)options[8];
        return items.indexOf(itemID) != -1;
    }

    public static void setDoNotShowAgainStatus(String itemID, boolean status) {
        ArrayList items = (ArrayList)options[8];
        if (status) {
            items.remove(itemID);
            items.add(itemID);
        } else {
            items.remove(itemID);
        }
        OPTIONS.save();
    }
}

