/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.controllers.navigation;

import com.youversion.apiextension.objects.J2MENotification;
import com.youversion.apiextension.objects.J2MEUpgradeNotification;
import com.youversion.application.controllers.core.NavigationController;
import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.events.core.Event;
import com.youversion.application.global.OPTIONS;
import com.youversion.application.model.NotificationManager;
import com.youversion.application.views.AlertForm;
import com.youversion.application.views.notifications.UpdateNotificationForm;
import com.youversion.objects.Notification;
import com.youversion.objects.NotificationCollection;
import com.youversion.utils.NotificationsUtil;
import com.youversion.utils.VersioningUtils;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Locale;

public class NotificationsController
extends NavigationController {
    public void processEvent(Event event) {
        switch (event.getType()) {
            case 200045: {
                this.handleReceivedNotifications(event);
                break;
            }
            case 990053: {
                this.handleShowNotificationForm(event);
            }
        }
    }

    public void handleShowNotificationForm(Event event) {
        Notification notification = (Notification)event.getPayload();
        J2MENotification j2meNotification = NotificationsUtil.notificationToJ2meNotification(notification);
        if (j2meNotification instanceof J2MEUpgradeNotification) {
            NotificationManager.getInstance().setActiveNotification(notification);
            UpdateNotificationForm notificationForm = new UpdateNotificationForm(StyleSheet.base_screenStyle);
            NotificationsController.showDisplayable(notificationForm);
        }
    }

    public void handleReceivedNotifications(Event event) {
        NotificationCollection collection = (NotificationCollection)event.getPayload();
        NotificationManager.getInstance().setCollection(collection);
        if (collection == null) {
            return;
        }
        boolean hasNewNotifications = false;
        for (int i = 0; i < collection.size(); ++i) {
            J2MEUpgradeNotification upgradeNotification;
            Notification notification = collection.elementAt(i);
            J2MENotification j2meNotification = NotificationsUtil.notificationToJ2meNotification(notification);
            if (j2meNotification == null || !(j2meNotification instanceof J2MEUpgradeNotification) || !VersioningUtils.compare((upgradeNotification = (J2MEUpgradeNotification)j2meNotification).getUpgradeToVersion(), OPTIONS.getAppVersion()) || OPTIONS.getDoNotShowAgainStatus(upgradeNotification.getUpgradeToVersion())) continue;
            hasNewNotifications = true;
            Event showDashboard = new Event(990006);
            Event showNotification = new Event(990053, notification);
            Event doNotShowAgainEvent = new Event(100014, upgradeNotification.getUpgradeToVersion());
            AlertForm.showOkDismissDoNotShowThisAgain(Locale.get(142), upgradeNotification.get(OPTIONS.getLanguage()).getTeaser(), showNotification, showDashboard, doNotShowAgainEvent);
        }
        if (!hasNewNotifications) {
            EVENT_SYSTEM.queueEvent(990006);
        }
    }

    public void release() {
    }
}

