/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.controllers.navigation;

import com.youversion.application.controllers.core.NavigationController;
import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.events.core.Event;
import com.youversion.application.events.core.EventListener;
import com.youversion.exceptions.YouVersionApiException;
import com.youversion.objects.ApiError;
import de.enough.polish.util.Locale;
import java.util.Vector;

public class ErrorController
implements EventListener {
    public ErrorController() {
        EVENT_SYSTEM.registerListener(this);
    }

    public void processEvent(Event event) {
        switch (event.getType()) {
            case 0: {
                String title = Locale.get(138);
                String content = Locale.get(139);
                if (event.getPayload() != null) {
                    Exception exception = (Exception)event.getPayload();
                    if (exception instanceof YouVersionApiException) {
                        YouVersionApiException apiException = (YouVersionApiException)exception;
                        Vector errors = apiException.getErrors();
                        if (apiException.getMessage() != null) {
                            content = content + apiException.getMessage();
                        }
                        for (int index = 0; index < errors.size(); ++index) {
                            ApiError apiError = (ApiError)errors.elementAt(index);
                            String error = apiError.getError();
                            content = content + "\n\n" + error;
                        }
                    } else {
                        content = content + "\n\n" + exception.getMessage();
                    }
                }
                NavigationController.hideLoading();
                EVENT_SYSTEM.queueEvent(990014, new Object[]{title, content, null});
            }
        }
    }
}

