/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.controllers.navigation;

import com.youversion.application.controllers.core.NavigationController;
import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.events.core.Event;
import com.youversion.application.model.BibleReaderManager;
import com.youversion.application.model.reader.BookmarkChapterDescriptor;
import com.youversion.application.model.reader.ChapterDescriptor;
import com.youversion.application.views.notes.SelectVersesForm;
import com.youversion.application.views.reader.BibleBookChaptersForm;
import com.youversion.application.views.reader.BibleBooksForm;
import com.youversion.application.views.reader.BibleLanguagesForm;
import com.youversion.application.views.reader.BibleReadChapterForm;
import com.youversion.application.views.reader.BibleVersionsForm;
import com.youversion.application.views.settings.SettingsReaderForm;
import com.youversion.objects.Book;
import com.youversion.objects.Version;
import de.enough.polish.ui.StyleSheet;

public class BibleReaderController
extends NavigationController {
    private BibleReadChapterForm bibleReadChapterForm;
    private SelectVersesForm selectVersesForm;

    public void processEvent(Event event) {
        BibleReaderManager bibleReaderManager = BibleReaderManager.getInstance();
        ChapterDescriptor chapterDescriptor = bibleReaderManager.getChapterDescriptor();
        ChapterDescriptor workChapterDescriptor = bibleReaderManager.getWorkChapterDescriptor();
        Object payload = event.getPayload();
        switch (event.getType()) {
            case 990005: {
                BibleLanguagesForm bibleLanguagesForm = new BibleLanguagesForm(StyleSheet.base_screenStyle);
                BibleReaderController.showDisplayable(bibleLanguagesForm);
                break;
            }
            case 990001: {
                BibleVersionsForm bibleVersionsForm = new BibleVersionsForm(StyleSheet.base_screenStyle);
                BibleReaderController.showDisplayable(bibleVersionsForm);
                break;
            }
            case 990002: {
                boolean versionChanged;
                Version workVersion = workChapterDescriptor.getVersion();
                Version currentVersion = bibleReaderManager.getContext() == 0 ? chapterDescriptor.getVersion() : workChapterDescriptor.getVersion();
                boolean bl = versionChanged = !workVersion.getAbbreviation().equals(currentVersion.getAbbreviation());
                if (!versionChanged) {
                    BibleBooksForm bibleBooksForm = new BibleBooksForm(StyleSheet.base_screenStyle);
                    BibleReaderController.showDisplayable(bibleBooksForm);
                    break;
                }
                BibleReaderController.showLoading();
                EVENT_SYSTEM.queueEvent(10003, 2, workVersion);
                break;
            }
            case 990003: {
                BibleBookChaptersForm bibleBookChaptersForm = new BibleBookChaptersForm(StyleSheet.base_screenStyle);
                BibleReaderController.showDisplayable(bibleBookChaptersForm);
                break;
            }
            case 990004: {
                BibleReaderController.showLoading();
                BibleReaderManager.getInstance().setContext(0);
                if (payload instanceof BookmarkChapterDescriptor) {
                    EVENT_SYSTEM.queueEvent(100010, 2, payload);
                    return;
                }
                if (!(payload instanceof Object[])) break;
                Integer readChapterNr = (Integer)((Object[])payload)[0];
                Book readChapterBook = (Book)((Object[])payload)[1];
                Version readChapterVersion = (Version)((Object[])payload)[2];
                EVENT_SYSTEM.queueEvent(10005, 2, new Object[]{readChapterNr, readChapterBook, readChapterVersion});
                return;
            }
            case 990051: {
                BibleReaderController.showLoading();
                BibleReaderManager.getInstance().setContext(1);
                if (payload instanceof BookmarkChapterDescriptor) {
                    EVENT_SYSTEM.queueEvent(100010, 2, payload);
                    return;
                }
                if (!(payload instanceof Object[])) break;
                Integer readChapterNr = (Integer)((Object[])payload)[0];
                Book readChapterBook = (Book)((Object[])payload)[1];
                Version readChapterVersion = (Version)((Object[])payload)[2];
                EVENT_SYSTEM.queueEvent(10005, 2, new Object[]{readChapterNr, readChapterBook, readChapterVersion});
                return;
            }
            case 990007: {
                SettingsReaderForm readerOptionsForm = new SettingsReaderForm(StyleSheet.base_screenStyle);
                BibleReaderController.showDisplayable(readerOptionsForm);
                break;
            }
            case 10004: {
                BibleBooksForm bibleBooksForm = new BibleBooksForm(StyleSheet.base_screenStyle);
                BibleReaderController.showDisplayable(bibleBooksForm);
                break;
            }
            case 100006: {
                if (bibleReaderManager.getContext() == 0) {
                    bibleReaderManager.commit();
                    if (this.bibleReadChapterForm == null) {
                        this.bibleReadChapterForm = new BibleReadChapterForm(StyleSheet.reader_screenStyle);
                    }
                    this.bibleReadChapterForm.setContent();
                    BibleReaderController.showDisplayable(this.bibleReadChapterForm);
                    break;
                }
                if (bibleReaderManager.getContext() != 1) break;
                if (this.selectVersesForm == null) {
                    this.selectVersesForm = new SelectVersesForm(StyleSheet.base_screenStyle);
                }
                this.selectVersesForm.setContent();
                BibleReaderController.showDisplayable(this.selectVersesForm);
                break;
            }
            case 770001: {
                if (this.bibleReadChapterForm == null) break;
                this.bibleReadChapterForm.setContent();
            }
        }
    }

    public void release() {
        this.bibleReadChapterForm = null;
        this.selectVersesForm = null;
    }
}

