/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.controllers.data;

import com.youversion.BibleApi;
import com.youversion.BookmarksApi;
import com.youversion.EventItemsApi;
import com.youversion.EventsApi;
import com.youversion.LiveApi;
import com.youversion.NotesApi;
import com.youversion.NotificationsApi;
import com.youversion.ReadingPlanApi;
import com.youversion.UsersApi;
import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.events.core.Event;
import com.youversion.application.events.core.EventListener;
import com.youversion.application.global.GLOBAL;
import com.youversion.application.global.NAVIGATION_HISTORY;
import com.youversion.application.global.OPTIONS;
import com.youversion.application.model.BibleReferenceManager;
import com.youversion.application.model.BookmarksManager;
import com.youversion.application.model.LiveManager;
import com.youversion.application.model.NotificationManager;
import com.youversion.application.model.ReadingPlansManager;
import com.youversion.application.model.SearchManager;
import com.youversion.application.model.plans.ReadingPlansDescriptor;
import com.youversion.application.views.core.Notification;
import com.youversion.exceptions.YouVersionApiException;
import com.youversion.internal.BibleApiPrivate;
import com.youversion.internal.Chapter;
import com.youversion.objects.BibleSearchResult;
import com.youversion.objects.Book;
import com.youversion.objects.BookCollection;
import com.youversion.objects.Bookmark;
import com.youversion.objects.BookmarkCollection;
import com.youversion.objects.BookmarkLabelCollection;
import com.youversion.objects.LiveEvent;
import com.youversion.objects.LiveEventCollection;
import com.youversion.objects.LiveEventPollResultItem;
import com.youversion.objects.Note;
import com.youversion.objects.NoteCollection;
import com.youversion.objects.NotificationCollection;
import com.youversion.objects.ReadingPlan;
import com.youversion.objects.ReadingPlanAdjustedDayCollection;
import com.youversion.objects.ReadingPlanCollection;
import com.youversion.objects.ReadingPlanDay;
import com.youversion.objects.ReadingPlanSubscription;
import com.youversion.objects.Reference;
import com.youversion.objects.ReferenceCollection;
import com.youversion.objects.User;
import com.youversion.objects.VerseCollection;
import com.youversion.objects.Version;
import com.youversion.objects.VersionCollection;
import com.youversion.utils.ExceptionUtil;
import de.enough.polish.util.Locale;
import java.util.Vector;

public class NetworkingController
implements EventListener {
    public static final String NETWORKING_ERROR = "(10001)";

    public NetworkingController() {
        EVENT_SYSTEM.registerListener(this);
    }

    public void processEvent(Event event) {
        try {
            switch (event.getType()) {
                case 20000: {
                    VersionCollection versionCollection = BibleApiPrivate.getVersions(GLOBAL.API_CONNECTION);
                    EVENT_SYSTEM.queueEvent(200001, 2, versionCollection);
                    break;
                }
                case 20001: {
                    VersionCollection versionCollection = BibleApiPrivate.getVersions(GLOBAL.API_CONNECTION);
                    EVENT_SYSTEM.queueEvent(20002, 2, versionCollection);
                    break;
                }
                case 20003: {
                    Version v = (Version)event.getPayload();
                    BookCollection bookCollection = BibleApi.getBooks(GLOBAL.API_CONNECTION, v.getAbbreviation());
                    EVENT_SYSTEM.queueEvent(20004, 2, new Object[]{bookCollection, v});
                    break;
                }
                case 20005: {
                    Object[] payload = (Object[])event.getPayload();
                    Integer readChapterNr = (Integer)payload[0];
                    Book readChapterBook = (Book)payload[1];
                    Version readChapterVersion = (Version)payload[2];
                    Chapter readChapterResultChapter = BibleApiPrivate.getChapter(GLOBAL.API_CONNECTION, readChapterVersion.getAbbreviation(), readChapterBook.getAbbreviation() + "." + readChapterNr.toString(), BibleApiPrivate.FORMAT_TEXT);
                    Object[] readChapterResult = new Object[]{readChapterResultChapter, readChapterNr, readChapterBook, readChapterVersion};
                    EVENT_SYSTEM.queueEvent(200006, 2, readChapterResult);
                    break;
                }
                case 200007: {
                    Object[] authenticatePayload = (Object[])event.getPayload();
                    String authUsername = (String)authenticatePayload[0];
                    String authPassword = (String)authenticatePayload[1];
                    User authUser = null;
                    try {
                        authUser = UsersApi.authenticate(GLOBAL.API_CONNECTION, authUsername, authPassword);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    EVENT_SYSTEM.queueEvent(200008, new Object[]{authUsername, authPassword, authUser});
                    break;
                }
                case 200009: {
                    User bookmarksRequestUser;
                    Integer bookmarksRequestUserId = null;
                    Integer bookmarksRequestPage = null;
                    if (event.getPayload() != null) {
                        bookmarksRequestPage = (Integer)event.getPayload();
                    }
                    if ((bookmarksRequestUser = (User)((Object[])OPTIONS.getOption(1))[2]) != null) {
                        bookmarksRequestUserId = new Integer(bookmarksRequestUser.getId());
                    }
                    String bookmarkLabelFilter = null;
                    if (BookmarksManager.getInstance().getCurrentLabelFilter() != null) {
                        bookmarkLabelFilter = BookmarksManager.getInstance().getCurrentLabelFilter().getLabel();
                    }
                    BookmarkCollection requestBookmarksResponse = null;
                    requestBookmarksResponse = BookmarksApi.items(GLOBAL.API_CONNECTION, bookmarksRequestUserId, bookmarkLabelFilter, bookmarksRequestPage);
                    EVENT_SYSTEM.queueEvent(200010, 2, new Object[]{bookmarksRequestPage, requestBookmarksResponse});
                    break;
                }
                case 200011: {
                    String deleteBookmarksUsername = (String)((Object[])OPTIONS.getOption(1))[0];
                    String deleteBookmarksPassword = (String)((Object[])OPTIONS.getOption(1))[1];
                    Bookmark deleteBookmark = (Bookmark)event.getPayload();
                    boolean done = BookmarksApi.delete(GLOBAL.API_CONNECTION, deleteBookmarksUsername, deleteBookmarksPassword, new Long(deleteBookmark.getId()));
                    if (!done) break;
                    Notification.show(Locale.get(15), NAVIGATION_HISTORY.peek());
                    break;
                }
                case 200012: {
                    String createBookmarksUsername = (String)((Object[])OPTIONS.getOption(1))[0];
                    String createBookmarksPassword = (String)((Object[])OPTIONS.getOption(1))[1];
                    ReferenceCollection createBookmarksReferenceCollection = new ReferenceCollection();
                    if (event.getPayload() instanceof BookmarkCollection) {
                        BookmarkCollection bookmarks = (BookmarkCollection)event.getPayload();
                        for (int i = 0; i < bookmarks.size(); ++i) {
                            Bookmark temp = (Bookmark)bookmarks.elementAt(i);
                            BookmarksApi.create(GLOBAL.API_CONNECTION, createBookmarksUsername, createBookmarksPassword, temp);
                        }
                        break;
                    }
                    if (event.getPayload() instanceof Bookmark) {
                        Bookmark bookmark = (Bookmark)event.getPayload();
                        if (bookmark.getId() <= 0L) {
                            BookmarksApi.create(GLOBAL.API_CONNECTION, createBookmarksUsername, createBookmarksPassword, bookmark);
                            break;
                        }
                        BookmarksApi.create(GLOBAL.API_CONNECTION, createBookmarksUsername, createBookmarksPassword, bookmark);
                        break;
                    }
                    Object[] createBookmarksPayload = (Object[])event.getPayload();
                    String createBookmarksVersion = (String)createBookmarksPayload[0];
                    Reference[] createBookmarksReferences = (Reference[])createBookmarksPayload[1];
                    for (int i = 0; i < createBookmarksReferences.length; ++i) {
                        createBookmarksReferenceCollection.addElement(createBookmarksReferences[i]);
                    }
                    Bookmark bookmark = new Bookmark(createBookmarksVersion, createBookmarksReferenceCollection.toOsis());
                    BookmarksApi.create(GLOBAL.API_CONNECTION, createBookmarksUsername, createBookmarksPassword, bookmark);
                    break;
                }
                case 200013: {
                    String shareContentUsername = (String)((Object[])OPTIONS.getOption(1))[0];
                    String shareContentPassword = (String)((Object[])OPTIONS.getOption(1))[1];
                    Object[] shareEventPayload = (Object[])event.getPayload();
                    UsersApi.share(GLOBAL.API_CONNECTION, shareContentUsername, shareContentPassword, (String)shareEventPayload[0], (String)shareEventPayload[1], (Vector)shareEventPayload[2]);
                    break;
                }
                case 200014: {
                    this.handleRequestPlanCategoryDetails(event);
                    break;
                }
                case 200016: {
                    Object[] requestIndividualPlanDayPayload = (Object[])event.getPayload();
                    ReadingPlan reqestIndividualPlanDayPlan = (ReadingPlan)requestIndividualPlanDayPayload[0];
                    Integer requestIndividualPlanDayNo = (Integer)requestIndividualPlanDayPayload[1];
                    String requestIndividualPlanDayUsername = (String)((Object[])OPTIONS.getOption(1))[0];
                    String requestIndividualPlanDayPassword = (String)((Object[])OPTIONS.getOption(1))[1];
                    User requestIndividualPlanUser = (User)((Object[])OPTIONS.getOption(1))[2];
                    Integer requestIndividualPlanUserId = null;
                    if (requestIndividualPlanUser != null) {
                        requestIndividualPlanUserId = new Integer(requestIndividualPlanUser.getId());
                    }
                    ReadingPlanDay requestIndividualPlanDayResult = ReadingPlanApi.references(GLOBAL.API_CONNECTION, requestIndividualPlanDayUsername, requestIndividualPlanDayPassword, requestIndividualPlanUserId, new Integer(reqestIndividualPlanDayPlan.getId()), requestIndividualPlanDayNo);
                    BibleReferenceManager bibleReferenceManager = BibleReferenceManager.getInstance();
                    bibleReferenceManager.setReadingPlanDay(requestIndividualPlanDayResult);
                    EVENT_SYSTEM.queueEvent(200017, 2, requestIndividualPlanDayResult);
                    break;
                }
                case 200018: {
                    this.handleBeRequestReference(event);
                    break;
                }
                case 200020: {
                    this.handleRequestMyPlans(event);
                    break;
                }
                case 200022: {
                    this.handleRequestIndividualPlanDetails((ReadingPlan)event.getPayload());
                    break;
                }
                case 200024: {
                    this.handleResetSubscription(event);
                    break;
                }
                case 200025: {
                    this.handleSubscribeToPlan(event);
                    break;
                }
                case 200026: {
                    this.handleUnsubscribeFromPlan(event);
                    break;
                }
                case 200027: {
                    this.handleUpdatePlanCompletion(event);
                    break;
                }
                case 200028: {
                    this.handleRequestSearchResults(event);
                    break;
                }
                case 200030: {
                    this.handleRequestMyNotes(event);
                    break;
                }
                case 200032: {
                    this.handeRequestPublicNotesForReference(event);
                    break;
                }
                case 200034: {
                    this.handleRequestLiveSearchResults(event);
                    break;
                }
                case 200036: {
                    this.handleRequestLiveEvent(event);
                    break;
                }
                case 200038: {
                    this.handleSubmitLivePrayerResponse(event);
                    break;
                }
                case 200040: {
                    this.handleSubmitLiveQAResponse(event);
                }
                case 200042: {
                    this.handleSubmitLivePollResponse(event);
                    break;
                }
                case 200044: {
                    this.handleNotificationRequest(event);
                    break;
                }
                case 200046: {
                    this.handleSaveNote(event);
                    break;
                }
                case 200049: {
                    this.handleDeleteNote(event);
                    break;
                }
                case 200051: {
                    this.handleRequestBookmarksLabels(event);
                }
            }
        }
        catch (YouVersionApiException ex) {
            EVENT_SYSTEM.queueEvent(0, ExceptionUtil.addErrorMessage(ex, NETWORKING_ERROR));
        }
        catch (Throwable ex) {
            EVENT_SYSTEM.queueEvent(0, new YouVersionApiException(ex));
        }
    }

    public void handleRequestBookmarksLabels(Event event) throws YouVersionApiException {
        Integer page = (Integer)event.getPayload();
        User user = (User)((Object[])OPTIONS.getOption(1))[2];
        BookmarkLabelCollection result = BookmarksApi.labels(GLOBAL.API_CONNECTION, new Integer(user.getId()), page);
        EVENT_SYSTEM.queueEvent(200052, 2, new Object[]{page, result});
    }

    public void handleDeleteNote(Event event) throws YouVersionApiException {
        Note note = (Note)event.getPayload();
        String username = (String)((Object[])OPTIONS.getOption(1))[0];
        String password = (String)((Object[])OPTIONS.getOption(1))[1];
        NotesApi.delete(GLOBAL.API_CONNECTION, username, password, note.getId());
        EVENT_SYSTEM.queueEvent(200050, event.getContext(), 2, note);
    }

    public void handleSaveNote(Event event) throws YouVersionApiException {
        Note note = (Note)event.getPayload();
        String username = (String)((Object[])OPTIONS.getOption(1))[0];
        String password = (String)((Object[])OPTIONS.getOption(1))[1];
        User user = (User)((Object[])OPTIONS.getOption(1))[2];
        String YVML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE yv-note SYSTEM \"http://api.youversion.com/pub/yvml_1_0.dtd\">\n<yv-note>" + note.getContentText() + "</yv-note>";
        note.setContentYvml(YVML);
        Note result = null;
        if (note.getId() == 0L) {
            result = NotesApi.create(GLOBAL.API_CONNECTION, username, password, note, null);
            EVENT_SYSTEM.queueEvent(200048, event.getContext(), 2, result);
        } else {
            result = NotesApi.update(GLOBAL.API_CONNECTION, username, password, note, null);
            EVENT_SYSTEM.queueEvent(200047, event.getContext(), 2, result);
        }
    }

    public void handeRequestPublicNotesForReference(Event event) throws YouVersionApiException {
        Object[] payload = (Object[])event.getPayload();
        Integer page = (Integer)payload[0];
        NoteCollection results = null;
        ReferenceCollection references = new ReferenceCollection();
        if (payload[1] instanceof Reference) {
            references.addElement((Reference)payload[1]);
        } else {
            references.addAll((ReferenceCollection)payload[1]);
        }
        try {
            results = NotesApi.items(GLOBAL.API_CONNECTION, null, references, (int)page);
        }
        catch (YouVersionApiException ex) {
            if (ex.getStatusCode() == 404) {
                results = new NoteCollection();
            }
            throw ex;
        }
        EVENT_SYSTEM.queueEvent(200033, 2, new Object[]{page, references, results});
    }

    public void handleRequestMyNotes(Event event) throws YouVersionApiException {
        String username = (String)((Object[])OPTIONS.getOption(1))[0];
        String password = (String)((Object[])OPTIONS.getOption(1))[1];
        User user = (User)((Object[])OPTIONS.getOption(1))[2];
        Integer userId = null;
        if (user != null) {
            userId = new Integer(user.getId());
        }
        Object[] payload = (Object[])event.getPayload();
        Integer localPage = (Integer)payload[0];
        ReferenceCollection localReferences = (ReferenceCollection)payload[1];
        String localMode = (String)payload[2];
        NoteCollection result = null;
        try {
            result = NotesApi.items(GLOBAL.API_CONNECTION, username, password, userId, localReferences, (int)localPage, localMode);
        }
        catch (YouVersionApiException ex) {
            if (ex.getStatusCode() == 404) {
                result = new NoteCollection();
            }
            throw ex;
        }
        EVENT_SYSTEM.queueEvent(200031, 2, new Object[]{localPage, localReferences, localMode, result});
    }

    public void handleRequestSearchResults(Event event) throws YouVersionApiException {
        Object[] payload = (Object[])event.getPayload();
        String query = (String)payload[0];
        Version version = (Version)payload[1];
        Integer page = (Integer)payload[2];
        BibleSearchResult results = null;
        try {
            results = BibleApi.search(GLOBAL.API_CONNECTION, query, version.getAbbreviation(), null, null, null, null, page);
        }
        catch (YouVersionApiException ex) {
            if (ex.getStatusCode() == 404) {
                results = new BibleSearchResult();
            }
            throw ex;
        }
        SearchManager searchManager = SearchManager.getInstance();
        searchManager.setQuery(query);
        searchManager.setPage(page);
        searchManager.setResults(results);
        EVENT_SYSTEM.queueEvent(200029, 2);
    }

    public void handleUpdatePlanCompletion(Event event) throws YouVersionApiException {
        String username = (String)((Object[])OPTIONS.getOption(1))[0];
        String password = (String)((Object[])OPTIONS.getOption(1))[1];
        Object[] payload = (Object[])event.getPayload();
        Integer planID = (Integer)payload[0];
        Integer dayID = (Integer)payload[1];
        Vector references = (Vector)payload[2];
        ReadingPlanApi.updateCompletions(GLOBAL.API_CONNECTION, username, password, planID, dayID, references);
        ReadingPlan tempPlan = new ReadingPlan();
        tempPlan.setId(planID);
        EVENT_SYSTEM.queueEvent(200016, 2, new Object[]{tempPlan, dayID});
    }

    public void handleUnsubscribeFromPlan(Event event) throws YouVersionApiException {
        ReadingPlan plan = (ReadingPlan)event.getPayload();
        String username = (String)((Object[])OPTIONS.getOption(1))[0];
        String password = (String)((Object[])OPTIONS.getOption(1))[1];
        Integer planID = new Integer(plan.getId());
        ReadingPlanApi.unsubscribe(GLOBAL.API_CONNECTION, username, password, planID);
        this.handleRequestIndividualPlanDetails(plan);
    }

    public void handleSubscribeToPlan(Event event) throws YouVersionApiException {
        ReadingPlan plan;
        block2: {
            plan = (ReadingPlan)event.getPayload();
            String username = (String)((Object[])OPTIONS.getOption(1))[0];
            String password = (String)((Object[])OPTIONS.getOption(1))[1];
            Integer planID = new Integer(plan.getId());
            try {
                ReadingPlanApi.subscribe(GLOBAL.API_CONNECTION, username, password, planID);
            }
            catch (YouVersionApiException ex) {
                if (ex.getMessage().indexOf("reading_plans.user_id.subscribed_to_reading_plan") >= 0) break block2;
                throw ex;
            }
        }
        this.handleRequestIndividualPlanDetails(plan);
    }

    public void handleResetSubscription(Event event) throws YouVersionApiException {
        ReadingPlan plan = (ReadingPlan)event.getPayload();
        User user = (User)((Object[])OPTIONS.getOption(1))[2];
        String username = (String)((Object[])OPTIONS.getOption(1))[0];
        String password = (String)((Object[])OPTIONS.getOption(1))[1];
        Integer planID = new Integer(plan.getId());
        ReadingPlanSubscription result = ReadingPlanApi.resetSubscription(GLOBAL.API_CONNECTION, username, password, planID);
        plan.setSubscription(result);
        EVENT_SYSTEM.queueEvent(200023, 2, plan);
    }

    public void handleRequestIndividualPlanDetails(ReadingPlan plan) throws YouVersionApiException {
        User user = (User)((Object[])OPTIONS.getOption(1))[2];
        ReadingPlan result = plan;
        if (user != null) {
            String username = (String)((Object[])OPTIONS.getOption(1))[0];
            String password = (String)((Object[])OPTIONS.getOption(1))[1];
            try {
                ReadingPlan inResult;
                result = inResult = ReadingPlanApi.view(GLOBAL.API_CONNECTION, username, password, new Integer(user.getId()), new Integer(plan.getId()), null);
            }
            catch (Exception ex) {
                result.setSubscription(null);
            }
        }
        EVENT_SYSTEM.queueEvent(200023, 2, result);
    }

    public void handleRequestPlanCategoryDetails(Event event) throws YouVersionApiException {
        Object[] requestPlansCategoryDetailsPayload = (Object[])event.getPayload();
        String requestCategory = (String)requestPlansCategoryDetailsPayload[0];
        Integer requestPage = (Integer)requestPlansCategoryDetailsPayload[1];
        ReadingPlanCollection readingPlanResult = ReadingPlanApi.library(GLOBAL.API_CONNECTION, requestCategory, requestPage);
        ReadingPlansManager readingPlansManager = ReadingPlansManager.getInstance();
        ReadingPlansDescriptor allReadingPlansDescriptor = readingPlansManager.getAllPlansDescriptor();
        allReadingPlansDescriptor.setPage(requestPage);
        allReadingPlansDescriptor.setCollection(readingPlanResult);
        EVENT_SYSTEM.queueEvent(200015, 2);
    }

    public void handleRequestMyPlans(Event event) throws YouVersionApiException {
        Integer requestPage = (Integer)event.getPayload();
        User user = (User)((Object[])OPTIONS.getOption(1))[2];
        String username = (String)((Object[])OPTIONS.getOption(1))[0];
        String password = (String)((Object[])OPTIONS.getOption(1))[1];
        ReadingPlanCollection readingPlanResult = ReadingPlanApi.items(GLOBAL.API_CONNECTION, username, password, new Integer(user.getId()), requestPage);
        ReadingPlansManager readingPlansManager = ReadingPlansManager.getInstance();
        ReadingPlansDescriptor myReadingPlansDescriptor = readingPlansManager.getMyPlansDescriptor();
        myReadingPlansDescriptor.setPage(requestPage);
        myReadingPlansDescriptor.setCollection(readingPlanResult);
        EVENT_SYSTEM.queueEvent(200021, 2);
    }

    public void handleBeRequestReference(Event event) throws YouVersionApiException {
        Object[] payload = (Object[])event.getPayload();
        String version = (String)payload[0];
        Integer referenceNumber = (Integer)payload[1];
        ReadingPlanDay readingPlanDay = (ReadingPlanDay)payload[2];
        VerseCollection verseCollection = null;
        ReadingPlanAdjustedDayCollection adjustedDayCollection = readingPlanDay.getAdjustedDays();
        Reference reference = adjustedDayCollection.getReference(referenceNumber).getReference();
        if (reference.getEndVerse() == 0) {
            Chapter chapter = BibleApiPrivate.getChapter(GLOBAL.API_CONNECTION, version, reference.getOsis(), BibleApiPrivate.FORMAT_TEXT);
            verseCollection = chapter.getVerses();
        } else {
            verseCollection = BibleApi.getVerse(GLOBAL.API_CONNECTION, version, reference.getOsis());
        }
        BibleReferenceManager bibleReferenceManager = BibleReferenceManager.getInstance();
        bibleReferenceManager.setVersion(version);
        bibleReferenceManager.setReference(reference);
        bibleReferenceManager.setReferenceNumber(referenceNumber);
        bibleReferenceManager.setReadingPlanDay(readingPlanDay);
        bibleReferenceManager.setVerseCollection(verseCollection);
        EVENT_SYSTEM.queueEvent(200019, 2);
    }

    public void handleRequestLiveSearchResults(Event event) throws YouVersionApiException {
        String location = (String)event.getPayload();
        LiveEventCollection liveEventCollectionResult = null;
        try {
            liveEventCollectionResult = LiveApi.search(GLOBAL.API_CONNECTION, location);
        }
        catch (YouVersionApiException ex) {
            if (ex.getStatusCode() == 404) {
                liveEventCollectionResult = new LiveEventCollection();
            }
            throw ex;
        }
        LiveManager liveManager = LiveManager.getInstance();
        liveManager.setLocation(location);
        liveManager.setCollection(liveEventCollectionResult);
        EVENT_SYSTEM.queueEvent(200035, 2);
    }

    public void handleRequestLiveEvent(Event event) throws YouVersionApiException {
        Integer id = (Integer)event.getPayload();
        LiveEvent liveEvent = EventsApi.view(GLOBAL.API_CONNECTION, id);
        LiveManager liveManager = LiveManager.getInstance();
        liveManager.setLiveEvent(liveEvent);
        EVENT_SYSTEM.queueEvent(200037, 2);
    }

    public void handleSubmitLivePrayerResponse(Event event) throws YouVersionApiException {
        Object[] payload = (Object[])event.getPayload();
        Integer id = (Integer)payload[0];
        String prayer = (String)payload[1];
        String name = (String)payload[2];
        String contactInfo = (String)payload[3];
        EventItemsApi.createPrayerResponse(GLOBAL.API_CONNECTION, id, name, contactInfo, prayer);
        EVENT_SYSTEM.queueEvent(200039, 2);
    }

    public void handleSubmitLiveQAResponse(Event event) throws YouVersionApiException {
        Object[] payload = (Object[])event.getPayload();
        Integer id = (Integer)payload[0];
        String uniqueId = (String)payload[1];
        String response = (String)payload[2];
        EventItemsApi.createQAResponse(GLOBAL.API_CONNECTION, id, uniqueId, response);
        EVENT_SYSTEM.queueEvent(200041, 2);
    }

    public void handleSubmitLivePollResponse(Event event) throws YouVersionApiException {
        Object[] payload = (Object[])event.getPayload();
        Integer id = (Integer)payload[0];
        String uniqueId = (String)payload[1];
        String response = (String)payload[2];
        EventItemsApi.createPollResponse(GLOBAL.API_CONNECTION, id, uniqueId, response);
        LiveEventPollResultItem pollResultItem = EventItemsApi.viewPollResults(GLOBAL.API_CONNECTION, id);
        LiveManager liveManager = LiveManager.getInstance();
        liveManager.setPollResultItem(pollResultItem);
        EVENT_SYSTEM.queueEvent(200043, 2);
    }

    public void handleNotificationRequest(Event event) throws YouVersionApiException {
        String model = System.getProperty("microedition.platform");
        Integer version = OPTIONS.getAppIteration();
        NotificationCollection notificationCollectionResult = NotificationsApi.items(GLOBAL.API_CONNECTION, "j2me", model, version);
        NotificationManager.getInstance().setCollection(notificationCollectionResult);
        EVENT_SYSTEM.queueEvent(200045, 2, notificationCollectionResult);
    }
}

