/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.controllers.core;

import com.youversion.ApiBase;
import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.events.core.Event;
import com.youversion.application.events.core.EventListener;
import com.youversion.application.global.GLOBAL;
import com.youversion.application.global.OPTIONS;
import com.youversion.application.views.settings.Languages;
import com.youversion.application.views.theme.LowLightTheme;
import de.enough.polish.util.Debug;
import de.enough.polish.util.Locale;
import java.io.IOException;
import javax.microedition.rms.RecordStore;

public class InitializationController
implements EventListener {
    public static final String RMS_VERSION_STORE_NAME = "RMS_VERSION_STORE";
    public static final int RMS_INCOMPATIBILE = 1;
    public static final int RMS_COMPATIBLE = 2;
    public static final int RMS_MISSING = 3;
    public static final byte[] CURRENT_RMS_DATA_VERSION = new byte[]{3, 0};
    public boolean dashboardFormWasShown = false;

    public InitializationController() {
        EVENT_SYSTEM.registerListener(this);
    }

    public void processEvent(Event event) {
        switch (event.getType()) {
            case 4: {
                EVENT_SYSTEM.queueEvent(990037);
                int compatibilityFlag = this.checkRMSVersionCompatibility();
                if (compatibilityFlag == 1) {
                    System.out.println("INCOMPATIBLE RMS DATA FOUND. CLEANUP REQUIRED.");
                    try {
                        Debug.debug("debug", "com.youversion.application.controllers.core.InitializationController", 91, "DELETE RMS VERSION RECORD STORE.");
                        RecordStore.deleteRecordStore(RMS_VERSION_STORE_NAME);
                        Debug.debug("debug", "com.youversion.application.controllers.core.InitializationController", 94, "START CLEANUP.");
                        GLOBAL.CACHE_CONTROLLER.handleSweepStorage();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else if (compatibilityFlag == 3) {
                    try {
                        System.out.println("NO RMS DATA FOUND. INITIALIZING RMS.");
                        RecordStore rs = RecordStore.openRecordStore(RMS_VERSION_STORE_NAME, true);
                        rs.addRecord(CURRENT_RMS_DATA_VERSION, 0, CURRENT_RMS_DATA_VERSION.length);
                        rs.closeRecordStore();
                        GLOBAL.CACHE_CONTROLLER.handleSweepStorage();
                    }
                    catch (Exception ex) {}
                } else {
                    Debug.debug("debug", "com.youversion.application.controllers.core.InitializationController", 121, "NO CLEANUP NEEDED.");
                }
                EVENT_SYSTEM.queueEvent(880002, "options://");
                break;
            }
            case 880003: {
                Object[] requestEvtData = (Object[])event.getPayload();
                String requestKey = (String)requestEvtData[0];
                if ("options://" != requestKey) break;
                OPTIONS.load((Object[])requestEvtData[1]);
                if (OPTIONS.isLowLightMode()) {
                    new LowLightTheme().apply();
                }
                String language = OPTIONS.getLanguage();
                String translationsUrl = Languages.getTranslationsUrl(language);
                try {
                    Locale.loadTranslations(translationsUrl);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ApiBase.setLocale(OPTIONS.getLanguage());
                Debug.debug("debug", "com.youversion.application.controllers.core.InitializationController", 150, "REQUEST NOTIFICATIONS.");
                EVENT_SYSTEM.queueEvent(200044, 2);
                break;
            }
            case 990006: {
                this.dashboardFormWasShown = true;
                break;
            }
            case 0: {
                this.handleExceptionEncountered(event);
            }
        }
    }

    public void handleExceptionEncountered(Event event) {
        if (!this.dashboardFormWasShown) {
            EVENT_SYSTEM.queueEvent(990006);
        }
    }

    public int checkRMSVersionCompatibility() {
        try {
            byte[] data;
            RecordStore rs = RecordStore.openRecordStore(RMS_VERSION_STORE_NAME, true);
            try {
                data = rs.getRecord(1);
            }
            catch (Exception ex) {
                rs.closeRecordStore();
                return 3;
            }
            rs.closeRecordStore();
            if (data[0] != CURRENT_RMS_DATA_VERSION[0]) {
                return 1;
            }
            return 2;
        }
        catch (Exception e) {
            return 1;
        }
    }
}

