/*
 * Decompiled with CFR 0.152.
 */
package com.youversion;

import com.youversion.ApiBase;
import com.youversion.ApiConnection;
import com.youversion.exceptions.YouVersionApiException;
import com.youversion.objects.Highlight;
import com.youversion.objects.HighlightCollection;
import com.youversion.objects.Reference;
import com.youversion.util.JsonHelper;
import com.youversion.util.StringHelper;
import java.util.Hashtable;
import java.util.Vector;
import org.json.me.JSONArray;
import org.json.me.JSONObject;

public class HighlightsApi
extends ApiBase {
    public static HighlightCollection chapter(ApiConnection conn, String username, String password, final Reference reference, final String version) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = -4124111474411834372L;
            {
                if (reference != null) {
                    this.put("reference", reference.getBookChapterOsis());
                }
                if (version != null) {
                    this.put("version", version);
                }
            }
        };
        String url = ApiBase.URL_BASE + "/highlights/chapter.json" + HighlightsApi.buildQueryString(map);
        try {
            ApiConnection.ApiResponse response = conn.makeGetRequest(url, username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (HighlightsApi.isSuccess(code)) {
                JSONObject data = parsed.getJSONObject("data");
                return HighlightCollection.unloadJSON(data);
            }
            if (code == 404) {
                return ApiBase.getApiFactory().newHighlightCollection();
            }
            innerEx = HighlightsApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable t) {
            innerEx = new YouVersionApiException(t);
        }
        throw innerEx;
    }

    public static HighlightCollection create(ApiConnection conn, String username, String password, HighlightCollection highlights) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        String url = ApiBase.URL_BASE + "/highlights/create.json";
        try {
            StringBuffer data = new StringBuffer();
            for (int i = 0; i < highlights.size(); ++i) {
                Highlight h = highlights.elementAt(i);
                if (i > 0) {
                    data.append("&");
                }
                data.append("data[]=");
                data.append(StringHelper.urlEncode("reference=" + h.getReference().getOsis()));
                data.append(StringHelper.urlEncode("&version=" + h.getVersion()));
                data.append(StringHelper.urlEncode("&color=" + h.getColor()));
            }
            String dataStr = data.toString();
            ApiBase.getDebugHelper().logDebug(dataStr);
            ApiConnection.ApiResponse response = conn.makePostRequest(url, dataStr.getBytes("UTF-8"), username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (HighlightsApi.isSuccess(code)) {
                boolean success = true;
                JSONArray datas = parsed.getJSONArray("data");
                for (int i = 0; i < datas.length(); ++i) {
                    if (HighlightsApi.isSuccess(datas.getJSONObject(i).getInt("code"))) continue;
                    success = false;
                    break;
                }
                if (success) {
                    JSONObject json = datas.getJSONObject(datas.length() - 1).getJSONObject("data");
                    return HighlightCollection.unloadJSON(json);
                }
            }
            innerEx = HighlightsApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable t) {
            innerEx = new YouVersionApiException(t);
        }
        throw innerEx;
    }

    public static HighlightCollection create(ApiConnection conn, String username, String password, final Highlight highlight) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            {
                if (highlight.getReference() != null) {
                    this.put("reference", highlight.getReference().getOsis());
                }
                if (highlight.getVersion() != null) {
                    this.put("version", highlight.getVersion());
                }
                if (highlight.getColor() != null) {
                    this.put("color", highlight.getColor());
                }
            }
        };
        String url = ApiBase.URL_BASE + "/highlights/create.json";
        try {
            byte[] data = HighlightsApi.buildQueryString(map).substring(1).getBytes("UTF-8");
            ApiConnection.ApiResponse response = conn.makePostRequest(url, data, username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (HighlightsApi.isSuccess(code)) {
                JSONObject json = parsed.getJSONObject("data");
                return HighlightCollection.unloadJSON(json);
            }
            innerEx = HighlightsApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable t) {
            innerEx = new YouVersionApiException(t);
        }
        throw innerEx;
    }

    public static boolean delete(ApiConnection conn, String username, String password, HighlightCollection highlights) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        String url = ApiBase.URL_BASE + "/highlights/delete.json";
        try {
            StringBuffer data = new StringBuffer();
            for (int i = 0; i < highlights.size(); ++i) {
                Highlight h = highlights.elementAt(i);
                if (i > 0) {
                    data.append("&");
                }
                data.append("data[]=");
                data.append(StringHelper.urlEncode("id=" + h.getId()));
            }
            String dataStr = data.toString();
            ApiBase.getDebugHelper().logDebug(dataStr);
            ApiConnection.ApiResponse response = conn.makePostRequest(url, dataStr.getBytes("UTF-8"), username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            return HighlightsApi.isSuccess(code);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable t) {
            innerEx = new YouVersionApiException(t);
        }
        throw innerEx;
    }

    public static Vector distinctColors(ApiConnection conn, String username, String password, final Integer userId) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            {
                if (userId != null) {
                    this.put("user_id", userId.toString());
                }
            }
        };
        String url = ApiBase.URL_BASE + "/configuration/items.json" + HighlightsApi.buildQueryString(map);
        try {
            ApiConnection.ApiResponse response = conn.makeGetRequest(url, username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (HighlightsApi.isSuccess(code)) {
                JSONObject data = parsed.getJSONObject("data");
                return JsonHelper.toVector(data.getJSONArray("highlight_colors"));
            }
            if (code == 404) {
                return new Vector();
            }
            innerEx = HighlightsApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable t) {
            innerEx = new YouVersionApiException(t);
        }
        throw innerEx;
    }
}

