/*
 * Decompiled with CFR 0.152.
 */
package com.youversion;

import com.youversion.ApiBase;
import com.youversion.exceptions.YouVersionApiException;
import com.youversion.exceptions.YouVersionAuthException;
import com.youversion.exceptions.YouVersionMaintenanceException;
import com.youversion.exceptions.YouVersionResponseException;
import com.youversion.exceptions.YouVersionServerException;
import java.io.IOException;
import java.util.Hashtable;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public interface ApiConnection {
    public ApiResponse makeGetRequest(String var1) throws IOException;

    public ApiResponse makePostRequest(String var1, byte[] var2) throws IOException;

    public ApiResponse makeGetRequest(String var1, String var2, String var3) throws IOException;

    public ApiResponse makePostRequest(String var1, byte[] var2, String var3, String var4) throws IOException;

    public static class ApiResponse {
        int statusCode;
        String statusMessage;
        String response;
        Hashtable responseHeaders;

        public ApiResponse() {
        }

        public ApiResponse(Hashtable responseHeaders, int statusCode, String statusMessage, String response) {
            this.setResponseHeaders(responseHeaders);
            this.setStatusCode(statusCode);
            this.setStatusMessage(statusMessage);
            this.setResponse(response);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(int statusCode) {
            this.statusCode = statusCode;
        }

        public String getStatusMessage() {
            return this.statusMessage;
        }

        public void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public void setResponse(String response) {
            this.response = response;
        }

        public Hashtable getResponseHeaders() {
            return this.responseHeaders;
        }

        public void setResponseHeaders(Hashtable responseHeaders) {
            this.responseHeaders = responseHeaders;
        }

        public String toString() {
            return this.response;
        }

        public void assertSuccess() throws YouVersionApiException {
            if (this.statusCode == 503 && this.responseHeaders != null && this.responseHeaders.containsKey("X-Planned")) {
                String until = (String)this.responseHeaders.get("X-Planned");
                throw new YouVersionMaintenanceException(this.statusMessage, until);
            }
            if (this.statusCode >= 500) {
                throw new YouVersionServerException(this.statusMessage);
            }
            try {
                JSONObject json = new JSONObject(this.response).getJSONObject("response");
                int code = json.getInt("code");
                String data = json.getString("data");
                if (code == 403) {
                    throw new YouVersionAuthException(code, data);
                }
            }
            catch (JSONException e) {
                ApiBase.getDebugHelper().logWarn(this.response);
                throw new YouVersionResponseException(this.statusMessage, e);
            }
        }
    }
}

