/*
 * Decompiled with CFR 0.152.
 */
package com.youversion;

import com.youversion.ApiFactory;
import com.youversion.DefaultApiFactory;
import com.youversion.exceptions.YouVersionApiException;
import com.youversion.util.DebugHelper;
import com.youversion.util.StringHelper;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.json.me.JSONObject;

public abstract class ApiBase {
    private static ApiFactory FACTORY = new DefaultApiFactory();
    private static DebugHelper DEFAULT_DEBUG_HELPER = new DebugHelper(){

        public void logError(String message, Throwable t) {
        }

        public void logDebug(String message) {
        }

        public void logWarn(String message) {
        }
    };
    private static DebugHelper DEBUG = null;
    protected static final String DEFAULT_API = "2.4";
    protected static String URL_BASE = "http://api.youversion.com/2.4";
    protected static String URL_BASE_SSL = "https://api.youversion.com/2.4";
    private static String locale = null;

    public static void setServer(String server) {
        URL_BASE = "http://" + server + "/" + DEFAULT_API;
        URL_BASE_SSL = "https://" + server + "/" + DEFAULT_API;
    }

    public static void setDebugHelper(DebugHelper helper) {
        DEBUG = helper;
    }

    public static boolean isDebugHelperSet() {
        return DEBUG != null;
    }

    public static DebugHelper getDebugHelper() {
        if (DEBUG == null) {
            return DEFAULT_DEBUG_HELPER;
        }
        return DEBUG;
    }

    public static boolean isSuccess(int code) {
        return code >= 200 && code < 300;
    }

    public static String buildQueryString(Hashtable parts) {
        String qs = "?";
        boolean first = true;
        Enumeration keys = parts.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object part = parts.get(key);
            if (part instanceof Vector) {
                Vector strParts = (Vector)part;
                for (int i = 0; i < strParts.size(); ++i) {
                    if (!first || i > 0) {
                        qs = qs + "&";
                    }
                    qs = qs + StringHelper.urlEncode(key) + "[]=" + StringHelper.urlEncode(strParts.elementAt(i).toString());
                }
            } else {
                if (!first) {
                    qs = qs + "&";
                }
                qs = qs + StringHelper.urlEncode(key) + "=" + StringHelper.urlEncode(parts.get(key).toString());
            }
            first = false;
        }
        return qs.equals("?") ? "" : qs;
    }

    public static YouVersionApiException buildReadException(JSONObject response) {
        YouVersionApiException ex;
        try {
            int code = response.getInt("code");
            String data = response.getString("data");
            ex = new YouVersionApiException(code, data);
        }
        catch (Throwable t) {
            ex = new YouVersionApiException(t);
        }
        return ex;
    }

    protected static byte[] mapToPostData(Hashtable map) throws UnsupportedEncodingException {
        if (map.size() == 0) {
            return new byte[0];
        }
        return ApiBase.buildQueryString(map).substring(1).getBytes("UTF-8");
    }

    protected static String makePlusSeparatedString(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            sb.append(vector.elementAt(i).toString() + "+");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static void setLocale(String country) {
        locale = country;
    }

    public static String getLocale() {
        return locale;
    }

    public static ApiFactory getApiFactory() {
        return FACTORY;
    }

    public static void setApiFactory(ApiFactory factory) {
        if (factory == null) {
            factory = new DefaultApiFactory();
        }
        FACTORY = factory;
    }
}

