/*
 * Decompiled with CFR 0.152.
 */
package joybits.disciples;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import joybits.disciples.DisCanvas;
import joybits.disciples.FontParam;
import joybits.disciples.Globals;
import joybits.disciples.ScrollBarParam;

public class StringProcessor
implements FontParam,
ScrollBarParam {
    protected String text;
    protected String[] textLines;
    protected int stringId;
    public int currentLine = 0;
    private byte offsetY = 0;
    public int linesCount = 0;
    private int layout;
    public boolean drawCentered = false;
    public int width = 0;
    public int height = 0;
    public static final byte EXTRA_WIDTH = 4;
    public static final byte LAYOUT_TOP = 0;
    public static final byte LAYOUT_MIDDLE = 1;
    public static final byte LAYOUT_LEFT = 2;
    public static final byte LAYOUT_CENTER = 3;
    public static final byte LAYOUT_RIGHT = 4;
    public static final int SPLIT_OFFSET = 4;
    public boolean dontDrawScrollBar = false;
    private static final int paddingVertical = 0;
    public int contentHeight;
    public int contentWidth;

    public StringProcessor(int StringId, int _width, int _height, byte _layout) {
        this.init(StringId, _width, _height, _layout);
    }

    public void init(int StringId, int _width, int _height, byte _layout) {
        Object var5_5 = null;
        if (DisCanvas._a1()) {
            return;
        }
        this.width = _width;
        if (_layout == 2) {
            this.width += 4;
        }
        this.height = _height;
        this.layout = _layout;
        if (this.height < this.contentHeight) {
            this.setText(StringId, this.width - 2 - 2);
        } else {
            this.setText(StringId, this.width);
        }
        this.linesCount = this.height / 10;
    }

    public StringProcessor(String str, int _width, int _height, byte _layout) {
        this.init(str, _width, _height, _layout);
    }

    public void init(String str, int _width, int _height, byte _layout) {
        this.width = _width;
        if (_layout == 2) {
            this.width += 4;
        }
        this.height = _height;
        this.layout = _layout;
        this.text = str;
        if (this.height < this.contentHeight) {
            this.initContent(this.width - 2 - 2);
        } else {
            this.initContent(this.width);
        }
        this.linesCount = this.height / 10;
    }

    public void setText(int StringId, int width) {
        this.stringId = StringId;
        this.text = (String)Globals.mStringArr.elementAt(this.stringId);
        this.initContent(width);
    }

    public void paintContent(Graphics g, int x, int y) {
        if (this.drawCentered) {
            y += (this.height - this.contentHeight) / 2;
        }
        this.drawCentered = false;
        for (int i = 0; i < this.textLines.length; ++i) {
            String line = this.textLines[i];
            int lineWidth = Globals.getStringWidth(line);
            int tx = x;
            if (this.layout == 4) {
                tx = this.width - lineWidth;
            } else if (this.layout == 3) {
                tx = x + (this.width - lineWidth) / 2;
            }
            Globals.drawString(g, tx, y, line);
            y += 10;
        }
    }

    public void scrollDown(int step) {
        if (this.contentHeight <= this.height) {
            return;
        }
        this.offsetY = (byte)(this.offsetY - step);
        if (this.offsetY <= 0) {
            this.offsetY = (byte)(this.offsetY + 10);
            ++this.currentLine;
            if (this.textLines.length - this.linesCount < this.currentLine) {
                this.currentLine = this.textLines.length - this.linesCount;
                this.offsetY = 0;
            }
        }
    }

    public void scrollUp(int step) {
        if (this.contentHeight <= this.height) {
            return;
        }
        if (this.currentLine == 0) {
            this.offsetY = 0;
            return;
        }
        this.offsetY = (byte)(this.offsetY + step);
        if (this.offsetY >= 10) {
            this.offsetY = (byte)(this.offsetY - 10);
            --this.currentLine;
            if (this.currentLine < 0) {
                this.currentLine = 0;
                this.offsetY = 0;
            }
        }
    }

    public void drawScrollBar(Graphics g, int x, int y, int width, int height) {
        if (this.dontDrawScrollBar) {
            this.dontDrawScrollBar = false;
            return;
        }
        if (this.textLines.length == this.linesCount) {
            return;
        }
        int sliderH = 10;
        int roundHeight = height / 10 * 10;
        int sliderY = y + (roundHeight - sliderH) * this.currentLine / (this.textLines.length - this.linesCount);
        int sliderX = x + width + 2;
        g.setClip(sliderX, y, 2, height);
        g.setColor(0);
        g.fillRect(sliderX, y, 2, height);
        g.setColor(12418143);
        g.fillRect(sliderX, sliderY, 2, sliderH);
    }

    public void paintContentScroll(Graphics g, int x, int y) {
        if (this.contentHeight > this.height) {
            this.drawScrollBar(g, x, y, this.width, this.height);
        } else {
            if (this.drawCentered) {
                y += (this.height - this.contentHeight) / 2;
            }
            this.drawCentered = false;
        }
        this.paintContent(g, x, y, this.width, this.height, this.currentLine, this.linesCount);
    }

    public int paintContent(Graphics g, int x, int y, int width, int height, int fromLine, int linesCount) {
        int endLine = Math.min(this.textLines.length, fromLine + linesCount);
        String line = "";
        int currY = y - 10;
        for (int i = fromLine - 1; i < endLine; ++i) {
            if (i == -1) {
                currY += 10;
                continue;
            }
            line = this.textLines[i];
            int lineWidth = Globals.getStringWidth(line);
            int tx = x;
            if (this.layout == 4) {
                tx = width - lineWidth;
            } else if (this.layout == 3) {
                tx = x + (width - lineWidth) / 2;
            }
            Globals.drawClippedString(g, tx, currY + this.offsetY, line, y, height);
            currY += 10;
        }
        return endLine;
    }

    public int paintContent(Graphics g, int x, int y, int width, int fromLine, int linesCount) {
        Object var7_7 = null;
        if (DisCanvas._a1()) {
            return 0;
        }
        int endLine = Math.min(this.textLines.length, fromLine + linesCount);
        String line = "";
        for (int i = fromLine; i < endLine; ++i) {
            line = this.textLines[i];
            int lineWidth = Globals.getStringWidth(line);
            int tx = x;
            if (this.layout == 4) {
                tx = width - lineWidth;
            } else if (this.layout == 3) {
                tx = x + (width - x - lineWidth) / 2;
            }
            Globals.drawString(g, tx, y, line);
            y += 10;
        }
        return endLine;
    }

    protected void initContent(int firstLineWidth) {
        String[] lines = this.split(this.text, firstLineWidth - 4);
        this.contentHeight = lines.length * 10 - 0;
        int maxWidth = 0;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            int width = Globals.getStringWidth(line);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        this.contentWidth = maxWidth;
        this.textLines = lines;
    }

    private String[] split(String value, int firstLineWidth) {
        Vector<String> lines;
        block19: {
            boolean hasLineBreaks = value.indexOf(94) != -1;
            int completeWidth = Globals.getStringWidth(value);
            char[] valueChars = value.toCharArray();
            if (completeWidth <= firstLineWidth) {
                if (hasLineBreaks) {
                    int lastIndex = 0;
                    Vector<String> strings = null;
                    for (int i = 0; i < valueChars.length; ++i) {
                        char c = valueChars[i];
                        if (c != '^') continue;
                        if (strings == null) {
                            strings = new Vector<String>();
                        }
                        strings.addElement(new String(valueChars, lastIndex, i - lastIndex));
                        lastIndex = i + 1;
                    }
                    if (strings == null) {
                        String[] res = new String[]{value};
                        return res;
                    }
                    strings.addElement(new String(valueChars, lastIndex, valueChars.length - lastIndex));
                    Object[] res = new String[strings.size()];
                    strings.copyInto(res);
                    return res;
                }
                String[] res = new String[]{value};
                return res;
            }
            lines = new Vector<String>();
            if (!hasLineBreaks) {
                int widthPerChar = completeWidth * 100 / valueChars.length;
                int startIndex = 0;
                while (true) {
                    int index;
                    int i123;
                    if ((i123 = (index = firstLineWidth * 100 / widthPerChar) + startIndex) >= valueChars.length) {
                        lines.addElement(new String(valueChars, startIndex, valueChars.length - startIndex));
                        break block19;
                    }
                    while (valueChars[i123] != '_' && valueChars[i123] != '-') {
                        if (--i123 >= startIndex) continue;
                        i123 = index + startIndex;
                        break;
                    }
                    if (valueChars[i123] == '-') {
                        ++i123;
                    }
                    lines.addElement(new String(valueChars, startIndex, i123 - startIndex));
                    if (valueChars[i123] == '_') {
                        startIndex = i123 + 1;
                        continue;
                    }
                    startIndex = i123;
                }
            }
            int lastIndex = 0;
            for (int i = 0; i < valueChars.length; ++i) {
                char c = valueChars[i];
                if (c != '^' && i != valueChars.length - 1) continue;
                String line = null;
                line = i == valueChars.length - 1 ? new String(valueChars, lastIndex, i + 1 - lastIndex) : new String(valueChars, lastIndex, i - lastIndex);
                completeWidth = Globals.getStringWidth(line);
                if (completeWidth <= firstLineWidth) {
                    lines.addElement(line);
                } else {
                    char[] valueChars123 = line.toCharArray();
                    int widthPerChar = completeWidth * 100 / valueChars123.length;
                    int startIndex = 0;
                    while (true) {
                        int index;
                        int i123;
                        if ((i123 = (index = firstLineWidth * 100 / widthPerChar) + startIndex) >= valueChars123.length) {
                            lines.addElement(new String(valueChars123, startIndex, valueChars123.length - startIndex));
                            break;
                        }
                        while (valueChars123[i123] != '_' && valueChars123[i123] != '-') {
                            if (--i123 >= startIndex) continue;
                            i123 = index + startIndex;
                            break;
                        }
                        if (valueChars123[i123] == '-') {
                            ++i123;
                        }
                        lines.addElement(new String(valueChars123, startIndex, i123 - startIndex));
                        if (valueChars123[i123] == '_') {
                            startIndex = i123 + 1;
                            continue;
                        }
                        startIndex = i123;
                    }
                }
                lastIndex = i + 1;
            }
        }
        Object[] res = new String[lines.size()];
        lines.copyInto(res);
        return res;
    }
}

