/*
 * Decompiled with CFR 0.152.
 */
package joybits.disciples;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import joybits.disciples.ArmyCharacter;
import joybits.disciples.Battle;
import joybits.disciples.DisCanvas;
import joybits.disciples.GlobalConstants;
import joybits.disciples.Globals;
import joybits.disciples.Map;
import joybits.disciples.StringParamInterface;

public class ArmyController
implements GlobalConstants,
StringParamInterface {
    public static ArmyController instance;
    public static byte[] armySequenceDraw;
    private byte[][] pathMap;
    public byte[][] initMap;
    public byte[] path;
    public byte currId;
    public int pathPtr;
    public int pathLength;
    public byte targetID;
    public byte item = (byte)-1;
    private int mapWidth;
    private int mapHeight;
    public int armyX;
    public int armyY;
    public int armyNewX;
    public int armyNewY;
    public byte armyDistX;
    public byte armyDistY;
    public int pathTick;
    public Vector armyVector;
    public short[] battleUnits;
    public int battleUnitsCount = 0;
    public boolean aiReady;
    public boolean moveArmy;
    public boolean aiTurn;
    public boolean inAI = false;
    public byte nrest = 0;
    public byte nress = 0;
    public boolean goToHeal = false;
    public int aiPreyId;
    public int aiBestChoice;
    public byte aiPreyX;
    public byte aiPreyY;
    public byte aiChoiceType;
    public byte[][] enemyMap;
    public boolean moreThenOneMonster;
    public byte wayMonster;
    public byte unitCounter;
    public byte armyIterCount;

    public ArmyController() {
        instance = this;
        this.mapWidth = DisCanvas.instance.map.width;
        this.mapHeight = DisCanvas.instance.map.height;
        this.armyVector = new Vector();
        this.path = new byte[256];
        this.pathLength = 0;
        this.pathPtr = 0;
        this.currId = (byte)-1;
        this.battleUnits = new short[1750];
        this.battleUnitsCount = 0;
        armySequenceDraw = new byte[128];
        this.enemyMap = new byte[Map.instance.width][Map.instance.height];
    }

    public void delArmy(int id) {
        this.armyVector.removeElementAt(id);
    }

    public byte getX(int id) {
        ArmyCharacter tempArmy = (ArmyCharacter)this.armyVector.elementAt(id);
        return tempArmy.x;
    }

    public byte getY(int id) {
        ArmyCharacter tempArmy = (ArmyCharacter)this.armyVector.elementAt(id);
        return tempArmy.y;
    }

    public void removeBattleUnit(int index) {
        int j;
        ArmyCharacter ac;
        int i;
        if (index == -1) {
            return;
        }
        int start = index * 5;
        --this.battleUnitsCount;
        for (i = start; i < this.battleUnitsCount * 5; ++i) {
            this.battleUnits[i] = this.battleUnits[i + 5];
        }
        for (i = 0; i < this.armyVector.size(); ++i) {
            ac = (ArmyCharacter)this.armyVector.elementAt(i);
            for (j = 0; j < 6; j = (int)((byte)(j + 1))) {
                if (ac.units[j] != index) continue;
                ac.units[j] = -1;
            }
        }
        for (i = 0; i < this.armyVector.size(); ++i) {
            ac = (ArmyCharacter)this.armyVector.elementAt(i);
            for (j = 0; j < 6; j = (int)((byte)(j + 1))) {
                if (ac.units[j] <= index) continue;
                int n = j;
                ac.units[n] = (short)(ac.units[n] - 1);
            }
        }
    }

    public short addBattleUnit(byte u) {
        short hp;
        Object var2_2 = null;
        if (DisCanvas._a0()) {
            return 0;
        }
        if (u == -1) {
            return -1;
        }
        this.battleUnits[this.battleUnitsCount * 5 + 0] = u;
        this.battleUnits[this.battleUnitsCount * 5 + 1] = hp = Battle.instance.unitStaticParams[u * 6 + 0];
        this.battleUnits[this.battleUnitsCount * 5 + 2] = 0;
        if (u > 14 && u < 42) {
            int typeSection = -1;
            for (int m = 0; m < 8; m = (int)((byte)(m + 1))) {
                if (u < DisCanvas.UNITS_TYPE_START[m]) continue;
                typeSection = m;
            }
            if (u > DisCanvas.UNITS_TYPE_START[typeSection] && typeSection > -1) {
                this.battleUnits[this.battleUnitsCount * 5 + 2] = Battle.instance.unitStaticParams[(u - 1) * 6 + 5];
            }
        }
        this.battleUnits[this.battleUnitsCount * 5 + 4] = 0;
        byte level = 1;
        for (int i = 0; i < 8; ++i) {
            if (u < DisCanvas.UNITS_TYPE_START[i]) continue;
            level = (byte)(u - DisCanvas.UNITS_TYPE_START[i] + 1);
        }
        this.battleUnits[this.battleUnitsCount * 5 + 3] = level;
        if (u >= 8 && u <= 14) {
            int n = this.battleUnitsCount * 5 + 4;
            this.battleUnits[n] = (short)(this.battleUnits[n] | 0x100);
        }
        ++this.battleUnitsCount;
        return (short)(this.battleUnitsCount - 1);
    }

    public void addArmy(byte x, byte y, byte leader, byte owner, byte u0, byte u1, byte u2, byte u3, byte u4, byte u5, byte id, boolean visible) {
        ArmyCharacter character = new ArmyCharacter(x, y, leader, owner);
        character.globalX = x * 16 + 8;
        character.globalY = y * 16 + 8;
        character.id = id;
        character.visible = visible;
        character.units[0] = this.addBattleUnit(u0);
        character.units[1] = this.addBattleUnit(u1);
        character.units[2] = this.addBattleUnit(u2);
        character.units[3] = this.addBattleUnit(u3);
        character.units[4] = this.addBattleUnit(u4);
        character.units[5] = this.addBattleUnit(u5);
        character.initGlobalParams();
        this.armyVector.addElement(character);
    }

    public int getScreenX(int x) {
        return Map.instance.getScreenX(x);
    }

    public int getScreenY(int y) {
        return Map.instance.getScreenX(y);
    }

    public void drawArmies(Graphics g) {
        for (int n = 0; n < this.armyVector.size(); ++n) {
            if (armySequenceDraw[n] == -1) continue;
            ArmyCharacter tempArmy = (ArmyCharacter)this.armyVector.elementAt(armySequenceDraw[n]);
            if ((Map.instance.tiles[tempArmy.x][tempArmy.y] & 0x40) == 0 || !tempArmy.visible) continue;
            tempArmy.draw(g, this.currId == armySequenceDraw[n]);
        }
    }

    public void shuffleAnimation() {
        for (int n = 0; n < this.armyVector.size(); ++n) {
            ArmyCharacter ac = (ArmyCharacter)this.armyVector.elementAt(n);
            if (ac.owner >= 3 || ac.leader == -1 || ac.units[ac.leader] == -1) continue;
            short unitType = this.battleUnits[ac.units[ac.leader] * 5 + 0];
            int animIndex = -1;
            if (unitType <= 7) {
                animIndex = Battle.HEROES_ANIMATIONS + unitType * 8;
                animIndex += ac.direction;
                if (DisCanvas.instance.onTourney && this.currId == n) {
                    animIndex += 4;
                }
            } else {
                animIndex = Battle.NEUTRAL_ANIMATIONS + (unitType - 7) - 1;
            }
            byte framesCount = Battle.instance.animation[animIndex][0];
            ac.frame = (byte)(Globals.rand(100) % framesCount);
            int frameStart = Battle.instance.getFrame(animIndex, ac.frame);
            int delay = Battle.instance.animation[animIndex][frameStart + 1] / 2;
            ac.tick = (byte)(Globals.rand(5) % delay);
        }
    }

    public void animStep() {
        for (int n = 0; n < this.armyVector.size(); ++n) {
            ArmyCharacter tempArmy = (ArmyCharacter)this.armyVector.elementAt(n);
            if (tempArmy.owner >= 3 || !tempArmy.visible) continue;
            short unitType = this.battleUnits[tempArmy.units[tempArmy.leader] * 5 + 0];
            int animIndex = -1;
            if (unitType <= 7) {
                animIndex = Battle.HEROES_ANIMATIONS + unitType * 8;
                animIndex += tempArmy.direction;
                if (DisCanvas.instance.onTourney && this.currId == n) {
                    animIndex += 4;
                }
            } else {
                animIndex = Battle.NEUTRAL_ANIMATIONS + (unitType - 7) - 1;
            }
            int frameStart = Battle.instance.getFrame(animIndex, tempArmy.frame);
            int delay = Battle.instance.animation[animIndex][frameStart + 1] / 2;
            tempArmy.tick = (byte)(tempArmy.tick + 1);
            if (tempArmy.tick < delay && !this.aiTurn && !DisCanvas.instance.fastMove) continue;
            tempArmy.tick = 0;
            tempArmy.frame = (byte)(tempArmy.frame + 1);
            byte xShift = Battle.instance.animation[animIndex][frameStart + 2];
            byte yShift = Battle.instance.animation[animIndex][frameStart + 3];
            tempArmy.globalX += xShift;
            tempArmy.globalY += yShift;
            if (DisCanvas.instance.onTourney) {
                tempArmy.animShiftX = (byte)(tempArmy.animShiftX + xShift);
                tempArmy.animShiftY = (byte)(tempArmy.animShiftY + yShift);
            }
            tempArmy.frame = (byte)(tempArmy.frame % Battle.instance.animation[animIndex][0]);
        }
    }

    public byte getId(int x, int y) {
        return this.getId(x, y, false);
    }

    public byte getId(int x, int y, boolean allOwners) {
        for (byte i = 0; i < this.armyVector.size(); i = (byte)((byte)(i + 1))) {
            ArmyCharacter temp = (ArmyCharacter)this.armyVector.elementAt(i);
            if (!temp.visible || !allOwners && temp.owner >= 3 || temp.x != x || temp.y != y) continue;
            return i;
        }
        return -1;
    }

    public byte getId() {
        return this.currId;
    }

    public byte getOwner(int id) {
        Object var2_2 = null;
        if (DisCanvas._a1()) {
            return 0;
        }
        if (id > this.armyVector.size() - 1 || id < 0) {
            return -1;
        }
        ArmyCharacter armyChar = (ArmyCharacter)this.armyVector.elementAt(id);
        return armyChar.owner;
    }

    public byte getOwner() {
        return this.getOwner(this.currId);
    }

    public void clearPath() {
        this.targetID = (byte)-1;
        this.pathLength = 0;
        this.pathPtr = 0;
    }

    public void markArmy(byte id) {
        this.currId = id;
        if (id == -1 || this.currId >= this.armyVector.size()) {
            return;
        }
        ArmyCharacter temp = (ArmyCharacter)this.armyVector.elementAt(this.currId);
        if (temp.owner >= 3) {
            return;
        }
        if (temp.nx != -1 && temp.ny != -1 && (temp.x != temp.nx || temp.y != temp.ny)) {
            DisCanvas.instance.toTarget(temp.nx, temp.ny);
        }
    }

    public boolean isMarked() {
        return this.currId > -1;
    }

    public void unmarkArmy() {
        this.currId = (byte)-1;
        this.clearPath();
    }

    public boolean toAim(int x, int y) {
        return this.isMarked() && this.armyDistX == x && this.armyDistY == y && this.targetID != -1;
    }

    private void initPathEngine() {
        this.pathPtr = 0;
        this.pathLength = 0;
        for (int i = 0; i < this.mapHeight; i = (int)((byte)(i + 1))) {
            for (int j = 0; j < this.mapWidth; j = (int)((byte)(j + 1))) {
                this.pathMap[j][i] = this.initMap[j][i];
            }
        }
        if (!this.aiTurn) {
            this.visionOnMap();
        }
        this.fillMap();
    }

    private void checkTarget() {
        ArmyCharacter temp = (ArmyCharacter)this.armyVector.elementAt(this.currId);
        switch (this.targetID) {
            case 0: {
                break;
            }
            case 7: {
                if (this.getOwner() == 0 && Map.instance.layer3[Map.instance.isMineOnCell(this.path[this.pathLength * 2], this.path[this.pathLength * 2 + 1])][4] != 0) {
                    DisCanvas.instance.toolTipStringId = (short)395;
                    DisCanvas.instance.toolTipString = "";
                    DisCanvas.instance.toolTipAvatarId = this.battleUnits[temp.units[temp.leader] * 5 + 0];
                    DisCanvas.instance.nextTriggerId = (byte)-1;
                    DisCanvas.instance.returnGameState = (byte)2;
                    DisCanvas.instance.nextGameState = (byte)39;
                    temp.movePoints = 0;
                }
                Map.instance.layer3[Map.instance.isMineOnCell((int)this.path[this.pathLength * 2], (int)this.path[this.pathLength * 2 + 1])][4] = this.getOwner(this.currId);
                break;
            }
            case 5: 
            case 8: {
                if (this.aiTurn) break;
                DisCanvas.instance.nextGameState = (byte)30;
                DisCanvas.instance.exchange = false;
                break;
            }
            case 9: {
                if (this.aiTurn) break;
                DisCanvas.instance.nextGameState = (byte)52;
                break;
            }
            case 3: {
                DisCanvas.instance.currentTownId = Map.instance.isTownBodyOnCell(temp.x, temp.y, false);
                int currTown = !this.aiTurn ? Map.instance.layer3[DisCanvas.instance.currentTownId][5] : this.aiPreyId;
                ArmyCharacter ac = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(DisCanvas.instance.capitals[currTown][0]);
                ac.animShiftX = 0;
                ac.animShiftY = 0;
                if (!this.aiTurn) {
                    if (ac.owner % 3 == 0) {
                        DisCanvas.instance.nextGameState = (byte)19;
                        break;
                    }
                    boolean townIsEmpty = true;
                    for (int i = 0; i < 6; ++i) {
                        if (ac.units[i] == -1) continue;
                        townIsEmpty = false;
                    }
                    if (!townIsEmpty) {
                        DisCanvas.instance.battle.prepare(this.currId, DisCanvas.instance.capitals[currTown][0]);
                        ac.isInTownAdditionalCheck = true;
                        break;
                    }
                    DisCanvas.instance.battle.prepareEssential(this.currId, DisCanvas.instance.capitals[currTown][0]);
                    DisCanvas.instance.battle.endBattle((byte)1);
                    break;
                }
                ac.isInTownAdditionalCheck = true;
                if (ac.owner != 1 && ac.owner != 4) {
                    boolean townIsEmpty = true;
                    for (int i = 0; i < 6; ++i) {
                        if (ac.units[i] == -1) continue;
                        townIsEmpty = false;
                    }
                    if (townIsEmpty) {
                        DisCanvas.instance.battle.prepareEssential(this.currId, DisCanvas.instance.capitals[currTown][0]);
                        DisCanvas.instance.battle.endBattle((byte)1);
                        DisCanvas.instance.findLeaderInCapital(DisCanvas.instance.currentTownId);
                        break;
                    }
                    if (this.getOwner(DisCanvas.instance.capitals[currTown][0]) != 3) {
                        DisCanvas.instance.battle.fastBattle(this.currId, DisCanvas.instance.capitals[currTown][0]);
                        break;
                    }
                    DisCanvas.instance.battle.prepare(DisCanvas.instance.capitals[currTown][0], this.currId);
                    break;
                }
                DisCanvas.instance.capitals[currTown][1] = this.currId;
                break;
            }
            case 4: {
                this.item = Map.instance.isItemOnCell(this.path[this.pathLength * 2], this.path[this.pathLength * 2 + 1]);
                this.initMap[this.path[this.pathLength * 2]][this.path[this.pathLength * 2 + 1]] = 126;
                if (this.item != -1) {
                    if (Map.instance.mapItems[this.item][2] == 101) {
                        if (!temp.addArtefact(Map.instance.mapItems[this.item][3])) break;
                        byte tmp = this.item;
                        this.item = Map.instance.mapItems[this.item][3];
                        Map.instance.deleteItem(tmp);
                    } else {
                        int n = this.getOwner() * 3;
                        DisCanvas.instance.res[n] = DisCanvas.instance.res[n] + 100;
                        Map.instance.deleteItem(this.item);
                        this.item = (byte)-1;
                    }
                }
                if (this.aiTurn) break;
                DisCanvas.instance.nextGameState = (byte)13;
                break;
            }
            case 1: {
                if (!this.aiTurn) {
                    DisCanvas.instance.battle.prepare(this.currId, this.getId(this.path[this.pathLength * 2], this.path[this.pathLength * 2 + 1]));
                    break;
                }
                if (this.getOwner(this.getId(this.path[this.pathLength * 2], this.path[this.pathLength * 2 + 1])) != 0) {
                    DisCanvas.instance.battle.fastBattle(this.currId, this.getId(this.path[this.pathLength * 2], this.path[this.pathLength * 2 + 1]));
                    break;
                }
                DisCanvas.instance.battle.prepare(this.getId(this.path[this.pathLength * 2], this.path[this.pathLength * 2 + 1]), this.currId);
            }
        }
        temp.ny = (byte)-1;
        temp.nx = (byte)-1;
        this.fillEnemyMap();
        this.clearPath();
    }

    public byte seeAround(int ux, int uy) {
        if (this.getOwner() == -1) {
            return -1;
        }
        if (ux < 0 || ux > Map.instance.width - 1 || uy < 0 || uy > Map.instance.height - 1) {
            return -1;
        }
        if ((Map.instance.tiles[ux][uy] & 0x40) == 0 && !ArmyController.instance.aiTurn) {
            return -1;
        }
        for (int x = -1; x <= 1; x = (int)((byte)(x + 1))) {
            for (int y = -1; y <= 1; y = (int)((byte)(y + 1))) {
                if (ux + x < 0 || ux + x > Map.instance.width - 1 || uy + y < 0 || uy + y > Map.instance.height - 1 || this.enemyMap[ux + x][uy + y] == -1 || this.getOwner(this.enemyMap[ux + x][uy + y]) == this.getOwner()) continue;
                return this.enemyMap[ux + x][uy + y];
            }
        }
        return -1;
    }

    public void setTarget(byte target) {
        this.targetID = target;
    }

    public void computePath(byte newX, byte newY) {
        if (this.currId == -1) {
            this.targetID = (byte)-1;
            return;
        }
        if (this.targetID == 0) {
            if ((Map.instance.tiles[newX][newY] & 0x80) != 0) {
                this.targetID = (byte)-1;
                return;
            }
            if ((Map.instance.tiles[newX][newY] & 0x40) == 0) {
                this.targetID = (byte)-1;
                return;
            }
        }
        byte[] wayMonstersArr = new byte[128];
        int wayMonstersCount = 0;
        this.wayMonster = (byte)-1;
        this.moreThenOneMonster = false;
        if (this.currId >= this.armyVector.size()) {
            this.unmarkArmy();
            return;
        }
        ArmyCharacter temp = (ArmyCharacter)this.armyVector.elementAt(this.currId);
        this.armyX = temp.x;
        this.armyY = temp.y;
        this.armyDistX = temp.nx = newX;
        this.armyDistY = temp.ny = newY;
        this.initPathEngine();
        while (this.armyX != this.armyDistX || this.armyY != this.armyDistY) {
            this.findNext();
            this.path[this.pathLength * 2] = (byte)this.armyNewX;
            this.path[this.pathLength * 2 + 1] = (byte)this.armyNewY;
            byte m = this.seeAround(this.armyNewX, this.armyNewY);
            boolean rep = false;
            if (m != -1) {
                for (int b = 0; b < wayMonstersCount; b = (int)((byte)(b + 1))) {
                    if (wayMonstersArr[b] != m) continue;
                    rep = true;
                    break;
                }
                if (!rep) {
                    wayMonstersArr[wayMonstersCount] = m;
                    wayMonstersCount = (byte)(wayMonstersCount + 1);
                }
            }
            if (wayMonstersCount > 1) {
                this.moreThenOneMonster = true;
            }
            if (wayMonstersCount > 0) {
                this.wayMonster = wayMonstersArr[0];
            }
            this.armyX = this.armyNewX;
            this.armyY = this.armyNewY;
            ++this.pathLength;
            if (this.pathLength <= 100) continue;
            this.clearPath();
            return;
        }
        switch (this.targetID) {
            case 0: 
            case 3: {
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                --this.pathLength;
                if (this.inAI || this.pathLength != 0) break;
                this.checkTarget();
            }
        }
    }

    private void dirMaker(ArmyCharacter ac) {
        if (ac.y > this.path[this.pathPtr * 2 + 1]) {
            ac.direction = 0;
        }
        if (ac.x < this.path[this.pathPtr * 2]) {
            ac.direction = 1;
        }
        if (ac.y < this.path[this.pathPtr * 2 + 1]) {
            ac.direction = (byte)2;
        }
        if (ac.x > this.path[this.pathPtr * 2]) {
            ac.direction = (byte)3;
        }
    }

    public int getTriggerIndex(byte id) {
        for (int i = 0; i < Map.instance.triggersCount; ++i) {
            byte triggerId = Map.instance.triggers[i * 7 + 0];
            if (id != triggerId) continue;
            return i;
        }
        return -1;
    }

    public void activateTrigger(byte id) {
        if (id == -1) {
            return;
        }
        int index = this.getTriggerIndex(id);
        if (index == -1) {
            return;
        }
        byte type = Map.instance.triggers[index * 7 + 1];
        byte next = Map.instance.triggers[index * 7 + 2];
        byte param1 = Map.instance.triggers[index * 7 + 4];
        byte param2 = Map.instance.triggers[index * 7 + 5];
        block0 : switch (type) {
            case 5: {
                DisCanvas.instance.toolTipStringId = (short)(0 + param1);
                DisCanvas.instance.toolTipAvatarId = param2;
                DisCanvas.instance.nextGameState = (byte)39;
                DisCanvas.instance.nextTriggerId = next;
                break;
            }
            case 6: {
                for (int i = 0; i < this.armyVector.size(); ++i) {
                    ArmyCharacter ac = (ArmyCharacter)this.armyVector.elementAt(i);
                    if (ac.id != param1) continue;
                    ac.visible = true;
                    this.activateTrigger(next);
                    break block0;
                }
                break;
            }
            case 8: {
                DisCanvas.instance.toolTipStringId = (short)442;
                DisCanvas.instance.returnGameState = 1;
                DisCanvas.instance.nextTriggerId = (byte)-1;
                DisCanvas.instance.nextGameState = (byte)48;
                Battle.instance.defeat = true;
                break;
            }
            case 7: {
                DisCanvas.instance.toolTipStringId = (short)(45 + DisCanvas.instance.currentLevel);
                DisCanvas.instance.currentLevel = (byte)(DisCanvas.instance.currentLevel + 1);
                DisCanvas.instance.returnGameState = (byte)4;
                DisCanvas.instance.nextTriggerId = (byte)-1;
                DisCanvas.instance.nextGameState = (byte)48;
                Battle.instance.victory = true;
                break;
            }
            case 9: {
                DisCanvas.instance.delayLength = param1;
                DisCanvas.instance.nextTriggerId = next;
                DisCanvas.instance.returnGameState = DisCanvas.instance.nextGameState;
                DisCanvas.instance.nextGameState = (byte)51;
                break;
            }
            case 10: {
                this.activateTrigger(next);
                this.activateTrigger(param1);
                this.activateTrigger(param2);
                break;
            }
            default: {
                Map.instance.triggers[index * 7 + 3] = 1;
            }
        }
    }

    public void checkHasTownsTriggers() {
        for (int i = 0; i < Map.instance.triggersCount; ++i) {
            byte type = Map.instance.triggers[i * 7 + 1];
            byte enabled = Map.instance.triggers[i * 7 + 3];
            byte param1 = Map.instance.triggers[i * 7 + 4];
            byte param2 = Map.instance.triggers[i * 7 + 5];
            byte param3 = Map.instance.triggers[i * 7 + 6];
            if (type != 11 || enabled == 0) continue;
            boolean allTownsCaptured = true;
            for (int j = 0; j < this.armyVector.size(); ++j) {
                ArmyCharacter ac = (ArmyCharacter)this.armyVector.elementAt(j);
                if ((ac.id == param1 || param1 == -1) && ac.owner != 0) {
                    allTownsCaptured = false;
                    break;
                }
                if ((ac.id == param2 || param2 == -1) && ac.owner != 0) {
                    allTownsCaptured = false;
                    break;
                }
                if (ac.id != param3 && param3 != -1 || ac.owner == 0) continue;
                allTownsCaptured = false;
                break;
            }
            if (!allTownsCaptured) continue;
            System.out.println("qwerty");
            DisCanvas.instance.currGameState = DisCanvas.instance.nextGameState;
            byte next = Map.instance.triggers[i * 7 + 2];
            this.activateTrigger(next);
            Map.instance.triggers[i * 7 + 3] = 0;
        }
    }

    public void checkBattleEndTriggers(byte armyWin, byte armyLose) {
        for (int i = 0; i < Map.instance.triggersCount; ++i) {
            byte next;
            ArmyCharacter ac2;
            ArmyCharacter ac1;
            byte type = Map.instance.triggers[i * 7 + 1];
            byte enabled = Map.instance.triggers[i * 7 + 3];
            byte param1 = Map.instance.triggers[i * 7 + 4];
            byte param2 = Map.instance.triggers[i * 7 + 5];
            if (type == 2 && enabled != 0) {
                ac1 = (ArmyCharacter)this.armyVector.elementAt(armyWin);
                ac2 = (ArmyCharacter)this.armyVector.elementAt(armyLose);
                if (!(param1 != ac1.id && param1 != -1 || param2 != ac2.id && param2 != -1)) {
                    DisCanvas.instance.returnGameState = (byte)2;
                    next = Map.instance.triggers[i * 7 + 2];
                    Map.instance.triggers[i * 7 + 3] = 0;
                    this.activateTrigger(next);
                }
            }
            if (type != 4 || enabled == 0 || armyWin == -1 || armyLose == -1) continue;
            ac1 = (ArmyCharacter)this.armyVector.elementAt(armyWin);
            ac2 = (ArmyCharacter)this.armyVector.elementAt(armyLose);
            if (param1 != ac1.owner && param1 != -1 || param2 != ac2.id && param2 != -1) continue;
            System.out.println("On capture town trigger");
            DisCanvas.instance.returnGameState = (byte)19;
            next = Map.instance.triggers[i * 7 + 2];
            Map.instance.triggers[i * 7 + 3] = 0;
            this.activateTrigger(next);
            return;
        }
    }

    public void checkPointTriggers(byte x, byte y) {
        for (int i = 0; i < Map.instance.triggersCount; ++i) {
            byte type = Map.instance.triggers[i * 7 + 1];
            byte enabled = Map.instance.triggers[i * 7 + 3];
            if (type != 1 || enabled == 0) continue;
            byte triggerX = Map.instance.triggers[i * 7 + 4];
            byte triggerY = Map.instance.triggers[i * 7 + 5];
            if (triggerX != x || triggerY != y) continue;
            byte next = Map.instance.triggers[i * 7 + 2];
            this.activateTrigger(next);
            Map.instance.triggers[i * 7 + 3] = 0;
        }
    }

    public boolean moveArmyOneCell() {
        if (this.currId == -1) {
            DisCanvas.instance.fastMove = false;
            return false;
        }
        if (this.targetID == -1) {
            DisCanvas.instance.fastMove = false;
            return false;
        }
        ArmyCharacter ac = (ArmyCharacter)this.armyVector.elementAt(this.currId);
        if (this.pathPtr < this.pathLength && ac.movePoints > 0) {
            if (this.pathTick % 4 == 0) {
                boolean needMove = false;
                if (ac.animShiftX >= 16) {
                    ac.animShiftX = (byte)(ac.animShiftX - 16);
                    needMove = true;
                }
                if (ac.animShiftX <= -16) {
                    ac.animShiftX = (byte)(ac.animShiftX + 16);
                    needMove = true;
                }
                if (ac.animShiftY >= 16) {
                    ac.animShiftY = (byte)(ac.animShiftY - 16);
                    needMove = true;
                }
                if (ac.animShiftY <= -16) {
                    ac.animShiftY = (byte)(ac.animShiftY + 16);
                    needMove = true;
                }
                this.dirMaker(ac);
                DisCanvas.instance.gameStill = 0;
                if (needMove) {
                    Map.instance.armyStep = true;
                    this.initMap[ac.x][ac.y] = 126;
                    ac.x = this.path[this.pathPtr * 2];
                    ac.y = this.path[this.pathPtr * 2 + 1];
                    ac.isInTownAdditionalCheck = true;
                    this.initMap[ac.x][ac.y] = 127;
                    this.checkPointTriggers(ac.x, ac.y);
                    ac.findInFrontObjects();
                    byte monster = this.seeAround(ac.x, ac.y);
                    if (monster != -1 && this.getOwner(monster) != this.getOwner(this.currId)) {
                        this.targetID = 1;
                        this.pathLength = this.pathPtr + 1;
                        this.path[this.pathLength * 2] = this.getX(monster);
                        this.path[this.pathLength * 2 + 1] = this.getY(monster);
                    }
                    if (this.pathPtr == this.pathLength - 1 || DisCanvas.instance.wantToStop) {
                        DisCanvas.instance.gameStill = 1;
                        Map.instance.draw();
                        ac.frame = 0;
                        ac.tick = 0;
                        ac.movePoints = (byte)(ac.movePoints - 1);
                        if (this.pathPtr != this.pathLength - 1 && DisCanvas.instance.wantToStop) {
                            DisCanvas.instance.toTarget(this.path[(this.pathPtr + 1) * 2], this.path[(this.pathPtr + 1) * 2 + 1]);
                        }
                        this.checkTarget();
                        DisCanvas.instance.wantToStop = false;
                        DisCanvas.instance.fastMove = false;
                        return false;
                    }
                    ac.movePoints = (byte)(ac.movePoints - 1);
                    ++this.pathPtr;
                    this.calculateSequence();
                    DisCanvas.instance.gameStill = 1;
                }
            }
        } else if (ac.movePoints <= 0) {
            ac.frame = 0;
            ac.tick = 0;
            DisCanvas.instance.fastMove = false;
            return false;
        }
        return true;
    }

    public void visionOnMap() {
        for (int j = 0; j < this.mapHeight; ++j) {
            for (int i = 0; i < this.mapWidth; ++i) {
                if ((Map.instance.tiles[i][j] & 0x40) != 0) continue;
                this.pathMap[i][j] = 127;
            }
        }
    }

    public void initMap() {
        int i;
        this.initMap = new byte[this.mapWidth][this.mapHeight];
        this.pathMap = new byte[this.mapWidth][this.mapHeight];
        for (i = 0; i < Map.instance.natureCount; ++i) {
            if (Map.instance.nature[i][2] <= 0 || Map.instance.nature[i][2] >= 10) continue;
            this.initMap[Map.instance.nature[i][0]][Map.instance.nature[i][1]] = 125;
        }
        for (int j = 0; j < this.mapHeight; ++j) {
            for (int i2 = 0; i2 < this.mapWidth; ++i2) {
                this.initMap[i2][j] = (Map.instance.tiles[i2][j] & 0x80) != 0 ? 127 : (Map.instance.isItemOnCell(i2, j) != -1 ? 127 : 126);
            }
        }
        for (i = 0; i < Map.instance.layer3Count; ++i) {
            if (Map.instance.layer3[i][2] < 53 || Map.instance.layer3[i][2] > 55) continue;
            this.initMap[Map.instance.layer3[i][0]][Map.instance.layer3[i][1]] = 127;
        }
        for (i = 0; i < Map.instance.mapItemsCount; ++i) {
            this.initMap[Map.instance.mapItems[i][0]][Map.instance.mapItems[i][1]] = 127;
        }
        for (i = 0; i < this.armyVector.size(); ++i) {
            if (i == this.currId) continue;
            ArmyCharacter ac = (ArmyCharacter)this.armyVector.elementAt(i);
            if (!ac.visible || ac.owner >= 3) continue;
            this.initMap[ac.x][ac.y] = 127;
        }
    }

    public void calculateVision(int acx, int acy, int vision) {
        for (int y = -vision; y <= vision; ++y) {
            for (int x = -vision; x <= vision; ++x) {
                if (acx + x < 0 || acy + y < 0 || acx + x >= Map.instance.width || acy + y >= Map.instance.height || x * x + y * y > vision * vision) continue;
                byte[] byArray = Map.instance.tiles[acx + x];
                int n = acy + y;
                byArray[n] = (byte)(byArray[n] | 0x40);
            }
        }
    }

    public void calculateVision() {
        for (int i = 0; i < this.armyVector.size(); ++i) {
            ArmyCharacter ta = (ArmyCharacter)this.armyVector.elementAt(i);
            if (!ta.visible || ta.owner % 3 != 0) continue;
            this.calculateVision(ta.x, ta.y, ta.vision);
        }
    }

    public boolean fillMap() {
        this.pathMap[this.armyDistX][this.armyDistY] = 0;
        this.pathMap[this.armyX][this.armyY] = 124;
        byte count = 0;
        int maxCount = 100;
        if (this.aiTurn) {
            maxCount = 24;
        }
        while (count < 32) {
            for (int j = 0; j < this.mapHeight; ++j) {
                for (int i = 0; i < this.mapWidth; ++i) {
                    if (this.pathMap[i][j] != count) continue;
                    for (int x = -1; x <= 1; x = (int)((byte)(x + 1))) {
                        for (int y = -1; y <= 1; y = (int)((byte)(y + 1))) {
                            if (Globals.abs(x) + Globals.abs(y) == 2 || i + x < 0 || i + x > this.mapWidth - 1 || j + y < 0 || j + y > this.mapHeight - 1) continue;
                            if (this.pathMap[i + x][j + y] == 124) {
                                return true;
                            }
                            if (this.pathMap[i + x][j + y] == 126) {
                                this.pathMap[i + x][j + y] = (byte)(count + 2);
                            }
                            if (this.pathMap[i + x][j + y] != 125) continue;
                            this.pathMap[i + x][j + y] = (byte)(count + 1);
                        }
                    }
                }
            }
            count = (byte)(count + 1);
        }
        return false;
    }

    public void findNext() {
        byte min = 127;
        for (int i = -1; i <= 1; i = (int)((byte)(i + 1))) {
            for (int j = -1; j <= 1; j = (int)((byte)(j + 1))) {
                if (Globals.abs(i) + Globals.abs(j) == 2 || this.armyX + i < 0 || this.armyX + i > this.mapWidth - 1 || this.armyY + j < 0 || this.armyY + j > this.mapHeight - 1 || this.pathMap[this.armyX + i][this.armyY + j] >= min) continue;
                min = this.pathMap[this.armyX + i][this.armyY + j];
                this.armyNewX = (byte)(this.armyX + i);
                this.armyNewY = (byte)(this.armyY + j);
            }
        }
    }

    public void restoreHP() {
        Object var1_1 = null;
        if (DisCanvas._a1()) {
            return;
        }
        for (int i = 0; i < this.armyVector.size(); ++i) {
            ArmyCharacter ac = (ArmyCharacter)this.armyVector.elementAt(i);
            if (ac.leader == -1 || ac.units[ac.leader] == -1) continue;
            short hpleft = this.battleUnits[ac.units[ac.leader] * 5 + 1];
            short hpmax = Battle.instance.getHpTotalGlobal(ac.units[ac.leader]);
            if (!ac.abilities[12] || hpleft >= hpmax) continue;
            if (hpleft + 15 >= hpmax) {
                this.battleUnits[ac.units[ac.leader] * 5 + 1] = hpmax;
                continue;
            }
            int n = ac.units[ac.leader] * 5 + 1;
            this.battleUnits[n] = (short)(this.battleUnits[n] + 15);
        }
    }

    public void restoreMP(byte owner) {
        for (int i = 0; i < this.armyVector.size(); ++i) {
            ArmyCharacter ac = (ArmyCharacter)this.armyVector.elementAt(i);
            ac.maxMP(owner, true);
        }
    }

    public boolean DruidHero() {
        ArmyCharacter ac = (ArmyCharacter)this.armyVector.elementAt(this.currId);
        return ac.abilities[2];
    }

    public void findNextHero(byte owner) {
        ArmyCharacter ac;
        Object var2_2 = null;
        if (DisCanvas._a0()) {
            return;
        }
        int newHero = -1;
        int ind = (this.currId + 1) % this.armyVector.size();
        for (int c = 0; c < this.armyVector.size(); ++c) {
            ac = (ArmyCharacter)this.armyVector.elementAt(ind);
            if (ac.visible && this.getOwner(ind) == owner) {
                newHero = ind;
                break;
            }
            ind = (ind + 1) % this.armyVector.size();
        }
        if (newHero != -1) {
            this.unmarkArmy();
            this.markArmy((byte)newHero);
            ac = (ArmyCharacter)this.armyVector.elementAt(newHero);
            for (int i = 0; i < 50; ++i) {
                int x = Map.instance.getScreenX(ac.x);
                int y = Map.instance.getScreenY(ac.y);
                Map.instance.moveCamera(x, y, true);
                DisCanvas.instance.cursorFloatX = ac.x * 10000;
                DisCanvas.instance.cursorFloatY = ac.y * 10000;
                DisCanvas.instance.cursorX = ac.x;
                DisCanvas.instance.cursorY = ac.y;
            }
        }
    }

    public byte artefactType(byte id) {
        ArmyCharacter ac = (ArmyCharacter)this.armyVector.elementAt(this.currId);
        return ac.artefactType(id);
    }

    public byte getCurrHeroArt(byte id) {
        if (id == -1) {
            return -1;
        }
        ArmyCharacter ac = (ArmyCharacter)this.armyVector.elementAt(this.currId);
        return ac.slot[id];
    }

    public boolean isArtEquip(byte id) {
        ArmyCharacter ac = (ArmyCharacter)this.armyVector.elementAt(this.currId);
        return ac.isEquipped(id);
    }

    public void sellArtifact(byte selArt) {
        ArmyCharacter ac = (ArmyCharacter)this.armyVector.elementAt(this.currId);
        if (selArt <= -1 || selArt >= ac.slotcount) {
            return;
        }
        byte artId = ac.slot[selArt];
        if (!DisCanvas.instance.exchange) {
            int n = this.getOwner() * 3;
            DisCanvas.instance.res[n] = DisCanvas.instance.res[n] + DisCanvas.artefacts_cost[artId];
        } else {
            ArmyCharacter ac1 = (ArmyCharacter)this.armyVector.elementAt(DisCanvas.instance.exchangeArmy);
            ac1.addArtefact(artId);
        }
        this.item = ac.slot[selArt];
        ac.delArtefact(selArt);
    }

    public void buyArtifact(byte selArt) {
        ArmyCharacter ac = (ArmyCharacter)this.armyVector.elementAt(this.currId);
        if (selArt <= -1 || selArt >= DisCanvas.artefacts_at_market[DisCanvas.instance.marketId].length) {
            return;
        }
        byte artId = DisCanvas.artefacts_at_market[DisCanvas.instance.marketId][selArt];
        if (DisCanvas.instance.res[this.getOwner() * 3] < DisCanvas.artefacts_cost[artId]) {
            return;
        }
        int n = this.getOwner() * 3;
        DisCanvas.instance.res[n] = DisCanvas.instance.res[n] - DisCanvas.artefacts_cost[artId];
        this.item = DisCanvas.artefacts_at_market[DisCanvas.instance.marketId][selArt];
        ac.addArtefact(artId);
    }

    public byte isAlliedArmiesAround() {
        if (this.currId == -1) {
            return -1;
        }
        ArmyCharacter ac = (ArmyCharacter)this.armyVector.elementAt(this.currId);
        byte x = ac.x;
        byte y = ac.y;
        byte owner = ac.owner;
        int aroundN = 0;
        int armyId = -1;
        for (int j = 0; j < this.armyVector.size(); j = (int)((byte)(j + 1))) {
            ac = (ArmyCharacter)this.armyVector.elementAt(j);
            if (ac.owner != owner) continue;
            if (x == ac.x + 1 && y == ac.y) {
                armyId = j;
                ++aroundN;
            }
            if (x == ac.x - 1 && y == ac.y) {
                armyId = j;
                ++aroundN;
            }
            if (x == ac.x && y == ac.y - 1) {
                armyId = j;
                ++aroundN;
            }
            if (x == ac.x && y == ac.y + 1) {
                armyId = j;
                ++aroundN;
            }
            if (x == ac.x + 1 && y == ac.y + 1) {
                armyId = j;
                ++aroundN;
            }
            if (x == ac.x - 1 && y == ac.y - 1) {
                armyId = j;
                ++aroundN;
            }
            if (x == ac.x + 1 && y == ac.y - 1) {
                armyId = j;
                ++aroundN;
            }
            if (x != ac.x - 1 || y != ac.y + 1) continue;
            armyId = j;
            ++aroundN;
        }
        if (aroundN == 0) {
            return -1;
        }
        if (aroundN > 1) {
            return -2;
        }
        return (byte)armyId;
    }

    public void calculateSequence() {
        if (this.armyVector.size() == 0) {
            ArmyController.armySequenceDraw[0] = -1;
        }
        int rockCnt = -1;
        for (int j = 0; j < this.armyVector.size(); j = (int)((byte)(j + 1))) {
            ArmyController.armySequenceDraw[j] = -1;
            if (this.getOwner(j) > 2) continue;
            rockCnt = (byte)(rockCnt + 1);
            ArmyCharacter ac = (ArmyCharacter)this.armyVector.elementAt(j);
            byte ind = -1;
            byte minx = 127;
            for (byte i = 0; i < this.armyVector.size(); i = (byte)((byte)(i + 1))) {
                if (this.getOwner(i) > 2) continue;
                ac = (ArmyCharacter)this.armyVector.elementAt(i);
                if (ac.y >= minx) continue;
                boolean rep = false;
                for (int k = 0; k < j; k = (int)((byte)(k + 1))) {
                    if (armySequenceDraw[k] != i) continue;
                    rep = true;
                }
                if (rep) continue;
                ind = i;
                minx = ac.y;
            }
            ArmyController.armySequenceDraw[rockCnt] = ind;
            if (ind == -1) break;
        }
    }

    public void fillEnemyMap() {
        for (byte y = 0; y < Map.instance.height; y = (byte)(y + 1)) {
            for (byte x = 0; x < Map.instance.width; x = (byte)(x + 1)) {
                this.enemyMap[x][y] = -1;
            }
        }
        for (int i = 0; i < this.armyVector.size(); i = (int)((byte)(i + 1))) {
            ArmyCharacter ac = (ArmyCharacter)this.armyVector.elementAt(i);
            if (ac.owner >= 3) continue;
            this.enemyMap[ac.x][ac.y] = i;
        }
    }

    public void initAI() {
        Object var1_1 = null;
        if (DisCanvas._a1()) {
            return;
        }
        this.unitCounter = 0;
        this.aiReady = false;
        this.aiTurn = true;
    }

    public void ai() {
        if (DisCanvas.instance.onTourney) {
            return;
        }
        this.hireLeaders();
        if (this.unitCounter >= this.armyVector.size() || this.armyVector.size() == 0) {
            this.aiReady = true;
            this.aiTurn = false;
            return;
        }
        ArmyCharacter ac = (ArmyCharacter)this.armyVector.elementAt(this.unitCounter);
        boolean newAim = false;
        if (ac.owner == 1) {
            this.armyIterCount = (byte)(this.armyIterCount + 1);
            this.unmarkArmy();
            this.markArmy(this.unitCounter);
            this.reorderUnits(ac);
            if (Map.instance.isTownOnCell(ac.x, ac.y) != -1) {
                this.healInTown(ac);
                this.hireUnit(ac);
            }
            this.buyArt(ac);
            this.equipArmy(ac);
            this.healArmy(ac);
            newAim = this.computeWeight(ac);
            if (newAim) {
                this.setTarget(this.aiChoiceType);
                this.computePath(this.aiPreyX, this.aiPreyY);
                DisCanvas.instance.onTourney = true;
            }
        }
        if (!newAim || ac.movePoints == 0 || this.armyIterCount >= 3) {
            this.unitCounter = (byte)(this.unitCounter + 1);
            this.armyIterCount = 0;
        }
    }

    public void reorderUnits(ArmyCharacter ac) {
        short temp;
        if (this.battleUnits[ac.units[ac.leader] * 5 + 0] == 4) {
            temp = ac.units[1];
            ac.units[1] = ac.units[ac.leader];
            ac.units[ac.leader] = temp;
            ac.leader = 1;
        } else {
            temp = ac.units[4];
            ac.units[4] = ac.units[ac.leader];
            ac.units[ac.leader] = temp;
            ac.leader = (byte)4;
        }
        for (byte i = 0; i < 6; i = (byte)(i + 1)) {
            if (ac.units[i] == -1 || ac.leader == i) continue;
            short type = this.battleUnits[ac.units[i] * 5 + 0];
            if (type >= 29 && type < 33) {
                temp = ac.units[0];
                ac.units[0] = ac.units[i];
                ac.units[i] = temp;
                continue;
            }
            if (type >= 33 && type < 36) {
                temp = ac.units[3];
                ac.units[3] = ac.units[i];
                ac.units[i] = temp;
                continue;
            }
            if (type >= 36 && type < 39) {
                temp = ac.units[5];
                ac.units[5] = ac.units[i];
                ac.units[i] = temp;
                continue;
            }
            if (type < 39 || type >= 42) continue;
            temp = ac.units[2];
            ac.units[2] = ac.units[i];
            ac.units[i] = temp;
        }
    }

    public void hireUnit(ArmyCharacter ac) {
        boolean possesed = false;
        boolean cultist = false;
        boolean gargoyle = false;
        boolean devil = false;
        int empty = -1;
        if (ac.unitsCount() < ac.leadership && ac.leadership < 6) {
            for (int b = 0; b < 6; b = (int)((byte)(b + 1))) {
                if (ac.units[b] == -1) {
                    empty = b;
                    continue;
                }
                short type = this.battleUnits[ac.units[b] * 5 + 0];
                if (type >= 29 && type < 33) {
                    possesed = true;
                }
                if (type >= 33 && type < 36) {
                    cultist = true;
                }
                if (type >= 36 && type < 39) {
                    gargoyle = true;
                }
                if (type < 39 || type >= 42) continue;
                devil = true;
            }
            if (empty == -1) {
                return;
            }
            int lv = DisCanvas.instance.res[3];
            if (!possesed) {
                if (DisCanvas.UNITS_COST[4] > lv) {
                    return;
                }
                this.battleUnits[this.battleUnitsCount * 5 + 0] = 29;
                this.battleUnits[this.battleUnitsCount * 5 + 1] = Battle.instance.unitStaticParams[174];
            } else if (!cultist) {
                if (DisCanvas.UNITS_COST[5] > lv) {
                    return;
                }
                this.battleUnits[this.battleUnitsCount * 5 + 0] = 33;
                this.battleUnits[this.battleUnitsCount * 5 + 1] = Battle.instance.unitStaticParams[198];
            } else if (!gargoyle) {
                if (DisCanvas.UNITS_COST[6] > lv) {
                    return;
                }
                this.battleUnits[this.battleUnitsCount * 5 + 0] = 36;
                this.battleUnits[this.battleUnitsCount * 5 + 1] = Battle.instance.unitStaticParams[216];
            } else {
                if (DisCanvas.UNITS_COST[7] > lv) {
                    return;
                }
                this.battleUnits[this.battleUnitsCount * 5 + 0] = 39;
                this.battleUnits[this.battleUnitsCount * 5 + 1] = Battle.instance.unitStaticParams[234];
            }
            this.battleUnits[this.battleUnitsCount * 5 + 2] = 0;
            this.battleUnits[this.battleUnitsCount * 5 + 4] = 0;
            this.battleUnits[this.battleUnitsCount * 5 + 3] = 1;
            ++this.battleUnitsCount;
            ac.units[empty] = (short)(this.battleUnitsCount - 1);
            DisCanvas.instance.res[3] = DisCanvas.instance.res[3] - lv;
        }
    }

    public void hireLeaders() {
        int i;
        Object var1_1 = null;
        if (DisCanvas._a0()) {
            return;
        }
        boolean duke = false;
        boolean councelor = false;
        boolean baroness = false;
        boolean archdevil = false;
        int armCount = 0;
        for (i = 0; i < this.armyVector.size(); i = (int)((byte)(i + 1))) {
            ArmyCharacter ac = (ArmyCharacter)this.armyVector.elementAt(i);
            if (ac.owner != 1) continue;
            armCount = (short)(armCount + 1);
            if (ac.units[ac.leader] == -1) continue;
            if (this.battleUnits[ac.units[ac.leader] * 5 + 0] == 4) {
                duke = true;
            }
            if (this.battleUnits[ac.units[ac.leader] * 5 + 0] == 5) {
                councelor = true;
            }
            if (this.battleUnits[ac.units[ac.leader] * 5 + 0] == 6) {
                baroness = true;
            }
            if (this.battleUnits[ac.units[ac.leader] * 5 + 0] != 7) continue;
            archdevil = true;
        }
        for (i = 0; i < Map.instance.layer3Count; i = (int)((byte)(i + 1))) {
            if (Map.instance.layer3[i][2] != 51 && (Map.instance.layer3[i][2] != 52 || Map.instance.layer3[i][4] != 1) || DisCanvas.instance.capitals[Map.instance.layer3[i][5]][1] != -1 || armCount >= 4) continue;
            int lv = DisCanvas.instance.res[3];
            byte armyX = (byte)(Map.instance.layer3[i][0] + 1);
            byte armyY = (byte)(Map.instance.layer3[i][1] + 3);
            if (Map.instance.layer3[i][5] >= 2) {
                armyY = (byte)(armyY - 1);
            }
            if (!duke && Map.instance.findMine((byte)1)) {
                if (DisCanvas.UNITS_COST[0] > lv) {
                    return;
                }
                this.addArmy(armyX, armyY, (byte)1, (byte)1, (byte)-1, (byte)4, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, true);
                DisCanvas.instance.res[3] = DisCanvas.instance.res[3] - DisCanvas.UNITS_COST[0];
            } else if (!baroness) {
                if (DisCanvas.UNITS_COST[2] > lv) {
                    return;
                }
                this.addArmy(armyX, armyY, (byte)1, (byte)1, (byte)-1, (byte)6, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, true);
                DisCanvas.instance.res[3] = DisCanvas.instance.res[3] - DisCanvas.UNITS_COST[2];
            } else if (!councelor) {
                if (DisCanvas.UNITS_COST[1] > lv) {
                    return;
                }
                this.addArmy(armyX, armyY, (byte)1, (byte)1, (byte)-1, (byte)5, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, true);
                DisCanvas.instance.res[3] = DisCanvas.instance.res[3] - DisCanvas.UNITS_COST[1];
            } else {
                if (DisCanvas.UNITS_COST[3] > lv) {
                    return;
                }
                this.addArmy(armyX, armyY, (byte)1, (byte)1, (byte)-1, (byte)7, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, true);
                DisCanvas.instance.res[3] = DisCanvas.instance.res[3] - DisCanvas.UNITS_COST[3];
            }
            instance.calculateSequence();
            DisCanvas.instance.capitals[Map.instance.layer3[i][5]][1] = (byte)(this.armyVector.size() - 1);
        }
    }

    public short getArmyState(ArmyCharacter ac) {
        int deadUnit = 0;
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            if (ac.units[i] == -1 || this.battleUnits[ac.units[i] * 5 + 1] > 0) continue;
            deadUnit = (byte)(deadUnit + 1);
        }
        short ret = (short)((ac.leadership - ac.unitsCount()) * 50);
        ret = (short)(ret + (short)deadUnit * 0);
        return ret;
    }

    public void buyArt(ArmyCharacter ac) {
        if (Map.instance.isBuildingOnCell(ac.x, ac.y - 1) != -1 && this.bottlesNeeded(ac) && DisCanvas.instance.res[ac.owner * 3] >= DisCanvas.artefacts_cost[0] * this.nrest + DisCanvas.artefacts_cost[1] * this.nress) {
            byte i;
            for (i = 0; i < this.nress; i = (byte)(i + 1)) {
                if (DisCanvas.instance.res[ac.owner * 3] < DisCanvas.artefacts_cost[1]) continue;
                ac.addArtefact((byte)1);
                int n = ac.owner * 3;
                DisCanvas.instance.res[n] = DisCanvas.instance.res[n] - DisCanvas.artefacts_cost[1];
            }
            for (i = 0; i < this.nrest; i = (byte)(i + 1)) {
                if (DisCanvas.instance.res[ac.owner * 3] < DisCanvas.artefacts_cost[0]) continue;
                ac.addArtefact((byte)0);
                int n = ac.owner * 3;
                DisCanvas.instance.res[n] = DisCanvas.instance.res[n] - DisCanvas.artefacts_cost[0];
            }
        }
    }

    public boolean bottlesNeeded(ArmyCharacter hero) {
        this.nrest = (byte)-1;
        this.nress = (byte)-1;
        for (byte b = 0; b < hero.slotcount; b = (byte)(b + 1)) {
            if (hero.slot[b] == 0) {
                this.nrest = hero.counts[b] < 2 ? (byte)(2 - hero.counts[b]) : (byte)0;
            }
            if (hero.slot[b] != 1) continue;
            this.nress = hero.counts[b] < 2 ? (byte)(2 - hero.counts[b]) : (byte)0;
        }
        if (this.nrest == -1) {
            this.nrest = (byte)2;
        }
        if (this.nress == -1) {
            this.nress = (byte)2;
        }
        return (this.nrest > 0 || this.nress > 0) && DisCanvas.instance.res[3] >= DisCanvas.artefacts_cost[0] * this.nrest + DisCanvas.artefacts_cost[1] * this.nress;
    }

    public void equipArmy(ArmyCharacter hero) {
        byte b;
        byte[] best = new byte[3];
        byte c = 0;
        for (byte b2 = 0; b2 < hero.slotcount; b2 = (byte)(b2 + 1)) {
            if (hero.artefactType(hero.slot[b2]) != 2) continue;
            best[c] = b2;
            c = (byte)(c + 1);
        }
        byte m = 0;
        byte p = -1;
        for (b = 0; b < c; b = (byte)((byte)(b + 1))) {
            if (best[b] <= m) continue;
            m = best[b];
            p = b;
        }
        if (p != -1) {
            hero.artefactEquip(hero.slot[best[p]]);
        }
        c = 0;
        for (b = 0; b < hero.slotcount; b = (byte)((byte)(b + 1))) {
            if (hero.artefactType(hero.slot[b]) != 0) continue;
            best[c] = b;
            c = (byte)(c + 1);
        }
        m = 0;
        p = -1;
        for (b = 0; b < c; b = (byte)((byte)(b + 1))) {
            if (best[b] <= m) continue;
            m = best[b];
            p = b;
        }
        if (p != -1) {
            hero.artefactEquip(hero.slot[best[p]]);
        }
        c = 0;
        for (b = 0; b < hero.slotcount; b = (byte)((byte)(b + 1))) {
            if (hero.artefactType(hero.slot[b]) != 1) continue;
            best[c] = b;
            c = (byte)(c + 1);
        }
        m = 0;
        p = -1;
        for (b = 0; b < c; b = (byte)((byte)(b + 1))) {
            if (best[b] <= m) continue;
            m = best[b];
            p = b;
        }
        if (p != -1) {
            hero.artefactEquip(hero.slot[best[p]]);
        }
        c = 0;
        for (b = 0; b < hero.slotcount; b = (byte)(b + 1)) {
            if (hero.artefactType(hero.slot[b]) != 3 && hero.artefactType(hero.slot[b]) != 4) continue;
            hero.artefactEquip(b);
        }
    }

    public void healArmy(ArmyCharacter hero) {
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            short hpTotal;
            if (hero.units[i] == -1 || (hpTotal = Battle.instance.getHpTotalGlobal(hero.units[i])) - this.battleUnits[hero.units[i] * 5 + 1] <= 10) continue;
            if (this.battleUnits[hero.units[i] * 5 + 1] > 0) {
                if (!hero.findArtefact((byte)0)) continue;
                hero.delArtefact(hero.getArtefactSlot((byte)0));
                if (this.battleUnits[hero.units[i] * 5 + 1] + 100 > hpTotal) {
                    this.battleUnits[hero.units[i] * 5 + 1] = hpTotal;
                    continue;
                }
                int n = hero.units[i] * 5 + 1;
                this.battleUnits[n] = (short)(this.battleUnits[n] + 100);
                continue;
            }
            if (!hero.findArtefact((byte)1)) continue;
            hero.delArtefact(hero.getArtefactSlot((byte)1));
            this.battleUnits[hero.units[i] * 5 + 1] = 1;
        }
    }

    public void healInTown(ArmyCharacter hero) {
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            if (hero.units[i] == -1) continue;
            if (DisCanvas.instance.res[hero.owner * 3] <= 0) break;
            short hpTotal = Battle.instance.getHpTotalGlobal(hero.units[i]);
            short toHeal = (short)(hpTotal - this.battleUnits[hero.units[i] * 5 + 1]);
            if (toHeal <= 0) continue;
            if (this.battleUnits[hero.units[i] * 5 + 1] > 0) {
                if (DisCanvas.instance.res[hero.owner * 3] > toHeal) {
                    int n = hero.owner * 3;
                    DisCanvas.instance.res[n] = DisCanvas.instance.res[n] - toHeal;
                    this.battleUnits[hero.units[i] * 5 + 1] = hpTotal;
                    continue;
                }
                int n = hero.units[i] * 5 + 1;
                this.battleUnits[n] = (short)(this.battleUnits[n] + DisCanvas.instance.res[hero.owner * 3]);
                DisCanvas.instance.res[hero.owner * 3] = 0;
                continue;
            }
            if (DisCanvas.instance.res[hero.owner * 3] < hpTotal) continue;
            this.battleUnits[hero.units[i] * 5 + 1] = 1;
            int n = hero.owner * 3;
            DisCanvas.instance.res[n] = DisCanvas.instance.res[n] - hpTotal;
        }
    }

    public boolean computeWeight(ArmyCharacter unit) {
        byte j;
        byte currTownId;
        int chance;
        int chance2;
        byte i;
        this.aiBestChoice = 0;
        int selW = 0;
        this.aiChoiceType = (byte)-1;
        this.aiPreyId = -1;
        this.inAI = true;
        if (!unit.noTarget) {
            unit.currentWindow = (byte)4;
        } else if (unit.noTarget && unit.currentWindow < 12) {
            unit.currentWindow = (byte)(unit.currentWindow + 1);
        } else if (unit.currentWindow >= 12) {
            unit.currentWindow = (byte)4;
        }
        DisCanvas.instance.currentTownId = (byte)-1;
        for (i = 0; i < Map.instance.mapItemsCount; i = (byte)(i + 1)) {
            if (Globals.abs(unit.x - Map.instance.mapItems[i][0]) > unit.currentWindow || Globals.abs(unit.y - Map.instance.mapItems[i][1]) > unit.currentWindow) continue;
            this.setTarget((byte)4);
            this.computePath(Map.instance.mapItems[i][0], Map.instance.mapItems[i][1]);
            unit.maxMP(unit.owner, false);
            selW = 1400;
            if (unit.movePoints - this.pathLength >= 0) {
                selW -= this.pathLength * 10;
            } else {
                selW -= unit.movePoints * 10;
                selW -= ((this.pathLength - unit.movePoints) / unit.maxMP(unit.owner, false) + 1) * 100;
            }
            if (!this.moreThenOneMonster) {
                if (this.wayMonster != -1 && (chance2 = Battle.instance.computeChances(this.unitCounter, this.wayMonster)) < 50) {
                    selW -= 300 + (50 - chance2) * 50;
                }
            } else {
                selW = 0;
            }
            if (selW < 0) {
                selW = 0;
            }
            if (this.targetID == -1 || selW <= this.aiBestChoice) continue;
            this.aiPreyId = i;
            this.aiPreyX = Map.instance.mapItems[i][0];
            this.aiPreyY = Map.instance.mapItems[i][1];
            this.aiBestChoice = selW;
            this.aiChoiceType = (byte)4;
        }
        selW = this.aiBestChoice;
        if (this.DruidHero()) {
            for (i = 0; i < Map.instance.layer3Count; i = (byte)(i + 1)) {
                if (Map.instance.layer3[i][2] < 53 || Map.instance.layer3[i][2] > 55 || Map.instance.layer3[i][4] == 1 || Globals.abs(unit.x - Map.instance.layer3[i][0]) > unit.currentWindow || Globals.abs(unit.y - Map.instance.layer3[i][1]) > unit.currentWindow) continue;
                this.setTarget((byte)7);
                this.computePath(Map.instance.layer3[i][0], Map.instance.layer3[i][1]);
                unit.maxMP(unit.owner, false);
                selW = 1200;
                if (unit.movePoints - this.pathLength >= 0) {
                    selW -= this.pathLength * 10;
                } else {
                    selW -= unit.movePoints * 10;
                    selW -= ((this.pathLength - unit.movePoints) / unit.maxMP(unit.owner, false) + 1) * 100;
                }
                if (!this.moreThenOneMonster) {
                    if (this.wayMonster != -1 && (chance2 = Battle.instance.computeChances(this.unitCounter, this.wayMonster)) < 50) {
                        selW -= 300 + (50 - chance2) * 50;
                    }
                } else {
                    selW = 0;
                }
                if (!Map.instance.findMine((byte)1) && DisCanvas.instance.res[3] < 100 && Map.instance.layer3[i][2] == 53) {
                    selW += 1000;
                }
                if (selW < 0) {
                    selW = 0;
                }
                if (this.targetID == -1 || selW < this.aiBestChoice) continue;
                this.aiPreyId = i;
                this.aiPreyX = Map.instance.layer3[i][0];
                this.aiPreyY = Map.instance.layer3[i][1];
                this.aiBestChoice = selW;
                this.aiChoiceType = (byte)7;
            }
        }
        selW = this.aiBestChoice;
        for (i = 0; i < this.armyVector.size(); i = (byte)(i + 1)) {
            if (i == this.currId) continue;
            ArmyCharacter ac = (ArmyCharacter)this.armyVector.elementAt(i);
            if (!ac.visible || ac.owner >= 3 || ac.owner == this.getOwner(this.currId) || Globals.abs(unit.x - ac.x) > unit.currentWindow || Globals.abs(unit.y - ac.y) > unit.currentWindow) continue;
            this.setTarget((byte)1);
            this.computePath(ac.x, ac.y);
            unit.maxMP(unit.owner, false);
            selW = 1400;
            int win = Battle.instance.computeChances(this.unitCounter, i);
            if (win < 50) {
                selW -= (50 - win) * 0;
            }
            if (unit.movePoints - this.pathLength >= 0) {
                selW -= this.pathLength * 10;
            } else {
                selW -= unit.movePoints * 10;
                selW -= ((this.pathLength - unit.movePoints) / unit.maxMP(unit.owner, false) + 1) * 100;
            }
            if (!this.moreThenOneMonster) {
                if (this.wayMonster != -1 && (chance = Battle.instance.computeChances(this.unitCounter, this.wayMonster)) < 50) {
                    selW -= 300 + (50 - chance) * 50;
                }
            } else {
                selW = 0;
            }
            if (selW < 0) {
                selW = 0;
            }
            if (this.targetID == -1 || selW < this.aiBestChoice) continue;
            this.aiPreyId = i;
            this.aiPreyX = ac.x;
            this.aiPreyY = ac.y;
            this.aiBestChoice = selW;
            this.aiChoiceType = 1;
        }
        selW = this.aiBestChoice;
        for (i = 0; i < Map.instance.layer3Count; i = (byte)(i + 1)) {
            if (Map.instance.layer3[i][2] != 56 || Globals.abs(unit.x - Map.instance.layer3[i][0]) > unit.currentWindow || Globals.abs(unit.y - Map.instance.layer3[i][1]) > unit.currentWindow) continue;
            this.setTarget((byte)5);
            this.computePath((byte)(Map.instance.layer3[i][0] + 1), (byte)(Map.instance.layer3[i][1] + 1));
            unit.maxMP(unit.owner, false);
            selW = 1200;
            if (!this.bottlesNeeded(unit)) {
                selW = 0;
            } else {
                selW += this.nrest * 25;
                selW += this.nress * 25;
            }
            if (unit.movePoints - this.pathLength >= 0) {
                selW -= this.pathLength * 10;
            } else {
                selW -= unit.movePoints * 10;
                selW -= ((this.pathLength - unit.movePoints) / unit.maxMP(unit.owner, false) + 1) * 100;
            }
            if (!this.moreThenOneMonster) {
                int chance3;
                if (this.wayMonster != -1 && (chance3 = Battle.instance.computeChances(this.unitCounter, this.wayMonster)) < 50) {
                    selW -= 300 + (50 - chance3) * 50;
                }
            } else {
                selW = 0;
            }
            if (!Map.instance.findMine((byte)1) && DisCanvas.instance.res[3] < 100) {
                selW = 0;
            }
            if (selW < 0) {
                selW = 0;
            }
            if (this.targetID == -1 || selW < this.aiBestChoice) continue;
            this.aiPreyId = i;
            this.aiPreyX = (byte)(Map.instance.layer3[i][0] + 1);
            this.aiPreyY = (byte)(Map.instance.layer3[i][1] + 1);
            this.aiBestChoice = selW;
            this.aiChoiceType = (byte)5;
        }
        selW = this.aiBestChoice;
        for (i = 0; i < DisCanvas.instance.townsCount; i = (byte)(i + 1)) {
            short addit;
            if (this.getOwner(DisCanvas.instance.capitals[i][0]) != 4 || DisCanvas.instance.capitals[i][1] != -1) continue;
            int entY = 3;
            currTownId = DisCanvas.instance.capitals[i][2];
            if (Map.instance.layer3[currTownId][2] == 52) {
                entY = 2;
            }
            if (Map.instance.layer3[currTownId][0] + 1 == unit.x && Map.instance.layer3[currTownId][1] + entY == unit.y) break;
            this.setTarget((byte)3);
            this.computePath((byte)(Map.instance.layer3[currTownId][0] + 1), (byte)(Map.instance.layer3[currTownId][1] + entY));
            unit.maxMP(unit.owner, false);
            selW = 500;
            if (unit.movePoints - this.pathLength >= 0) {
                selW -= this.pathLength * 10;
            } else {
                selW -= unit.movePoints * 10;
                selW -= ((this.pathLength - unit.movePoints) / unit.maxMP(unit.owner, false) + 1) * 100;
            }
            if (!this.moreThenOneMonster) {
                if (this.wayMonster != -1 && (chance = Battle.instance.computeChances(this.unitCounter, this.wayMonster)) < 50) {
                    selW -= 300 + (50 - chance) * 50;
                }
            } else {
                selW = 0;
            }
            selW = (addit = this.getArmyState(unit)) > 0 ? (selW += addit) : 0;
            if (!Map.instance.findMine((byte)1) && DisCanvas.instance.res[3] < 100) {
                selW = 0;
            }
            boolean isAlliedInTown = false;
            if (DisCanvas.instance.capitals[i][1] != -1) {
                isAlliedInTown = true;
            }
            if (Map.instance.isTownOnCellAi(unit.x, unit.y) != -1) {
                isAlliedInTown = true;
            }
            if (isAlliedInTown) {
                selW = 0;
            }
            if (selW < 0) {
                selW = 0;
            }
            if (this.targetID == -1 || selW < this.aiBestChoice) continue;
            this.aiPreyId = i;
            this.aiPreyX = (byte)(Map.instance.layer3[currTownId][0] + 1);
            this.aiPreyY = (byte)(Map.instance.layer3[currTownId][1] + entY);
            this.aiBestChoice = selW;
            this.aiChoiceType = (byte)3;
            DisCanvas.instance.currentTownId = currTownId;
        }
        selW = this.aiBestChoice;
        for (i = 0; i < DisCanvas.instance.townsCount; i = (byte)(i + 1)) {
            if (this.getOwner(DisCanvas.instance.capitals[i][0]) == 4) continue;
            int entY = 3;
            currTownId = DisCanvas.instance.capitals[i][2];
            if (Map.instance.layer3[currTownId][2] == 52) {
                entY = 2;
            }
            if (Map.instance.layer3[currTownId][0] + 1 == unit.x && Map.instance.layer3[currTownId][1] + entY == unit.y) break;
            this.setTarget((byte)3);
            this.computePath((byte)(Map.instance.layer3[currTownId][0] + 1), (byte)(Map.instance.layer3[currTownId][1] + entY));
            unit.maxMP(unit.owner, false);
            selW = 1600;
            chance = Battle.instance.computeChances(this.unitCounter, DisCanvas.instance.capitals[i][0]);
            if (chance < 50) {
                selW -= (50 - chance) * 50;
            }
            if (unit.movePoints - this.pathLength >= 0) {
                selW -= this.pathLength * 10;
            } else {
                selW -= unit.movePoints * 10;
                selW -= ((this.pathLength - unit.movePoints) / unit.maxMP(unit.owner, false) + 1) * 100;
            }
            if (!this.moreThenOneMonster) {
                if (this.wayMonster != -1 && (chance = Battle.instance.computeChances(this.unitCounter, this.wayMonster)) < 50) {
                    selW -= 300 + (50 - chance) * 50;
                }
            } else {
                selW = 0;
            }
            if (!Map.instance.findMine((byte)1) && DisCanvas.instance.res[3] < 100) {
                selW = 0;
            }
            if (selW < 0) {
                selW = 0;
            }
            if (this.targetID == -1 || selW < this.aiBestChoice) continue;
            this.aiPreyId = i;
            this.aiPreyX = (byte)(Map.instance.layer3[currTownId][0] + 1);
            this.aiPreyY = (byte)(Map.instance.layer3[currTownId][1] + entY);
            this.aiBestChoice = selW;
            this.aiChoiceType = (byte)3;
            DisCanvas.instance.currentTownId = DisCanvas.instance.capitals[i][2];
        }
        this.inAI = false;
        if (this.aiBestChoice == 0) {
            this.aiPreyId = -1;
        }
        if (this.aiPreyId == -1) {
            unit.noTarget = true;
            return false;
        }
        unit.isInTownAdditionalCheck = false;
        if (unit.isInTown() && (i = Map.instance.isTownOnCellAi(unit.x, unit.y)) != -1 && (j = Map.instance.layer3[i][5]) != -1) {
            DisCanvas.instance.capitals[j][1] = -1;
        }
        System.out.println("aiChoiceType=" + this.aiChoiceType);
        return true;
    }
}

