/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class MeBoy
extends MIDlet
implements CommandListener {
    public static final boolean debug = false;
    public static int rotations = 0;
    public static int maxFrameSkip = 3;
    public static boolean enableScaling = true;
    public static int scalingMode = 0;
    public static boolean keepProportions = true;
    public static boolean fullScreen = false;
    public static boolean disableColor = false;
    public static boolean enableSound = false;
    public static boolean advancedSound = false;
    public static boolean advancedGraphics = false;
    public static boolean showFps = false;
    public static boolean showLogItem = false;
    public static int lazyLoadingThreshold = 512;
    public static int language;
    private static boolean bluetoothAvailable;
    public static int suspendCounter;
    public static String[] suspendName10;
    public static String[] suspendName20;
    public static String[] literal;
    private static int languageCount;
    private static String[] languages;
    private static int[] languageLookup;
    private String[] cartDisplayName = null;
    private String[] cartFileName = null;
    private int numCarts;
    private boolean fatalError;
    public static String logString;
    private static MeBoy instance;
    public static Display display;
    private List mainMenu;
    private Form messageForm;
    private GBCanvas gbCanvas;
    private List cartList;
    private List changeDir;
    private List suspendList;
    private Form settingsForm;
    private TextField frameSkipField;
    private TextField rotationField;
    private TextField loadThresholdField;
    private TextField scalingModeField;
    private ChoiceGroup graphicsGroup;
    private ChoiceGroup miscSettingsGroup;
    private ChoiceGroup soundGroup;
    private ChoiceGroup languageGroup;
    private Bluetooth bluetooth;
    private Hashtable cartIDsDB = new Hashtable();
    private static boolean chDirRetToMain;
    private static String romsPath;
    private String curDir = "file:///";
    private Command refreshCommand;
    private Command chDirCommand;

    public void startApp() {
        if (instance == this) {
            return;
        }
        try {
            bluetoothAvailable = Bluetooth.available();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        instance = this;
        display = Display.getDisplay((MIDlet)this);
        GBCanvas.readSettings();
        this.readLangIndexFile();
        if (!this.readLiteralsFile()) {
            return;
        }
        this.readFSettings();
        if (!this.upgradeSavegames()) {
            return;
        }
        this.showMainMenu();
    }

    private boolean readLiteralsFile() {
        try {
            String string;
            InputStreamReader inputStreamReader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/lang/" + language + ".txt"), "UTF-8");
            int n = 0;
            while ((string = this.next(inputStreamReader)) != null) {
                MeBoy.literal[n++] = string;
            }
            inputStreamReader.close();
            while (n < literal.length) {
                MeBoy.literal[n++] = "?";
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (language > 0) {
                language = 0;
                return this.readLiteralsFile();
            }
            MeBoy.showError("Failed to read the language file.", null, exception);
            this.fatalError = true;
            return false;
        }
        return true;
    }

    private void readLangIndexFile() {
        try {
            String string;
            InputStreamReader inputStreamReader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/lang/index.txt"), "UTF-8");
            Vector<Integer> vector = new Vector<Integer>();
            Vector<String> vector2 = new Vector<String>();
            languageCount = 0;
            while ((string = this.next(inputStreamReader)) != null) {
                vector.addElement(new Integer(string.charAt(0) - 97));
                vector2.addElement(this.next(inputStreamReader));
                ++languageCount;
            }
            languages = new String[languageCount];
            languageLookup = new int[languageCount];
            vector2.copyInto(languages);
            languageCount = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                MeBoy.languageLookup[MeBoy.languageCount++] = (Integer)enumeration.nextElement();
            }
            inputStreamReader.close();
        }
        catch (Exception exception) {
            languages = new String[]{"English"};
            languageLookup = new int[]{0};
            languageCount = 1;
        }
    }

    private String next(InputStreamReader inputStreamReader) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = inputStreamReader.read()) != -1) {
            if (n >= 32) {
                stringBuffer.append((char)n);
                continue;
            }
            if (stringBuffer.length() <= 0) continue;
            return stringBuffer.toString();
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        return null;
    }

    public void readFSettings() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"set_f", (boolean)false);
            int n = recordStore.getNumRecords();
            if (n > 0) {
                romsPath = new String(recordStore.getRecord(1));
            }
            if (n > 1) {
                int n2 = GBCanvas.getInt(recordStore.getRecord(2), 0) * 2 + 3;
                for (int i = 3; i < n2; i += 2) {
                    this.cartIDsDB.put(new String(recordStore.getRecord(i)), new String(recordStore.getRecord(i + 1)));
                }
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeRomsPath() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"set_f", (boolean)true);
            byte[] byArray = romsPath.getBytes();
            int n = byArray.length;
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, n);
            } else {
                recordStore.setRecord(1, byArray, 0, n);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            MeBoy.log(exception.toString());
        }
    }

    public void writeCartIDsDB() {
        if (romsPath.length() == 0) {
            return;
        }
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"set_f", (boolean)true);
            int n = recordStore.getNumRecords();
            int n2 = this.cartIDsDB.size();
            byte[] byArray = new byte[4];
            GBCanvas.setInt(byArray, 0, n2);
            if (n < 2) {
                recordStore.addRecord(byArray, 0, 4);
            } else {
                recordStore.setRecord(2, byArray, 0, 4);
            }
            int n3 = 3;
            Enumeration enumeration = this.cartIDsDB.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)this.cartIDsDB.get(string);
                byArray = string.getBytes();
                int n4 = byArray.length;
                byte[] byArray2 = string2.getBytes();
                int n5 = byArray2.length;
                if (n < n3) {
                    recordStore.addRecord(byArray, 0, n4);
                    recordStore.addRecord(byArray2, 0, n5);
                    n3 += 2;
                    continue;
                }
                if (n > n3) {
                    recordStore.setRecord(n3++, byArray, 0, n4);
                    recordStore.setRecord(n3++, byArray2, 0, n5);
                    continue;
                }
                recordStore.setRecord(n3, byArray, 0, n4);
                recordStore.addRecord(byArray2, 0, n5);
                n3 += 2;
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            MeBoy.log(exception.toString());
        }
    }

    private boolean readCartNames() {
        try {
            String string;
            FileConnection fileConnection = (FileConnection)Connector.open((String)romsPath, (int)1);
            Enumeration enumeration = fileConnection.list();
            SortedStringVector sortedStringVector = new SortedStringVector();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                string = string2.toLowerCase();
                if (!string.endsWith(".gb") && !string.endsWith(".sgb") && !string.endsWith(".gbc")) continue;
                sortedStringVector.addElement(string2);
            }
            enumeration = null;
            fileConnection.close();
            sortedStringVector.sort();
            this.numCarts = sortedStringVector.size();
            this.cartDisplayName = new String[this.numCarts];
            this.cartFileName = new String[this.numCarts];
            for (int i = 0; i < this.numCarts; ++i) {
                string = (String)sortedStringVector.elementAt(i);
                this.cartDisplayName[i] = string.substring(0, string.lastIndexOf(46));
                this.cartFileName[i] = romsPath + string;
            }
        }
        catch (Exception exception) {
            MeBoy.showError(literal[51], null, exception);
            return false;
        }
        return true;
    }

    public boolean upgradeSavegames() {
        Enumeration enumeration = this.cartIDsDB.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.cartIDsDB.get(string);
            String string3 = string2.substring(string2.lastIndexOf(47) + 1);
            try {
                RecordStore recordStore = RecordStore.openRecordStore((String)string3, (boolean)false);
                if (recordStore.getNumRecords() > 0) {
                    byte[] byArray = recordStore.getRecord(1);
                    RecordStore recordStore2 = RecordStore.openRecordStore((String)("20R_" + string), (boolean)true);
                    if (recordStore2.getNumRecords() == 0) {
                        recordStore2.addRecord(byArray, 0, byArray.length);
                    }
                    recordStore2.closeRecordStore();
                    recordStore.deleteRecord(1);
                }
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {}
        }
        try {
            int n = 0;
            while (n < suspendName10.length) {
                if (this.upgradeSuspendedGame(n)) continue;
                MeBoy.log("Could not upgrade " + suspendName10[n]);
                ++n;
            }
        }
        catch (Exception exception) {
            this.fatalError = true;
            MeBoy.showError(literal[50], null, exception);
            return false;
        }
        return true;
    }

    private boolean upgradeSuspendedGame(int n) throws RecordStoreException {
        boolean bl = false;
        String string = suspendName10[n];
        RecordStore recordStore = RecordStore.openRecordStore((String)("s" + string), (boolean)false);
        byte[] byArray = recordStore.getRecord(1);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (byArray[n2] != 0) {
            stringBuffer.append((char)byArray[n2]);
            ++n2;
        }
        String string2 = stringBuffer.toString();
        Enumeration enumeration = this.cartIDsDB.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = (String)this.cartIDsDB.get(string3);
            String string5 = string4.substring(string4.lastIndexOf(47) + 1);
            if (!string2.equals(string5)) continue;
            String[] stringArray = suspendName10;
            suspendName10 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 0, suspendName10, 0, n);
            System.arraycopy(stringArray, n + 1, suspendName10, n, suspendName10.length - n);
            bl = true;
            GBCanvas.writeSettings();
            recordStore.deleteRecord(1);
            recordStore.closeRecordStore();
            recordStore = null;
            RecordStore recordStore2 = RecordStore.openRecordStore((String)("20S_" + string), (boolean)true);
            boolean bl2 = false;
            if (recordStore2.getNumRecords() == 0) {
                boolean bl3;
                byte[] byArray2 = string3.getBytes();
                int n3 = string2.length() + 629;
                if ((byArray.length - n3) % 8192 == 132) {
                    bl3 = true;
                } else if ((byArray.length - n3) % 8192 == 0) {
                    bl3 = false;
                } else {
                    recordStore2.closeRecordStore();
                    throw new RuntimeException("1 " + byArray.length + " " + n3);
                }
                int n4 = 107 + string2.length() + (bl3 ? 1 : 0);
                byte[] byArray3 = new byte[byArray.length - n4];
                int n5 = 0;
                int n6 = string2.length() + 1;
                byArray3[n5++] = 1;
                byArray3[n5++] = (byte)(bl3 ? 1 : 0);
                System.arraycopy(byArray, n6, byArray3, n5, 24);
                int n7 = GBCanvas.getInt(byArray, (n6 += 24) - 4);
                int n8 = GBCanvas.getInt(byArray, n6);
                System.arraycopy(byArray, n6 += 4, byArray3, n5 += 24, 4);
                n5 += 4;
                n6 += 5;
                byArray3[n5++] = (byte)(n7 == Integer.MAX_VALUE ? 1 : 0);
                byArray3[n5++] = 0;
                byArray3[n5++] = byArray[n6++];
                byArray3[n5++] = byArray[n6++];
                byArray3[n5++] = (byte)(n8 == Integer.MAX_VALUE ? 1 : 0);
                int n9 = bl3 ? 32768 : 8192;
                System.arraycopy(byArray, n6, byArray3, n5, n9 + 160);
                System.arraycopy(byArray, n6 += n9 + 256, byArray3, n5 += n9 + 160, 264);
                n5 += 264;
                n6 += 268;
                if (bl3) {
                    int n10 = byArray3.length - n5 - 131;
                    System.arraycopy(byArray, n6, byArray3, n5, n10);
                    System.arraycopy(byArray, n6 += n10 + 7, byArray3, n5 += n10, 131);
                    n5 += 131;
                    n6 += 131;
                } else {
                    int n11 = byArray3.length - n5;
                    System.arraycopy(byArray, n6, byArray3, n5, n11);
                    n5 += n11;
                    n6 += n11 + 6;
                }
                if (n6 != byArray.length) {
                    recordStore2.closeRecordStore();
                    throw new RuntimeException(string + " " + n6 + "/" + byArray.length);
                }
                recordStore2.addRecord(byArray2, 0, byArray2.length);
                recordStore2.addRecord(byArray3, 0, byArray3.length);
                bl2 = true;
            }
            recordStore2.closeRecordStore();
            if (!bl2) break;
            MeBoy.addSuspendedGame(string);
            break;
        }
        if (recordStore != null) {
            recordStore.closeRecordStore();
        }
        return bl;
    }

    public void pauseApp() {
        if (this.gbCanvas != null) {
            this.gbCanvas.pause();
        }
    }

    public void destroyApp(boolean bl) {
    }

    public void unloadCart() {
        this.showMainMenu();
        this.gbCanvas.releaseReferences();
        this.gbCanvas = null;
    }

    private static String formatDetails(String string, Throwable throwable) {
        if (throwable != null) {
            string = string == null || string.length() == 0 ? throwable.toString() : string + ", " + throwable;
        }
        if (string != null && string.length() > 0) {
            return " (" + string + ")";
        }
        return "";
    }

    public static void showError(String string, String string2, Throwable throwable) {
        if (string == null) {
            string = literal[47];
        }
        instance.showMessage(literal[46], string + MeBoy.formatDetails(string2, throwable));
        if (MeBoy.instance.gbCanvas != null) {
            MeBoy.instance.gbCanvas.releaseReferences();
        }
        MeBoy.instance.gbCanvas = null;
    }

    public static void showLog() {
        instance.showMessage(literal[28], logString);
    }

    public void showMessage(String string, String string2) {
        this.messageForm = new Form(string);
        this.messageForm.append(string2);
        this.messageForm.setCommandListener((CommandListener)this);
        this.messageForm.addCommand(new Command(literal[10], 2, 0));
        display.setCurrent((Displayable)this.messageForm);
    }

    private void messageCommand() {
        if (this.fatalError) {
            this.destroyApp(true);
            this.notifyDestroyed();
        } else {
            this.messageForm = null;
            this.showMainMenu();
        }
    }

    private void showMainMenu() {
        this.mainMenu = new List("MeBoy-F 2.2.1", 3);
        this.mainMenu.append(literal[0], null);
        if (suspendName20.length > 0) {
            this.mainMenu.append(literal[1], null);
        }
        this.mainMenu.append(literal[2], null);
        if (bluetoothAvailable) {
            this.mainMenu.append(literal[4], null);
        }
        this.mainMenu.append(literal[5], null);
        if (showLogItem) {
            this.mainMenu.append(literal[3], null);
        }
        this.mainMenu.append(literal[6], null);
        this.mainMenu.setCommandListener((CommandListener)this);
        display.setCurrent((Displayable)this.mainMenu);
    }

    private void mainMenuCommand(Command command) {
        String string = this.mainMenu.getString(this.mainMenu.getSelectedIndex());
        if (string == literal[0]) {
            this.showCartList();
        } else if (string == literal[1]) {
            this.showResumeGame();
        } else if (string == literal[2]) {
            this.showSettings();
        } else if (string == literal[4]) {
            this.bluetooth = new Bluetooth(this);
        } else if (string == literal[5]) {
            this.showMessage(literal[5], "MeBoy-F 2.2.1 \u00a9 kFYatek, 2010.\nhttp://kfyatek-dev.jogger.pl/\n\nMeBoy \u00a9 Bj\u00f6rn Carlin, 2005-2009.\nhttp://arktos.se/meboy/");
        } else if (string == literal[3]) {
            MeBoy.log(literal[29] + " " + Runtime.getRuntime().freeMemory() + "/" + Runtime.getRuntime().totalMemory());
            MeBoy.showLog();
        } else if (string == literal[6]) {
            this.destroyApp(true);
            this.notifyDestroyed();
        } else {
            MeBoy.showError(null, "Unknown command: " + command.getLabel(), null);
        }
    }

    private void showCartList() {
        final MeBoy meBoy = this;
        Thread thread = new Thread(){

            public void run() {
                if (romsPath.length() == 0 || !MeBoy.this.readCartNames()) {
                    chDirRetToMain = true;
                    MeBoy.this.showChangeDir("");
                    return;
                }
                MeBoy.this.cartList = new List(literal[7], 3);
                for (int i = 0; i < MeBoy.this.numCarts; ++i) {
                    MeBoy.this.cartList.append(MeBoy.this.cartDisplayName[i], null);
                }
                MeBoy.this.cartList.addCommand(new Command(literal[10], 2, 1));
                MeBoy.this.cartList.addCommand(MeBoy.this.refreshCommand = new Command(literal[72], 1, 1));
                MeBoy.this.cartList.addCommand(MeBoy.this.chDirCommand = new Command(literal[73], 1, 1));
                MeBoy.this.cartList.setCommandListener(meBoy);
                display.setCurrent((Displayable)MeBoy.this.cartList);
            }
        };
        thread.start();
    }

    private void cartListCommand(Command command) {
        if (command.getCommandType() == 2) {
            this.cartList = null;
            this.showMainMenu();
            return;
        }
        if (command == this.refreshCommand) {
            this.showCartList();
            return;
        }
        if (command == this.chDirCommand) {
            chDirRetToMain = false;
            this.showChangeDir(romsPath);
            return;
        }
        int n = this.cartList.getSelectedIndex();
        final String string = this.cartFileName[n];
        final String string2 = this.cartDisplayName[n];
        final MeBoy meBoy = this;
        Thread thread = new Thread(){

            public void run() {
                try {
                    MeBoy.this.gbCanvas = new GBCanvas(string, meBoy, string2);
                    MeBoy.this.cartList = null;
                    display.setCurrent((Displayable)MeBoy.this.gbCanvas);
                }
                catch (Exception exception) {
                    MeBoy.showError(null, "error#1", exception);
                }
            }
        };
        thread.start();
    }

    private void showChangeDir(final String string) {
        final MeBoy meBoy = this;
        Thread thread = new Thread(){

            public void run() {
                try {
                    if (string.length() <= 8) {
                        MeBoy.this.changeDir = new List(literal[74], 3);
                        MeBoy.this.curDir = "file:///";
                        Enumeration enumeration = FileSystemRegistry.listRoots();
                        SortedStringVector sortedStringVector = new SortedStringVector();
                        while (enumeration.hasMoreElements()) {
                            sortedStringVector.addElement(enumeration.nextElement());
                        }
                        enumeration = null;
                        sortedStringVector.sort();
                        enumeration = sortedStringVector.elements();
                        while (enumeration.hasMoreElements()) {
                            MeBoy.this.changeDir.append((String)enumeration.nextElement(), null);
                        }
                    } else {
                        MeBoy.this.changeDir = new List(string.substring(8), 3);
                        MeBoy.this.curDir = string;
                        MeBoy.this.changeDir.append(literal[75], null);
                        MeBoy.this.changeDir.append(literal[76], null);
                        FileConnection fileConnection = (FileConnection)Connector.open((String)MeBoy.this.curDir, (int)1);
                        Enumeration enumeration = fileConnection.list();
                        SortedStringVector sortedStringVector = new SortedStringVector();
                        while (enumeration.hasMoreElements()) {
                            String string2 = (String)enumeration.nextElement();
                            if (string2.charAt(string2.length() - 1) != '/') continue;
                            sortedStringVector.addElement(string2);
                        }
                        enumeration = null;
                        fileConnection.close();
                        sortedStringVector.sort();
                        enumeration = sortedStringVector.elements();
                        while (enumeration.hasMoreElements()) {
                            MeBoy.this.changeDir.append((String)enumeration.nextElement(), null);
                        }
                    }
                    MeBoy.this.changeDir.addCommand(new Command(literal[57], 2, 1));
                    MeBoy.this.changeDir.addCommand(MeBoy.this.refreshCommand = new Command(literal[72], 1, 1));
                    MeBoy.this.changeDir.setCommandListener(meBoy);
                    display.setCurrent((Displayable)MeBoy.this.changeDir);
                }
                catch (Exception exception) {
                    MeBoy.showError(literal[77], null, exception);
                }
            }
        };
        thread.start();
    }

    private void changeDirCommand(Command command) {
        if (command.getCommandType() == 2) {
            if (chDirRetToMain) {
                this.showMainMenu();
            } else {
                this.showCartList();
            }
        } else if (command == this.refreshCommand) {
            this.showChangeDir(this.curDir);
        } else {
            int n = this.changeDir.getSelectedIndex();
            if (this.curDir.length() > 8 && n < 2) {
                if (n == 0) {
                    romsPath = this.curDir;
                    this.writeRomsPath();
                    this.showCartList();
                } else {
                    int n2 = this.curDir.lastIndexOf(47, this.curDir.length() - 2);
                    this.showChangeDir(this.curDir.substring(0, n2 + 1));
                }
            } else {
                this.showChangeDir(this.curDir + this.changeDir.getString(n));
            }
        }
    }

    private void showResumeGame() {
        if (suspendName20.length == 0) {
            this.showMainMenu();
            return;
        }
        this.suspendList = new List(literal[7], 3);
        for (int i = 0; i < suspendName20.length; ++i) {
            this.suspendList.append(suspendName20[i], null);
        }
        this.suspendList.addCommand(new Command(literal[8], 1, 2));
        this.suspendList.addCommand(new Command(literal[9], 1, 2));
        this.suspendList.addCommand(new Command(literal[10], 2, 1));
        this.suspendList.setCommandListener((CommandListener)this);
        display.setCurrent((Displayable)this.suspendList);
    }

    private void resumeGameCommand(Command command) {
        if (command.getCommandType() == 2) {
            this.suspendList = null;
            this.showMainMenu();
            return;
        }
        String string = command.getLabel();
        int n = this.suspendList.getSelectedIndex();
        String string2 = suspendName20[n];
        if (string == literal[8]) {
            try {
                String[] stringArray = suspendName20;
                suspendName20 = new String[stringArray.length - 1];
                System.arraycopy(stringArray, 0, suspendName20, 0, n);
                System.arraycopy(stringArray, n + 1, suspendName20, n, suspendName20.length - n);
                GBCanvas.writeSettings();
                RecordStore.deleteRecordStore((String)("20S_" + string2));
            }
            catch (Exception exception) {
                MeBoy.showError(null, "error#2", exception);
            }
            this.showResumeGame();
        } else if (string == literal[9]) {
            try {
                String string3 = string2;
                String string4 = suspendCounter++ + string3.substring(string3.indexOf(58));
                RecordStore recordStore = RecordStore.openRecordStore((String)("20S_" + string3), (boolean)true);
                byte[] byArray = recordStore.getRecord(1);
                byte[] byArray2 = recordStore.getRecord(2);
                recordStore.closeRecordStore();
                recordStore = RecordStore.openRecordStore((String)("20S_" + string4), (boolean)true);
                recordStore.addRecord(byArray, 0, byArray.length);
                recordStore.addRecord(byArray2, 0, byArray2.length);
                recordStore.closeRecordStore();
                MeBoy.addSuspendedGame(string4);
                this.showResumeGame();
            }
            catch (Exception exception) {
                MeBoy.showError(null, "error#3", exception);
            }
        } else {
            final MeBoy meBoy = this;
            final String string5 = string2;
            Thread thread = new Thread(){

                public void run() {
                    try {
                        RecordStore recordStore = RecordStore.openRecordStore((String)("20S_" + string5), (boolean)false);
                        String string = new String(recordStore.getRecord(1));
                        byte[] byArray = recordStore.getRecord(2);
                        recordStore.closeRecordStore();
                        String string2 = (String)MeBoy.this.cartIDsDB.get(string);
                        if (string2 == null) {
                            MeBoy.showError(literal[11], string, null);
                        } else {
                            String string3 = string2.substring(string2.lastIndexOf(47) + 1, string2.lastIndexOf(46));
                            MeBoy.this.gbCanvas = new GBCanvas(string, string2, meBoy, string3, string5, byArray);
                            display.setCurrent((Displayable)MeBoy.this.gbCanvas);
                        }
                        MeBoy.this.suspendList = null;
                    }
                    catch (Exception exception) {
                        MeBoy.showError(null, "error#4", exception);
                    }
                }
            };
            thread.start();
        }
    }

    private void showSettings() {
        this.settingsForm = new Form(literal[2]);
        this.frameSkipField = new TextField(literal[12], "" + maxFrameSkip, 3, 2);
        this.settingsForm.append((Item)this.frameSkipField);
        this.rotationField = new TextField(literal[13], "" + rotations, 2, 2);
        this.settingsForm.append((Item)this.rotationField);
        this.graphicsGroup = new ChoiceGroup(literal[14], 2, new String[]{literal[15], literal[16], literal[17]}, null);
        this.graphicsGroup.setSelectedIndex(0, enableScaling);
        this.graphicsGroup.setSelectedIndex(1, keepProportions);
        this.graphicsGroup.setSelectedIndex(2, advancedGraphics);
        this.settingsForm.append((Item)this.graphicsGroup);
        this.scalingModeField = new TextField(literal[18], Integer.toString(scalingMode), 2, 2);
        this.settingsForm.append((Item)this.scalingModeField);
        this.soundGroup = new ChoiceGroup(literal[19], 2, new String[]{literal[20], literal[21]}, null);
        this.soundGroup.setSelectedIndex(0, enableSound);
        this.soundGroup.setSelectedIndex(1, advancedSound);
        this.settingsForm.append((Item)this.soundGroup);
        this.languageGroup = new ChoiceGroup(literal[22], 1, languages, null);
        for (int i = 0; i < languages.length; ++i) {
            this.languageGroup.setSelectedIndex(i, language == languageLookup[i]);
        }
        this.settingsForm.append((Item)this.languageGroup);
        this.miscSettingsGroup = new ChoiceGroup(literal[23], 2, new String[]{literal[24], literal[25]}, null);
        this.miscSettingsGroup.setSelectedIndex(0, disableColor);
        this.miscSettingsGroup.setSelectedIndex(1, showLogItem);
        this.settingsForm.append((Item)this.miscSettingsGroup);
        this.loadThresholdField = new TextField(literal[26], "" + lazyLoadingThreshold * 16, 5, 2);
        this.settingsForm.append((Item)this.loadThresholdField);
        this.settingsForm.addCommand(new Command(literal[10], 2, 0));
        this.settingsForm.addCommand(new Command(literal[27], 4, 1));
        this.settingsForm.setCommandListener((CommandListener)this);
        display.setCurrent((Displayable)this.settingsForm);
    }

    private void settingsCommand(Command command) {
        if (command.getCommandType() == 2) {
            this.settingsForm = null;
            this.showMainMenu();
            return;
        }
        int n = Integer.parseInt(this.frameSkipField.getString());
        maxFrameSkip = Math.max(Math.min(n, 59), 0);
        rotations = Integer.parseInt(this.rotationField.getString()) & 3;
        lazyLoadingThreshold = Math.max(Integer.parseInt(this.loadThresholdField.getString()) / 16, 20);
        enableScaling = this.graphicsGroup.isSelected(0);
        keepProportions = this.graphicsGroup.isSelected(1);
        advancedGraphics = this.graphicsGroup.isSelected(2);
        n = Integer.parseInt(this.scalingModeField.getString());
        scalingMode = Math.max(Math.min(n, 3), 0);
        disableColor = this.miscSettingsGroup.isSelected(0);
        showLogItem = this.miscSettingsGroup.isSelected(1);
        enableSound = this.soundGroup.isSelected(0);
        advancedSound = this.soundGroup.isSelected(1);
        int n2 = language;
        language = languageLookup[this.languageGroup.getSelectedIndex()];
        GBCanvas.writeSettings();
        if (n2 != language) {
            this.readLiteralsFile();
            this.cartList = null;
        }
        this.settingsForm = null;
        this.showMainMenu();
    }

    public void addSavegamesToList(List list, Vector vector, Vector vector2) {
        Enumeration enumeration = this.cartIDsDB.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.cartIDsDB.get(string);
            String string3 = string2.substring(string2.lastIndexOf(47) + 1, string2.lastIndexOf(46));
            try {
                RecordStore recordStore = RecordStore.openRecordStore((String)("20R_" + string), (boolean)true);
                if (recordStore.getNumRecords() > 0) {
                    list.append(string3, null);
                    vector.addElement(string);
                    vector2.addElement(string2);
                }
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                MeBoy.log(exception.toString());
            }
        }
    }

    private boolean tearDownBluetooth() {
        if (this.bluetooth != null) {
            this.bluetooth.tearDown();
            this.bluetooth = null;
            return true;
        }
        return false;
    }

    public synchronized void cancelBluetooth() {
        if (this.tearDownBluetooth()) {
            this.showMainMenu();
        }
    }

    public synchronized void cancelBluetooth(String string) {
        if (this.tearDownBluetooth()) {
            this.showMessage(literal[4], string);
        }
    }

    public synchronized void cancelBluetooth(Exception exception) {
        if (!this.tearDownBluetooth()) {
            return;
        }
        MeBoy.log("BT: " + exception);
        this.showMessage(literal[4], literal[59]);
    }

    public synchronized void finishBluetooth() {
        if (this.tearDownBluetooth()) {
            this.showMessage(literal[4], literal[58]);
        }
    }

    public synchronized void finishBluetoothReceive(String string, String string2, String string3, String string4, byte[] byArray) {
        this.tearDownBluetooth();
        if (string.equals("r")) {
            String string5;
            if (string4.length() == 0) {
                string5 = null;
                if (string5 == null && string3.length() > 0) {
                    string5 = this.findMatch(string3, true);
                }
                if (string5 == null && string2.length() > 0) {
                    string5 = this.findMatch(string2, true);
                }
                if (string5 != null) {
                    string4 = string5;
                }
            }
            if (string4.length() > 0) {
                MeBoy.addGameRAM(string4, byArray);
                this.showMessage(literal[4], literal[58]);
            } else {
                string5 = "";
                if (string2.length() > 0) {
                    string5 = string2;
                } else if (string3.length() > 0) {
                    string5 = string3;
                } else if (string4.length() > 0) {
                    string5 = string4;
                }
                this.showMessage(literal[4], literal[63] + MeBoy.formatDetails(string5, null));
            }
        } else if (string4.length() > 0) {
            try {
                String string6 = suspendCounter++ + ": " + string2;
                RecordStore recordStore = RecordStore.openRecordStore((String)("20S_" + string6), (boolean)true);
                if (recordStore.getNumRecords() == 0) {
                    recordStore.addRecord(string4.getBytes(), 0, string4.length());
                    recordStore.addRecord(byArray, 0, byArray.length);
                } else {
                    recordStore.setRecord(1, string4.getBytes(), 0, string4.length());
                    recordStore.setRecord(2, byArray, 0, byArray.length);
                }
                recordStore.closeRecordStore();
                MeBoy.addSuspendedGame(string6);
                this.showMessage(literal[4], literal[58]);
            }
            catch (Exception exception) {
                this.showMessage(literal[4], literal[64] + MeBoy.formatDetails(string4, exception));
            }
        } else {
            this.showMessage(literal[4], literal[63] + MeBoy.formatDetails(string4, null));
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.messageForm) {
            this.messageCommand();
        } else if (displayable == this.mainMenu) {
            this.mainMenuCommand(command);
        } else if (displayable == this.cartList) {
            this.cartListCommand(command);
        } else if (displayable == this.changeDir) {
            this.changeDirCommand(command);
        } else if (displayable == this.suspendList) {
            this.resumeGameCommand(command);
        } else if (displayable == this.settingsForm) {
            this.settingsCommand(command);
        }
    }

    public static void log(String string) {
        if (string == null) {
            return;
        }
        logString = logString + string + '\n';
    }

    public static void addGameRAM(String string, byte[] byArray) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)("20R_" + string), (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addSuspendedGame(String string) {
        String[] stringArray = suspendName20;
        suspendName20 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, suspendName20, 0, stringArray.length);
        MeBoy.suspendName20[stringArray.length] = string;
        GBCanvas.writeSettings();
    }

    private String findMatch(String string, boolean bl) {
        String string2;
        String string3;
        String string4;
        Enumeration enumeration = this.cartIDsDB.keys();
        while (enumeration.hasMoreElements()) {
            string4 = (String)enumeration.nextElement();
            String string5 = (String)this.cartIDsDB.get(string4);
            if (string5.equals(string)) {
                return string4;
            }
            string3 = string5.substring(string5.lastIndexOf(47) + 1);
            if (string3.equals(string)) {
                return string4;
            }
            string2 = string3.substring(0, string3.lastIndexOf(46));
            if (!string2.equals(string)) continue;
            return string4;
        }
        string4 = string;
        if (bl) {
            int n = string.lastIndexOf(46);
            if (n > 0) {
                string4 = string.substring(0, n);
            }
            enumeration = this.cartIDsDB.keys();
            while (enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                string2 = (String)this.cartIDsDB.get(string3);
                String string6 = string2.substring(string2.lastIndexOf(47) + 1);
                if (!string6.startsWith(string4)) continue;
                return string3;
            }
        }
        return null;
    }

    public void updateCartID(String string, String string2) {
        this.cartIDsDB.put(string2, string);
        this.writeCartIDsDB();
    }

    static {
        bluetoothAvailable = false;
        suspendCounter = 1;
        suspendName10 = new String[0];
        suspendName20 = new String[0];
        literal = new String[80];
        languageCount = 1;
        languages = new String[]{"English"};
        languageLookup = new int[]{0};
        logString = "";
        chDirRetToMain = false;
        romsPath = "";
    }

    private static class SortedStringVector
    extends Vector {
        private static final int INSERTIONSORT_THRESHOLD = 7;

        private SortedStringVector() {
        }

        private static int cisc(String string, String string2) {
            String string3;
            String string4 = string.toLowerCase();
            int n = string4.compareTo(string3 = string2.toLowerCase());
            return n == 0 ? string.compareTo(string2) : n;
        }

        private static void swap(Object[] objectArray, int n, int n2) {
            Object object = objectArray[n];
            objectArray[n] = objectArray[n2];
            objectArray[n2] = object;
        }

        private static void mergeSort(Object[] objectArray, Object[] objectArray2, int n, int n2) {
            int n3 = n2 - n;
            if (n3 < 7) {
                for (int i = n; i < n2; ++i) {
                    for (int j = i; j > n && SortedStringVector.cisc((String)objectArray2[j - 1], (String)objectArray2[j]) > 0; --j) {
                        SortedStringVector.swap(objectArray2, j, j - 1);
                    }
                }
                return;
            }
            int n4 = n;
            int n5 = n2;
            int n6 = n + n2 >>> 1;
            SortedStringVector.mergeSort(objectArray2, objectArray, n, n6);
            SortedStringVector.mergeSort(objectArray2, objectArray, n6, n2);
            if (SortedStringVector.cisc((String)objectArray[n6 - 1], (String)objectArray[n6]) <= 0) {
                System.arraycopy(objectArray, n, objectArray2, n4, n3);
                return;
            }
            int n7 = n;
            int n8 = n6;
            for (int i = n4; i < n5; ++i) {
                objectArray2[i] = n8 >= n2 || n7 < n6 && SortedStringVector.cisc((String)objectArray[n7], (String)objectArray[n8]) <= 0 ? objectArray[n7++] : objectArray[n8++];
            }
        }

        public void sort() {
            Object[] objectArray = new Object[this.elementCount];
            System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
            SortedStringVector.mergeSort(objectArray, this.elementData, 0, this.elementCount);
        }
    }
}

