/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SimpleGraphicsChip
extends GraphicsChip {
    boolean winEnabledThisFrame = true;
    boolean spritesEnabledThisFrame = true;
    private boolean screenFilled;
    private boolean windowStopped;
    private boolean winEnabledThisLine = false;
    private int windowStopLine = 144;
    private int windowStopX;
    private int windowStopY;
    boolean savedWindowDataSelect = false;
    private Image transparentImage;
    private Image[] tileImage;
    private boolean[] tileReadState;
    private int[][] imageBounds;
    private int[] tempPix;
    int tileWidth = 8;
    int tileHeight = 8;
    int imageHeight = 8;
    private Graphics graphics;

    public SimpleGraphicsChip(Dmgcpu dmgcpu) {
        super(dmgcpu);
        this.colors = new int[]{-1, -5592406, -11184811, -16777216};
        this.gbcMask = -16777216;
        this.transparentCutoff = this.cpu.gbcFeatures ? 32 : 0;
        this.tileImage = new Image[this.tileCount * this.colorCount];
        this.imageBounds = new int[this.tileCount][];
        this.tileReadState = new boolean[this.tileCount];
        this.cpu.memory[4] = this.videoRam;
        this.tempPix = new int[this.tileWidth * this.tileHeight * 2];
        this.transparentImage = Image.createRGBImage((int[])this.tempPix, (int)this.tileWidth, (int)this.tileHeight, (boolean)true);
        this.frameBufferImage = Image.createImage((int)this.scaledWidth, (int)this.scaledHeight);
        this.graphics = this.frameBufferImage.getGraphics();
    }

    public void UpdateLCDCFlags(int n) {
        if (this.doubledSprites != ((n & 4) != 0)) {
            this.invalidateAll(1);
            this.invalidateAll(2);
        }
        super.UpdateLCDCFlags(n);
        this.spritesEnabledThisFrame |= this.spritesEnabled;
    }

    public final void addressWrite(int n, byte by) {
        int n2;
        if (this.videoRam[n] == by) {
            return;
        }
        if (n < 6144 && this.tileReadState[n2 = (n >> 4) + this.tileOffset]) {
            int n3 = this.tileImage.length - this.tileCount + n2;
            do {
                this.tileImage[n3] = null;
            } while ((n3 -= this.tileCount) >= 0);
            this.imageBounds[n2] = null;
            this.tileReadState[n2] = false;
        }
        this.videoRam[n] = by;
    }

    public final void invalidateAll(int n) {
        int n2 = n * this.tileCount * 4;
        int n3 = (n + 1) * this.tileCount * 4;
        for (int i = n2; i < n3; ++i) {
            this.tileImage[i] = null;
        }
    }

    private final void drawSprites(int n) {
        if (!this.spritesEnabledThisFrame) {
            return;
        }
        int n2 = 255;
        if (this.doubledSprites) {
            n2 = 254;
            this.imageHeight = this.tileHeight * 2;
        }
        for (int i = 156; i >= 0; i -= 4) {
            int n3 = 0xFF & this.cpu.oam[i + 3];
            if ((n3 & 0x80) != n) continue;
            int n4 = (0xFF & this.cpu.oam[i + 1]) - 8;
            int n5 = (0xFF & this.cpu.oam[i]) - 16;
            if (n4 >= 160 || n5 >= 144 || n5 == -16) continue;
            int n6 = n2 & this.cpu.oam[i + 2];
            int n7 = n3 >> 5 & 3;
            if (this.cpu.gbcFeatures) {
                n7 += 32 + ((n3 & 7) << 2);
                n6 += 48 * (n3 & 8);
            } else {
                n7 += 4 + ((n3 & 0x10) >> 2);
            }
            this.draw(n6, n4, n5, n7);
        }
        this.imageHeight = this.tileHeight;
    }

    public final void notifyScanline(int n) {
        if (this.skipping) {
            return;
        }
        if (n == 0) {
            if (!this.cpu.gbcFeatures) {
                this.graphics.setColor(this.gbPalette[0]);
                this.graphics.fillRect(0, 0, this.scaledWidth, this.scaledHeight);
                this.drawSprites(128);
            }
            this.windowStopLine = 144;
            this.winEnabledThisFrame = this.winEnabled;
            this.winEnabledThisLine = this.winEnabled;
            this.screenFilled = false;
            this.windowStopped = false;
        }
        if (this.winEnabledThisLine && !this.winEnabled) {
            this.windowStopLine = n & 0xFF;
            this.winEnabledThisLine = false;
        }
        if (n == (this.cpu.registers[74] & 0xFF) + 1) {
            this.savedWindowDataSelect = this.bgWindowDataSelect;
        }
        if (!this.bgEnabled) {
            return;
        }
        if (this.winEnabledThisLine && !this.windowStopped && (this.cpu.registers[75] & 0xFF) - 7 == 0 && (this.cpu.registers[74] & 0xFF) <= n - 7) {
            int n2 = this.cpu.registers[66] & 7;
            int n3 = (n & 0xF8) - n2;
            if (n3 >= 136) {
                this.screenFilled = true;
            }
        } else if ((this.cpu.registers[66] + n & 7) == 7 || n == 144) {
            int n4 = this.cpu.registers[67] & 7;
            int n5 = this.cpu.registers[66] & 7;
            int n6 = (this.cpu.registers[67] & 0xFF) >> 3;
            int n7 = (this.cpu.registers[66] & 0xFF) >> 3;
            int n8 = this.hiBgTileMapAddress ? 7168 : 6144;
            int n9 = (n & 0xF8) - n5;
            int n10 = 160;
            int n11 = (n >> 3) + n7;
            int n12 = n6;
            int n13 = n8 + ((n11 & 0x1F) << 5);
            for (int i = -n4; i < n10; i += 8) {
                int n14 = this.bgWindowDataSelect ? this.videoRamBanks[0][n13 + (n12 & 0x1F)] & 0xFF : 256 + this.videoRamBanks[0][n13 + (n12 & 0x1F)];
                int n15 = 0;
                if (this.cpu.gbcFeatures) {
                    byte by = this.videoRamBanks[1][n13 + (n12 & 0x1F)];
                    n15 += (by & 7) << 2;
                    n15 += by >> 5 & 3;
                    n14 += 384 * (by >> 3 & 1);
                }
                ++n12;
                this.draw(n14, i, n9, n15);
            }
            if (n9 >= 136) {
                this.screenFilled = true;
            }
        }
        if (n == 143) {
            if (!this.screenFilled) {
                this.notifyScanline(144);
            }
            this.updateFrameBufferImage();
        }
    }

    private final void updateFrameBufferImage() {
        if (this.lcdEnabled) {
            if (this.winEnabledThisFrame) {
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                int n6 = n5 = this.hiWinTileMapAddress ? 7168 : 6144;
                if (this.windowStopped) {
                    n4 = this.windowStopX;
                    n3 = this.windowStopY;
                } else {
                    n4 = (this.cpu.registers[75] & 0xFF) - 7;
                    n3 = this.cpu.registers[74] & 0xFF;
                }
                if (!this.cpu.gbcFeatures) {
                    this.graphics.setColor(this.gbPalette[0]);
                    n2 = this.windowStopLine - n3;
                    n = 160 - n4;
                    this.graphics.fillRect(n4 * this.tileWidth >> 3, n3 * this.tileHeight >> 3, n * this.tileWidth >> 3, n2 * this.tileHeight >> 3);
                }
                int n7 = n3;
                int n8 = 19 - (n3 >> 3);
                for (int i = 0; i < n8 && n3 + i * 8 < this.windowStopLine; ++i) {
                    n = n5 + i * 32;
                    int n9 = n4;
                    while (n9 < 160) {
                        n2 = this.savedWindowDataSelect ? this.videoRamBanks[0][n] & 0xFF : 256 + this.videoRamBanks[0][n];
                        int n10 = 0;
                        if (this.cpu.gbcFeatures) {
                            byte by = this.videoRamBanks[1][n];
                            n10 += (by & 7) << 2;
                            n10 += by >> 5 & 3;
                            n2 += 384 * (by >> 3 & 1);
                        }
                        this.draw(n2, n9, n7, n10);
                        n9 += 8;
                        ++n;
                    }
                    n7 += 8;
                }
            }
            if (this.cpu.gbcFeatures) {
                this.drawSprites(128);
            }
            this.drawSprites(0);
        } else {
            this.graphics.setColor(this.cpu.gbcFeatures ? -1 : this.gbPalette[0]);
            this.graphics.fillRect(0, 0, this.scaledWidth, this.scaledHeight);
        }
        this.spritesEnabledThisFrame = this.spritesEnabled;
    }

    private final Image updateImage(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int[] nArray;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12 = n + this.tileCount * n2;
        boolean bl = n >= 384;
        int n13 = bl ? n - 384 << 4 : n << 4;
        int n14 = n2 & 0xFC;
        byte[] byArray = bl ? this.videoRamBanks[1] : this.videoRamBanks[0];
        int[] nArray2 = this.cpu.gbcFeatures ? this.gbcPalette : this.gbPalette;
        boolean bl2 = n2 >= this.transparentCutoff;
        int n15 = 0;
        if (!bl2) {
            n11 = this.tileWidth;
            n10 = this.imageHeight;
            n9 = 4 - this.tileWidth;
            n8 = 4 - this.tileHeight;
        } else if (this.imageBounds[n] != null) {
            nArray = this.imageBounds[n];
            n11 = nArray[4];
            n10 = nArray[5];
            n8 = nArray[6];
            n9 = nArray[7];
            n13 += nArray[8];
            n15 = nArray[9];
        } else {
            nArray = new int[10];
            nArray[0] = this.tileWidth;
            nArray[1] = this.imageHeight;
            n7 = n13;
            n6 = 0;
            n8 = 4 - this.tileHeight;
            for (n5 = 0; n5 < this.imageHeight; ++n5) {
                n4 = byArray[n7] | byArray[n7 + 1];
                if (n4 != 0) {
                    nArray[1] = Math.min(nArray[1], n5);
                    nArray[3] = n5 + 1;
                }
                n6 |= n4;
                n8 += 8;
                while (n8 > 0) {
                    n8 -= this.tileHeight;
                    n7 += 2;
                }
            }
            n3 = 4 - this.tileWidth;
            n5 = this.tileWidth;
            while (--n5 >= 0) {
                if ((n6 & 1) != 0) {
                    nArray[0] = n5;
                    nArray[2] = Math.max(nArray[2], n5 + 1);
                }
                n3 += 8;
                while (n3 > 0) {
                    n3 -= this.tileWidth;
                    n6 >>= 1;
                }
            }
            if (nArray[0] == this.tileWidth) {
                this.tileImage[n12] = this.transparentImage;
                this.tileReadState[n] = true;
                return this.tileImage[n12];
            }
            this.imageBounds[n] = nArray;
            nArray[2] = this.tileWidth - nArray[2];
            nArray[3] = this.imageHeight - nArray[3];
            nArray[4] = n11 = this.tileWidth - nArray[2] - nArray[0];
            nArray[5] = n10 = this.imageHeight - nArray[3] - nArray[1];
            n9 = 4 - this.tileWidth + (nArray[2] << 3);
            for (n8 = 4 - this.tileHeight + (nArray[1] << 3); n8 > 0; n8 -= this.tileHeight) {
                nArray[8] = nArray[8] + 2;
            }
            while (n9 > 0) {
                n9 -= this.tileWidth;
                n15 += 2;
            }
            nArray[6] = n8;
            nArray[7] = n9;
            n13 += nArray[8];
            nArray[9] = n15;
        }
        int n16 = 0;
        n7 = 1;
        n6 = 0;
        if ((n2 & 2) != 0) {
            n6 = -n11 << 1;
            n16 = n11 * (n10 - 1);
        }
        if ((n2 & 1) == 0) {
            n7 = -1;
            n16 += n11 - 1;
            n6 += n11 << 1;
        }
        n5 = 0;
        n4 = n10;
        while (--n4 >= 0) {
            int n17 = weaveLookup[byArray[n13] & 0xFF] + (weaveLookup[byArray[n13 + 1] & 0xFF] << 1) >> n15;
            n3 = n9;
            int n18 = n11;
            while (--n18 >= 0) {
                this.tempPix[n16] = nArray2[n14 + (n17 & 3)];
                n16 += n7;
                n3 += 8;
                while (n3 > 0) {
                    n3 -= this.tileWidth;
                    n17 >>= 2;
                }
            }
            n16 += n6;
            n8 += 8;
            while (n8 > 0) {
                n8 -= this.tileHeight;
                n5 |= ~(byArray[n13] | byArray[n13 + 1]);
                n13 += 2;
            }
        }
        if (n5 >> (n15 >> 1) == 0) {
            bl2 = false;
        }
        this.tileImage[n12] = Image.createRGBImage((int[])this.tempPix, (int)n11, (int)n10, (boolean)bl2);
        this.tileReadState[n] = true;
        return this.tileImage[n12];
    }

    private final void draw(int n, int n2, int n3, int n4) {
        int n5 = n + this.tileCount * n4;
        Image image = this.tileImage[n5];
        if (image == null) {
            image = this.updateImage(n, n4);
        }
        if (image == this.transparentImage) {
            return;
        }
        if (this.scale) {
            n3 = n3 * this.tileHeight >> 3;
            n2 = n2 * this.tileWidth >> 3;
        }
        if (n4 >= this.transparentCutoff) {
            int[] nArray = this.imageBounds[n];
            this.graphics.drawImage(image, n2 + nArray[(n4 & 1) << 1], n3 + nArray[1 + (n4 & 2)], 20);
        } else {
            this.graphics.drawImage(image, n2, n3, 20);
        }
    }

    public final void stopWindowFromLine() {
        this.windowStopped = true;
        this.windowStopLine = this.cpu.registers[68] & 0xFF;
        this.windowStopX = (this.cpu.registers[75] & 0xFF) - 7;
        this.windowStopY = this.cpu.registers[74] & 0xFF;
    }

    public void setScale(int n, int n2) {
        int n3 = this.tileWidth;
        int n4 = this.tileHeight;
        this.tileWidth = n / 20;
        this.tileHeight = n2 / 18;
        if (MeBoy.keepProportions) {
            if (this.tileWidth < this.tileHeight) {
                this.tileHeight = this.tileWidth;
            } else {
                this.tileWidth = this.tileHeight;
            }
        }
        this.scale = this.tileWidth != 8 || this.tileHeight != 8;
        this.scaledWidth = this.tileWidth * 20;
        this.scaledHeight = this.tileHeight * 18;
        if (this.tileWidth != n3 || this.tileHeight != n4) {
            int n5;
            for (n5 = 0; n5 < this.tileImage.length; ++n5) {
                this.tileImage[n5] = null;
            }
            for (n5 = 0; n5 < this.tileReadState.length; ++n5) {
                this.tileReadState[n5] = false;
                this.imageBounds[n5] = null;
            }
        }
        this.imageHeight = this.tileHeight;
        this.tempPix = new int[this.tileWidth * this.tileHeight * 2];
        this.frameBufferImage = Image.createImage((int)this.scaledWidth, (int)this.scaledHeight);
        this.graphics = this.frameBufferImage.getGraphics();
    }
}

