/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class GameMap {
    static int screenWidth;
    static int screenHeight;
    static byte tileWidth;
    static byte tileHight;
    static int[] mapSize;
    short[] tileProperties;
    int w;
    int h;
    String[] name;
    static int setOffX;
    static int setOffY;
    byte[] mapData1;
    byte[] mapData2;
    static GameEngine engine;
    public static short[][] itemData;
    public static short[][] deckData;
    public static short[][] mapExit;
    int mapID;
    String mapName;
    String fileName;
    int weather;
    String music;
    byte[] enemys;
    int enemyLevel;
    static short battleBg;
    int BGM;
    short[][] areaPos;
    int cloudIndex;
    static int flashTime;
    static int redTime;
    static short[][] deck;
    int[][] mapExitImage = new int[][]{{87, 42, 0, 0, 0, 0}, {88, 43, 0, 0, 0, 0}};
    int mapExitindex = 0;
    static int flagMap;
    static int flagX;
    static int flagY;
    static int flagImgIndex;
    public static final byte ITEM_TYPE = 0;
    public static final byte ITEM_X = 1;
    public static final byte ITEM_Y = 2;
    public static final byte ITEM_TR = 3;
    public static final byte OBJ_ID = 0;
    public static final byte OBJ_IMG = 1;
    public static final byte OBJ_ADDX = 2;
    public static final byte OBJ_ADDY = 3;
    public static final byte OBJ_W = 4;
    public static final byte OBJ_H = 5;
    static int shakeTime;
    public static final byte CLOSE = 0;
    public static final byte OPEN = 1;
    public static byte SCEEN_MOVE;
    int adjustX;
    int adjustY;
    static boolean isMoveScreen;
    Event event;
    String command;
    Image mapBuff;
    int buffWidth;
    int buffHeight;
    boolean isBuffNull;
    int lastStartX;
    int lastStartY;
    int lastEndX;
    int lastEndY;

    public void free() {
        this.mapData1 = null;
        this.mapData2 = null;
        this.mapBuff = null;
        deckData = null;
        mapExit = null;
        itemData = null;
        System.gc();
    }

    public void init(String dat) {
        String[] param = Event.splitString(dat, " ");
        if (param[0].equals("id")) {
            this.mapID = Event.sToi(param[1]);
        } else if (param[0].equals("name")) {
            this.mapName = param[1];
        } else if (param[0].equals("dat")) {
            this.fileName = param[1];
        } else if (param[0].equals("weather")) {
            this.weather = Event.sToi(param[1]);
        } else if (param[0].equals("music")) {
            this.music = param[1];
        } else if (param[0].equals("enemys")) {
            if (param[1].equals("null")) {
                this.enemys = null;
            } else {
                String[] s = Event.splitString(param[1], ",");
                this.enemys = new byte[s.length];
                int j = 0;
                while (j < this.enemys.length) {
                    this.enemys[j] = (byte)Event.sToi(s[j]);
                    ++j;
                }
            }
        } else if (param[0].equals("battleBg")) {
            battleBg = (short)Event.sToi(param[1]);
        } else if (param[0].equals("BGM")) {
            this.BGM = Event.sToi(param[1]);
        } else if (param[0].equals("enemyLevel")) {
            this.enemyLevel = Event.sToi(param[1]);
        }
    }

    public GameMap(GameEngine en, int sw, int sh) {
        screenWidth = sw;
        screenHeight = sh;
        GameMap.setOff(0, 0);
        engine = en;
    }

    public static void setOff(int x, int y) {
        setOffX = x;
        setOffY = y;
    }

    public void initMap() {
        this.mapData1 = this.loadMap("/map/" + this.fileName + "a.dat", true);
        Tools.createImage(this.name, 1);
        this.mapData2 = this.loadMap("/map/" + this.fileName + "b.dat", false);
        this.initMapBuff();
        deckData = null;
        mapExit = null;
        this.areaPos = null;
        this.adjustX = screenWidth / 2;
        this.adjustY = screenHeight / 2 + 20;
        GameMap.setWeather(this.weather);
        String str = "/deck/" + this.fileName + "dck.dat";
        deckData = GameEngine.readPosData(str);
        String str1 = "/mapdeck/" + this.fileName + "exit.dat";
        mapExit = GameEngine.readPosData(str1);
    }

    public static void setWeather(int type) {
        switch (type) {
            case 0: {
                break;
            }
            case 1: {
                GameEngine.initStar(1, -7, 15, 50, -1);
                break;
            }
            case 2: {
                GameEngine.initStar(2, -4, 5, 200, -1);
                break;
            }
            case 3: {
                GameEngine.initStar(3, -3, 12, 200, -1);
            }
        }
    }

    public void setMapBG(Graphics g) {
        g.setColor(0);
        g.fillRect(setOffX, setOffY, 240, 320);
    }

    public void setMap(Graphics g) {
        if (MyGameCanvas.gameStatus == 15 || MyGameCanvas.nextStatus == 15) {
            return;
        }
        MyGameCanvas.drawCleanScreen(g, 0);
        this.drawMap(g, setOffX, setOffY);
        this.setMapFG();
        this.drawTaskFlag(200);
        if (deckData != null) {
            this.drawDeck();
        }
        this.drawMapExit();
        if (redTime > 0) {
            --redTime;
            Tools.addObject((byte)1, setOffX, setOffY, screenWidth, screenHeight, true, 20, 0xFF0000, 5000);
        }
        if (flashTime > 0) {
            --flashTime;
            Tools.addObject((byte)1, setOffX, setOffY, screenWidth, screenHeight, true, 20, GameMIDlet.gameIndex % 2 == 0 ? 0 : 0xFFFFFF, 5000);
        }
    }

    public void setTile1(Graphics g) {
        int n = setOffX / tileWidth * mapSize[1] + setOffY / tileHight;
        int nw = screenWidth / tileWidth + 2;
        int nh = screenHeight / tileHight + 2;
        int j = 0;
        while (j < nw) {
            int s;
            int i = s = n + j * mapSize[1];
            while (i < s + nh) {
                if (i < this.mapData1.length && i >= 0) {
                    int dataTemp = GameMap.getLow(this.mapData1[i]);
                    int x = i / mapSize[1] * tileHight;
                    int y = i % mapSize[1] * tileWidth;
                    if (this.mapData1[i] == -1) {
                        g.setColor(0);
                        g.fillRect(x - setOffX, y - setOffY, (int)tileWidth, (int)tileHight);
                    } else {
                        Tools.drawClipImage(g, 400 + dataTemp, x - setOffX, y - setOffY, 0, 0, tileWidth, tileHight, 20, GameMap.getTrans(this.mapData1[i]));
                    }
                }
                ++i;
            }
            ++j;
        }
    }

    public void setTile2(Graphics g) {
        int n = setOffX / tileWidth * mapSize[1] + setOffY / tileHight;
        int nw = screenWidth / tileWidth + 2;
        int nh = screenHeight / tileHight + 2;
        int j = 0;
        while (j < nw) {
            int s;
            int i = s = n + j * mapSize[1];
            while (i < s + nh) {
                if (i < this.mapData2.length && i >= 0) {
                    int dataTemp = GameMap.getLow(this.mapData2[i]);
                    int x = i / mapSize[1] * tileHight;
                    int y = i % mapSize[1] * tileWidth;
                    if (this.mapData2[i] != -1) {
                        Tools.drawClipImage(g, 400 + dataTemp, x - setOffX, y - setOffY, 0, 0, tileWidth, tileHight, 20, GameMap.getTrans(this.mapData2[i]));
                    }
                }
                ++i;
            }
            ++j;
        }
    }

    public void drawDeck() {
        if (deckData == null) {
            return;
        }
        byte[] SpecialUp = new byte[]{31, 41, 44, 45, 49, 50, 51, 55, 57, 84};
        byte[] SpecialUp1 = new byte[]{79};
        byte[] SpecialUp2 = new byte[]{37, 38};
        byte[] SpecialUp3 = new byte[]{36};
        int i = 0;
        while (i < deckData.length) {
            int id = this.getObjIndex(deckData[i][0]);
            if (deck[id][1] == 17) {
                return;
            }
            if (deck[id][1] == 18) {
                return;
            }
            int tempLev = 0;
            int j = 0;
            while (j < SpecialUp.length) {
                if (deck[id][0] == SpecialUp[j]) {
                    tempLev = 200;
                }
                ++j;
            }
            int j2 = 0;
            while (j2 < SpecialUp1.length) {
                if (deck[id][0] == SpecialUp1[j2]) {
                    tempLev = 100;
                }
                ++j2;
            }
            int k = 0;
            while (k < SpecialUp2.length) {
                if (deck[id][0] == SpecialUp2[k]) {
                    tempLev = -500;
                }
                ++k;
            }
            int k2 = 0;
            while (k2 < SpecialUp3.length) {
                if (deck[id][0] == SpecialUp3[k2]) {
                    tempLev = 5;
                }
                ++k2;
            }
            if (deck[id][0] != 72 && deck[id][0] != 85) {
                Tools.addObject(deck[id][1], deckData[i][1] + deck[id][2], deckData[i][2] + deck[id][3], 36, (byte)deckData[i][3], deckData[i][2] + tempLev);
            } else {
                int imageW = Tools.getImage(deck[id][1]).getWidth() / 3;
                int imageH = Tools.getImage(deck[id][1]).getHeight();
                Tools.addObject(deck[id][1], deckData[i][1] + deck[id][2], deckData[i][2] + deck[id][3], GameMIDlet.gameIndex % 3 * imageW, 0, imageW, imageH, 36, (byte)deckData[i][3], deckData[i][2] + tempLev);
            }
            if (deck[id][0] >= 33 && deck[id][0] <= 36) {
                Tools.addObject(deck[id][1], deckData[i][1] + deck[id][2] + Tools.getImage(deck[id][1]).getWidth(), deckData[i][2] + deck[id][3], 36, (byte)1, deckData[i][2] + tempLev);
            }
            ++i;
        }
    }

    public void drawMapExit() {
        if (mapExit == null) {
            return;
        }
        ++this.mapExitindex;
        if (this.mapExitindex > 2) {
            this.mapExitindex = 0;
        }
        int i = 0;
        while (i < mapExit.length) {
            switch (mapExit[i][0]) {
                case 87: {
                    Tools.addObject(43, mapExit[i][1], mapExit[i][2], 17 * this.mapExitindex, 0, 17, 16, 36, (byte)0, mapExit[i][2]);
                    break;
                }
                case 89: {
                    Tools.addObject(42, mapExit[i][1], mapExit[i][2], 16 * this.mapExitindex, 0, 17, 16, 36, (byte)1, mapExit[i][2]);
                    break;
                }
                case 90: {
                    Tools.addObject(43, mapExit[i][1], mapExit[i][2], 17 * this.mapExitindex, 0, 16, 17, 36, (byte)2, mapExit[i][2]);
                    break;
                }
                case 88: {
                    Tools.addObject(42, mapExit[i][1], mapExit[i][2], 16 * this.mapExitindex, 0, 16, 17, 36, (byte)0, mapExit[i][2]);
                }
            }
            ++i;
        }
    }

    public void drawTaskFlag(int lev) {
        if (flagMap == -1 || GameEngine.gameRank != flagMap) {
            return;
        }
        if (flagImgIndex == 0) {
            Tools.addObject(262, flagX + 1, flagY, 14 * (GameMIDlet.gameIndex % 4 / 2), 0, 14, 35, 36, (byte)0, lev + flagY);
        } else {
            Tools.addObject(263, flagX - 17 - GameMIDlet.gameIndex % 4 / 2, flagY, 49 * (GameMIDlet.gameIndex % 4 / 2), 0, 49, 49, 36, (byte)0, lev + flagY);
        }
    }

    int getObjIndex(int id) {
        int i = 0;
        while (i < deck.length) {
            if (deck[i][0] == id) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int hitDecorations(int x, int y) {
        if (deckData == null) {
            return -1;
        }
        int i = 0;
        while (i < deckData.length) {
            short id = deckData[i][0];
            int objIndex = this.getObjIndex(id);
            if (deck[objIndex][1] == 18) {
                return -1;
            }
            if (objIndex != -1) {
                short w = deck[objIndex][4];
                short h = deck[objIndex][5];
                if (w != 0 && h != 0) {
                    if (deck[objIndex][0] <= 36 && deck[objIndex][0] >= 33 && x >= deckData[i][1] && x < deckData[i][1] + w * 2 && y < deckData[i][2] && y > deckData[i][2] - h) {
                        return i;
                    }
                    if (x >= deckData[i][1] && x < deckData[i][1] + w && y < deckData[i][2] && y > deckData[i][2] - h) {
                        return i;
                    }
                }
            }
            ++i;
        }
        return -1;
    }

    public void drawWeather(int lev) {
        GameEngine.moveStar(true);
        GameEngine.drawStar(0, 0, lev);
    }

    public static void screenShake() {
        if (shakeTime == 0) {
            return;
        }
        if (shakeTime > 0) {
            --shakeTime;
        }
        setOffY = GameMIDlet.gameIndex % 2 == 0 ? setOffY + 2 : setOffY - 2;
    }

    public void setMapFG() {
        switch (this.mapID) {
            case 0: {
                Tools.addObject(172, setOffX, setOffY, 20, (byte)0, 0);
                break;
            }
            case 58: {
                Tools.addObject((byte)1, setOffX, setOffY, screenWidth, 100, true, 20, 5742585, 0);
                Tools.addObject(50, setOffX, setOffY + screenHeight - 16, 36, (byte)0, 0);
                Tools.addObject(50, setOffX + 120, setOffY + screenHeight - 16, 36, (byte)1, 0);
                Tools.addObject((byte)1, setOffX, setOffY + screenHeight, screenWidth, 16, true, 36, 16053756, 0);
                break;
            }
            case 69: {
                Tools.addObject(172, setOffX, setOffY, 20, (byte)0, 0);
            }
        }
    }

    public int getSetOffX(int x) {
        short dx = (short)(x - this.adjustX);
        dx = (short)Math.max(dx, 0);
        dx = (short)Math.min(dx, mapSize[0] * tileWidth - screenWidth);
        return dx;
    }

    public int getSetOffY(int y) {
        short dy = (short)(y - this.adjustY);
        dy = (short)Math.max(dy, 0);
        dy = (short)Math.min(dy, mapSize[1] * tileHight - screenHeight);
        return dy;
    }

    public void AdjustSrceen(int x, int y) {
        setOffX = Math.abs(x - setOffX - this.adjustX) > SCEEN_MOVE ? (x - setOffX - this.adjustX >= SCEEN_MOVE ? (setOffX += SCEEN_MOVE) : (setOffX -= SCEEN_MOVE)) : (int)((short)(x - this.adjustX));
        setOffX = (short)Math.max(setOffX, 0);
        setOffX = (short)Math.min(setOffX, mapSize[0] * tileWidth - screenWidth);
        setOffY = Math.abs(y - setOffY - this.adjustY) > SCEEN_MOVE ? (y - setOffY - this.adjustY >= SCEEN_MOVE ? (setOffY += SCEEN_MOVE) : (setOffY -= SCEEN_MOVE)) : (int)((short)(y - this.adjustY));
        setOffY = (short)Math.max(setOffY, 0);
        setOffY = (short)Math.min(setOffY, mapSize[1] * tileHight - screenHeight);
        if (isMoveScreen && this.checkMoveScreen(x, y)) {
            isMoveScreen = false;
            this.finish();
        }
    }

    public boolean checkMoveScreen(int x, int y) {
        short tempx = (short)(x - this.adjustX);
        tempx = (short)Math.max(tempx, 0);
        tempx = (short)Math.min(tempx, mapSize[0] * tileWidth - screenWidth);
        short tempy = (short)(y - this.adjustY);
        tempy = (short)Math.max(tempy, 0);
        tempy = (short)Math.min(tempy, mapSize[1] * tileHight - screenHeight);
        return setOffX == tempx && setOffY == tempy;
    }

    public void sender(Event event, String command) {
        this.event = event;
        this.command = command;
    }

    public void finish() {
        if (this.event != null) {
            this.event.setEnd(this.command);
            this.event = null;
            this.command = null;
        }
    }

    public boolean canRun(int x, int y) {
        if (this.hitDecorations(x, y) != -1) {
            return false;
        }
        if (x < 0 || x > mapSize[0] * tileHight - tileHight || y < tileHight - 1 || y > mapSize[1] * tileHight) {
            return false;
        }
        if (this.mapData2 == null) {
            return this.canRun(x, y, this.mapData1);
        }
        if (this.inMapData(x, y, this.mapData2) == -1) {
            return this.canRun(x, y, this.mapData1);
        }
        return this.canRun(x, y, this.mapData2);
    }

    public boolean canRun(int x, int y, byte[] mapData) {
        if (this.inMapData(x, y, mapData) == -1) {
            return false;
        }
        return Tools.getProperties(this.tileProperties[GameMap.getLow(this.inMapData(x, y, mapData))], (byte)15);
    }

    private byte inMapData(int x, int y, byte[] mapData) {
        int n = x / tileWidth * mapSize[1] + y / tileHight;
        if (n < 0 || n >= mapData.length || y > mapSize[1] * tileHight || x > mapSize[0] * tileWidth || x < 0) {
            return -1;
        }
        return mapData[n];
    }

    public static int getTrans(int v) {
        return v >> 6 & 3;
    }

    public static int get2nd(int v) {
        return v << 1 >> 7 & 1;
    }

    public static int getLow(int v) {
        return v & 0x3F;
    }

    static int bToi(byte byte0) {
        int i = byte0;
        if (byte0 < 0) {
            i += 256;
        }
        return i;
    }

    public static int getIndex(int v) {
        return v & 0x3F;
    }

    public int getIndex(int x, int y, byte[] mapData) {
        return GameMap.getIndex(this.inMapData(x, y, mapData));
    }

    public byte[] loadMap(String file, boolean isFirst) {
        byte[] mapData;
        InputStream is = this.getClass().getResourceAsStream(file);
        if (is == null) {
            return null;
        }
        DataInputStream in = new DataInputStream(is);
        try {
            GameMap.mapSize[0] = GameMap.bToi(in.readByte());
            GameMap.mapSize[1] = GameMap.bToi(in.readByte());
            tileWidth = in.readByte();
            tileHight = in.readByte();
            int size = mapSize[0] * mapSize[1];
            mapData = new byte[size];
            in.read(mapData);
            if (isFirst) {
                this.tileProperties = null;
                int len = in.readShort();
                this.name = new String[len];
                this.tileProperties = new short[len];
                int i = 0;
                while (i < len) {
                    byte nameLen = in.readByte();
                    byte[] names = new byte[nameLen];
                    in.read(names);
                    this.name[i] = new String(names);
                    this.tileProperties[i] = in.readShort();
                    ++i;
                }
            }
            is.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
        return mapData;
    }

    void initMapBuff() {
        if (this.mapBuff == null) {
            this.isBuffNull = true;
            tileWidth = (byte)16;
            tileHight = (byte)16;
            this.buffWidth = screenWidth - screenWidth % tileWidth + tileWidth * 2;
            this.buffHeight = screenHeight - screenHeight % tileHight + tileHight * 2;
            this.mapBuff = Image.createImage((int)this.buffWidth, (int)this.buffHeight);
        }
    }

    void drawBuff(Graphics g, int clipX, int clipY, int clipW, int clipH, int x, int y) {
        g.setClip(x, y, clipW, clipH);
        g.drawImage(this.mapBuff, x - clipX, y - clipY, 20);
        g.setClip(0, 0, screenWidth, screenHeight);
    }

    void drawMap(Graphics g, int setOffX, int setOffY) {
        Graphics g1 = this.mapBuff.getGraphics();
        int startX = setOffX / tileWidth;
        int endX = startX + screenWidth / tileWidth + 1;
        int startY = setOffY / tileHight;
        int endY = startY + screenHeight / tileHight + 1;
        if (this.isBuffNull) {
            this.isBuffNull = false;
            this.updateBuff(g1, startX, startY, endX, endY);
            this.lastStartX = startX;
            this.lastStartY = startY;
            this.lastEndX = endX;
            this.lastEndY = endY;
        }
        if (this.lastStartX != startX) {
            int tmp2;
            int tmp1;
            if (this.lastStartX < startX) {
                tmp1 = this.lastEndX + 1;
                tmp2 = endX;
            } else {
                tmp1 = startX;
                tmp2 = this.lastStartX - 1;
            }
            this.updateBuff(g1, tmp1, startY, tmp2, endY);
            this.lastStartX = startX;
            this.lastEndX = endX;
        }
        if (this.lastStartY != startY) {
            int tmp4;
            int tmp3;
            if (this.lastStartY < startY) {
                tmp3 = this.lastEndY + 1;
                tmp4 = endY;
            } else {
                tmp3 = startY;
                tmp4 = this.lastStartY - 1;
            }
            this.updateBuff(g1, startX, tmp3, endX, tmp4);
            this.lastStartY = startY;
            this.lastEndY = endY;
        }
        int t1 = setOffX % this.buffWidth;
        int t2 = setOffY % this.buffHeight;
        int t3 = (setOffX + screenWidth) % this.buffWidth;
        int t4 = (setOffY + screenHeight) % this.buffHeight;
        if (t3 > t1) {
            if (t4 > t2) {
                this.drawBuff(g, t1, t2, screenWidth, screenHeight, 0, 0);
            } else {
                this.drawBuff(g, t1, t2, screenWidth, screenHeight - t4, 0, 0);
                this.drawBuff(g, t1, 0, screenWidth, t4, 0, screenHeight - t4);
            }
        } else if (t4 > t2) {
            this.drawBuff(g, t1, t2, screenWidth - t3, screenHeight, 0, 0);
            this.drawBuff(g, 0, t2, t3, screenHeight, screenWidth - t3, 0);
        } else {
            this.drawBuff(g, t1, t2, screenWidth - t3, screenHeight - t4, 0, 0);
            this.drawBuff(g, t1, 0, screenWidth - t3, t4, 0, screenHeight - t4);
            this.drawBuff(g, 0, t2, t3, screenHeight - t4, screenWidth - t3, 0);
            this.drawBuff(g, 0, 0, t3, t4, screenWidth - t3, screenHeight - t4);
        }
    }

    void updateBuff(Graphics g, int startX, int startY, int endX, int endY) {
        int y = startY * tileHight % this.buffHeight;
        int i = startY;
        while (i <= endY) {
            int x = startX * tileWidth % this.buffWidth;
            int j = startX;
            while (j <= endX) {
                byte mapIndex1 = this.inMapData(j * tileWidth, i * tileHight, this.mapData1);
                int dataTemp1 = GameMap.getIndex(mapIndex1);
                int transData1 = GameMap.getTrans(mapIndex1);
                if ((byte)mapIndex1 != -1) {
                    g.setClip(x, y, (int)tileWidth, (int)tileHight);
                    Tools.drawClipImage(g, 400 + dataTemp1, x, y, 0, 0, tileWidth, tileHight, 20, transData1);
                    g.setClip(setOffX, setOffY, 240, 320);
                } else {
                    g.setClip(x, y, (int)tileWidth, (int)tileHight);
                    g.setColor(0);
                    g.fillRect(x, y, (int)tileWidth, (int)tileHight);
                    g.setClip(setOffX, setOffY, 240, 320);
                }
                if (this.mapData2 != null) {
                    byte mapIndex2 = this.inMapData(j * tileWidth, i * tileHight, this.mapData2);
                    int dataTemp2 = GameMap.getIndex(mapIndex2);
                    int transData2 = GameMap.getTrans(mapIndex2);
                    if ((byte)mapIndex2 != -1) {
                        g.setClip(x, y, (int)tileWidth, (int)tileHight);
                        Tools.drawClipImage(g, 400 + dataTemp2, x, y, 0, 0, tileWidth, tileHight, 20, transData2);
                        g.setClip(setOffX, setOffY, 240, 320);
                    }
                }
                if ((x += tileWidth) >= this.buffWidth) {
                    x -= this.buffWidth;
                }
                ++j;
            }
            if ((y += tileHight) >= this.buffHeight) {
                y -= this.buffHeight;
            }
            ++i;
        }
    }

    static {
        mapSize = new int[2];
        deck = new short[][]{{1, 18, 0, 0, 48, 64}, {3, 1, 0, 0, 48, 48}, {5, 2, 0, 0, 48, 64}, {7, 3, 0, 0, 48, 32}, {8, 0, 0, 0, 48, 30}, {9, 4, 0, 0, 80, 54}, {12, 5, 0, 0, 30, 23}, {23, 6, 0, 0, 16, 51}, {28, 7, 0, 0, 78, 48}, {29, 8, 0, 0, 0, 0}, {31, 9, 0, 0, 32, 13}, {32, 10, 0, 0, 16, 32}, {33, 11, -10, 24, 100, 170}, {35, 12, 0, 0, 100, 96}, {36, 13, 0, 0, 32, 96}, {37, 14, 0, 0, 0, 0}, {38, 15, 0, 16, 186, 16}, {39, 16, 0, 0, 64, 20}, {41, 17, 0, 0, 0, 0}, {44, 18, 0, 0, 0, 0}, {45, 19, 0, 0, 0, 0}, {49, 20, 0, 0, 0, 0}, {50, 21, 0, 0, 0, 0}, {51, 22, 0, 0, 0, 0}, {55, 23, 0, 0, 0, 0}, {57, 24, 0, 0, 0, 0}, {59, 25, -24, 0, 16, 16}, {60, 26, -48, 0, 16, 32}, {61, 27, -32, 0, 16, 32}, {63, 28, -8, 0, 16, 16}, {64, 29, -8, 0, 16, 16}, {65, 30, -8, 0, 16, 16}, {66, 31, -24, 0, 16, 16}, {67, 32, -24, 0, 16, 16}, {68, 33, -8, 0, 16, 16}, {69, 34, -24, 0, 16, 16}, {72, 35, -8, -64, 16, 16}, {79, 36, 0, 0, 0, 0}, {80, 37, 0, 0, 32, 63}, {82, 38, 0, 0, 16, 16}, {83, 39, 0, 0, 48, 56}, {84, 40, 0, 0, 48, 32}, {85, 41, 0, 0, 48, 144}};
        flagMap = -1;
        SCEEN_MOVE = (byte)10;
    }
}

