/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DownloadClass {
    public static final int STATE_ACTIVE = 1;
    public static final int STATE_COMPLETED = 2;
    public static final int STATE_ERROR = 3;
    public static final int STATE_QUEUED = 4;
    private int Id;
    private int State;
    private int Format;
    private long Size;
    private long Done;
    private String Title;
    private String VideoId;
    private String FileName;
    private String FileExtension;
    private String ErrorMsg;

    public DownloadClass(int state, int format, long size, long done, String title, String video_id, String file_name, String file_extension, String error_msg) {
        this.Id = 0;
        this.State = state;
        this.Format = format;
        this.Size = size;
        this.Done = done;
        this.Title = title;
        this.VideoId = video_id;
        this.FileName = file_name;
        this.FileExtension = file_extension;
        this.ErrorMsg = error_msg;
    }

    public DownloadClass(DownloadClass download) {
        this.Id = download.Id;
        this.State = download.State;
        this.Format = download.Format;
        this.Size = download.Size;
        this.Done = download.Done;
        this.Title = new String(download.Title);
        this.VideoId = new String(download.VideoId);
        this.FileName = new String(download.FileName);
        this.FileExtension = new String(download.FileExtension);
        this.ErrorMsg = new String(download.ErrorMsg);
    }

    public DownloadClass(int id, byte[] record) throws IOException {
        DataInputStream data_stream = new DataInputStream(new ByteArrayInputStream(record));
        this.Id = id;
        this.State = data_stream.readInt();
        this.Format = data_stream.readInt();
        this.Size = data_stream.readLong();
        this.Done = data_stream.readLong();
        this.Title = data_stream.readUTF();
        this.VideoId = data_stream.readUTF();
        this.FileName = data_stream.readUTF();
        this.FileExtension = data_stream.readUTF();
        this.ErrorMsg = data_stream.readUTF();
    }

    public void SetId(int id) {
        this.Id = id;
    }

    public void SetState(int state) {
        this.State = state;
    }

    public void SetFormat(int format) {
        this.Format = format;
    }

    public void SetSize(long size) {
        this.Size = size;
    }

    public void SetDone(long done) {
        this.Done = done;
    }

    public void SetErrorMsg(String error_msg) {
        this.ErrorMsg = error_msg;
    }

    public int GetId() {
        return this.Id;
    }

    public int GetState() {
        return this.State;
    }

    public int GetFormat() {
        return this.Format;
    }

    public long GetSize() {
        return this.Size;
    }

    public long GetDone() {
        return this.Done;
    }

    public String GetTitle() {
        return this.Title;
    }

    public String GetVideoId() {
        return this.VideoId;
    }

    public String GetFileName() {
        return this.FileName;
    }

    public String GetFileExtension() {
        return this.FileExtension;
    }

    public String GetErrorMsg() {
        return this.ErrorMsg;
    }

    public String GetVisibleName() {
        long percent_done = this.Size == 0L ? 0L : this.Done * 100L / this.Size;
        if (this.State == 1) {
            return "[" + String.valueOf(percent_done) + "%] " + this.Title;
        }
        if (this.State == 2) {
            return "[DONE] " + this.Title;
        }
        if (this.State == 3) {
            return "[" + this.ErrorMsg + "] " + this.Title;
        }
        if (this.State == 4) {
            return "[QUEUED] " + this.Title;
        }
        return "[???] " + this.Title;
    }

    public String GetFullFileName() {
        return this.FileName + "." + this.FileExtension;
    }

    public byte[] ToByteArray() throws IOException {
        ByteArrayOutputStream byte_stream = new ByteArrayOutputStream();
        DataOutputStream data_stream = new DataOutputStream(byte_stream);
        data_stream.writeInt(this.State);
        data_stream.writeInt(this.Format);
        data_stream.writeLong(this.Size);
        data_stream.writeLong(this.Done);
        data_stream.writeUTF(this.Title);
        data_stream.writeUTF(this.VideoId);
        data_stream.writeUTF(this.FileName);
        data_stream.writeUTF(this.FileExtension);
        data_stream.writeUTF(this.ErrorMsg);
        return byte_stream.toByteArray();
    }
}

