/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client.test;

import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.AsyncFileMessageStore;
import com.whatsapp.client.ChatHistory;
import com.whatsapp.client.FunXMPP;
import com.whatsapp.client.MessageStore;
import com.whatsapp.client.test.MessageFactory;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class MessageStoreTestMidlet
extends MIDlet
implements CommandListener {
    Form form;
    Command writeCmd = new Command("write", 4, 1);
    Command readCmd = new Command("read", 4, 1);
    Command deleteCmd = new Command("delete", 3, 1);
    Command readBeforeCmd = new Command("read before", 4, 2);
    Command deleteHistoryCmd = new Command("delete hist", 3, 2);
    Command getChatsCmd = new Command("get chats", 4, 2);
    Command findOfflineCmd = new Command("get offliners", 4, 2);
    MessageStore mStore = new AsyncFileMessageStore();
    Vector _storedMessages = null;
    StringItem dispText = new StringItem("latest: ", "");

    protected void startApp() throws MIDletStateChangeException {
        Display d = Display.getDisplay((MIDlet)this);
        this.form = new Form("message store test");
        this.form.addCommand(this.writeCmd);
        this.form.addCommand(this.readCmd);
        this.form.addCommand(this.deleteCmd);
        this.form.addCommand(this.readBeforeCmd);
        this.form.addCommand(this.deleteHistoryCmd);
        this.form.addCommand(this.getChatsCmd);
        this.form.addCommand(this.findOfflineCmd);
        this.form.setCommandListener((CommandListener)this);
        this.form.append((Item)this.dispText);
        d.setCurrent((Displayable)this.form);
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean bln) throws MIDletStateChangeException {
    }

    public void commandAction(Command c, Displayable dsplbl) {
        if (this._storedMessages == null && (c == this.readCmd || c == this.readBeforeCmd || c == this.deleteCmd || c == this.deleteHistoryCmd)) {
            Utilities.logData("no stored messages yet");
            Alert alert = new Alert("error");
            alert.setString("do write first");
            Display.getDisplay((MIDlet)this).setCurrent(alert, (Displayable)this.form);
            return;
        }
        if (c == this.writeCmd) {
            this._storedMessages = MessageFactory.getMessages(5);
            FunXMPP.FMessage fmsg = null;
            for (int i = 0; i < 5; ++i) {
                fmsg = (FunXMPP.FMessage)this._storedMessages.elementAt(i);
                Utilities.logData("storing fmsg with jid " + fmsg.key.remote_jid + " and data " + fmsg.data);
                this.mStore.putMessage(fmsg, null);
            }
            Utilities.logData("finished putting all messages");
            this.dispText.setText("write finished");
        } else if (c == this.readCmd) {
            String useJid = ((FunXMPP.FMessage)this._storedMessages.elementAt((int)0)).key.remote_jid;
            Vector v = this.mStore.getMessages(useJid, "id-1");
            Utilities.logData("found " + v.size() + " messages for " + useJid);
            this.dispText.setText("found " + v.size() + " messages for " + useJid);
        } else if (c == this.deleteCmd) {
            int middle = this._storedMessages.size() / 2;
            FunXMPP.FMessage deleteThis = (FunXMPP.FMessage)this._storedMessages.elementAt(middle);
            Utilities.logData("attempting to delete middle message with id " + deleteThis.key.id + " and data " + deleteThis.data);
            this.mStore.deleteMessage(deleteThis);
            this.dispText.setText("deleted " + deleteThis.key.id);
        } else if (c == this.readBeforeCmd) {
            FunXMPP.FMessage lastMsg = (FunXMPP.FMessage)this._storedMessages.lastElement();
            Vector v = this.mStore.getMessagesBefore(lastMsg.key.remote_jid, lastMsg, 3, null);
            Utilities.logData("found " + v.size() + " messages before last msg");
            for (int i = 0; i < v.size(); ++i) {
                FunXMPP.FMessage curMsg = (FunXMPP.FMessage)v.elementAt(i);
                Utilities.logData("ID returned from getBefore: " + curMsg.key.id);
            }
        } else if (c == this.deleteHistoryCmd) {
            String useJid = ((FunXMPP.FMessage)this._storedMessages.elementAt((int)0)).key.remote_jid;
            this.mStore.deleteChatHistory(useJid);
        } else if (c == this.getChatsCmd) {
            Vector v = this.mStore.getChats();
            Utilities.logData("getChats sees number of chats " + v.size());
            for (int i = 0; i < v.size(); ++i) {
                ChatHistory curHist = (ChatHistory)v.elementAt(i);
                Utilities.logData("seeing chat jid " + curHist._jid);
            }
        } else if (c == this.findOfflineCmd) {
            Vector v = this.mStore.getAllOfflineMessages();
            Utilities.logData("found " + v.size() + " offline messages.");
        }
    }
}

