/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.util.DateTimeUtilities;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.Constants;
import com.whatsapp.client.FGApp;
import com.whatsapp.client.MMSCreator;
import com.whatsapp.client.Res;
import com.whatsapp.client.test.ContactListMidlet;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VideoControl;

public class VideoDisplayForm
extends Form
implements CommandListener {
    private String _vidLoc;
    private String _mimeType;
    private Displayable _parentScr;
    private Player _player;
    private VideoControl _vControl;
    private boolean _mmsPreviewMode = false;
    private MMSCreator.VideoCreator _vidCreator = null;
    private Command _backCmd = new Command(Res.getString(59), 2, 1);
    private Command _playCmd = new Command(Res.getString(115), 4, 1);
    private Command _stopCmd = new Command(Res.getString(161), 4, 1);
    private Command _chooseCmd = new Command(Res.getString(69), 4, 1);
    private Command _cancelCmd = new Command(Res.getString(63), 3, 1);

    public VideoDisplayForm(Displayable parentScr, long timestamp, String vidLoc, String mimeType, MMSCreator.VideoCreator videoCreator) {
        super(Constants.STRING_EMPTY_STRING);
        this._vidLoc = vidLoc;
        this._mimeType = mimeType;
        Utilities.logData("video screen launched with file " + vidLoc + " and mimetype " + mimeType);
        this._parentScr = parentScr;
        if (videoCreator != null) {
            this._vidCreator = videoCreator;
            this._mmsPreviewMode = true;
            this.addCommand(this._chooseCmd);
            this.addCommand(this._cancelCmd);
            this.setTitle(Res.getString(123));
        } else {
            this.addCommand(this._backCmd);
            this.setTitle(DateTimeUtilities.simpleDayFormat(timestamp) + " " + DateTimeUtilities.shortTimeFormat(timestamp));
        }
        this.setCommandListener(this);
        this.append(Res.getString(103));
        BGLoader loader = new BGLoader();
        loader.start();
    }

    public void commandAction(Command cmd, Displayable dsplbl) {
        if (cmd == this._backCmd || cmd == this._cancelCmd) {
            if (this._player != null) {
                try {
                    this._player.stop();
                }
                catch (MediaException mmx) {
                    // empty catch block
                }
                this._player.close();
            }
            FGApp.getInstance().setTopPane(this._parentScr);
            ContactListMidlet.getInstance()._display.setCurrent(this._parentScr);
        } else if (cmd == this._playCmd) {
            if (this._player != null) {
                try {
                    this._player.start();
                    this.removeCommand(this._playCmd);
                    this.addCommand(this._stopCmd);
                }
                catch (Throwable t) {
                    Utilities.logData("couldnt play vid: " + t.toString());
                }
            }
        } else if (cmd == this._stopCmd) {
            if (this._player != null) {
                try {
                    this._player.stop();
                    this.removeCommand(this._stopCmd);
                    this.addCommand(this._playCmd);
                }
                catch (Throwable t) {
                    Utilities.logData("couldnt stop vid: " + t.toString());
                }
            }
        } else if (cmd == this._chooseCmd) {
            if (this._player != null) {
                try {
                    this._player.stop();
                }
                catch (MediaException mediaException) {
                    // empty catch block
                }
                this._player.close();
            }
            this._vidCreator.postChoiceProcessFile();
            FGApp.getInstance().setTopPane(this._parentScr);
            ContactListMidlet.getInstance()._display.setCurrent(this._parentScr);
        }
    }

    private class BGLoader
    extends Thread {
        private BGLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object fileC = null;
            Object is = null;
            boolean result = false;
            String errorTxt = Constants.STRING_EMPTY_STRING;
            try {
                VideoDisplayForm.this._player = Manager.createPlayer((String)VideoDisplayForm.this._vidLoc);
                VideoDisplayForm.this._player.realize();
                VideoDisplayForm.this._vControl = (VideoControl)VideoDisplayForm.this._player.getControl("VideoControl");
                VideoDisplayForm.this._player.prefetch();
                if (VideoDisplayForm.this._vControl != null) {
                    Item vItem = (Item)VideoDisplayForm.this._vControl.initDisplayMode(0, null);
                    VideoDisplayForm.this.deleteAll();
                    VideoDisplayForm.this._vControl.setDisplaySize(VideoDisplayForm.this.getWidth(), VideoDisplayForm.this.getHeight() - 40);
                    VideoDisplayForm.this.append(vItem);
                    VideoDisplayForm.this.addCommand(VideoDisplayForm.this._playCmd);
                    result = true;
                }
            }
            catch (Throwable t) {
                Utilities.logData("video loader died: " + t.toString());
                errorTxt = t.toString();
            }
            if (!result) {
                Alert byeAlert = new Alert(Res.getString(170), errorTxt, null, AlertType.ERROR);
                FGApp.getInstance().setTopPane(VideoDisplayForm.this._parentScr);
                ContactListMidlet.getInstance()._display.setCurrent(byeAlert, VideoDisplayForm.this._parentScr);
            }
        }
    }
}

