/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.contacts.MMSUploader;
import com.whatsapp.api.sapi.ImageProcessing;
import com.whatsapp.api.sapi.ImageProcessingListener;
import com.whatsapp.api.util.SafeThread;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.BGApp;
import com.whatsapp.client.BGMMSCreator;
import com.whatsapp.client.FunXMPP;
import com.whatsapp.client.MMSDownloader;
import com.whatsapp.client.MediaData;
import com.whatsapp.client.MessageStore;
import com.whatsapp.client.MessageStoreProvider;
import com.whatsapp.client.Res;

public class UploadScaler
implements ImageProcessingListener {
    public static final int SCALE_TYPE_STARTING_UP = 0;
    public static final int SCALE_TYPE_THUMB = 1;
    public static final int SCALE_TYPE_PREVIEW = 2;
    public static final int SCALE_TYPE_SENDABLE = 3;
    public static final int SCALE_TYPE_FINISHED = 10;
    private boolean _ready = false;
    private ImageProcessing _imageProc = null;
    private String _sourceFile;
    private BGMMSCreator _creator;
    private int _curState = 0;
    private byte _curTransID;

    public UploadScaler(String file, BGMMSCreator creator) {
        this._sourceFile = file;
        this._creator = creator;
    }

    public void initialize() {
        try {
            this._imageProc = new ImageProcessing(this);
            this._imageProc.connect();
        }
        catch (Throwable t) {
            Utilities.logData("couldnt init upload scaler: " + t.toString());
            this.imageScaleError((byte)0, t.getMessage());
        }
    }

    public void imageProcessingSystemMessageReceived(String message) {
        Utilities.logData("image proc system message: " + message);
    }

    public void imageProcessingServerReady() {
        this._ready = true;
        if (this.cancelCheck()) {
            return;
        }
        if (this._creator._retryMode) {
            MediaData md = (MediaData)this._creator._fmsg.thumb_image;
            if (this._creator._fmsg.data != null && this._creator._fmsg.data.length() > 0 || md.externalThumbCount > 0) {
                Utilities.logData("skipping thumbnail on upload retry");
                this._curState = 3;
                BGApp.getInstance().sendToFG(new byte[]{1}, (byte)59);
                this._curTransID = this._imageProc.resizeImage(this._sourceFile, 800, 800, ImageProcessing.ASPECT_LOCK_PARTIAL);
                return;
            }
        }
        this._curState = 1;
        this._curTransID = this._imageProc.resizeImage(this._sourceFile, 100, 100, ImageProcessing.ASPECT_FULL_IMAGE);
    }

    public void imageProcessingServerClosed(int reason) {
        this._ready = false;
        this._imageProc = null;
    }

    private boolean cancelCheck() {
        if (this._creator.isCancelled()) {
            Utilities.logData("scaler sees cancelled, wrapping up");
            BGMMSCreator.creatorDone(this._creator);
            this._creator._fmsg.status = 0;
            MessageStoreProvider.getMessageStore().updateMessageStatus(this._creator._fmsg, false, null);
            BGApp.getInstance().reportMMSXferCancelled();
            this.cleanup();
            return true;
        }
        return false;
    }

    public void imageScaleComplete(byte transid, final String fullPath) {
        if (this._curState == 1) {
            if (this.cancelCheck()) {
                return;
            }
            String usePath = "file:///" + fullPath;
            Utilities.logData("pulling thumb data from " + usePath);
            byte[] jpegData = Utilities.getFileAsByteArray(usePath);
            MessageStoreProvider.getMessageStore().addExternalThumbnail(this._creator._fmsg.key, jpegData, new MessageStore.CompletionCallback(){

                public void operationCompleted() {
                    BGApp.getInstance().sendToFG(new byte[]{1}, (byte)59);
                }
            });
            if (this.cancelCheck()) {
                return;
            }
            this._curState = 3;
            this._curTransID = this._imageProc.resizeImage(this._sourceFile, 800, 800, ImageProcessing.ASPECT_LOCK_PARTIAL);
        } else if (this._curState == 3) {
            if (this.cancelCheck()) {
                return;
            }
            BGApp.getInstance().sendToFG(new byte[]{3}, (byte)59);
            MMSUploader uploadThread = new MMSUploader("file:///" + fullPath, this._creator._mmsInfo.contentType, BGApp.getInstance()._myPlainJid, this._creator._fmsg.key, this._creator._fmsg.media_name, this._creator);
            uploadThread.start();
            if (this._creator._retryMode) {
                MediaData md = (MediaData)this._creator._fmsg.thumb_image;
                if (md.scaledFilename != null) {
                    Utilities.logData("skipping preview scale on upload retry");
                    this.cleanup();
                    return;
                }
            }
            this._curState = 2;
            this._curTransID = this._imageProc.resizeImage(this._sourceFile, 300, 200, ImageProcessing.ASPECT_LOCK_PARTIAL);
        } else if (this._curState == 2) {
            String permanentLoc = MMSDownloader.copyScaledImageToPermLocation("file:///" + fullPath);
            MessageStoreProvider.getMessageStore().addMMSFilename("file:///" + this._sourceFile, permanentLoc, new MessageStore.MMSKeyStoreCallback(){
                private long _offset;

                public void setOffset(long offset) {
                    Utilities.logData("send of mms got offset " + offset + " for orig file " + UploadScaler.this._sourceFile + ", scaled file " + fullPath);
                    this._offset = offset;
                }

                public void operationCompleted() {
                    SafeThread t = new SafeThread("upload scaler writeback"){

                        public void safeRun() {
                            UploadScaler.this._creator.keyWriteBackToggle(true);
                            MessageStore mStore = MessageStoreProvider.getMessageStore();
                            FunXMPP.FMessage updatedFMsg = mStore.getMessage(((UploadScaler)(this).UploadScaler.this)._creator._fmsg.key);
                            MediaData md = (MediaData)updatedFMsg.thumb_image;
                            md.filenameKey = _offset;
                            mStore.updateMessageStatus(updatedFMsg, true, new MessageStore.CompletionCallback(){

                                public void operationCompleted() {
                                    UploadScaler.this._creator.keyWriteBackToggle(false);
                                    BGApp.getInstance().sendToFG(new byte[]{2}, (byte)59);
                                }
                            });
                        }
                    };
                    t.start();
                }
            });
            this.cleanup();
        }
    }

    private synchronized void cleanup() {
        if (this._imageProc != null) {
            this._imageProc.closeConnection();
            this._imageProc = null;
        }
        this._curState = 10;
    }

    public void imageScaleError(byte transid, String reason) {
        Utilities.logData("UploadScaler sees an error: " + reason + " state: " + this._curState + " source: " + this._sourceFile);
        if (this._curState == 0 || this._curState == 3 || this._curState == 1) {
            BGMMSCreator.creatorDone(this._creator);
            this._creator._fmsg.status = 0;
            MessageStoreProvider.getMessageStore().updateMessageStatus(this._creator._fmsg, false, null);
            BGApp.getInstance().reportMMSUploadFail(this._creator._fmsg.key.remote_jid, Res.getString(11, reason));
        }
        this.cleanup();
    }
}

