/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.ui.Command;
import com.whatsapp.client.ContactListPane;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public abstract class TabState {
    public static final int ROW_HEIGHT = 44;
    protected ContactListPane _parentScr;
    protected Vector _masterList;
    protected Vector _filteredList;
    protected String _curFilter;
    private int _index;
    private static int START_FACTOR = 189;
    private static int END_FACTOR = 128;

    public TabState(ContactListPane parentScr, int index) {
        this._parentScr = parentScr;
        this._index = index;
    }

    public int getIndex() {
        return this._index;
    }

    public abstract void filterList(String var1, boolean var2);

    public void filterList(String filter) {
        this.filterList(filter, false);
    }

    public abstract int getNumListItems();

    public abstract Vector getListItems(int var1, int var2);

    public boolean isTrulyEmpty() {
        return this._curFilter == null && this.getNumListItems() == 0;
    }

    public abstract String getTabText();

    public boolean needsHighlight() {
        return false;
    }

    public abstract void selectItem(int var1);

    public abstract void deleteItem(int var1);

    public Vector getCommands() {
        return new Vector();
    }

    public boolean tabCommandHandler(Command c) {
        return false;
    }

    public int getRowHeight() {
        return 44;
    }

    protected Vector safeExcerpt(Vector v, int start, int numItems) {
        int curIndex;
        Vector resItems = new Vector(numItems);
        if (start < 0) {
            return resItems;
        }
        int lastValidIndex = v.size() - 1;
        for (int i = 0; i < numItems && (curIndex = start + i) <= lastValidIndex; ++i) {
            resItems.addElement(v.elementAt(curIndex));
        }
        return resItems;
    }

    public static void paintFocusedBackground(Graphics g, int x, int y, int width, int height) {
        int gradations = Math.min(height, 12);
        int extraGain = height % gradations;
        int slice = (END_FACTOR - START_FACTOR) / gradations;
        int heightSlice = height / gradations;
        int runningOffset = 0;
        for (int i = 0; i < gradations; ++i) {
            int curFactor;
            int newColor = curFactor = START_FACTOR + slice * i;
            g.setColor(newColor);
            int curSlice = heightSlice;
            if (i < extraGain) {
                ++curSlice;
            }
            g.fillRect(x, y + runningOffset, width, curSlice);
            runningOffset += curSlice;
        }
    }

    public boolean subnameCheck(String name) {
        String lName = name.toLowerCase();
        int s = lName.length();
        for (int lastSpace = 0; lastSpace < s; ++lastSpace) {
            if (lName.substring(lastSpace).startsWith(this._curFilter)) {
                return true;
            }
            if ((lastSpace = lName.indexOf(32, lastSpace + 1)) == -1) break;
        }
        return false;
    }
}

