/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.BGApp;
import com.whatsapp.client.ChatHistory;
import com.whatsapp.client.Constants;
import com.whatsapp.client.FunXMPP;
import com.whatsapp.client.MediaData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Serializer {
    public static final int CUR_SER_VERSION = 5;

    private static void keyToDOS(FunXMPP.FMessage.Key key, DataOutputStream dOS) throws IOException {
        dOS.writeUTF(key.remote_jid);
        dOS.writeBoolean(key.from_me);
        dOS.writeUTF(key.id);
    }

    private static FunXMPP.FMessage.Key keyFromDIS(DataInputStream dIS) throws IOException {
        String jid = Utilities.safeIntern(dIS.readUTF());
        boolean from_me = dIS.readBoolean();
        String id2 = dIS.readUTF();
        return new FunXMPP.FMessage.Key(jid, from_me, id2);
    }

    public static byte[] serialize(FunXMPP.FMessage.Key key) throws IOException {
        ByteArrayOutputStream baOS = new ByteArrayOutputStream(100);
        DataOutputStream dOS = new DataOutputStream(baOS);
        Serializer.keyToDOS(key, dOS);
        dOS.flush();
        dOS.close();
        baOS.flush();
        byte[] res = baOS.toByteArray();
        baOS.close();
        return res;
    }

    public static FunXMPP.FMessage.Key unserializeKey(byte[] bytes) throws IOException {
        ByteArrayInputStream baIS = new ByteArrayInputStream(bytes);
        DataInputStream dIS = new DataInputStream(baIS);
        FunXMPP.FMessage.Key newKey = Serializer.keyFromDIS(dIS);
        dIS.close();
        baIS.close();
        return newKey;
    }

    public static byte[] serialize(BGApp.FmsgKeyStatus keyStatus) throws IOException {
        ByteArrayOutputStream baOS = new ByteArrayOutputStream(100);
        DataOutputStream dOS = new DataOutputStream(baOS);
        Serializer.keyToDOS(keyStatus.key, dOS);
        dOS.writeInt(keyStatus.status);
        dOS.flush();
        dOS.close();
        baOS.flush();
        byte[] res = baOS.toByteArray();
        baOS.close();
        return res;
    }

    public static BGApp.FmsgKeyStatus unserializeKeyStatus(byte[] bytes) throws IOException {
        ByteArrayInputStream baIS = new ByteArrayInputStream(bytes);
        DataInputStream dIS = new DataInputStream(baIS);
        FunXMPP.FMessage.Key newKey = Serializer.keyFromDIS(dIS);
        int status = dIS.readInt();
        BGApp.FmsgKeyStatus res = new BGApp.FmsgKeyStatus(newKey, status);
        dIS.close();
        baIS.close();
        return res;
    }

    public static byte[] serialize(BGApp.ContactChatInfo ccInfo) throws IOException {
        ByteArrayOutputStream baOS = new ByteArrayOutputStream(100);
        DataOutputStream dOS = new DataOutputStream(baOS);
        dOS.writeUTF(ccInfo.jid);
        dOS.writeInt(ccInfo.state);
        dOS.writeLong(ccInfo.timestamp);
        dOS.flush();
        dOS.close();
        baOS.flush();
        byte[] res = baOS.toByteArray();
        baOS.close();
        return res;
    }

    public static BGApp.ContactChatInfo unserializeCCInfo(byte[] bytes) throws IOException {
        ByteArrayInputStream baIS = new ByteArrayInputStream(bytes);
        DataInputStream dIS = new DataInputStream(baIS);
        String j = dIS.readUTF();
        int s = dIS.readInt();
        long l = dIS.readLong();
        BGApp.ContactChatInfo ccInfo = new BGApp.ContactChatInfo(j, s, l);
        dIS.close();
        baIS.close();
        return ccInfo;
    }

    public static byte[] serializeStringArr(String[] sArr) throws IOException {
        ByteArrayOutputStream baOS = new ByteArrayOutputStream(100);
        DataOutputStream dOS = new DataOutputStream(baOS);
        for (int i = 0; i < sArr.length; ++i) {
            Utilities.safeStringOut(sArr[i], dOS);
        }
        dOS.flush();
        dOS.close();
        baOS.flush();
        byte[] res = baOS.toByteArray();
        baOS.close();
        return res;
    }

    public static String[] unserializeStringArr(byte[] bytes, int n) throws IOException {
        ByteArrayInputStream baIS = new ByteArrayInputStream(bytes);
        DataInputStream dIS = new DataInputStream(baIS);
        String[] sArr = new String[n];
        for (int i = 0; i < n; ++i) {
            sArr[i] = Utilities.readBlankAsNull(dIS);
        }
        dIS.close();
        baIS.close();
        return sArr;
    }

    public static byte[] serialize(String s) throws IOException {
        ByteArrayOutputStream baOS = new ByteArrayOutputStream(100);
        DataOutputStream dOS = new DataOutputStream(baOS);
        dOS.writeUTF(s);
        dOS.flush();
        dOS.close();
        baOS.flush();
        byte[] res = baOS.toByteArray();
        baOS.close();
        return res;
    }

    public static String unserializeString(byte[] bytes) throws IOException {
        ByteArrayInputStream baIS = new ByteArrayInputStream(bytes);
        DataInputStream dIS = new DataInputStream(baIS);
        String s = dIS.readUTF();
        dIS.close();
        baIS.close();
        return s;
    }

    public static void serializeFMsgStatusOnly(FunXMPP.FMessage fmsg, boolean includeMMSKey, DataOutputStream dOS) throws IOException {
        dOS.writeInt(5);
        dOS.writeUTF(fmsg.key.id);
        dOS.writeUTF(fmsg.key.remote_jid);
        dOS.writeBoolean(fmsg.key.from_me);
        dOS.writeInt(fmsg.status);
        if (includeMMSKey) {
            MediaData md = (MediaData)fmsg.thumb_image;
            if (md == null) {
                dOS.writeLong(-1L);
                dOS.writeInt(0);
            } else {
                Utilities.logData("stored to disk mms filename key of " + md.filenameKey + " for " + fmsg.key.id);
                dOS.writeLong(md.filenameKey);
                dOS.writeInt(md.externalThumbCount);
            }
            if (fmsg.key.from_me) {
                if (MediaData.hasURL(fmsg.media_wa_type)) {
                    PaddedStringField.writeString(fmsg.media_url, dOS);
                } else {
                    PaddedStringField.writeNull(dOS);
                }
            } else {
                Utilities.safeStringOut(fmsg.media_url, dOS);
            }
            dOS.writeLong(fmsg.media_size);
        }
    }

    public static void serializeFMSG(FunXMPP.FMessage fmsg, DataOutputStream dOS, boolean skelData) throws IOException {
        Serializer.serializeFMsgStatusOnly(fmsg, true, dOS);
        if (fmsg.remote_resource != null) {
            dOS.writeUTF(fmsg.remote_resource);
        } else {
            dOS.writeUTF("");
        }
        dOS.writeBoolean(fmsg.wants_receipt);
        if (skelData && fmsg.data != null && fmsg.data.length() > 50) {
            dOS.writeUTF(fmsg.data.substring(0, 50));
        } else {
            Utilities.safeStringOut(fmsg.data, dOS);
        }
        dOS.writeLong(fmsg.timestamp);
        Utilities.safeStringOut(fmsg.media_mime_type, dOS);
        dOS.writeByte(fmsg.media_wa_type);
        Utilities.safeStringOut(fmsg.media_name, dOS);
        dOS.writeDouble(fmsg.latitude);
        dOS.writeDouble(fmsg.longitude);
    }

    public static byte[] serialize(FunXMPP.FMessage fmsg) throws IOException {
        ByteArrayOutputStream baOS = new ByteArrayOutputStream(100);
        DataOutputStream dOS = new DataOutputStream(baOS);
        Serializer.serializeFMSG(fmsg, dOS, false);
        dOS.flush();
        dOS.close();
        baOS.flush();
        byte[] res = baOS.toByteArray();
        baOS.close();
        return res;
    }

    public static byte[] serializeSkeleton(FunXMPP.FMessage fmsg) throws IOException {
        ByteArrayOutputStream baOS = new ByteArrayOutputStream(100);
        DataOutputStream dOS = new DataOutputStream(baOS);
        Serializer.serializeFMSG(fmsg, dOS, true);
        dOS.flush();
        dOS.close();
        baOS.flush();
        byte[] res = baOS.toByteArray();
        baOS.close();
        return res;
    }

    public static FunXMPP.FMessage unserializeFMSG(DataInputStream dIS) throws IOException {
        int version = dIS.readInt();
        if (version < 4) {
            throw new IllegalStateException("bad version " + version + " on serialized messages " + "current is " + 5);
        }
        String id2 = dIS.readUTF();
        String jid = Utilities.safeIntern(dIS.readUTF());
        boolean from_me = dIS.readBoolean();
        FunXMPP.FMessage.Key newKey = new FunXMPP.FMessage.Key(jid, from_me, id2);
        FunXMPP.FMessage fmsg = new FunXMPP.FMessage(newKey);
        fmsg.status = dIS.readInt();
        long mmsFilenameKey = dIS.readLong();
        int externalThumbCount = -1;
        if (version >= 5) {
            externalThumbCount = dIS.readInt();
            fmsg.media_url = from_me ? PaddedStringField.readString(dIS) : Utilities.readBlankAsNull(dIS);
            fmsg.media_size = dIS.readLong();
        }
        fmsg.remote_resource = Utilities.readBlankAsNull(dIS);
        fmsg.wants_receipt = dIS.readBoolean();
        fmsg.data = Utilities.readBlankAsNull(dIS);
        fmsg.timestamp = dIS.readLong();
        if (version < 5) {
            fmsg.media_url = Utilities.readBlankAsNull(dIS);
        }
        fmsg.media_mime_type = Utilities.readBlankAsNull(dIS);
        fmsg.media_wa_type = dIS.readByte();
        if (version < 5) {
            fmsg.media_size = dIS.readLong();
        }
        fmsg.media_name = Utilities.readBlankAsNull(dIS);
        fmsg.latitude = dIS.readDouble();
        fmsg.longitude = dIS.readDouble();
        if (fmsg.media_wa_type != 0) {
            MediaData md = new MediaData(fmsg, mmsFilenameKey, externalThumbCount);
            fmsg.thumb_image = md;
        }
        return fmsg;
    }

    public static FunXMPP.FMessage unserializeFMSG(byte[] bytes) throws IOException {
        ByteArrayInputStream baIS = new ByteArrayInputStream(bytes);
        DataInputStream dIS = new DataInputStream(baIS);
        FunXMPP.FMessage res = Serializer.unserializeFMSG(dIS);
        dIS.close();
        baIS.close();
        return res;
    }

    public static ChatHistory.GroupPlusMetadata unserializeGroupMetaData(byte[] bytes) throws IOException {
        ByteArrayInputStream baIS = new ByteArrayInputStream(bytes);
        DataInputStream dIS = new DataInputStream(baIS);
        ChatHistory.GroupPlusMetadata metaD = new ChatHistory.GroupPlusMetadata();
        metaD.gjid = Utilities.readBlankAsNull(dIS);
        metaD.owner = Utilities.readBlankAsNull(dIS);
        metaD.subject = Utilities.readBlankAsNull(dIS);
        metaD.subject_owner_jid = Utilities.readBlankAsNull(dIS);
        metaD.subject_t = dIS.readInt();
        metaD.creation = dIS.readInt();
        dIS.close();
        baIS.close();
        return metaD;
    }

    private static void writeGroupMetaDataToDOS(String owner, String subject, String subject_owner_jid, int subject_t, int creation, DataOutputStream dOS) throws IOException {
        Utilities.safeStringOut(owner, dOS);
        Utilities.safeStringOut(subject, dOS);
        Utilities.safeStringOut(subject_owner_jid, dOS);
        dOS.writeInt(subject_t);
        dOS.writeInt(creation);
    }

    public static byte[] serializeGroupMetadata(String gjid, String owner, String subject, String subject_owner_jid, int subject_t, int creation) throws IOException {
        ByteArrayOutputStream baOS = new ByteArrayOutputStream(100);
        DataOutputStream dOS = new DataOutputStream(baOS);
        Utilities.safeStringOut(gjid, dOS);
        Serializer.writeGroupMetaDataToDOS(owner, subject, subject_owner_jid, subject_t, creation, dOS);
        dOS.flush();
        dOS.close();
        baOS.flush();
        byte[] res = baOS.toByteArray();
        baOS.close();
        return res;
    }

    public static byte[] serialize(ChatHistory chatHistory) throws IOException {
        ByteArrayOutputStream baOS = new ByteArrayOutputStream(100);
        DataOutputStream dOS = new DataOutputStream(baOS);
        Utilities.safeStringOut(chatHistory._jid, dOS);
        Utilities.safeStringOut(chatHistory._readableName, dOS);
        Utilities.safeStringOut(chatHistory._lastID, dOS);
        dOS.writeBoolean(chatHistory._lastFromMe);
        dOS.writeLong(chatHistory._lastTimestamp);
        Utilities.safeStringOut(chatHistory._lastExcerpt, dOS);
        dOS.writeInt(chatHistory._lastStatus);
        dOS.writeBoolean(chatHistory._typing);
        if (chatHistory._group != null) {
            dOS.writeBoolean(true);
            Serializer.writeGroupMetaDataToDOS(chatHistory._group._owner, chatHistory._group._subject, null, chatHistory._group._subjectT, (int)(chatHistory._group._creation / 1000L), dOS);
            Utilities.safeStringOut(chatHistory._group._lastParty, dOS);
        } else {
            dOS.writeBoolean(false);
        }
        byte[] res = baOS.toByteArray();
        baOS.close();
        return res;
    }

    public static ChatHistory unserializeChatHistory(byte[] data) throws IOException {
        ByteArrayInputStream baIS = new ByteArrayInputStream(data);
        DataInputStream dIS = new DataInputStream(baIS);
        ChatHistory newHist = new ChatHistory();
        newHist._jid = Utilities.readBlankAsNull(dIS);
        newHist._readableName = Utilities.readBlankAsNull(dIS);
        newHist._lastID = Utilities.readBlankAsNull(dIS);
        newHist._lastFromMe = dIS.readBoolean();
        newHist._lastTimestamp = dIS.readLong();
        newHist._lastExcerpt = Utilities.readBlankAsNull(dIS);
        newHist._lastStatus = dIS.readInt();
        newHist._typing = dIS.readBoolean();
        if (dIS.readBoolean()) {
            newHist._group = new ChatHistory.Group();
            String owner = Utilities.readBlankAsNull(dIS);
            String subject = Utilities.readBlankAsNull(dIS);
            String subject_owner_jid = Utilities.readBlankAsNull(dIS);
            int subjectT = dIS.readInt();
            int creationT = dIS.readInt();
            newHist.updateGroupChat(owner, creationT, subject, subjectT);
            newHist._group._lastParty = Utilities.readBlankAsNull(dIS);
        }
        return newHist;
    }

    public static byte[] serialize(BGApp.MMSUploadInfo mmsInfo) throws IOException {
        ByteArrayOutputStream baOS = new ByteArrayOutputStream(100);
        DataOutputStream dOS = new DataOutputStream(baOS);
        Serializer.keyToDOS(mmsInfo.key, dOS);
        Utilities.safeStringOut(mmsInfo.fullPath, dOS);
        Utilities.safeStringOut(mmsInfo.contentType, dOS);
        Utilities.safeStringOut(mmsInfo.cryptoName, dOS);
        byte[] res = baOS.toByteArray();
        baOS.close();
        return res;
    }

    public static BGApp.MMSUploadInfo unserializeMMSUploadInfo(byte[] data) throws IOException {
        ByteArrayInputStream baIS = new ByteArrayInputStream(data);
        DataInputStream dIS = new DataInputStream(baIS);
        BGApp.MMSUploadInfo newInfo = new BGApp.MMSUploadInfo();
        newInfo.key = Serializer.keyFromDIS(dIS);
        newInfo.fullPath = Utilities.readBlankAsNull(dIS);
        newInfo.contentType = Utilities.readBlankAsNull(dIS);
        newInfo.cryptoName = Utilities.readBlankAsNull(dIS);
        return newInfo;
    }

    private static class PaddedStringField {
        public static final int MAGIC_NULL = 0;
        public static final int MAGIC_PADDED = 1;
        public static final int MAX_LEN = 255;

        private PaddedStringField() {
        }

        public static void writeNull(DataOutputStream dOS) throws IOException {
            dOS.writeByte(0);
        }

        public static void writeString(String s, DataOutputStream dOS) throws IOException {
            Utilities.logData("trying to write padded string " + s);
            byte[] rawStr = s == null ? new byte[]{} : s.getBytes(Constants.CHARSET_UTF8);
            if (rawStr.length > 255) {
                throw new IllegalStateException("too long for padded field: " + s);
            }
            dOS.writeByte(1);
            int remaining = 255 - rawStr.length;
            byte lenAsByte = (byte)(rawStr.length - 128);
            dOS.writeByte(lenAsByte);
            if (rawStr.length > 0) {
                dOS.write(rawStr);
            }
            for (int i = 0; i < remaining; ++i) {
                dOS.writeByte(0);
            }
            Utilities.logData("padded str wrote " + rawStr.length + " data and " + remaining + " padding");
        }

        public static String readString(DataInputStream dIS) throws IOException {
            String s;
            byte magicByte = dIS.readByte();
            if (magicByte == 0) {
                return null;
            }
            if (magicByte != 1) {
                throw new IllegalStateException("unknown magic byte: " + magicByte);
            }
            byte lenAsByte = dIS.readByte();
            int len = lenAsByte + 128;
            if (len == 0) {
                s = null;
            } else {
                byte[] rawStr = new byte[len];
                dIS.read(rawStr);
                s = new String(rawStr, Constants.CHARSET_UTF8);
            }
            dIS.skip(255 - len);
            return s;
        }
    }
}

