/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.CountryPhoneInfo;
import com.whatsapp.client.PhoneRegBase;
import com.whatsapp.client.Res;
import java.io.IOException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.TextField;
import javax.microedition.rms.RecordStoreException;

public class PhoneReg
extends PhoneRegBase
implements ItemCommandListener,
ItemStateListener {
    private final PhoneRegAlert phoneRegAlert = new PhoneRegAlert();
    private final Command okCommand = new Command(Res.getString(109), 8, 0);
    public final ChoiceGroup ccChoice;
    public final TextField phoneField = new TextField(Res.getString(112), null, 1, 3);

    public PhoneReg() {
        super(Res.getString(114));
        String[] countryNames;
        try {
            countryNames = CountryPhoneInfo.getCountryNames();
        }
        catch (IOException ex) {
            countryNames = new String[]{};
        }
        this.ccChoice = new ChoiceGroup(null, 4, countryNames, null);
        try {
            int mcc;
            int mccCcIndex;
            String mnc = System.getProperty("com.nokia.mid.mnc");
            if (mnc != null && mnc.length() >= 3 && (mccCcIndex = CountryPhoneInfo.indexOfMcc(mcc = Integer.valueOf(mnc.substring(0, 3)).intValue())) != -1) {
                this.ccChoice.setSelectedIndex(mccCcIndex, true);
            }
        }
        catch (IOException ex) {
            Utilities.logData("countries/load/io-error: " + ex);
        }
        this.itemStateChanged((Item)this.ccChoice);
        this.append(Res.getString(179));
        this.append((Item)this.ccChoice);
        this.append((Item)this.phoneField);
        this.phoneField.setItemCommandListener((ItemCommandListener)this);
        this.setItemStateListener(this);
    }

    public void commandAction(Command command, Item item) {
        if (command == this.okCommand) {
            if (this.isRequesting()) {
                return;
            }
            try {
                String ccNumber = this.phoneField.getString();
                CountryPhoneInfo.Country country = CountryPhoneInfo.parseCCNumber(ccNumber);
                int cc = country.cc;
                String number = country.trimForSMS(ccNumber.substring(Integer.toString(cc).length() + 1));
                if (!country.checkNumberLength(number)) {
                    throw new NumberFormatException();
                }
                PhoneReg.saveReg(cc, number);
                this.phoneRegAlert.showExistReqProgress();
                this.mid._display.setCurrent((Alert)this.phoneRegAlert, (Displayable)this);
                this.startExistRequest(cc, number);
            }
            catch (NumberFormatException ex) {
                this.showError(Res.getString(119));
            }
            catch (RecordStoreException ex) {
                Utilities.logData("reg/save/rms-error: " + ex.toString());
                this.showError(Res.getString(55));
            }
            catch (IOException ex) {
                Utilities.logData("countries/load/io-error: " + ex);
            }
        }
    }

    protected void onExistRequestDone(int cc, String number, String status, String result) {
        if (status != null && status.equals("fail")) {
            this.phoneRegAlert.showConfirmation(cc, number);
            return;
        }
        super.onExistRequestDone(cc, number, status, result);
    }

    protected void onExistRequestError(String msg) {
        this.showError(msg);
    }

    public void itemStateChanged(Item item) {
        if (item == this.ccChoice) {
            try {
                CountryPhoneInfo.Country country = CountryPhoneInfo.parseCCNumber(this.phoneField.getString());
                this.phoneField.delete(1, Integer.toString(country.cc).length());
            }
            catch (NumberFormatException ex) {
            }
            catch (IOException ex) {
                Utilities.logData("countries/load/io-error: " + ex);
            }
            int selectedIdx = this.ccChoice.getSelectedIndex();
            if (selectedIdx == -1) {
                return;
            }
            try {
                CountryPhoneInfo.Country country = CountryPhoneInfo.getCountry(selectedIdx);
                String ccPrefix = '+' + Integer.toString(country.cc);
                if (this.phoneField.size() > 0) {
                    this.phoneField.delete(0, 1);
                }
                this.phoneField.setMaxSize(ccPrefix.length() + this.phoneField.size());
                this.phoneField.insert(ccPrefix, 0);
            }
            catch (IOException ex) {
                Utilities.logData("countries/load/io-error: " + ex);
            }
            this.itemStateChanged((Item)this.phoneField);
        } else if (item == this.phoneField) {
            char[] phoneFieldString = new char[this.phoneField.size()];
            this.phoneField.getChars(phoneFieldString);
            int i = 0;
            int j = 0;
            while (i < phoneFieldString.length) {
                switch (phoneFieldString[i]) {
                    case '+': {
                        if (i == 0) break;
                    }
                    case '#': 
                    case '*': 
                    case 'w': {
                        this.phoneField.delete(j--, 1);
                    }
                }
                ++i;
                ++j;
            }
            if (phoneFieldString.length < 1 || phoneFieldString[0] != '+') {
                this.phoneField.insert("+", 0);
            }
            try {
                String ccNumber = this.phoneField.getString();
                CountryPhoneInfo.Country country = CountryPhoneInfo.parseCCNumber(ccNumber);
                int ccLength = Integer.toString(country.cc).length();
                String number = ccNumber.substring(ccLength + 1);
                if (country.checkNumberLength(number)) {
                    this.phoneField.setDefaultCommand(this.okCommand);
                } else {
                    this.phoneField.removeCommand(this.okCommand);
                }
                this.phoneField.setMaxSize(1 + ccLength + country.getMaxNumberLength(number));
            }
            catch (NumberFormatException ex) {
                this.phoneField.removeCommand(this.okCommand);
                int max = 4;
                if (this.phoneField.size() > max) {
                    this.phoneField.delete(1, this.phoneField.size() - 1);
                }
                this.phoneField.setMaxSize(max);
            }
            catch (IOException ex) {
                Utilities.logData("countries/load/io-error: " + ex);
                this.phoneField.setDefaultCommand(this.okCommand);
                this.phoneField.setMaxSize(18);
            }
        }
    }

    private void startSMSReg(int cc, String number) {
        try {
            PhoneReg.saveReg(cc, number);
            PhoneReg.nextRegStep();
            this.mid.startupScreenflow();
        }
        catch (RecordStoreException ex) {
            Utilities.logData("reg/phone/rms-error: " + ex.toString());
            this.showError(Res.getString(55));
        }
    }

    private class PhoneRegAlert
    extends Alert
    implements CommandListener {
        private int cc;
        private String number;
        private final Command yesCommand = new Command(Res.getString(181), 4, 0);
        private final Command noCommand = new Command(Res.getString(107), 3, 1);
        private final Command stopCommand = new Command(Res.getString(63), 6, 0);
        private final Gauge indicator = new Gauge(null, false, -1, 2);

        private PhoneRegAlert() {
            super(null);
            this.setTimeout(-2);
            this.setCommandListener(this);
        }

        public void showExistReqProgress() {
            this.setString(Res.getString(71));
            if (this.getIndicator() != this.indicator) {
                this.setIndicator(this.indicator);
            }
            this.removeCommand(this.yesCommand);
            this.removeCommand(this.noCommand);
            this.addCommand(this.stopCommand);
        }

        public void showConfirmation(int cc, String number) {
            this.cc = cc;
            this.number = number;
            this.setString(Res.getString(150, PhoneRegBase.getSMSNumber(cc, number)));
            this.setIndicator(null);
            this.addCommand(this.yesCommand);
            this.addCommand(this.noCommand);
            this.removeCommand(this.stopCommand);
        }

        public void commandAction(Command command, Displayable d) {
            if (command == this.yesCommand) {
                PhoneReg.this.startSMSReg(this.cc, this.number);
            } else if (command == this.noCommand) {
                PhoneReg.this.phoneField.delete(0, PhoneReg.this.phoneField.size());
                PhoneReg.this.itemStateChanged((Item)PhoneReg.this.phoneField);
                PhoneReg.this.itemStateChanged((Item)PhoneReg.this.ccChoice);
                PhoneReg.this.mid._display.setCurrent((Displayable)PhoneReg.this);
            } else if (command == this.stopCommand) {
                if (PhoneReg.this.isRequesting()) {
                    PhoneReg.this.request.stop();
                }
                PhoneReg.this.mid._display.setCurrent((Displayable)PhoneReg.this);
            }
        }
    }
}

