/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.BGApp;
import com.whatsapp.client.FunXMPP;
import com.whatsapp.client.MessageStore;
import com.whatsapp.client.MessageStoreProvider;
import java.util.Vector;

public class OfflineMessages {
    public static final int OFFLINE_MSG_FIX_BUF_SIZE = 8;
    int _totalCount;
    MixedBag _bag = new MixedBag();

    public synchronized void add(FunXMPP.FMessage fmsg) {
        int fixedCount = 0;
        MixedBag curBag = this._bag;
        while (curBag != null) {
            fixedCount += curBag.fixedSize;
            if (curBag.nextBag == null) {
                boolean destinedForOverflow;
                boolean bl = destinedForOverflow = fixedCount >= 8;
                if (destinedForOverflow) {
                    curBag.overflow.addElement(fmsg.key);
                    Utilities.logData("offliner " + fmsg.key + " add to overflow, size " + curBag.overflow.size());
                } else if (curBag.overflow.size() > 0) {
                    MixedBag newBag = new MixedBag();
                    newBag.fixed[0] = fmsg;
                    newBag.fixedSize = 1;
                    curBag.nextBag = newBag;
                } else {
                    curBag.fixed[curBag.fixedSize++] = fmsg;
                }
                ++this._totalCount;
                return;
            }
            curBag = curBag.nextBag;
        }
        Utilities.logData("failed to add msg to offline with key " + fmsg.key.toString());
    }

    public synchronized void remove(FunXMPP.FMessage fmsg) {
        boolean found = false;
        if (this._totalCount == 0) {
            return;
        }
        MixedBag curBag = this._bag;
        while (curBag != null) {
            for (int i = 0; i < curBag.fixedSize; ++i) {
                FunXMPP.FMessage curMsg = curBag.fixed[i];
                if (found) {
                    curBag.fixed[i - 1] = curMsg;
                    curBag.fixed[i] = null;
                    continue;
                }
                if (!curMsg.key.equals(fmsg.key)) continue;
                found = true;
                curBag.fixed[i] = null;
            }
            if (found) {
                --curBag.fixedSize;
            } else {
                found = curBag.overflow.removeElement(fmsg.key);
            }
            if (found) {
                --this._totalCount;
                Utilities.logData("offline remove cache hit, current offline count: " + this._totalCount);
                return;
            }
            curBag = curBag.nextBag;
        }
    }

    public synchronized void populate() {
        Vector rawOffliners = MessageStoreProvider.getMessageStore().getAllOfflineMessages();
        int size = rawOffliners.size();
        Utilities.logData("trying to populate offliner with " + size + " stored messages");
        for (int i = 0; i < size; ++i) {
            this.add((FunXMPP.FMessage)rawOffliners.elementAt(i));
        }
    }

    private synchronized MixedBag shallowCopyOut() {
        MixedBag prevBag = null;
        MixedBag firstBag = null;
        MixedBag curBag = this._bag;
        while (curBag != null) {
            int i;
            MixedBag newBag = new MixedBag();
            if (prevBag != null) {
                prevBag.nextBag = newBag;
            } else {
                firstBag = newBag;
            }
            for (i = 0; i < curBag.fixedSize; ++i) {
                newBag.fixed[newBag.fixedSize++] = curBag.fixed[i];
            }
            for (i = 0; i < curBag.overflow.size(); ++i) {
                newBag.overflow.addElement(curBag.overflow.elementAt(i));
            }
            prevBag = newBag;
            curBag = curBag.nextBag;
        }
        return firstBag;
    }

    public void sendAll(BGApp bgApp) {
        Utilities.logData("copying out and sending " + this._totalCount + " offline messages");
        MixedBag copyRoot = this.shallowCopyOut();
        MessageStore mStore = MessageStoreProvider.getMessageStore();
        MixedBag curBag = copyRoot;
        while (curBag != null) {
            int i;
            for (i = 0; i < curBag.fixedSize; ++i) {
                bgApp.addMessageToSenderThread(curBag.fixed[i]);
            }
            for (i = 0; i < curBag.overflow.size(); ++i) {
                FunXMPP.FMessage.Key curKey = (FunXMPP.FMessage.Key)curBag.overflow.elementAt(i);
                FunXMPP.FMessage fmsg = mStore.getMessage(curKey);
                bgApp.addMessageToSenderThread(fmsg);
            }
            curBag = curBag.nextBag;
        }
    }

    public String dumpState() {
        StringBuffer sb = new StringBuffer();
        int bags = 0;
        sb.append("totalCount: " + this._totalCount);
        MixedBag curBag = this._bag;
        while (curBag != null) {
            sb.append("===> bag at level " + bags);
            ++bags;
            sb.append("fixedSize: " + curBag.fixedSize);
            for (int i = 0; i < curBag.fixedSize; ++i) {
                sb.append("[[");
                sb.append(curBag.fixed[i].key.id);
                sb.append("]]");
            }
            sb.append("overflow size: " + curBag.overflow.size());
            curBag = curBag.nextBag;
        }
        return sb.toString();
    }

    private static class MixedBag {
        int fixedSize = 0;
        public FunXMPP.FMessage[] fixed = new FunXMPP.FMessage[8];
        public Vector overflow = new Vector(8);
        public MixedBag nextBag = null;

        private MixedBag() {
        }
    }
}

