/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.contacts.Syncer;
import com.whatsapp.api.sapi.ImageProcessing;
import com.whatsapp.api.sapi.ImageProcessingListener;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.BGApp;
import com.whatsapp.client.Constants;
import com.whatsapp.client.FunXMPP;
import com.whatsapp.client.MediaData;
import com.whatsapp.client.MessageStore;
import com.whatsapp.client.MessageStoreProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.file.FileConnection;

public class MMSDownloader
implements ImageProcessingListener {
    private DownloadRunner _curRunner = null;
    private ImageProcessing _imageProcessing;
    private MMSDownloadCallback _pendingScale = null;

    public MMSDownloader() {
        try {
            this._imageProcessing = new ImageProcessing(this);
            this._imageProcessing.connect();
        }
        catch (IOException ex) {
            this._imageProcessing.closeConnection();
            Utilities.logData("error hooking up image processor: " + ex.toString());
            this._imageProcessing = null;
        }
    }

    public boolean isActive() {
        return this._curRunner != null || this._pendingScale != null;
    }

    public synchronized boolean requestDownload(FunXMPP.FMessage fmsg) {
        if (this._curRunner != null || this._pendingScale != null) {
            return false;
        }
        this._curRunner = new DownloadRunner(fmsg);
        this._curRunner.start();
        return true;
    }

    public synchronized void cancelDownload() {
        if (this._curRunner != null) {
            this._curRunner.cancel();
        }
    }

    private synchronized void runnerDone(DownloadRunner runner) {
        if (this._curRunner == runner) {
            this._curRunner = null;
        } else {
            Utilities.logData("RUNNER MISMATCH");
        }
    }

    public void imageProcessingSystemMessageReceived(String message) {
        Utilities.logData("Downloader got an image processor message: " + message);
    }

    public void imageProcessingServerReady() {
        Utilities.logData("system image processor ready!");
    }

    public void imageProcessingServerClosed(int reason) {
        Utilities.logData("system image processor closed because " + reason);
        this._imageProcessing = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String copyScaledImageToPermLocation(String src) {
        String string;
        InputStream srcIS;
        FileConnection destFileC;
        FileConnection srcFileC;
        block39: {
            String waDir = System.getProperty(Constants.PROPERTY_FILECONN_PRIVATE_DIR) + "WA_images/";
            srcFileC = null;
            destFileC = null;
            srcIS = null;
            OutputStream destOS = null;
            try {
                int actual;
                srcFileC = (FileConnection)Connector.open((String)waDir, (int)3);
                if (!srcFileC.exists()) {
                    srcFileC.mkdir();
                }
                srcFileC.close();
                String destName = waDir + Utilities.getLocalFilename(src);
                srcFileC = (FileConnection)Connector.open((String)src, (int)1);
                srcIS = srcFileC.openInputStream();
                destFileC = (FileConnection)Connector.open((String)destName, (int)3);
                if (destFileC.exists()) {
                    destFileC.delete();
                }
                destFileC.create();
                destOS = destFileC.openOutputStream();
                long expectedBytes = srcFileC.fileSize();
                byte[] buf = new byte[2048];
                for (long readBytes = 0L; readBytes < expectedBytes; readBytes += (long)actual) {
                    int chunk = 2048;
                    if (expectedBytes - readBytes < 2048L) {
                        chunk = (int)(expectedBytes - readBytes);
                    }
                    if ((actual = srcIS.read(buf, 0, chunk)) < 0) break;
                    destOS.write(buf, 0, actual);
                }
                destOS.flush();
                string = destName;
                if (destOS == null) break block39;
            }
            catch (Throwable t) {
                try {
                    Utilities.logData("blew up trying to copy out scaled " + src + " with " + t.toString());
                    String string2 = null;
                    return string2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (destOS != null) {
                        try {
                            destOS.close();
                        }
                        catch (Exception x) {}
                    }
                    if (srcIS != null) {
                        try {
                            srcIS.close();
                        }
                        catch (Exception x) {}
                    }
                    if (destFileC != null) {
                        try {
                            destFileC.close();
                        }
                        catch (Exception x) {}
                    }
                    if (srcFileC != null) {
                        try {
                            srcFileC.close();
                        }
                        catch (Exception x) {}
                    }
                }
            }
            try {
                destOS.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (srcIS != null) {
            try {
                srcIS.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (destFileC != null) {
            try {
                destFileC.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (srcFileC == null) return string;
        try {
            srcFileC.close();
            return string;
        }
        catch (Exception x) {
            // empty catch block
        }
        return string;
    }

    public void imageScaleComplete(byte transid, String path) {
        Utilities.logData("image scale complete for id " + transid + " at path " + path);
        BGApp.getInstance().sendToFG(new byte[]{97}, (byte)55);
        MMSDownloadCallback fsCallback = this._pendingScale;
        if (fsCallback != null) {
            String systemScaledFilename = "file://" + path;
            String ourName = MMSDownloader.copyScaledImageToPermLocation(systemScaledFilename);
            if (ourName == null) {
                ourName = systemScaledFilename;
            }
            fsCallback.setScaledFilename(ourName);
            MessageStoreProvider.getMessageStore().addMMSFilename(fsCallback._filename, ourName, fsCallback);
        }
        this._pendingScale = null;
    }

    public void imageScaleError(byte transid, String reason) {
        MMSDownloadCallback fsCallback = this._pendingScale;
        if (fsCallback != null) {
            Utilities.logData("image processing failed for " + fsCallback._filename + " because " + reason);
            MessageStoreProvider.getMessageStore().addMMSFilename(fsCallback._filename, null, fsCallback);
        }
        this._pendingScale = null;
    }

    private class DownloadRunner
    extends Thread {
        FunXMPP.FMessage _fmsg;
        boolean _stopped = false;

        public void cancel() {
            Utilities.logData("cancelling download for " + this._fmsg.media_url);
            this._stopped = true;
        }

        private FileConnection selectFilename(FunXMPP.FMessage fmsg, String useURL) throws IOException {
            FileConnection fileC;
            String useDir;
            switch (fmsg.media_wa_type) {
                case 1: {
                    useDir = System.getProperty("fileconn.dir.photos");
                    break;
                }
                case 3: {
                    useDir = System.getProperty("fileconn.dir.videos");
                    break;
                }
                case 2: {
                    useDir = System.getProperty("fileconn.dir.recordings");
                    break;
                }
                default: {
                    useDir = System.getProperty("fileconn.dir.recordings");
                }
            }
            Utilities.logData("picked dir " + useDir + " for download of " + useURL);
            String filename = fmsg.media_name;
            if (filename == null || filename.length() == 0) {
                filename = Utilities.getLocalFilename(useURL);
            } else {
                String urlExt;
                String mediaNameExt = MediaData.getExt(filename);
                if (!mediaNameExt.equals(urlExt = MediaData.getExt(useURL))) {
                    Utilities.logData("rewriting extension of " + filename + " to match " + useURL);
                    filename = mediaNameExt.length() == 0 ? filename + urlExt : filename.substring(0, filename.length() - mediaNameExt.length()) + urlExt;
                }
            }
            String fullFile = useDir + filename;
            while ((fileC = (FileConnection)Connector.open((String)fullFile, (int)3)).exists()) {
                fileC.close();
                fullFile = Utilities.incrementFilename(fullFile);
            }
            fileC.create();
            return fileC;
        }

        public DownloadRunner(FunXMPP.FMessage fmsg) {
            this._fmsg = fmsg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FileConnection fileC = null;
            HttpConnection httpConn = null;
            InputStream httpIS = null;
            OutputStream fileOS = null;
            boolean success = false;
            String filename = null;
            String errorText = Constants.STRING_EMPTY_STRING;
            try {
                this._fmsg.status |= 0x100;
                MessageStoreProvider.getMessageStore().updateMessageStatus(this._fmsg, false, null);
                String useURL = MediaData.rewriteDownloadURL(this._fmsg);
                fileC = this.selectFilename(this._fmsg, useURL);
                filename = fileC.getURL();
                Utilities.logData("picked full file " + filename + " for download of " + useURL);
                fileOS = fileC.openOutputStream();
                if (this._stopped) {
                    return;
                }
                httpConn = (HttpConnection)Connector.open((String)useURL, (int)1, (boolean)true);
                httpConn.setRequestProperty("User-Agent", Syncer.getUserAgent());
                int responseCode = httpConn.getResponseCode();
                if (responseCode != 200) {
                    throw new IllegalStateException("got http response " + responseCode);
                }
                int bytesExpected = httpConn.getHeaderFieldInt(Constants.HTTP_REQUEST_PROPERTY_CONTENT_LENGTH, (int)this._fmsg.media_size);
                String mimeType = httpConn.getType();
                httpIS = httpConn.openInputStream();
                int bytesRead = 0;
                byte[] buf = new byte[4096];
                int lastPercentSent = -1;
                while (bytesRead < bytesExpected) {
                    if (this._stopped) {
                        return;
                    }
                    int bytesLeft = bytesExpected - bytesRead;
                    int readSize = bytesLeft < 4096 ? bytesLeft : 4096;
                    int actual = httpIS.read(buf, 0, readSize);
                    if (actual == -1) break;
                    if (this._stopped) {
                        return;
                    }
                    fileOS.write(buf, 0, actual);
                    int percentComplete = 3 + (bytesRead += actual) * 91 / bytesExpected;
                    if (percentComplete <= lastPercentSent + 1) continue;
                    BGApp.getInstance().sendToFG(new byte[]{(byte)percentComplete}, (byte)55);
                    lastPercentSent = percentComplete;
                }
                fileOS.flush();
                Utilities.logData("downloaded " + useURL + " to " + filename + " size: " + bytesRead);
                success = true;
            }
            catch (Throwable t) {
                Utilities.logData("MMS download for " + this._fmsg.media_url + " failed with " + t.toString());
                errorText = t.toString();
            }
            finally {
                if (httpIS != null) {
                    try {
                        httpIS.close();
                    }
                    catch (Exception x) {}
                }
                if (fileOS != null) {
                    try {
                        fileOS.close();
                    }
                    catch (Exception x) {}
                }
                if (httpConn != null) {
                    try {
                        httpConn.close();
                    }
                    catch (Exception x) {}
                }
                if (fileC != null) {
                    if (this._stopped) {
                        try {
                            fileC.delete();
                        }
                        catch (Exception x) {}
                    }
                    try {
                        fileC.close();
                    }
                    catch (Exception x) {}
                }
                MMSDownloader.this.runnerDone(this);
                this._fmsg.status = 0;
                if (this._stopped) {
                    MessageStoreProvider.getMessageStore().updateMessageStatus(this._fmsg, false, null);
                    BGApp.getInstance().reportMMSXferCancelled();
                } else if (success) {
                    MMSDownloadCallback fsCallback = new MMSDownloadCallback(this._fmsg, filename);
                    if (this._fmsg.media_wa_type != 1 || MMSDownloader.this._imageProcessing == null) {
                        MessageStoreProvider.getMessageStore().addMMSFilename(filename, null, fsCallback);
                    } else {
                        String impFilename = filename.substring(8);
                        byte curID = MMSDownloader.this._imageProcessing.resizeImage(impFilename, 300, 200);
                        MMSDownloader.this._pendingScale = fsCallback;
                        Utilities.logData("registered image scaling for " + filename + " with trans id " + curID);
                    }
                } else {
                    BGApp.getInstance().reportMMSDownloadFail(this._fmsg.media_url, errorText);
                }
            }
        }
    }

    public static class MMSDownloadCallback
    extends MessageStore.MMSKeyStoreCallback {
        private long _offset;
        private FunXMPP.FMessage _fmsg;
        private String _filename;
        private String _scaledFilename;

        public MMSDownloadCallback(FunXMPP.FMessage fmsg, String filename) {
            this._fmsg = fmsg;
            this._filename = filename;
        }

        public void setOffset(long offset) {
            this._offset = offset;
        }

        public void setScaledFilename(String path) {
            this._scaledFilename = path;
        }

        public void operationCompleted() {
            MessageStore mStore = MessageStoreProvider.getMessageStore();
            this._fmsg.thumb_image = new MediaData(this._fmsg, this._offset);
            MessageStore.CompletionCallback finalCallback = new MessageStore.CompletionCallback(){

                public void operationCompleted() {
                    BGApp.getInstance().reportMMSDownloadComplete(((MMSDownloadCallback)MMSDownloadCallback.this)._fmsg.media_url, MMSDownloadCallback.this._filename, MMSDownloadCallback.this._scaledFilename);
                }
            };
            mStore.updateMessageStatus(this._fmsg, true, finalCallback);
        }
    }
}

