/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.nokia.mid.ui.DeviceControl;
import com.whatsapp.api.contacts.ContactInfoDetails;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.Constants;
import com.whatsapp.client.FGApp;
import com.whatsapp.client.Res;
import com.whatsapp.client.test.ContactListMidlet;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;

public class InitForm
extends Form
implements CommandListener {
    private static String ERROR_LOW_DISK = Res.getString(140);
    StringItem _stateString = new StringItem(Constants.STRING_EMPTY_STRING, Res.getString(122));
    StringItem _progressString = new StringItem(Res.getString(76), Constants.STRING_EMPTY_STRING);
    StringItem _errorItem = new StringItem(Constants.STRING_EMPTY_STRING, Constants.STRING_EMPTY_STRING);
    private RegRunner regRunner;
    private ContactInfoDetails.PIMCacher _pimCacher = null;
    public Command _retryCmd = new Command(Res.getString(138), 4, 1);
    public Command _retrySyncCmd = new Command(Res.getString(137), 8, 1);
    public Command _retryPimCmd = new Command(Res.getString(137), 8, 1);
    private static String PIM_CACHER_STATE_TEXT = Res.getString(177);
    private static String COLD_SYNCER_STATE_TEXT = Res.getString(178);
    private static String REG_STATE_TEXT = Res.getString(134);

    public InitForm() {
        super(Res.getString(98));
        this.setCommandListener(this);
        this.append(Res.getString(118));
        this._stateString.setLayout(256);
        this.append((Item)this._stateString);
        this.append((Item)this._progressString);
        this.append((Item)this._errorItem);
    }

    public void startReg() {
        this.regRunner = new RegRunner();
        this.regRunner.start();
    }

    public void firstSyncDetected() {
        if (this.regRunner != null) {
            this.regRunner.done();
        }
        FGApp.getInstance().sendZeroDataAlertToBG((byte)23);
        ContactListMidlet.getInstance().startupScreenflow();
    }

    public void syncFailDetected(byte errorCode, String errorText) {
        this._stateString.setText(Constants.STRING_EMPTY_STRING);
        this._errorItem.setLabel(Res.getString(153));
        if (errorCode == 1) {
            this._errorItem.setText(ERROR_LOW_DISK);
        } else {
            this._errorItem.setText(errorText);
        }
        this.addCommand(this._retrySyncCmd);
    }

    public void coldSyncUpdate(int percentDone) {
        this._progressString.setText(Integer.toString(percentDone) + '%');
    }

    public void commandAction(Command cmd, Displayable dsplbl) {
        if (cmd == this._retryCmd) {
            InitForm initF = new InitForm();
            ContactListMidlet.getInstance()._display.setCurrent((Displayable)initF);
            FGApp.getInstance().setTopPane((Object)initF);
            initF.startReg();
        } else if (cmd == this._retrySyncCmd) {
            Utilities.logData("InitForm user retrying sync");
            this.removeCommand(this._retrySyncCmd);
            FGApp.getInstance().sendZeroDataAlertToBG((byte)15);
            this._stateString.setText(COLD_SYNCER_STATE_TEXT);
            this._errorItem.setLabel(Constants.STRING_EMPTY_STRING);
            this._errorItem.setText(Constants.STRING_EMPTY_STRING);
            this._progressString.setText(Constants.STRING_EMPTY_STRING);
        } else if (cmd == this._retryPimCmd) {
            Utilities.logData("InitForm user retrying PIM");
            this.removeCommand(this._retryPimCmd);
            this._stateString.setText(PIM_CACHER_STATE_TEXT);
            this._errorItem.setLabel(Constants.STRING_EMPTY_STRING);
            this._errorItem.setText(Constants.STRING_EMPTY_STRING);
            this._progressString.setText(Constants.STRING_EMPTY_STRING);
            PIMCacheRunner pimRunner = new PIMCacheRunner();
            pimRunner.start();
        }
    }

    public void pimcacheFailDetected() {
        this._stateString.setText(Constants.STRING_EMPTY_STRING);
        this._errorItem.setLabel(Res.getString(94));
        if (this._pimCacher.getErrorCode() == 1) {
            this._errorItem.setText(ERROR_LOW_DISK);
        } else {
            this._errorItem.setText(this._pimCacher.getErrorText());
        }
        this.addCommand(this._retryPimCmd);
    }

    class RegRunner
    extends Thread {
        private boolean _done = false;
        private int _failCount = 0;

        public void run() {
            long startTime = System.currentTimeMillis();
            long lastLights = 0L;
            InitForm.this._stateString.setText(PIM_CACHER_STATE_TEXT);
            PIMCacheRunner pimRunner = new PIMCacheRunner();
            pimRunner.start();
            while (!this._done) {
                long curTime = System.currentTimeMillis();
                if (curTime - lastLights > 2000L) {
                    DeviceControl.setLights((int)0, (int)100);
                    lastLights = curTime;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Exception x) {}
            }
        }

        public void done() {
            this._done = true;
        }
    }

    class PIMCacheRunner
    extends Thread
    implements ContactInfoDetails.PIMCacher.Listener {
        PIMCacheRunner() {
        }

        public void run() {
            InitForm.this._pimCacher = new ContactInfoDetails.PIMCacher(this);
            boolean res = InitForm.this._pimCacher.cacheAllPIMEntries();
            if (res) {
                InitForm.this._stateString.setText(COLD_SYNCER_STATE_TEXT);
                InitForm.this._progressString.setText(Constants.STRING_EMPTY_STRING);
                Utilities.logData("all pim entries cached, alerting bg cold sync");
                FGApp.getInstance().sendZeroDataAlertToBG((byte)15);
            } else {
                InitForm.this.pimcacheFailDetected();
            }
        }

        public void PimCacherProgress(int percentDone) {
            InitForm.this._progressString.setText(Integer.toString(percentDone) + '%');
        }
    }
}

