/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.util.MessageDigest;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.FunStore;
import com.whatsapp.org.bouncycastle.util.encoders.Base64;
import com.whatsapp.org.xmlpull.v1.XmlPullParser;
import com.whatsapp.org.xmlpull.v1.XmlPullParserException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;

public class FunXMPP {
    public static FunStore message_store = new FunStore();
    public static String[] dictionary = new String[]{null, null, null, null, null, "1", "1.0", "ack", "action", "active", "add", "all", "allow", "apple", "audio", "auth", "author", "available", "bad-request", "base64", "Bell.caf", "bind", "body", "Boing.caf", "cancel", "category", "challenge", "chat", "clean", "code", "composing", "config", "conflict", "contacts", "create", "creation", "default", "delay", "delete", "delivered", "deny", "DIGEST-MD5", "DIGEST-MD5-1", "dirty", "en", "enable", "encoding", "error", "expiration", "expired", "failure", "false", "favorites", "feature", "field", "free", "from", "g.us", "get", "Glass.caf", "google", "group", "groups", "g_sound", "Harp.caf", "http://etherx.jabber.org/streams", "http://jabber.org/protocol/chatstates", "id", "image", "img", "inactive", "internal-server-error", "iq", "item", "item-not-found", "jabber:client", "jabber:iq:last", "jabber:iq:privacy", "jabber:x:delay", "jabber:x:event", "jid", "jid-malformed", "kind", "leave", "leave-all", "list", "location", "max_groups", "max_participants", "max_subject", "mechanism", "mechanisms", "media", "message", "message_acks", "missing", "modify", "name", "not-acceptable", "not-allowed", "not-authorized", "notify", "Offline Storage", "order", "owner", "owning", "paid", "participant", "participants", "participating", "particpants", "paused", "picture", "ping", "PLAIN", "platform", "presence", "preview", "probe", "prop", "props", "p_o", "p_t", "query", "raw", "receipt", "receipt_acks", "received", "relay", "remove", "Replaced by new connection", "request", "resource", "resource-constraint", "response", "result", "retry", "rim", "s.whatsapp.net", "seconds", "server", "session", "set", "show", "sid", "sound", "stamp", "starttls", "status", "stream:error", "stream:features", "subject", "subscribe", "success", "system-shutdown", "s_o", "s_t", "t", "TimePassing.caf", "timestamp", "to", "Tri-tone.caf", "type", "unavailable", "uri", "url", "urn:ietf:params:xml:ns:xmpp-bind", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-session", "urn:ietf:params:xml:ns:xmpp-stanzas", "urn:ietf:params:xml:ns:xmpp-streams", "urn:xmpp:delay", "urn:xmpp:ping", "urn:xmpp:receipts", "urn:xmpp:whatsapp", "urn:xmpp:whatsapp:dirty", "urn:xmpp:whatsapp:mms", "urn:xmpp:whatsapp:push", "value", "vcard", "version", "video", "w", "w:g", "w:p:r", "wait", "x", "xml-not-well-formed", "xml:lang", "xmlns", "xmlns:stream", "Xylophone.caf"};

    public static void destroyMessage(FMessage fmessage) {
        message_store.remove(fmessage.key);
    }

    public static String removeResourceFromJID(String jid) {
        int slashidx = jid.indexOf(47);
        if (slashidx == -1) {
            return jid;
        }
        return jid.substring(0, slashidx);
    }

    public static String getResourceFromJID(String jid) {
        int slashidx = jid.indexOf(47);
        if (slashidx == -1) {
            return "";
        }
        return jid.substring(slashidx + 1);
    }

    public static String getTextAndEntities(XmlPullParser parser) throws IOException, XmlPullParserException {
        StringBuffer ret = new StringBuffer();
        parser.nextToken();
        while (parser.getEventType() != 3) {
            if (parser.getEventType() != 6 && parser.getEventType() != 4) {
                throw new XmlPullParserException("getTextAndEntities bad type: " + parser.getEventType());
            }
            ret.append(parser.getText());
            parser.nextToken();
        }
        return ret.toString();
    }

    public static void ignoreElement(XmlPullParser parser, String startag) throws IOException, XmlPullParserException {
        int depth = 0;
        while (true) {
            parser.nextToken();
            if (parser.getEventType() == 4 || parser.getEventType() == 6) continue;
            if (parser.getEventType() == 2) {
                ++depth;
                continue;
            }
            if (depth == 0) {
                parser.require(3, null, startag);
                return;
            }
            parser.require(3, null, null);
            --depth;
        }
    }

    public static final class KeyValue {
        public final String key;
        public final String value;

        public KeyValue(String k, String v) {
            if (v == null || k == null) {
                throw new NullPointerException();
            }
            this.key = k;
            this.value = v;
        }
    }

    public static final class ProtocolTreeNode {
        public final String tag;
        public final KeyValue[] attributes;
        public final ProtocolTreeNode[] children;
        public final String data;

        public ProtocolTreeNode(String tag, KeyValue[] attributes, ProtocolTreeNode[] children) {
            this.tag = tag;
            this.attributes = attributes;
            this.children = children;
            this.data = null;
        }

        public ProtocolTreeNode(String tag, KeyValue[] attributes, ProtocolTreeNode child) {
            this.tag = tag;
            this.attributes = attributes;
            this.children = new ProtocolTreeNode[]{child};
            this.data = null;
        }

        public ProtocolTreeNode(String tag, KeyValue[] attributes, String data) {
            this.tag = tag;
            this.attributes = attributes;
            this.children = null;
            this.data = data;
        }

        public ProtocolTreeNode(String tag, KeyValue[] attributes) {
            this.tag = tag;
            this.attributes = attributes;
            this.children = null;
            this.data = null;
        }

        public String getAttributeValue(String string) {
            if (this.attributes == null) {
                return null;
            }
            for (int i = 0; i < this.attributes.length; ++i) {
                KeyValue keyValue = this.attributes[i];
                if (!string.equals(keyValue.key)) continue;
                return keyValue.value;
            }
            return null;
        }

        public ProtocolTreeNode getChild(String string) {
            if (this.children == null) {
                return null;
            }
            for (int i = 0; i < this.children.length; ++i) {
                if (!string.equals(this.children[i].tag)) continue;
                return this.children[i];
            }
            return null;
        }

        public static ProtocolTreeNode safeGetChild(ProtocolTreeNode node, int i) throws CorruptStreamException {
            if (node == null || node.children == null || node.children.length <= i) {
                throw new CorruptStreamException("safeGetChild sees null node/child");
            }
            return node.children[i];
        }

        public Vector getAllChildren(String string) {
            Vector<ProtocolTreeNode> ret = new Vector<ProtocolTreeNode>();
            if (this.children == null) {
                return ret;
            }
            for (int i = 0; i < this.children.length; ++i) {
                if (!string.equals(this.children[i].tag)) continue;
                ret.addElement(this.children[i]);
            }
            return ret;
        }

        public ProtocolTreeNode getChild(int i) {
            if (this.children == null || this.children.length <= i) {
                return null;
            }
            return this.children[i];
        }

        public static void require(ProtocolTreeNode node, String string) throws CorruptStreamException {
            if (!ProtocolTreeNode.tagEquals(node, string)) {
                throw new CorruptStreamException("failed require. node: " + node + " string: " + string);
            }
        }

        public static boolean tagEquals(ProtocolTreeNode node, String string) {
            return node != null && node.tag != null && node.tag.equals(string);
        }
    }

    public static class BinTreeNodeReader
    implements TreeNodeReader {
        InputStream rawIn;
        InputStream in;
        byte[] buf = new byte[255];
        int bufSize = 0;
        String[] tokenMap;

        public BinTreeNodeReader(InputStream i, String[] dict) {
            this.rawIn = new EofIsExceptionInputStream(i);
            this.tokenMap = dict;
        }

        public ProtocolTreeNode nextTree() throws CorruptStreamException, IOException {
            int stanzaSize = BinTreeNodeReader.readInt16(this.rawIn);
            this.fillBuffer(stanzaSize);
            return this.nextTreeInternal();
        }

        public String lastStanza() {
            if (this.buf == null) {
                return "null";
            }
            StringBuffer sb = new StringBuffer();
            sb.append("size = ").append(Integer.toString(this.bufSize)).append('<');
            for (int i = 0; i < this.bufSize; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(Integer.toString(this.buf[i] & 0xFF));
            }
            sb.append('>');
            return sb.toString();
        }

        private ProtocolTreeNode nextTreeInternal() throws CorruptStreamException, IOException {
            int b = this.in.read();
            int size = this.readListSize(b);
            b = this.in.read();
            if (b == 2) {
                return null;
            }
            String tag = this.readString(b);
            if (size == 0 || tag == null) {
                throw new CorruptStreamException("nextTree sees 0 list or null tag");
            }
            int attribCount = (size - 2 + size % 2) / 2;
            KeyValue[] attribs = this.readAttributes(attribCount);
            if (size % 2 == 1) {
                return new ProtocolTreeNode(tag, attribs);
            }
            b = this.in.read();
            if (this.isListTag(b)) {
                return new ProtocolTreeNode(tag, attribs, this.readList(b));
            }
            return new ProtocolTreeNode(tag, attribs, this.readString(b));
        }

        private boolean isListTag(int b) {
            return b == 248 || b == 0 || b == 249;
        }

        private KeyValue[] readAttributes(int attribCount) throws IOException, CorruptStreamException {
            KeyValue[] attribs = new KeyValue[attribCount];
            for (int i = 0; i < attribCount; ++i) {
                String key = this.readString();
                String value = this.readString();
                attribs[i] = new KeyValue(key, value);
            }
            return attribs;
        }

        private ProtocolTreeNode[] readList(int token) throws CorruptStreamException, IOException {
            int size = this.readListSize(token);
            ProtocolTreeNode[] list = new ProtocolTreeNode[size];
            for (int i = 0; i < size; ++i) {
                list[i] = this.nextTreeInternal();
            }
            return list;
        }

        private int readListSize(int token) throws IOException, CorruptStreamException {
            int size;
            if (token == 0) {
                size = 0;
            } else if (token == 248) {
                size = BinTreeNodeReader.readInt8(this.in);
            } else if (token == 249) {
                size = BinTreeNodeReader.readInt16(this.in);
            } else {
                throw new CorruptStreamException("invalid list size in readListSize: token " + token);
            }
            return size;
        }

        private ProtocolTreeNode[] readList() throws IOException, CorruptStreamException {
            return this.readList(this.in.read());
        }

        private String readString() throws IOException, CorruptStreamException {
            return this.readString(this.in.read());
        }

        private String readString(int token) throws IOException, CorruptStreamException {
            if (token == -1) {
                throw new CorruptStreamException("-1 token in readString");
            }
            if (token > 4 && token < 245) {
                return this.getToken(token);
            }
            switch (token) {
                case 0: {
                    return null;
                }
                case 252: {
                    int size8 = BinTreeNodeReader.readInt8(this.in);
                    byte[] buf8 = new byte[size8];
                    BinTreeNodeReader.fillArray(buf8, this.in);
                    return new String(buf8, "UTF-8");
                }
                case 253: {
                    int size24 = BinTreeNodeReader.readInt24(this.in);
                    byte[] buf24 = new byte[size24];
                    BinTreeNodeReader.fillArray(buf24, this.in);
                    return new String(buf24, "UTF-8");
                }
                case 254: {
                    token = (byte)this.in.read();
                    return this.getToken(245 + token);
                }
                case 250: {
                    String user = this.readString();
                    String server = this.readString();
                    if (user != null && server != null) {
                        return user + "@" + server;
                    }
                    if (server != null) {
                        return server;
                    }
                    throw new CorruptStreamException("readString couldn't reconstruct jid");
                }
            }
            throw new CorruptStreamException("readString couldn't match token");
        }

        private static void fillArray(byte[] buf, InputStream i) throws IOException {
            BinTreeNodeReader.fillArray(buf, buf.length, i);
        }

        private static void fillArray(byte[] buf, int len, InputStream i) throws IOException {
            for (int count = 0; count < len; count += i.read(buf, count, len - count)) {
            }
        }

        private String getToken(int token) throws CorruptStreamException {
            String ret = token >= 0 && token < this.tokenMap.length ? this.tokenMap[token] : null;
            if (ret == null) {
                throw new CorruptStreamException("invalid token/length in getToken");
            }
            return ret;
        }

        private static int readInt8(InputStream i) throws IOException {
            return i.read();
        }

        private static int readInt16(InputStream i) throws IOException {
            int intTop = i.read();
            int intBot = i.read();
            int value = (intTop << 8) + intBot;
            return value;
        }

        private static int readInt24(InputStream i) throws IOException {
            int int1 = i.read();
            int int2 = i.read();
            int int3 = i.read();
            int value = (int1 << 16) + (int2 << 8) + (int3 << 0);
            return value;
        }

        public void streamStart() throws IOException, CorruptStreamException {
            int stanzaSize = BinTreeNodeReader.readInt16(this.rawIn);
            this.fillBuffer(stanzaSize);
            int tag = this.in.read();
            int size = this.readListSize(tag);
            tag = this.in.read();
            if (tag != 1) {
                throw new CorruptStreamException("expecting STREAM_START in streamStart");
            }
            int attribCount = (size - 2 + size % 2) / 2;
            KeyValue[] attribs = this.readAttributes(attribCount);
        }

        private void fillBuffer(int stanzaSize) throws IOException {
            if (this.buf.length < stanzaSize) {
                int newsize = Math.max(this.buf.length * 3 / 2, stanzaSize);
                this.buf = new byte[newsize];
            }
            this.bufSize = stanzaSize;
            BinTreeNodeReader.fillArray(this.buf, stanzaSize, this.rawIn);
            this.in = new ByteArrayInputStream(this.buf, 0, stanzaSize);
        }
    }

    public static class EofIsExceptionInputStream
    extends InputStream {
        InputStream inner;

        public EofIsExceptionInputStream(InputStream inner) {
            this.inner = inner;
        }

        public int read() throws IOException {
            int read = this.inner.read();
            if (read == -1) {
                throw new EOFException();
            }
            return read;
        }

        public int read(byte[] buf, int start, int len) throws IOException {
            int read = this.inner.read(buf, start, len);
            if (read == -1) {
                throw new EOFException();
            }
            return read;
        }

        public int read(byte[] buf) throws IOException {
            int read = this.inner.read(buf);
            if (read == -1) {
                throw new EOFException();
            }
            return read;
        }

        public int available() throws IOException {
            return this.inner.available();
        }

        public void close() throws IOException {
            this.inner.close();
        }

        public synchronized void mark(int paramInt) {
            this.inner.mark(paramInt);
        }

        public boolean markSupported() {
            return this.inner.markSupported();
        }

        public synchronized void reset() throws IOException {
            this.inner.reset();
        }

        public long skip(long paramLong) throws IOException {
            return this.inner.skip(paramLong);
        }
    }

    public static class BinTreeNodeWriter
    implements TreeNodeWriter {
        private static final int STREAM_START = 1;
        private static final int STREAM_END = 2;
        private static final int LIST_EMPTY = 0;
        private static final int LIST_8 = 248;
        private static final int LIST_16 = 249;
        private static final int JID_PAIR = 250;
        private static final int BINARY_8 = 252;
        private static final int BINARY_24 = 253;
        private static final int TOKEN_8 = 254;
        Hashtable tokenMap;
        OutputStream realOut;
        WAByteArrayOutputStream out;

        public BinTreeNodeWriter(OutputStream o, String[] dictionary) {
            this.realOut = o;
            this.out = new WAByteArrayOutputStream();
            this.tokenMap = new Hashtable(dictionary.length);
            for (int i = 0; i < dictionary.length; ++i) {
                if (dictionary[i] == null) continue;
                this.tokenMap.put(dictionary[i], new Integer(i));
            }
        }

        public synchronized void flushBuffer(boolean flushNetwork) throws IOException {
            int size = this.out.getCount();
            if ((size & 0xFFFF0000) != 0) {
                throw new IOException("Buffer too large: " + size);
            }
            BinTreeNodeWriter.writeInt16(this.realOut, size);
            this.realOut.write(this.out.getBuffer(), 0, size);
            this.out.reset();
            if (flushNetwork) {
                this.realOut.flush();
            }
        }

        public synchronized void streamEnd() throws IOException {
            this.writeListStart(1);
            this.out.write(2);
            this.flushBuffer(true);
        }

        public synchronized void streamStart(String domain, String resource) throws IOException {
            this.realOut.write(87);
            this.realOut.write(65);
            this.realOut.write(0);
            this.realOut.write(4);
            KeyValue[] streamOpenAttributes = new KeyValue[]{new KeyValue("to", domain), new KeyValue("resource", resource)};
            this.writeListStart(streamOpenAttributes.length * 2 + 1);
            this.out.write(1);
            this.writeAttributes(streamOpenAttributes);
            this.flushBuffer(false);
        }

        public synchronized void write(ProtocolTreeNode node) throws IOException {
            this.write(node, true);
        }

        public synchronized void write(ProtocolTreeNode node, boolean needsFlush) throws IOException {
            if (node == null) {
                this.out.write(0);
            } else {
                this.writeInternal(node);
            }
            this.flushBuffer(needsFlush);
        }

        private void writeInternal(ProtocolTreeNode node) throws IOException {
            this.writeListStart(1 + (node.attributes == null ? 0 : node.attributes.length * 2) + (node.children == null ? 0 : 1) + (node.data == null ? 0 : 1));
            this.writeString(node.tag);
            this.writeAttributes(node.attributes);
            if (node.data != null) {
                this.writeBytes(node.data.getBytes("UTF-8"));
            }
            if (node.children != null) {
                this.writeListStart(node.children.length);
                for (int i = 0; i < node.children.length; ++i) {
                    this.writeInternal(node.children[i]);
                }
            }
        }

        private void writeAttributes(KeyValue[] attributes) throws IOException {
            if (attributes != null) {
                for (int i = 0; i < attributes.length; ++i) {
                    this.writeString(attributes[i].key);
                    this.writeString(attributes[i].value);
                }
            }
        }

        private void writeString(String tag) throws IOException {
            try {
                Integer key = (Integer)this.tokenMap.get(tag);
                if (key != null) {
                    this.writeToken(key);
                } else {
                    int atIndex = tag.indexOf(64);
                    if (atIndex < 1) {
                        this.writeBytes(tag.getBytes("UTF-8"));
                    } else {
                        String server = tag.substring(atIndex + 1);
                        String user = tag.substring(0, atIndex);
                        this.writeJid(user, server);
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage());
            }
        }

        private void writeJid(String user, String server) throws IOException {
            this.out.write(250);
            if (user != null) {
                this.writeString(user);
            } else {
                this.writeToken(0);
            }
            this.writeString(server);
        }

        private void writeToken(int intValue) throws IOException {
            if (intValue < 245) {
                this.out.write((byte)intValue);
            } else if (intValue <= 500) {
                this.out.write(254);
                this.out.write((byte)(intValue - 245));
            }
        }

        private void writeBytes(byte[] bytes) throws IOException {
            int length = bytes.length;
            if (length >= 256) {
                this.out.write(253);
                this.writeInt24(length);
            } else {
                this.out.write(252);
                this.writeInt8(length);
            }
            this.out.write(bytes);
        }

        private void writeInt8(int v) throws IOException {
            this.out.write(v & 0xFF);
        }

        private void writeInt16(int v) throws IOException {
            BinTreeNodeWriter.writeInt16(this.out, v);
        }

        private static void writeInt16(OutputStream o, int v) throws IOException {
            o.write((v & 0xFF00) >> 8);
            o.write((v & 0xFF) >> 0);
        }

        private void writeInt24(int v) throws IOException {
            this.out.write((v & 0xFF0000) >> 16);
            this.out.write((v & 0xFF00) >> 8);
            this.out.write((v & 0xFF) >> 0);
        }

        private void writeListStart(int i) throws IOException {
            if (i == 0) {
                this.out.write(0);
            } else if (i < 256) {
                this.out.write(248);
                this.writeInt8(i);
            } else {
                this.out.write(249);
                this.writeInt16(i);
            }
        }
    }

    public static class WAByteArrayOutputStream
    extends ByteArrayOutputStream {
        public int getCount() {
            return this.count;
        }

        public byte[] getBuffer() {
            return this.buf;
        }
    }

    public static interface TreeNodeReader {
        public ProtocolTreeNode nextTree() throws CorruptStreamException, IOException;

        public void streamStart() throws IOException, CorruptStreamException;

        public String lastStanza();
    }

    public static interface TreeNodeWriter {
        public void streamStart(String var1, String var2) throws IOException;

        public void streamEnd() throws IOException;

        public void write(ProtocolTreeNode var1) throws IOException;

        public void write(ProtocolTreeNode var1, boolean var2) throws IOException;
    }

    public static abstract class Login {
        MessageDigest digest;
        TreeNodeReader in;
        TreeNodeWriter out;
        Connection connection;
        static String nonce_key = "nonce=\"";

        public Login(MessageDigest d, TreeNodeReader r, TreeNodeWriter w) {
            this.in = r;
            this.out = w;
            this.digest = d;
        }

        public void setConnection(Connection c) {
            this.connection = c;
        }

        public TreeNodeWriter getTreeWriter() {
            return this.out;
        }

        public TreeNodeReader getTreeReader() {
            return this.in;
        }

        abstract void login() throws IOException, LoginFailureException, CorruptStreamException;

        protected String getResponse(String challenge) throws IOException {
            int i = challenge.indexOf(nonce_key);
            if (i == -1) {
                throw new IOException("no nonce in challenge");
            }
            int j = challenge.indexOf(34, i += nonce_key.length());
            if (j == -1) {
                throw new IOException("bad nonce in challenge");
            }
            String nonce = challenge.substring(i, j);
            String cnonce = Long.toString(Math.abs(new Random().nextLong()), 36);
            String nc = "00000001";
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(this.md5Digest((this.connection.user + ":" + this.connection.domain + ":" + this.connection.password).getBytes()));
            bos.write(58);
            bos.write(nonce.getBytes());
            bos.write(58);
            bos.write(cnonce.getBytes());
            String digest_uri = "xmpp/" + this.connection.domain;
            byte[] A1 = bos.toByteArray();
            String A2 = "AUTHENTICATE:" + digest_uri;
            String KD = new String(this.bytesToHex(this.md5Digest(A1))) + ":" + nonce + ":" + nc + ":" + cnonce + ":auth:" + new String(this.bytesToHex(this.md5Digest(A2.getBytes())));
            String response = new String(this.bytesToHex(this.md5Digest(KD.getBytes())));
            StringBuffer bigger_response = new StringBuffer();
            bigger_response.append("realm=\"");
            bigger_response.append(this.connection.domain);
            bigger_response.append("\",response=");
            bigger_response.append(response);
            bigger_response.append(",nonce=\"");
            bigger_response.append(nonce);
            bigger_response.append("\",digest-uri=\"");
            bigger_response.append(digest_uri);
            bigger_response.append("\",cnonce=\"");
            bigger_response.append(cnonce);
            bigger_response.append("\",qop=auth");
            bigger_response.append(",username=\"");
            bigger_response.append(this.connection.user);
            bigger_response.append("\",nc=");
            bigger_response.append(nc);
            return bigger_response.toString();
        }

        byte[] md5Digest(byte[] input) {
            this.digest.reset();
            this.digest.update(input);
            return this.digest.digest();
        }

        byte forDigit(int b) {
            if (b < 10) {
                return (byte)(48 + b);
            }
            return (byte)(97 + b - 10);
        }

        byte[] bytesToHex(byte[] bytes) {
            byte[] ret = new byte[bytes.length * 2];
            int i = 0;
            for (int c = 0; c < bytes.length; ++c) {
                int ub = bytes[c];
                if (ub < 0) {
                    ub += 256;
                }
                ret[i] = this.forDigit(ub >> 4);
                ret[++i] = this.forDigit(ub % 16);
                ++i;
            }
            return ret;
        }

        public static final class WhatsApp
        extends Login {
            public WhatsApp(TreeNodeReader r, TreeNodeWriter w, MessageDigest d) {
                super(d, r, w);
            }

            public void login() throws IOException, LoginFailureException, CorruptStreamException {
                this.out.streamStart(this.connection.domain, this.connection.resource);
                this.sendFeatures();
                this.sendAuth();
                this.in.streamStart();
                String challengeData = this.readFeaturesAndChallenge();
                this.sendResponse(challengeData);
                this.readSuccess();
            }

            private void sendFeatures() throws IOException {
                ProtocolTreeNode[] protocolTreeNodeArray;
                if (!this.connection.supports_receipt_acks) {
                    protocolTreeNodeArray = null;
                } else {
                    ProtocolTreeNode[] protocolTreeNodeArray2 = new ProtocolTreeNode[1];
                    protocolTreeNodeArray = protocolTreeNodeArray2;
                    protocolTreeNodeArray2[0] = new ProtocolTreeNode("receipt_acks", null);
                }
                this.out.write(new ProtocolTreeNode("stream:features", null, protocolTreeNodeArray), false);
            }

            private void sendAuth() throws IOException {
                ProtocolTreeNode node = new ProtocolTreeNode("auth", new KeyValue[]{new KeyValue("xmlns", "urn:ietf:params:xml:ns:xmpp-sasl"), new KeyValue("mechanism", "DIGEST-MD5-1")});
                this.out.write(node);
            }

            private String readFeaturesAndChallenge() throws IOException, CorruptStreamException {
                ProtocolTreeNode root;
                boolean server_supports_receipt_acks = false;
                Integer server_properties_version = null;
                while ((root = this.in.nextTree()) != null) {
                    if (ProtocolTreeNode.tagEquals(root, "stream:features")) {
                        ProtocolTreeNode receiptAcksNode = root.getChild("receipt_acks");
                        ProtocolTreeNode propsNode = root.getChild("props");
                        boolean bl = server_supports_receipt_acks = receiptAcksNode != null;
                        if (propsNode == null) continue;
                        server_properties_version = new Integer(Integer.parseInt(propsNode.getAttributeValue("version")));
                        continue;
                    }
                    if (!ProtocolTreeNode.tagEquals(root, "challenge")) continue;
                    boolean bl = this.connection.supports_receipt_acks = this.connection.supports_receipt_acks && server_supports_receipt_acks;
                    if (server_properties_version != null) {
                        this.connection.server_properties_version = server_properties_version;
                    }
                    String data = new String(Base64.decode(root.data.getBytes()));
                    return data;
                }
                throw new CorruptStreamException("fell out of loop in readFeaturesAndChallenge");
            }

            private void sendResponse(String challengeData) throws IOException {
                String response = this.getResponse(challengeData);
                ProtocolTreeNode node = new ProtocolTreeNode("response", new KeyValue[]{new KeyValue("xmlns", "urn:ietf:params:xml:ns:xmpp-sasl")}, new String(Base64.encode(response.getBytes())));
                this.out.write(node);
            }

            private void readSuccess() throws CorruptStreamException, IOException, LoginFailureException {
                String kind;
                ProtocolTreeNode node = this.in.nextTree();
                if (ProtocolTreeNode.tagEquals(node, "failure")) {
                    throw new LoginFailureException(0);
                }
                ProtocolTreeNode.require(node, "success");
                String expiration = node.getAttributeValue("expiration");
                if (expiration != null) {
                    try {
                        this.connection.expire_date = Long.parseLong(expiration);
                    }
                    catch (NumberFormatException xxx) {
                        throw new IOException("invalid expire date: " + expiration);
                    }
                }
                this.connection.account_kind = "paid".equals(kind = node.getAttributeValue("kind")) ? 1 : ("free".equals(kind) ? 0 : -1);
                String status = node.getAttributeValue("status");
                if ("expired".equals(status)) {
                    LoginFailureException failex = new LoginFailureException(1);
                    failex.expire_date = this.connection.expire_date;
                    throw failex;
                }
                if ("active".equals(status)) {
                    if (expiration == null) {
                        throw new IOException("active account with no expiration");
                    }
                } else {
                    this.connection.account_kind = -1;
                }
            }
        }

        public static final class XMPP
        extends Login {
            public XMPP(TreeNodeReader in, TreeNodeWriter out, MessageDigest d) {
                super(d, in, out);
            }

            public synchronized void login() throws IOException, LoginFailureException, CorruptStreamException {
                this.send1();
                this.send2DigestMD5Mechanism();
                this.read1();
                String challenge = this.read2Challenge();
                this.send2SASLResponse(challenge);
                this.send2UselessResponse();
                this.read2Challenge();
                this.read2();
                this.send3();
                this.read3();
                this.send4();
                this.send5();
            }

            public void read1() throws IOException, CorruptStreamException {
                this.in.streamStart();
                ProtocolTreeNode node = this.in.nextTree();
                ProtocolTreeNode.require(node, "stream:features");
                node = ProtocolTreeNode.safeGetChild(node, 0);
                ProtocolTreeNode.require(node, "mechanisms");
                if (node.children != null) {
                    for (int i = 0; i < node.children.length; ++i) {
                        ProtocolTreeNode.require(node.children[i], "mechanism");
                    }
                }
            }

            public void read2() throws IOException, LoginFailureException, CorruptStreamException {
                String kind;
                ProtocolTreeNode node = this.in.nextTree();
                if (ProtocolTreeNode.tagEquals(node, "failure")) {
                    throw new LoginFailureException(0);
                }
                ProtocolTreeNode.require(node, "success");
                String expiration = node.getAttributeValue("expiration");
                if (expiration != null) {
                    try {
                        this.connection.expire_date = Long.parseLong(expiration);
                    }
                    catch (NumberFormatException xxx) {
                        throw new IOException("invalid expire date: " + expiration);
                    }
                }
                this.connection.account_kind = "paid".equals(kind = node.getAttributeValue("kind")) ? 1 : ("free".equals(kind) ? 0 : -1);
                String status = node.getAttributeValue("status");
                if ("expired".equals(status)) {
                    LoginFailureException failex = new LoginFailureException(1);
                    failex.expire_date = this.connection.expire_date;
                    throw failex;
                }
                if ("active".equals(status)) {
                    if (expiration == null) {
                        throw new IOException("active account with no expiration");
                    }
                } else {
                    this.connection.account_kind = -1;
                }
            }

            String read2Challenge() throws IOException, LoginFailureException, CorruptStreamException {
                ProtocolTreeNode node = this.in.nextTree();
                if (ProtocolTreeNode.tagEquals(node, "failure")) {
                    throw new LoginFailureException(0);
                }
                ProtocolTreeNode.require(node, "challenge");
                String data = new String(Base64.decode(node.data.getBytes()));
                return data;
            }

            void read3() throws IOException, CorruptStreamException {
                this.in.streamStart();
                ProtocolTreeNode node = this.in.nextTree();
                ProtocolTreeNode.require(node, "stream:features");
                boolean server_supports_receipt_acks = node.getChild("receipt_acks") != null;
                this.connection.supports_receipt_acks = this.connection.supports_receipt_acks && server_supports_receipt_acks;
            }

            void send1() throws IOException {
                this.out.streamStart(this.connection.domain, this.connection.resource);
            }

            void send2DigestMD5Mechanism() throws IOException {
                ProtocolTreeNode node = new ProtocolTreeNode("auth", new KeyValue[]{new KeyValue("xmlns", "urn:ietf:params:xml:ns:xmpp-sasl"), new KeyValue("mechanism", "DIGEST-MD5")});
                this.out.write(node);
            }

            public synchronized void sendOpenStreamMD5Mechanism() throws IOException {
                this.send1();
                this.send2DigestMD5Mechanism();
            }

            void send2SASLResponse(String challenge) throws IOException {
                String bigger_response = this.getResponse(challenge);
                ProtocolTreeNode node = new ProtocolTreeNode("response", new KeyValue[]{new KeyValue("xmlns", "urn:ietf:params:xml:ns:xmpp-sasl")}, new String(Base64.encode(bigger_response.getBytes())));
                this.out.write(node);
            }

            void send2UselessResponse() throws IOException {
                ProtocolTreeNode node = new ProtocolTreeNode("response", new KeyValue[]{new KeyValue("xmlns", "urn:ietf:params:xml:ns:xmpp-sasl")});
                this.out.write(node);
            }

            void send3() throws IOException {
                this.out.streamStart(this.connection.domain, this.connection.resource);
            }

            void send4() throws IOException {
                ProtocolTreeNode resourceNode = new ProtocolTreeNode("resource", null, this.connection.resource);
                ProtocolTreeNode[] featuresChildren = null;
                if (this.connection.supports_receipt_acks) {
                    featuresChildren = new ProtocolTreeNode[]{new ProtocolTreeNode("receipt_acks", null)};
                }
                ProtocolTreeNode featuresNode = new ProtocolTreeNode("features", null, featuresChildren);
                ProtocolTreeNode bindNode = new ProtocolTreeNode("bind", new KeyValue[]{new KeyValue("xmlns", "urn:ietf:params:xml:ns:xmpp-bind")}, new ProtocolTreeNode[]{resourceNode, featuresNode});
                ProtocolTreeNode iqNode = new ProtocolTreeNode("iq", new KeyValue[]{new KeyValue("type", "set"), new KeyValue("id", "0")}, bindNode);
                this.out.write(iqNode);
            }

            void send5() throws IOException {
                ProtocolTreeNode sessionNode = new ProtocolTreeNode("session", new KeyValue[]{new KeyValue("xmlns", "urn:ietf:params:xml:ns:xmpp-session")});
                ProtocolTreeNode iqNode = new ProtocolTreeNode("iq", new KeyValue[]{new KeyValue("type", "set"), new KeyValue("id", "1")}, new ProtocolTreeNode[]{sessionNode});
                this.out.write(iqNode);
            }
        }
    }

    public static class Connection {
        String domain;
        String resource;
        String user;
        String push_name;
        String password;
        String from;
        Listener event_handler;
        GroupListener group_event_handler;
        DateParser date_parser;
        boolean supports_receipt_acks = false;
        Integer server_properties_version = null;
        boolean verbose_id = false;
        Hashtable pending_server_requests = new Hashtable();
        Login login;
        TreeNodeWriter out;
        TreeNodeReader in;
        static final int ACCOUNT_KIND_UNKNOWN = -1;
        static final int ACCOUNT_KIND_FREE = 0;
        static final int ACCOUNT_KIND_PAID = 1;
        public int account_kind = -1;
        public long expire_date = 0L;
        public long lastTreeRead = 0L;
        static final int ID_HEADER_SIZE = 4;
        int iqid;

        public Connection(Login login, String domain, String resource, String user, String push_name, String password, Listener event_handler, GroupListener group_event_handler, DateParser date_parser) throws IOException, XmlPullParserException {
            this.in = login.getTreeReader();
            this.out = login.getTreeWriter();
            this.login = login;
            this.domain = domain;
            this.user = user;
            this.push_name = push_name;
            this.password = password;
            this.resource = resource;
            this.event_handler = event_handler;
            this.group_event_handler = group_event_handler;
            this.date_parser = date_parser;
            this.from = user + "@" + domain + "/" + resource;
        }

        public void setPushName(String push_name) {
            this.push_name = push_name;
            try {
                this.sendAvailableForChat();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void setVerboseId(boolean value) {
            this.verbose_id = value;
        }

        public void setReceiptAckCapable(boolean value) {
            this.supports_receipt_acks = value;
        }

        public void login() throws IOException, XmlPullParserException, LoginFailureException, CorruptStreamException {
            this.login.login();
            this.sendAvailableForChat();
        }

        public void sendNop() throws IOException {
            this.out.write(null);
        }

        public void sendPong(String id2) throws IOException {
            ProtocolTreeNode iqNode = new ProtocolTreeNode("iq", new KeyValue[]{new KeyValue("type", "result"), new KeyValue("to", this.domain), new KeyValue("id", id2)});
            this.out.write(iqNode);
        }

        private ProtocolTreeNode getReceiptAck(String to, String id2, String receiptType) throws IOException {
            ProtocolTreeNode ackNode = new ProtocolTreeNode("ack", new KeyValue[]{new KeyValue("xmlns", "urn:xmpp:receipts"), new KeyValue("type", receiptType)});
            ProtocolTreeNode messageNode = new ProtocolTreeNode("message", new KeyValue[]{new KeyValue("to", to), new KeyValue("type", "chat"), new KeyValue("id", id2)}, ackNode);
            return messageNode;
        }

        public void sendVisibleReceiptAck(String to, String id2) throws IOException {
            this.out.write(this.getReceiptAck(to, id2, "visible"));
        }

        public void sendDeliveredReceiptAck(String to, String id2) throws IOException {
            this.out.write(this.getReceiptAck(to, id2, "delivered"));
        }

        public static ProtocolTreeNode getSubjectMessage(String to, String id2, ProtocolTreeNode child) throws IOException {
            ProtocolTreeNode messageNode = new ProtocolTreeNode("message", new KeyValue[]{new KeyValue("to", to), new KeyValue("type", "subject"), new KeyValue("id", id2)}, child);
            return messageNode;
        }

        private void sendMessageWithBody(FMessage message) throws IOException {
            ProtocolTreeNode bodyNode = new ProtocolTreeNode("body", null, message.data);
            this.out.write(Connection.getMessageNode(message, bodyNode));
        }

        public void sendComposing(String to) throws IOException {
            ProtocolTreeNode composingNode = new ProtocolTreeNode("composing", new KeyValue[]{new KeyValue("xmlns", "http://jabber.org/protocol/chatstates")});
            ProtocolTreeNode messageNode = new ProtocolTreeNode("message", new KeyValue[]{new KeyValue("to", to), new KeyValue("type", "chat")}, composingNode);
            this.out.write(messageNode);
        }

        public void sendPaused(String to) throws IOException {
            ProtocolTreeNode pausedNode = new ProtocolTreeNode("paused", new KeyValue[]{new KeyValue("xmlns", "http://jabber.org/protocol/chatstates")});
            ProtocolTreeNode messageNode = new ProtocolTreeNode("message", new KeyValue[]{new KeyValue("to", to), new KeyValue("type", "chat")}, pausedNode);
            this.out.write(messageNode);
        }

        private void sendMessageWithMedia(FMessage message) throws IOException {
            if (7 == message.media_wa_type) {
                throw new RuntimeException("Cannot send system message over the network");
            }
            KeyValue xmlns = new KeyValue("xmlns", "urn:xmpp:whatsapp:mms");
            KeyValue type = new KeyValue("type", FMessage.getMessage_WA_Type_StrValue(message.media_wa_type));
            KeyValue[] mediaAttributes = 5 == message.media_wa_type ? new KeyValue[]{xmlns, type, new KeyValue("latitude", Double.toString(message.latitude)), new KeyValue("longitude", Double.toString(message.longitude))} : (4 != message.media_wa_type && message.media_name != null && message.media_url != null && message.media_size > 0L ? (message.media_duration_seconds <= 0 ? new KeyValue[]{xmlns, type, new KeyValue("file", message.media_name), new KeyValue("size", Long.toString(message.media_size)), new KeyValue("url", message.media_url)} : new KeyValue[]{xmlns, type, new KeyValue("file", message.media_name), new KeyValue("size", Long.toString(message.media_size)), new KeyValue("url", message.media_url), new KeyValue("seconds", Integer.toString(message.media_duration_seconds))}) : new KeyValue[]{xmlns, type});
            ProtocolTreeNode mediaNode = 4 == message.media_wa_type && message.media_name != null ? new ProtocolTreeNode("media", mediaAttributes, new ProtocolTreeNode("vcard", new KeyValue[]{new KeyValue("name", message.media_name)}, message.data)) : new ProtocolTreeNode("media", mediaAttributes, message.data);
            this.out.write(Connection.getMessageNode(message, mediaNode));
        }

        private static ProtocolTreeNode getMessageNode(FMessage message, ProtocolTreeNode child) throws IOException {
            Object requestNode = null;
            ProtocolTreeNode serverNode = new ProtocolTreeNode("server", null);
            ProtocolTreeNode xNode = new ProtocolTreeNode("x", new KeyValue[]{new KeyValue("xmlns", "jabber:x:event")}, new ProtocolTreeNode[]{serverNode});
            int childCount = (requestNode == null ? 0 : 1) + 2;
            ProtocolTreeNode[] messageChildren = new ProtocolTreeNode[childCount];
            int i = 0;
            if (requestNode != null) {
                messageChildren[i] = requestNode;
                ++i;
            }
            messageChildren[i] = xNode;
            messageChildren[++i] = child;
            ++i;
            ProtocolTreeNode messageNode = new ProtocolTreeNode("message", new KeyValue[]{new KeyValue("to", message.key.remote_jid), new KeyValue("type", "chat"), new KeyValue("id", message.key.id)}, messageChildren);
            return messageNode;
        }

        public void sendMessage(FMessage message) throws IOException {
            if (message.media_wa_type != 0) {
                this.sendMessageWithMedia(message);
            } else {
                this.sendMessageWithBody(message);
            }
        }

        public void sendSubjectReceived(String to, String id2) throws IOException {
            ProtocolTreeNode receivedNode = new ProtocolTreeNode("received", new KeyValue[]{new KeyValue("xmlns", "urn:xmpp:receipts")});
            ProtocolTreeNode messageNode = Connection.getSubjectMessage(to, id2, receivedNode);
            this.out.write(messageNode);
        }

        public void sendMessageReceived(FMessage message) throws IOException {
            ProtocolTreeNode receivedNode = new ProtocolTreeNode("received", new KeyValue[]{new KeyValue("xmlns", "urn:xmpp:receipts")});
            ProtocolTreeNode messageNode = new ProtocolTreeNode("message", new KeyValue[]{new KeyValue("to", message.key.remote_jid), new KeyValue("type", "chat"), new KeyValue("id", message.key.id)}, receivedNode);
            this.out.write(messageNode);
        }

        public void sendPresenceSubscriptionRequest(String to) throws IOException {
            ProtocolTreeNode presenceNode = new ProtocolTreeNode("presence", new KeyValue[]{new KeyValue("type", "subscribe"), new KeyValue("to", to)});
            this.out.write(presenceNode);
        }

        public void sendActive() throws IOException {
            ProtocolTreeNode presenceNode = new ProtocolTreeNode("presence", new KeyValue[]{new KeyValue("type", "active")});
            this.out.write(presenceNode);
        }

        public void sendInactive() throws IOException {
            ProtocolTreeNode presenceNode = new ProtocolTreeNode("presence", new KeyValue[]{new KeyValue("type", "inactive")});
            this.out.write(presenceNode);
        }

        public void sendUnsubscribeMe(String jid) throws IOException {
            ProtocolTreeNode presenceNode = new ProtocolTreeNode("presence", new KeyValue[]{new KeyValue("type", "unsubscribe"), new KeyValue("to", jid)});
            this.out.write(presenceNode);
        }

        public void sendUnsubscribeHim(String jid) throws IOException {
            ProtocolTreeNode presenceNode = new ProtocolTreeNode("presence", new KeyValue[]{new KeyValue("type", "unsubscribed"), new KeyValue("to", jid)});
            this.out.write(presenceNode);
        }

        private String makeId(String prefix) {
            ++this.iqid;
            String id2 = this.verbose_id ? prefix + this.iqid : Integer.toHexString(this.iqid);
            return id2;
        }

        public void sendDeleteFromRoster(String jid) throws IOException {
            String id2 = this.makeId("roster_");
            ProtocolTreeNode itemNode = new ProtocolTreeNode("item", new KeyValue[]{new KeyValue("jid", jid), new KeyValue("subscription", "remove")});
            ProtocolTreeNode queryNode = new ProtocolTreeNode("query", new KeyValue[]{new KeyValue("xmlns", "jabber:iq:roster")}, itemNode);
            ProtocolTreeNode iqNode = new ProtocolTreeNode("iq", new KeyValue[]{new KeyValue("type", "set"), new KeyValue("id", id2)}, queryNode);
            this.out.write(iqNode);
        }

        public void sendClose() throws IOException {
            ProtocolTreeNode presenceNode = new ProtocolTreeNode("presence", new KeyValue[]{new KeyValue("type", "unavailable")});
            this.out.write(presenceNode);
            this.out.streamEnd();
        }

        public void sendQueryLastOnline(String jid) throws IOException {
            String id2 = this.makeId("last_");
            this.pending_server_requests.put(id2, new IqResultHandler(){

                public void parse(ProtocolTreeNode node, String from) throws CorruptStreamException, IOException {
                    ProtocolTreeNode firstChild = node.getChild(0);
                    ProtocolTreeNode.require(firstChild, "query");
                    String seconds = firstChild.getAttributeValue("seconds");
                    String status = null;
                    status = firstChild.data;
                    try {
                        if (seconds != null && from != null) {
                            Connection.this.event_handler.onLastSeen(from, Integer.parseInt(seconds), status);
                        }
                    }
                    catch (NumberFormatException x) {
                        // empty catch block
                    }
                }
            });
            ProtocolTreeNode queryNode = new ProtocolTreeNode("query", new KeyValue[]{new KeyValue("xmlns", "jabber:iq:last")});
            ProtocolTreeNode iqNode = new ProtocolTreeNode("iq", new KeyValue[]{new KeyValue("id", id2), new KeyValue("type", "get"), new KeyValue("to", jid)}, queryNode);
            this.out.write(iqNode);
        }

        public void sendGetClientConfig() throws IOException {
            String id2 = this.makeId("get_config_");
            this.pending_server_requests.put(id2, new IqResultHandler(){

                public void parse(ProtocolTreeNode node, String from) throws CorruptStreamException, IOException {
                    ProtocolTreeNode configNode = node.getChild(0);
                    ProtocolTreeNode.require(configNode, "config");
                    String push_id = configNode.getAttributeValue("id");
                    Connection.this.event_handler.onClientConfigReceived(push_id);
                }

                public void error(ProtocolTreeNode node) throws CorruptStreamException, IOException {
                    Vector nodes = node.getAllChildren("config");
                    for (int i = 0; i < nodes.size(); ++i) {
                        ProtocolTreeNode configNode = (ProtocolTreeNode)nodes.elementAt(i);
                        if (configNode == null) continue;
                        String push_id = configNode.getAttributeValue("id");
                        Connection.this.event_handler.onClientConfigReceived(push_id);
                    }
                }
            });
            ProtocolTreeNode configNode = new ProtocolTreeNode("config", new KeyValue[]{new KeyValue("xmlns", "urn:xmpp:whatsapp:push")});
            ProtocolTreeNode iqNode = new ProtocolTreeNode("iq", new KeyValue[]{new KeyValue("id", id2), new KeyValue("type", "get"), new KeyValue("to", this.domain)}, configNode);
            this.out.write(iqNode);
        }

        public void sendClientConfig(String pushID, String platform) throws IOException {
            String id2 = this.makeId("config_");
            ProtocolTreeNode configNode = new ProtocolTreeNode("config", new KeyValue[]{new KeyValue("xmlns", "urn:xmpp:whatsapp:push"), new KeyValue("id", pushID), new KeyValue("platform", platform)});
            ProtocolTreeNode iqNode = new ProtocolTreeNode("iq", new KeyValue[]{new KeyValue("id", id2), new KeyValue("type", "set"), new KeyValue("to", this.domain)}, configNode);
            this.out.write(iqNode);
        }

        public void sendClientConfig(String sound, String pushID, boolean preview, String platform) throws IOException {
            String id2 = this.makeId("config_");
            ProtocolTreeNode configNode = new ProtocolTreeNode("config", new KeyValue[]{new KeyValue("xmlns", "urn:xmpp:whatsapp:push"), new KeyValue("sound", sound), new KeyValue("id", pushID), new KeyValue("preview", preview ? "1" : "0"), new KeyValue("platform", platform)});
            ProtocolTreeNode iqNode = new ProtocolTreeNode("iq", new KeyValue[]{new KeyValue("id", id2), new KeyValue("type", "set"), new KeyValue("to", this.domain)}, configNode);
            this.out.write(iqNode);
        }

        public void sendPing() throws IOException {
            String id2 = this.makeId("ping_");
            this.pending_server_requests.put(id2, new IqResultHandler(){

                public void parse(ProtocolTreeNode node, String from) throws CorruptStreamException, IOException {
                    Connection.this.event_handler.onPingResponseReceived();
                }

                public void error(ProtocolTreeNode node) throws CorruptStreamException, IOException {
                    Connection.this.event_handler.onPingResponseReceived();
                }
            });
            ProtocolTreeNode pingNode = new ProtocolTreeNode("ping", new KeyValue[]{new KeyValue("xmlns", "w:p")});
            ProtocolTreeNode iqNode = new ProtocolTreeNode("iq", new KeyValue[]{new KeyValue("id", id2), new KeyValue("type", "get")}, pingNode);
            this.out.write(iqNode);
        }

        public void sendGetPrivacyList() throws IOException {
            String id2 = this.makeId("privacylist_");
            this.pending_server_requests.put(id2, new IqResultHandler(){

                public void parse(ProtocolTreeNode node, String from) throws CorruptStreamException, IOException {
                    ProtocolTreeNode queryNode = node.getChild(0);
                    ProtocolTreeNode.require(queryNode, "query");
                    ProtocolTreeNode listNode = queryNode.getChild(0);
                    ProtocolTreeNode.require(listNode, "list");
                    Connection.this.event_handler.onPrivacyBlockListClear();
                    if (listNode.children != null) {
                        for (int i = 0; i < listNode.children.length; ++i) {
                            String jid;
                            ProtocolTreeNode itemNode = listNode.children[i];
                            ProtocolTreeNode.require(itemNode, "item");
                            if (!"jid".equals(itemNode.getAttributeValue("type")) || (jid = itemNode.getAttributeValue("value")) == null) continue;
                            Connection.this.event_handler.onPrivacyBlockListAdd(jid);
                        }
                    }
                }
            });
            ProtocolTreeNode listNode = new ProtocolTreeNode("list", new KeyValue[]{new KeyValue("name", "default")});
            ProtocolTreeNode queryNode = new ProtocolTreeNode("query", new KeyValue[]{new KeyValue("xmlns", "jabber:iq:privacy")}, listNode);
            ProtocolTreeNode iqNode = new ProtocolTreeNode("iq", new KeyValue[]{new KeyValue("id", id2), new KeyValue("type", "get")}, queryNode);
            this.out.write(iqNode);
        }

        public void sendSetPrivacyBlockedList(Hashtable list) throws IOException {
            this.sendSetPrivacyBlockedList(list, null, null);
        }

        public void sendSetPrivacyBlockedList(Hashtable list, final Runnable onSuccess, final IntRunnable onError) throws IOException {
            String id2 = this.makeId("privacy_");
            this.pending_server_requests.put(id2, new IqResultHandler(){

                public void parse(ProtocolTreeNode node, String from) throws IOException, CorruptStreamException {
                    if (onSuccess != null) {
                        onSuccess.run();
                    }
                }

                public void error(int code) {
                    if (onError != null) {
                        onError.run(code);
                    }
                }
            });
            ProtocolTreeNode[] listNodeChildren = new ProtocolTreeNode[list.size()];
            Enumeration e = list.elements();
            int order = 0;
            while (e.hasMoreElements()) {
                String jid = (String)e.nextElement();
                listNodeChildren[order] = new ProtocolTreeNode("item", new KeyValue[]{new KeyValue("type", "jid"), new KeyValue("value", jid), new KeyValue("action", "deny"), new KeyValue("order", Integer.toString(order))});
                ++order;
            }
            ProtocolTreeNode listNode = new ProtocolTreeNode("list", new KeyValue[]{new KeyValue("name", "default")}, listNodeChildren.length == 0 ? null : listNodeChildren);
            ProtocolTreeNode queryNode = new ProtocolTreeNode("query", new KeyValue[]{new KeyValue("xmlns", "jabber:iq:privacy")}, listNode);
            ProtocolTreeNode iqNode = new ProtocolTreeNode("iq", new KeyValue[]{new KeyValue("id", id2), new KeyValue("type", "set")}, queryNode);
            this.out.write(iqNode);
        }

        public void sendClearDirty(String category) throws IOException {
            Vector<String> v = new Vector<String>();
            v.addElement(category);
            this.sendClearDirty(v);
        }

        public void sendClearDirty(Vector categoryNames) throws IOException {
            String id2 = this.makeId("clean_dirty_");
            this.pending_server_requests.put(id2, new IqResultHandler(){

                public void parse(ProtocolTreeNode node, String from) throws CorruptStreamException, IOException {
                }
            });
            int size = categoryNames.size();
            ProtocolTreeNode[] cleanNodeChildren = new ProtocolTreeNode[size];
            for (int i = 0; i < size; ++i) {
                cleanNodeChildren[i] = new ProtocolTreeNode("category", new KeyValue[]{new KeyValue("name", (String)categoryNames.elementAt(i))});
            }
            ProtocolTreeNode cleanNode = new ProtocolTreeNode("clean", new KeyValue[]{new KeyValue("xmlns", "urn:xmpp:whatsapp:dirty")}, cleanNodeChildren);
            ProtocolTreeNode iqNode = new ProtocolTreeNode("iq", new KeyValue[]{new KeyValue("id", id2), new KeyValue("type", "set"), new KeyValue("to", "s.whatsapp.net")}, cleanNode);
            this.out.write(iqNode);
        }

        public void sendGetDirty() throws IOException {
            String id2 = this.makeId("get_dirty_");
            this.pending_server_requests.put(id2, new IqResultHandler(){

                public void parse(ProtocolTreeNode node, String from) throws CorruptStreamException, IOException {
                    ProtocolTreeNode dirtyNode = node.getChild(0);
                    ProtocolTreeNode.require(dirtyNode, "dirty");
                    Hashtable categories = Connection.this.parseCategories(dirtyNode);
                    Connection.this.event_handler.onDirtyResponse(categories);
                }
            });
            ProtocolTreeNode statusNode = new ProtocolTreeNode("status", new KeyValue[]{new KeyValue("xmlns", "urn:xmpp:whatsapp:dirty")});
            ProtocolTreeNode iqNode = new ProtocolTreeNode("iq", new KeyValue[]{new KeyValue("id", id2), new KeyValue("type", "get"), new KeyValue("to", "s.whatsapp.net")}, statusNode);
            this.out.write(iqNode);
        }

        public void sendGetServerProperties() throws IOException {
            String id2 = this.makeId("get_server_properties_");
            this.pending_server_requests.put(id2, new IqResultHandler(){

                public void parse(ProtocolTreeNode node, String from) throws CorruptStreamException, IOException {
                    ProtocolTreeNode propsNode = node.getChild("props");
                    if (propsNode != null) {
                        int version;
                        String versionString = propsNode.getAttributeValue("version");
                        try {
                            version = Integer.parseInt(versionString);
                        }
                        catch (NumberFormatException exn) {
                            version = 0;
                        }
                        Vector nodes = propsNode.getAllChildren("prop");
                        Hashtable<String, String> nameValueMap = new Hashtable<String, String>();
                        for (int i = 0; i < nodes.size(); ++i) {
                            ProtocolTreeNode propNode = (ProtocolTreeNode)nodes.elementAt(i);
                            String nameAttr = propNode.getAttributeValue("name");
                            String valueAttr = propNode.getAttributeValue("value");
                            nameValueMap.put(nameAttr, valueAttr);
                        }
                        Connection.this.group_event_handler.onServerProperties(version, nameValueMap);
                    }
                }
            });
            ProtocolTreeNode listNode = new ProtocolTreeNode("props", new KeyValue[]{new KeyValue("xmlns", "w")});
            ProtocolTreeNode iqNode = new ProtocolTreeNode("iq", new KeyValue[]{new KeyValue("id", id2), new KeyValue("type", "get"), new KeyValue("to", "s.whatsapp.net")}, listNode);
            this.out.write(iqNode);
        }

        public void sendCreateGroupChat(String subject) throws IOException {
            this.sendCreateGroupChat(subject, null, null);
        }

        public void sendCreateGroupChat(final String subject, final StringRunnable onSuccess, final IntRunnable onError) throws IOException {
            String id2 = this.makeId("create_group_");
            this.pending_server_requests.put(id2, new IqResultHandler(){

                public void parse(ProtocolTreeNode node, String from) throws CorruptStreamException, IOException {
                    ProtocolTreeNode groupNode = node.getChild(0);
                    ProtocolTreeNode.require(groupNode, "group");
                    String gid = groupNode.getAttributeValue("id");
                    Connection.this.group_event_handler.onGroupCreated(Connection.this.gidToGjid(gid), subject);
                    if (onSuccess != null) {
                        onSuccess.run(Connection.this.gidToGjid(gid));
                    }
                }

                public void error(int code) {
                    if (onError != null) {
                        onError.run(code);
                    }
                }
            });
            ProtocolTreeNode groupNode = new ProtocolTreeNode("group", new KeyValue[]{new KeyValue("xmlns", "w:g"), new KeyValue("action", "create"), new KeyValue("subject", subject)});
            ProtocolTreeNode iqNode = new ProtocolTreeNode("iq", new KeyValue[]{new KeyValue("id", id2), new KeyValue("type", "set"), new KeyValue("to", "g.us")}, groupNode);
            this.out.write(iqNode);
        }

        public void sendEndGroupChat(String gjid) throws IOException {
            this.sendEndGroupChat(gjid, null, null);
        }

        public void sendEndGroupChat(String gjid, final Runnable onSuccess, final IntRunnable onError) throws IOException {
            String id2 = this.makeId("remove_group_");
            this.pending_server_requests.put(id2, new IqResultHandler(){

                public void parse(ProtocolTreeNode node, String from) throws CorruptStreamException, IOException {
                    if (onSuccess != null) {
                        onSuccess.run();
                    }
                }

                public void error(int code) {
                    if (onError != null) {
                        onError.run(code);
                    }
                }
            });
            ProtocolTreeNode groupNode = new ProtocolTreeNode("group", new KeyValue[]{new KeyValue("xmlns", "w:g"), new KeyValue("action", "delete")});
            ProtocolTreeNode iqNode = new ProtocolTreeNode("iq", new KeyValue[]{new KeyValue("id", id2), new KeyValue("type", "set"), new KeyValue("to", gjid)}, groupNode);
            this.out.write(iqNode);
        }

        public void sendGetGroupInfo(String gjid) throws IOException {
            String id2 = this.makeId("get_g_info_");
            this.pending_server_requests.put(id2, new IqResultHandler(){

                public void parse(ProtocolTreeNode node, String from) throws CorruptStreamException, IOException {
                    ProtocolTreeNode groupNode = node.getChild(0);
                    ProtocolTreeNode.require(groupNode, "group");
                    String gid = groupNode.getAttributeValue("id");
                    String owner = groupNode.getAttributeValue("owner");
                    String subject = groupNode.getAttributeValue("subject");
                    String subject_t = groupNode.getAttributeValue("s_t");
                    String subject_owner = groupNode.getAttributeValue("s_o");
                    String creation = groupNode.getAttributeValue("creation");
                    Connection.this.group_event_handler.onGroupInfo(from, owner, subject, subject_owner, Integer.parseInt(subject_t), Integer.parseInt(creation));
                }
            });
            ProtocolTreeNode queryNode = new ProtocolTreeNode("query", new KeyValue[]{new KeyValue("xmlns", "w:g")});
            ProtocolTreeNode iqNode = new ProtocolTreeNode("iq", new KeyValue[]{new KeyValue("id", id2), new KeyValue("type", "get"), new KeyValue("to", gjid)}, queryNode);
            this.out.write(iqNode);
        }

        public void sendGetOwningGroups() throws IOException {
            String id2 = this.makeId("get_owning_groups_");
            this.pending_server_requests.put(id2, new IqResultHandler(){

                public void parse(ProtocolTreeNode node, String from) throws CorruptStreamException, IOException {
                    Vector groups = new Vector();
                    Connection.this.readGroupList(node, groups);
                    Connection.this.group_event_handler.onOwningGroups(groups);
                }
            });
            this.sendGetGroups(id2, "owning");
        }

        public synchronized void sendGetGroups() throws IOException {
            this.sendGetGroups((Runnable)null, (IntRunnable)null);
        }

        public synchronized void sendGetGroups(final Runnable onSuccess, final IntRunnable onError) throws IOException {
            String id2 = this.makeId("get_groups_");
            this.pending_server_requests.put(id2, new IqResultHandler(){

                public void parse(ProtocolTreeNode node, String from) throws CorruptStreamException, IOException {
                    Vector groups = new Vector();
                    Connection.this.readGroupList(node, groups);
                    Connection.this.group_event_handler.onParticipatingGroups(groups);
                    if (onSuccess != null) {
                        onSuccess.run();
                    }
                }

                public void error(int code) {
                    if (onError != null) {
                        onError.run(code);
                    }
                }
            });
            this.sendGetGroups(id2, "participating");
        }

        private void sendGetGroups(String id2, String type) throws IOException {
            ProtocolTreeNode listNode = new ProtocolTreeNode("list", new KeyValue[]{new KeyValue("xmlns", "w:g"), new KeyValue("type", type)});
            ProtocolTreeNode iqNode = new ProtocolTreeNode("iq", new KeyValue[]{new KeyValue("id", id2), new KeyValue("type", "get"), new KeyValue("to", "g.us")}, listNode);
            this.out.write(iqNode);
        }

        public void sendSetGroupSubject(String gjid, String subject) throws IOException {
            this.sendSetGroupSubject(gjid, subject, null, null);
        }

        public void sendSetGroupSubject(String gjid, String subject, final Runnable onSuccess, final IntRunnable onError) throws IOException {
            String id2 = this.makeId("set_group_subject_");
            this.pending_server_requests.put(id2, new IqResultHandler(){

                public void parse(ProtocolTreeNode node, String from) throws CorruptStreamException, IOException {
                    Connection.this.group_event_handler.onSetSubject(from);
                    if (onSuccess != null) {
                        onSuccess.run();
                    }
                }

                public void error(int code) {
                    if (onError != null) {
                        onError.run(code);
                    }
                }
            });
            ProtocolTreeNode subjectNode = new ProtocolTreeNode("subject", new KeyValue[]{new KeyValue("xmlns", "w:g"), new KeyValue("value", subject)});
            ProtocolTreeNode iqNode = new ProtocolTreeNode("iq", new KeyValue[]{new KeyValue("id", id2), new KeyValue("type", "set"), new KeyValue("to", gjid)}, subjectNode);
            this.out.write(iqNode);
        }

        public void sendAddParticipants(String gjid, Vector participants) throws IOException {
            this.sendAddParticipants(gjid, participants, null, null);
        }

        public void sendAddParticipants(String gjid, Vector participants, final Runnable onSuccess, final IntRunnable onError) throws IOException {
            String id2 = this.makeId("add_group_participants_");
            this.pending_server_requests.put(id2, new IqResultHandler(){

                public void parse(ProtocolTreeNode node, String from) throws CorruptStreamException, IOException {
                    Vector successVector = new Vector();
                    Hashtable failTable = new Hashtable();
                    Connection.this.readSuccessAndFailure(node, successVector, failTable, "add");
                    Connection.this.group_event_handler.onAddGroupParticipants(from, successVector, failTable);
                    if (onSuccess != null) {
                        onSuccess.run();
                    }
                }

                public void error(int code) {
                    if (onError != null) {
                        onError.run(code);
                    }
                }
            });
            this.sendVerbParticipants(gjid, participants, id2, "add");
        }

        public void sendRemoveParticipants(String gjid, Vector participants) throws IOException {
            this.sendRemoveParticipants(gjid, participants, null, null);
        }

        public void sendRemoveParticipants(String gjid, Vector participants, final Runnable onSuccess, final IntRunnable onError) throws IOException {
            String id2 = this.makeId("remove_group_participants_");
            this.pending_server_requests.put(id2, new IqResultHandler(){

                public void parse(ProtocolTreeNode node, String from) throws CorruptStreamException, IOException {
                    Vector successVector = new Vector();
                    Hashtable failTable = new Hashtable();
                    Connection.this.readSuccessAndFailure(node, successVector, failTable, "remove");
                    Connection.this.group_event_handler.onRemoveGroupParticipants(from, successVector, failTable);
                    if (onSuccess != null) {
                        onSuccess.run();
                    }
                }

                public void error(int code) {
                    if (onError != null) {
                        onError.run(code);
                    }
                }
            });
            this.sendVerbParticipants(gjid, participants, id2, "remove");
        }

        public void sendLeaveGroup(String gjid) throws IOException {
            this.sendLeaveGroup(gjid, null, null);
        }

        public void sendLeaveGroup(String gjid, Runnable onSuccess, IntRunnable onError) throws IOException {
            Vector<String> gjids = new Vector<String>();
            gjids.addElement(gjid);
            this.sendLeaveGroups(gjids, onSuccess, onError);
        }

        public void sendLeaveGroups(Vector gjids, final Runnable onSuccess, final IntRunnable onError) throws IOException {
            String id2 = this.makeId("leave_group_");
            this.pending_server_requests.put(id2, new IqResultHandler(){

                public void parse(ProtocolTreeNode node, String from) {
                    ProtocolTreeNode leaveChild = node.getChild("leave");
                    if (leaveChild != null) {
                        Vector groups = leaveChild.getAllChildren("group");
                        for (int i = 0; i < groups.size(); ++i) {
                            Connection.this.group_event_handler.onLeaveGroup(((ProtocolTreeNode)groups.elementAt(i)).getAttributeValue("id"));
                        }
                    }
                    if (onSuccess != null) {
                        onSuccess.run();
                    }
                }

                public void error(int code) {
                    if (onError != null) {
                        onError.run(code);
                    }
                }
            });
            int size = gjids.size();
            ProtocolTreeNode[] groupJidList = new ProtocolTreeNode[size];
            for (int i = 0; i < size; ++i) {
                groupJidList[i] = new ProtocolTreeNode("group", new KeyValue[]{new KeyValue("id", (String)gjids.elementAt(i))});
            }
            ProtocolTreeNode leaveNode = new ProtocolTreeNode("leave", new KeyValue[]{new KeyValue("xmlns", "w:g")}, groupJidList);
            ProtocolTreeNode iqNode = new ProtocolTreeNode("iq", new KeyValue[]{new KeyValue("id", id2), new KeyValue("type", "set"), new KeyValue("to", "g.us")}, leaveNode);
            this.out.write(iqNode);
        }

        private void sendVerbParticipants(String gjid, Vector participants, String id2, String inner_tag) throws IOException {
            int size = participants.size();
            ProtocolTreeNode[] innerNodeChildren = new ProtocolTreeNode[size];
            for (int i = 0; i < size; ++i) {
                innerNodeChildren[i] = new ProtocolTreeNode("participant", new KeyValue[]{new KeyValue("jid", (String)participants.elementAt(i))});
            }
            ProtocolTreeNode innerNode = new ProtocolTreeNode(inner_tag, new KeyValue[]{new KeyValue("xmlns", "w:g")}, innerNodeChildren);
            ProtocolTreeNode iqNode = new ProtocolTreeNode("iq", new KeyValue[]{new KeyValue("id", id2), new KeyValue("type", "set"), new KeyValue("to", gjid)}, innerNode);
            this.out.write(iqNode);
        }

        public void sendGetParticipants(String gjid) throws IOException {
            String id2 = this.makeId("get_participants_");
            this.pending_server_requests.put(id2, new IqResultHandler(){

                public void parse(ProtocolTreeNode node, String from) throws IOException {
                    Vector participants = new Vector();
                    Connection.this.readAttributeList(node, participants, "participant", "jid");
                    Connection.this.group_event_handler.onGetParticipants(from, participants);
                }
            });
            ProtocolTreeNode listNode = new ProtocolTreeNode("list", new KeyValue[]{new KeyValue("xmlns", "w:g")});
            ProtocolTreeNode iqNode = new ProtocolTreeNode("iq", new KeyValue[]{new KeyValue("id", id2), new KeyValue("type", "get"), new KeyValue("to", gjid)}, listNode);
            this.out.write(iqNode);
        }

        public void sendAvailableForChat() throws IOException {
            ProtocolTreeNode presenceNode = new ProtocolTreeNode("presence", new KeyValue[]{new KeyValue("name", this.push_name)});
            this.out.write(presenceNode);
        }

        private String gidToGjid(String gid) {
            return gid + "@g.us";
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean read() throws IOException, CorruptStreamException {
            ProtocolTreeNode node;
            try {
                node = this.in.nextTree();
                this.lastTreeRead = System.currentTimeMillis();
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (CorruptStreamException cse) {
                throw cse;
            }
            catch (Throwable t) {
                throw new FunRuntimeException(t, this.in.lastStanza());
            }
            if (node == null) {
                return false;
            }
            if (ProtocolTreeNode.tagEquals(node, "iq")) {
                String type = node.getAttributeValue("type");
                String id2 = node.getAttributeValue("id");
                String from = Utilities.safeIntern(node.getAttributeValue("from"));
                if (type == null) {
                    throw new CorruptStreamException("missing 'type' attribute in iq stanza");
                }
                if (type.equals("result")) {
                    if (this.pending_server_requests.containsKey(id2)) {
                        IqResultHandler handler = (IqResultHandler)this.pending_server_requests.remove(id2);
                        handler.parse(node, from);
                        return true;
                    }
                    if (!id2.startsWith(this.user)) return true;
                    ProtocolTreeNode accountNode = node.getChild(0);
                    ProtocolTreeNode.require(accountNode, "account");
                    String kind = accountNode.getAttributeValue("kind");
                    this.account_kind = "paid".equals(kind) ? 1 : ("free".equals(kind) ? 0 : -1);
                    String expiration = accountNode.getAttributeValue("expiration");
                    if (expiration == null) {
                        throw new IOException("no expiration");
                    }
                    try {
                        this.expire_date = Long.parseLong(expiration);
                    }
                    catch (NumberFormatException xxx) {
                        throw new IOException("invalid expire date: " + expiration);
                    }
                    this.event_handler.onAccountChange(this.account_kind, this.expire_date);
                    return true;
                }
                if (type.equals("error")) {
                    if (!this.pending_server_requests.containsKey(id2)) return true;
                    IqResultHandler handler = (IqResultHandler)this.pending_server_requests.remove(id2);
                    handler.error(node);
                    return true;
                }
                if (type.equals("get")) {
                    ProtocolTreeNode childNode = node.getChild(0);
                    if (ProtocolTreeNode.tagEquals(childNode, "ping")) {
                        this.event_handler.onPing(id2);
                        return true;
                    }
                    if (ProtocolTreeNode.tagEquals(childNode, "query") && from != null) {
                        if (!"http://jabber.org/protocol/disco#info".equals(childNode.getAttributeValue("xmlns"))) return true;
                        return true;
                    }
                    if (!ProtocolTreeNode.tagEquals(childNode, "relay")) return true;
                    if (from == null) return true;
                    return true;
                } else {
                    if (!type.equals("set")) throw new CorruptStreamException("unknown iq type attribute: " + type);
                    ProtocolTreeNode childNode = node.getChild(0);
                    if (!ProtocolTreeNode.tagEquals(childNode, "query")) return true;
                    String xmlns = childNode.getAttributeValue("xmlns");
                    if (!"jabber:iq:roster".equals(xmlns)) return true;
                    Vector itemNodes = childNode.getAllChildren("item");
                    int i = 0;
                    while (i < itemNodes.size()) {
                        ProtocolTreeNode itemNode = (ProtocolTreeNode)itemNodes.elementAt(i);
                        String jid = itemNode.getAttributeValue("jid");
                        String subscription = itemNode.getAttributeValue("subscription");
                        String ask = itemNode.getAttributeValue("ask");
                        ++i;
                    }
                    return true;
                }
            }
            if (ProtocolTreeNode.tagEquals(node, "presence")) {
                String xmlns = node.getAttributeValue("xmlns");
                String from = Utilities.safeIntern(node.getAttributeValue("from"));
                if ((xmlns == null || "urn:xmpp".equals(xmlns)) && from != null) {
                    String type = node.getAttributeValue("type");
                    if ("unavailable".equals(type)) {
                        this.event_handler.onAvailable(from, false);
                        return true;
                    }
                    if (null != type) {
                        if (!"available".equals(type)) return true;
                    }
                    this.event_handler.onAvailable(from, true);
                    return true;
                }
                if (!"w".equals(xmlns)) return true;
                if (from == null) return true;
                String add = node.getAttributeValue("add");
                String remove = node.getAttributeValue("remove");
                String status = node.getAttributeValue("status");
                if (add != null) {
                    if (this.group_event_handler == null) return true;
                    this.group_event_handler.onGroupAddUser(from, add);
                    return true;
                }
                if (remove != null) {
                    if (this.group_event_handler == null) return true;
                    this.group_event_handler.onGroupRemoveUser(from, remove);
                    return true;
                }
                if (!"dirty".equals(status)) return true;
                Hashtable categories = this.parseCategories(node);
                this.event_handler.onDirty(categories);
                return true;
            }
            if (!ProtocolTreeNode.tagEquals(node, "message")) return true;
            this.parseMessageInitialTagAlreadyChecked(node);
            return true;
        }

        private void parseMessageInitialTagAlreadyChecked(ProtocolTreeNode messageNode) throws IOException, CorruptStreamException {
            String typeAttribute;
            FMessage.Builder builder = new FMessage.Builder();
            String id2 = messageNode.getAttributeValue("id");
            String attribute_t = messageNode.getAttributeValue("t");
            String from = Utilities.safeIntern(messageNode.getAttributeValue("from"));
            String author = messageNode.getAttributeValue("author");
            if (author == null) {
                author = "";
            }
            if ("error".equals(typeAttribute = messageNode.getAttributeValue("type"))) {
                int errorCode = 0;
                Vector errorNodes = messageNode.getAllChildren("error");
                for (int i = 0; i < errorNodes.size(); ++i) {
                    ProtocolTreeNode errorNode = (ProtocolTreeNode)errorNodes.elementAt(i);
                    String codeString = errorNode.getAttributeValue("code");
                    try {
                        errorCode = Integer.parseInt(codeString);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                FMessage fmsg = null;
                if (from != null && id2 != null) {
                    FMessage.Key key = new FMessage.Key(from, true, id2);
                    fmsg = (FMessage)message_store.get(key);
                }
                if (fmsg != null) {
                    fmsg.status = 7;
                    this.event_handler.onMessageError(fmsg, errorCode);
                }
            } else if ("subject".equals(typeAttribute)) {
                String newSubject;
                boolean receiptRequested = false;
                Vector requestNodes = messageNode.getAllChildren("request");
                for (int i = 0; i < requestNodes.size(); ++i) {
                    ProtocolTreeNode requestNode = (ProtocolTreeNode)requestNodes.elementAt(i);
                    if (!"urn:xmpp:receipts".equals(requestNode.getAttributeValue("xmlns"))) continue;
                    receiptRequested = true;
                }
                ProtocolTreeNode bodyNode = messageNode.getChild("body");
                String string = newSubject = bodyNode == null ? null : bodyNode.data;
                if (newSubject != null && this.group_event_handler != null) {
                    this.group_event_handler.onGroupNewSubject(from, author, newSubject, Integer.parseInt(attribute_t));
                }
                if (receiptRequested) {
                    this.sendSubjectReceived(from, id2);
                }
            } else if ("chat".equals(typeAttribute)) {
                FMessage message;
                boolean duplicate = false;
                boolean wantsReceipt = false;
                ProtocolTreeNode[] messageChildren = messageNode.children == null ? new ProtocolTreeNode[]{} : messageNode.children;
                for (int i = 0; i < messageChildren.length; ++i) {
                    FMessage.Key key;
                    FMessage.Key key2;
                    ProtocolTreeNode childNode = messageChildren[i];
                    if (ProtocolTreeNode.tagEquals(childNode, "composing")) {
                        if (this.event_handler == null) continue;
                        this.event_handler.onIsTyping(from, true);
                        continue;
                    }
                    if (ProtocolTreeNode.tagEquals(childNode, "paused")) {
                        if (this.event_handler == null) continue;
                        this.event_handler.onIsTyping(from, false);
                        continue;
                    }
                    if (ProtocolTreeNode.tagEquals(childNode, "body") && id2 != null) {
                        String message2 = childNode.data;
                        key2 = new FMessage.Key(from, false, id2);
                        FMessage ret = (FMessage)message_store.get(key2);
                        if (ret == null) {
                            builder.key(key2).remote_resource(author).newIncomingInstance().data(message2);
                            continue;
                        }
                        builder = new FMessage.Builder().setInstance(ret);
                        duplicate = true;
                        continue;
                    }
                    if (ProtocolTreeNode.tagEquals(childNode, "media") && id2 != null) {
                        String str;
                        builder.media_wa_type(FMessage.getMessage_WA_Type(childNode.getAttributeValue("type"))).media_url(childNode.getAttributeValue("url")).media_name(childNode.getAttributeValue("file"));
                        try {
                            builder.media_size(Long.parseLong(childNode.getAttributeValue("size")));
                        }
                        catch (NumberFormatException x) {
                            str = x.getMessage();
                            System.err.println(str == null ? "NumberFormatException" : str);
                        }
                        try {
                            String secondsText = childNode.getAttributeValue("seconds");
                            if (secondsText != null) {
                                builder.media_duration_seconds(Integer.parseInt(secondsText));
                            }
                        }
                        catch (NumberFormatException x) {
                            str = x.getMessage();
                            System.err.println(str == null ? "NumberFormatException" : str);
                        }
                        if (builder.media_wa_type() == 5) {
                            String latitudeString = childNode.getAttributeValue("latitude");
                            String longitudeString = childNode.getAttributeValue("longitude");
                            if (latitudeString == null || longitudeString == null) {
                                throw new CorruptStreamException("location message missing lat or long attribute");
                            }
                            try {
                                Double latitude = Double.valueOf(latitudeString);
                                Double longitude = Double.valueOf(longitudeString);
                                builder.latitude(latitude).longitude(longitude);
                            }
                            catch (NumberFormatException x) {
                                throw new CorruptStreamException("location message exception parsing lat or long attribute: " + latitudeString + " " + longitudeString);
                            }
                        }
                        if (builder.media_wa_type() == 4) {
                            ProtocolTreeNode contactChildNode = childNode.getChild(0);
                            if (contactChildNode != null) {
                                builder.media_name(contactChildNode.getAttributeValue("name")).data(contactChildNode.data);
                            }
                        } else {
                            builder.data(childNode.data);
                        }
                        key = new FMessage.Key(from, false, id2);
                        FMessage ret = (FMessage)message_store.get(key);
                        if (ret == null) {
                            builder.key(key).remote_resource(author).newIncomingInstance();
                            continue;
                        }
                        builder = new FMessage.Builder().setInstance(ret);
                        duplicate = true;
                        continue;
                    }
                    if (ProtocolTreeNode.tagEquals(childNode, "active")) continue;
                    if (ProtocolTreeNode.tagEquals(childNode, "request")) {
                        builder.wants_receipt(true);
                        continue;
                    }
                    if (ProtocolTreeNode.tagEquals(childNode, "notify")) continue;
                    if (ProtocolTreeNode.tagEquals(childNode, "x")) {
                        Date stamp;
                        String stamp_str;
                        String xmlns = childNode.getAttributeValue("xmlns");
                        if ("jabber:x:event".equals(xmlns) && id2 != null) {
                            key2 = new FMessage.Key(from, true, id2);
                            FMessage message3 = (FMessage)message_store.get(key2);
                            if (message3 == null) continue;
                            message3.status = 4;
                            if (this.event_handler == null) continue;
                            this.event_handler.onMessageStatusUpdate(message3);
                            continue;
                        }
                        if (!"jabber:x:delay".equals(xmlns) || (stamp_str = childNode.getAttributeValue("stamp")) == null || (stamp = this.date_parser.parse(stamp_str)) == null) continue;
                        builder.timestamp(stamp.getTime()).offline(Boolean.TRUE);
                        continue;
                    }
                    if (ProtocolTreeNode.tagEquals(childNode, "delay") || !ProtocolTreeNode.tagEquals(childNode, "received") || id2 == null) continue;
                    key = new FMessage.Key(from, true, id2);
                    FMessage message4 = (FMessage)message_store.get(key);
                    if (message4 != null) {
                        message4.status = 5;
                        if (this.event_handler != null) {
                            this.event_handler.onMessageStatusUpdate(message4);
                            message_store.remove(key);
                        }
                    }
                    if (!this.supports_receipt_acks) continue;
                    String receipt_type = childNode.getAttributeValue("type");
                    if (receipt_type == null || receipt_type.equals("delivered")) {
                        this.sendDeliveredReceiptAck(from, id2);
                        continue;
                    }
                    if (!receipt_type.equals("visible")) continue;
                    this.sendVisibleReceiptAck(from, id2);
                }
                if (builder.timestamp() == null) {
                    builder.timestamp(System.currentTimeMillis()).offline(Boolean.FALSE);
                }
                if ((message = builder.build()) != null && this.event_handler != null) {
                    this.event_handler.onMessageForMe(message, duplicate);
                }
            }
        }

        private Hashtable parseCategories(ProtocolTreeNode dirtyNode) throws CorruptStreamException, IOException {
            Hashtable<String, String> categories = new Hashtable<String, String>();
            if (dirtyNode.children != null) {
                for (int i = 0; i < dirtyNode.children.length; ++i) {
                    ProtocolTreeNode childNode = dirtyNode.children[i];
                    if (!ProtocolTreeNode.tagEquals(childNode, "category")) continue;
                    String categoryName = childNode.getAttributeValue("name");
                    String timestamp = childNode.getAttributeValue("timestamp");
                    categories.put(categoryName, timestamp);
                }
            }
            return categories;
        }

        private void readGroupList(ProtocolTreeNode node, Vector vector) throws IOException {
            Vector nodes = node.getAllChildren("group");
            for (int i = 0; i < nodes.size(); ++i) {
                ProtocolTreeNode groupNode = (ProtocolTreeNode)nodes.elementAt(i);
                String gid = groupNode.getAttributeValue("id");
                String gjid = this.gidToGjid(gid);
                String owner = Utilities.safeIntern(groupNode.getAttributeValue("owner"));
                String subject = groupNode.getAttributeValue("subject");
                String subject_t = groupNode.getAttributeValue("s_t");
                String subject_owner = Utilities.safeIntern(groupNode.getAttributeValue("s_o"));
                String creation = groupNode.getAttributeValue("creation");
                this.group_event_handler.onGroupInfoFromList(gjid, owner, subject, subject_owner, Integer.parseInt(subject_t), Integer.parseInt(creation));
                vector.addElement(gjid);
            }
        }

        private void readAttributeList(ProtocolTreeNode node, Vector vector, String tag, String attribute) throws IOException {
            Vector nodes = node.getAllChildren(tag);
            for (int i = 0; i < nodes.size(); ++i) {
                ProtocolTreeNode tagNode = (ProtocolTreeNode)nodes.elementAt(i);
                String value = Utilities.safeIntern(tagNode.getAttributeValue(attribute));
                vector.addElement(value);
            }
        }

        private void readSuccessAndFailure(ProtocolTreeNode node, Vector successVector, Hashtable failTable, String itemTag) throws IOException {
            Vector nodes = node.getAllChildren(itemTag);
            for (int i = 0; i < nodes.size(); ++i) {
                Integer code;
                ProtocolTreeNode tagNode = (ProtocolTreeNode)nodes.elementAt(i);
                String addtype = tagNode.getAttributeValue("type");
                String participant = tagNode.getAttributeValue("participant");
                String codeString = tagNode.getAttributeValue("code");
                if ("success".equals(addtype)) {
                    successVector.addElement(participant);
                    continue;
                }
                try {
                    code = Integer.valueOf(codeString);
                }
                catch (Exception e) {
                    code = new Integer(499);
                }
                failTable.put(participant, code);
            }
        }
    }

    public static class FMessage {
        public static final byte WA_TYPE_UNDEFINED = 0;
        public static final byte WA_TYPE_IMAGE = 1;
        public static final byte WA_TYPE_AUDIO = 2;
        public static final byte WA_TYPE_VIDEO = 3;
        public static final byte WA_TYPE_CONTACT = 4;
        public static final byte WA_TYPE_LOCATION = 5;
        public static final byte WA_TYPE_SYSTEM = 7;
        public static final int STATUS_UNSENT = 0;
        public static final int STATUS_UPLOADING = 1;
        public static final int STATUS_UPLOADED = 2;
        public static final int STATUS_SENT_BY_CLIENT = 3;
        public static final int STATUS_RECEIVED_BY_SERVER = 4;
        public static final int STATUS_RECEIVED_BY_TARGET = 5;
        public static final int STATUS_NEVER_SEND = 6;
        public static final int STATUS_SERVER_BOUNCE = 7;
        public int status;
        public Key key;
        public String remote_resource;
        public final boolean needs_push;
        public boolean wants_receipt = false;
        public String data;
        public long timestamp;
        public String media_url;
        public String media_mime_type;
        public byte media_wa_type;
        public long media_size;
        public int media_duration_seconds;
        public String media_name;
        public double latitude;
        public double longitude;
        public Object thumb_image;
        public boolean gap_behind = true;
        public boolean offline;
        static String generating_header = System.currentTimeMillis() / 1000L + "-";
        static int generating_id = 0;
        static Object generating_lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FMessage(String remote_jid, boolean from_me) {
            this.needs_push = false;
            Object object = generating_lock;
            synchronized (object) {
                Key localKey;
                while (message_store.get(localKey = new Key(remote_jid, from_me, generating_header + Integer.toString(++generating_id))) != null) {
                }
                message_store.put(localKey, this);
                this.key = localKey;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FMessage(Key key) {
            this.needs_push = false;
            this.key = key;
            Object object = generating_lock;
            synchronized (object) {
                message_store.put(key, this);
            }
        }

        public FMessage(String remote_jid, String data, Object image) {
            this(remote_jid, true);
            this.data = data;
            this.thumb_image = image;
            this.timestamp = System.currentTimeMillis();
        }

        public void acceptVisitor(FMessageVisitor visitor) {
            switch (this.media_wa_type) {
                default: {
                    visitor.undefined(this);
                    break;
                }
                case 1: {
                    visitor.image(this);
                    break;
                }
                case 2: {
                    visitor.audio(this);
                    break;
                }
                case 3: {
                    visitor.video(this);
                    break;
                }
                case 4: {
                    visitor.contact(this);
                    break;
                }
                case 5: {
                    visitor.location(this);
                    break;
                }
                case 7: {
                    visitor.system(this);
                }
            }
        }

        public static byte getMessage_WA_Type(String type) {
            if (type == null || type.length() == 0) {
                return 0;
            }
            if (type.equalsIgnoreCase("system")) {
                return 7;
            }
            if (type.equalsIgnoreCase("image")) {
                return 1;
            }
            if (type.equalsIgnoreCase("audio")) {
                return 2;
            }
            if (type.equalsIgnoreCase("video")) {
                return 3;
            }
            if (type.equalsIgnoreCase("vcard")) {
                return 4;
            }
            if (type.equalsIgnoreCase("location")) {
                return 5;
            }
            return 0;
        }

        public static String getMessage_WA_Type_StrValue(byte type) {
            if (type == 0) {
                return null;
            }
            if (type == 7) {
                return "system";
            }
            if (type == 1) {
                return "image";
            }
            if (type == 2) {
                return "audio";
            }
            if (type == 3) {
                return "video";
            }
            if (type == 4) {
                return "vcard";
            }
            if (type == 5) {
                return "location";
            }
            return null;
        }

        public static class Key {
            public final String remote_jid;
            public final boolean from_me;
            public final String id;

            public Key(String remote_jid, boolean from_me, String id2) {
                this.remote_jid = remote_jid;
                this.from_me = from_me;
                this.id = id2;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.from_me ? 1231 : 1237);
                result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
                result = 31 * result + (this.remote_jid == null ? 0 : this.remote_jid.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Key other = (Key)obj;
                if (this.from_me != other.from_me) {
                    return false;
                }
                if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                    return false;
                }
                return !(this.remote_jid == null ? other.remote_jid != null : !this.remote_jid.equals(other.remote_jid));
            }

            static boolean exists(Key key) {
                return message_store.get(key) != null;
            }

            public String toString() {
                return "Key[id=" + this.id + ", from_me=" + this.from_me + ", remote_jid=" + this.remote_jid + "]";
            }
        }

        public static class Builder {
            private FMessage message;
            private String remote_jid;
            private String remote_resource;
            private Boolean from_me;
            private String id;
            private Boolean wants_receipt;
            private String data;
            private String thumb_image;
            private Long timestamp;
            private Boolean offline;
            private Byte media_wa_type;
            private Long media_size;
            private Integer media_duration_seconds;
            private String media_url;
            private String media_name;
            private Double latitude;
            private Double longitude;

            public Builder key(Key key) {
                this.remote_jid = key.remote_jid;
                this.from_me = key.from_me ? Boolean.TRUE : Boolean.FALSE;
                this.id = key.id;
                return this;
            }

            public Key key() {
                return new Key(this.remote_jid, this.from_me, this.id);
            }

            public Builder remote_jid(String remote_jid) {
                this.remote_jid = remote_jid;
                return this;
            }

            public String remote_jid() {
                return this.remote_jid;
            }

            public Builder remote_resource(String remote_resource) {
                this.remote_resource = remote_resource;
                return this;
            }

            public String remote_resource() {
                return this.remote_resource;
            }

            public Builder from_me(boolean from_me) {
                this.from_me = from_me ? Boolean.TRUE : Boolean.FALSE;
                return this;
            }

            public Boolean from_me() {
                return this.from_me;
            }

            public Builder id(String id2) {
                this.id = id2;
                return this;
            }

            public String id() {
                return this.id;
            }

            public Builder wants_receipt(boolean wants_receipt) {
                this.wants_receipt = wants_receipt ? Boolean.TRUE : Boolean.FALSE;
                return this;
            }

            public Boolean wants_receipt() {
                return this.wants_receipt;
            }

            public Builder data(String data) {
                this.data = data;
                return this;
            }

            public String data() {
                return this.data;
            }

            public Builder thumb_image(String thumb_image) {
                this.thumb_image = thumb_image;
                return this;
            }

            public String thumb_image() {
                return this.thumb_image;
            }

            public Builder offline(Boolean offline) {
                this.offline = offline;
                return this;
            }

            public Boolean offline() {
                return this.offline;
            }

            public Builder timestamp(long timestamp) {
                this.timestamp = new Long(timestamp);
                return this;
            }

            public Long timestamp() {
                return this.timestamp;
            }

            public Builder media_wa_type(byte media_wa_type) {
                this.media_wa_type = new Byte(media_wa_type);
                return this;
            }

            public Byte media_wa_type() {
                return this.media_wa_type;
            }

            public Builder media_size(long media_size) {
                this.media_size = new Long(media_size);
                return this;
            }

            public Long media_size() {
                return this.media_size;
            }

            public Builder media_duration_seconds(int media_duration_seconds) {
                this.media_duration_seconds = new Integer(media_duration_seconds);
                return this;
            }

            public Integer media_duration_seconds() {
                return this.media_duration_seconds;
            }

            public Builder media_url(String media_url) {
                this.media_url = media_url;
                return this;
            }

            public String media_url() {
                return this.media_url;
            }

            public Builder media_name(String media_name) {
                this.media_name = media_name;
                return this;
            }

            public String media_name() {
                return this.media_name;
            }

            public Builder latitude(Double latitude) {
                this.latitude = latitude;
                return this;
            }

            public Double latitude() {
                return this.latitude;
            }

            public Builder longitude(Double longitude) {
                this.longitude = longitude;
                return this;
            }

            public Double longitude() {
                return this.longitude;
            }

            public Builder setInstance(FMessage message) {
                this.message = message;
                return this;
            }

            public Builder newIncomingInstance() throws UnsupportedOperationException {
                if (this.remote_jid == null || this.from_me == null || this.id == null) {
                    throw new UnsupportedOperationException("missing required property before instantiating new incoming message");
                }
                this.message = new FMessage(new Key(this.remote_jid, this.from_me, this.id));
                return this;
            }

            public Builder newOutgoingInstance() {
                if (this.remote_jid == null || this.data == null || this.thumb_image == null) {
                    throw new UnsupportedOperationException("missing required property before instantiating new outgoing message");
                }
                if (this.id != null || this.from_me != null && !this.from_me.booleanValue()) {
                    throw new UnsupportedOperationException("invalid property set before instantiating new outgoing message");
                }
                this.message = new FMessage(this.remote_jid, this.data, this.thumb_image);
                return this;
            }

            public boolean instantiated() {
                return this.message != null;
            }

            public FMessage build() {
                if (this.message == null) {
                    return null;
                }
                if (this.remote_jid != null && this.from_me != null && this.id != null) {
                    this.message.key = new Key(this.remote_jid, this.from_me, this.id);
                }
                if (this.remote_resource != null) {
                    this.message.remote_resource = this.remote_resource;
                }
                if (this.wants_receipt != null) {
                    this.message.wants_receipt = this.wants_receipt;
                }
                if (this.data != null) {
                    this.message.data = this.data;
                }
                if (this.thumb_image != null) {
                    this.message.thumb_image = this.thumb_image;
                }
                if (this.timestamp != null) {
                    this.message.timestamp = this.timestamp;
                }
                if (this.offline != null) {
                    this.message.offline = this.offline;
                }
                if (this.media_wa_type != null) {
                    this.message.media_wa_type = this.media_wa_type;
                }
                if (this.media_size != null) {
                    this.message.media_size = this.media_size;
                }
                if (this.media_duration_seconds != null) {
                    this.message.media_duration_seconds = this.media_duration_seconds;
                }
                if (this.media_url != null) {
                    this.message.media_url = this.media_url;
                }
                if (this.media_name != null) {
                    this.message.media_name = this.media_name;
                }
                if (this.latitude != null) {
                    this.message.latitude = this.latitude;
                }
                if (this.longitude != null) {
                    this.message.longitude = this.longitude;
                }
                return this.message;
            }
        }
    }

    public static class FunRuntimeException
    extends RuntimeException {
        String bufString;
        Throwable t;

        public FunRuntimeException(Throwable t, String buf) {
            this.bufString = buf;
            this.t = t;
        }

        public String getMessage() {
            return "Wrapping: " + this.t.getClass().getName() + "\nFunRuntimeException last stanza: " + this.bufString;
        }

        public Throwable getInner() {
            return this.t;
        }
    }

    public static class CorruptStreamException
    extends Exception {
        public CorruptStreamException() {
        }

        public CorruptStreamException(String s) {
            super(s);
        }
    }

    public static class LoginFailureException
    extends Exception {
        public static final int TYPE_PASSWORD = 0;
        public static final int TYPE_EXPIRED = 1;
        public int type;
        public long expire_date;

        public LoginFailureException(int type) {
            this.type = type;
        }
    }

    public static interface FMessageVisitor {
        public void undefined(FMessage var1);

        public void image(FMessage var1);

        public void audio(FMessage var1);

        public void video(FMessage var1);

        public void contact(FMessage var1);

        public void location(FMessage var1);

        public void system(FMessage var1);
    }

    public static abstract class IqResultHandler {
        public abstract void parse(ProtocolTreeNode var1, String var2) throws IOException, CorruptStreamException;

        public void error(int code) {
        }

        public void error(ProtocolTreeNode node) throws IOException, CorruptStreamException {
            Vector nodes = node.getAllChildren("error");
            for (int i = 0; i < nodes.size(); ++i) {
                String errorCodeString;
                ProtocolTreeNode errorNode = (ProtocolTreeNode)nodes.elementAt(i);
                if (errorNode == null || (errorCodeString = errorNode.getAttributeValue("code")) == null) continue;
                int errorCode = Integer.parseInt(errorCodeString);
                this.error(errorCode);
            }
        }
    }

    public static interface StringRunnable {
        public void run(String var1);
    }

    public static interface IntRunnable {
        public void run(int var1);
    }

    public static interface GroupListener {
        public void onGroupAddUser(String var1, String var2);

        public void onGroupRemoveUser(String var1, String var2);

        public void onGroupNewSubject(String var1, String var2, String var3, int var4);

        public void onServerProperties(int var1, Hashtable var2);

        public void onGroupCreated(String var1, String var2);

        public void onGroupInfo(String var1, String var2, String var3, String var4, int var5, int var6);

        public void onGroupInfoFromList(String var1, String var2, String var3, String var4, int var5, int var6);

        public void onOwningGroups(Vector var1);

        public void onSetSubject(String var1);

        public void onAddGroupParticipants(String var1, Vector var2, Hashtable var3);

        public void onRemoveGroupParticipants(String var1, Vector var2, Hashtable var3);

        public void onGetParticipants(String var1, Vector var2);

        public void onParticipatingGroups(Vector var1);

        public void onLeaveGroup(String var1);
    }

    public static interface Listener {
        public void onMessageForMe(FMessage var1, boolean var2) throws IOException;

        public void onMessageStatusUpdate(FMessage var1);

        public void onMessageError(FMessage var1, int var2);

        public void onPing(String var1) throws IOException;

        public void onPingResponseReceived();

        public void onAvailable(String var1, boolean var2);

        public void onClientConfigReceived(String var1);

        public void onLastSeen(String var1, int var2, String var3);

        public void onIsTyping(String var1, boolean var2);

        public void onAccountChange(int var1, long var2);

        public void onPrivacyBlockListAdd(String var1);

        public void onPrivacyBlockListClear();

        public void onDirty(Hashtable var1);

        public void onDirtyResponse(Hashtable var1);
    }

    public static interface DateParser {
        public Date parse(String var1);
    }
}

