/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.Constants;
import com.whatsapp.client.FunXMPP;
import java.util.Enumeration;
import java.util.Hashtable;

public class FunStore {
    private static final int MAX_CAPACITY = 150;
    private static final long GARBAGE_COLLECTABLE_AGE = 900000L;
    private Hashtable _keys = new Hashtable();

    public Object get(FunXMPP.FMessage.Key key) {
        if (this._keys.get(key) != null) {
            return new FunXMPP.FMessage(key);
        }
        return null;
    }

    public void remove(FunXMPP.FMessage.Key key) {
        this._keys.remove(key);
    }

    public void put(FunXMPP.FMessage.Key key, FunXMPP.FMessage fmsg) {
        this._keys.put(key, new Long(System.currentTimeMillis()));
        if (this._keys.size() > 150) {
            this.gc();
        }
    }

    private void gc() {
        int initSize = this._keys.size();
        Enumeration en = this._keys.keys();
        long now = System.currentTimeMillis();
        int pelts = 0;
        FunXMPP.FMessage.Key curOldest = null;
        long curOldestTime = Long.MAX_VALUE;
        while (en.hasMoreElements()) {
            FunXMPP.FMessage.Key curKey = (FunXMPP.FMessage.Key)en.nextElement();
            if (curKey.from_me) continue;
            Long putTime = (Long)this._keys.get(curKey);
            if (putTime != null && now - putTime > 900000L) {
                this._keys.remove(curKey);
                ++pelts;
                continue;
            }
            if (pelts != 0 || curOldestTime <= putTime) continue;
            curOldest = curKey;
            curOldestTime = putTime;
        }
        if (pelts == 0 && curOldest != null) {
            this._keys.remove(curOldest);
        }
        Utilities.logData("garbage collected FunStore. size delta " + initSize + Constants.STRING_ARROW + this._keys.size());
    }
}

