/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.nokia.mid.s40.io.LocalMessageProtocolConnection;
import com.whatsapp.api.contacts.ContactFileSystemStore;
import com.whatsapp.api.contacts.ContactInfoDetails;
import com.whatsapp.api.contacts.ContactStatusPIMKey;
import com.whatsapp.api.contacts.Favorites;
import com.whatsapp.api.ui.DialogAlert;
import com.whatsapp.api.util.DateTimeUtilities;
import com.whatsapp.api.util.LocalMessageClient;
import com.whatsapp.api.util.LocalMessageListener;
import com.whatsapp.api.util.SMSSender;
import com.whatsapp.api.util.SafeThread;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.ApplicationData;
import com.whatsapp.client.BGApp;
import com.whatsapp.client.ChatHistory;
import com.whatsapp.client.ChatHistoryCache;
import com.whatsapp.client.ChatPane;
import com.whatsapp.client.ChatState;
import com.whatsapp.client.Constants;
import com.whatsapp.client.ContactListPane;
import com.whatsapp.client.ContactSupport;
import com.whatsapp.client.CountryPhoneInfo;
import com.whatsapp.client.FileUICallback;
import com.whatsapp.client.FunXMPP;
import com.whatsapp.client.InitForm;
import com.whatsapp.client.MessageStore;
import com.whatsapp.client.MessageStoreProvider;
import com.whatsapp.client.PhoneRegBase;
import com.whatsapp.client.Res;
import com.whatsapp.client.Serializer;
import com.whatsapp.client.Settings;
import com.whatsapp.client.StatusForm;
import com.whatsapp.client.test.ContactListMidlet;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Gauge;
import javax.microedition.rms.RecordStoreException;

public class FGApp
implements LocalMessageListener,
ContactInfoDetails.PIMCacher.Listener {
    private static FGApp _instance = null;
    private boolean _initialized = false;
    private MessageStore _mStore = null;
    private ChatHistoryCache _chatHistoryCache;
    private Favorites _favs;
    private LocalMessageProtocolConnection _lmConnection;
    public LocalMessageClient _lmClient;
    private Object _topPane;
    private ContactListPane _mainScreen = null;
    private int _curMMSState = 0;
    private String _launchJid = null;
    private Hashtable _statusHash = new Hashtable();
    private Hashtable _phoneHash = new Hashtable();
    private final Hashtable _readableNameHash = new Hashtable();
    public final Vector _pimCache = new Vector();
    private int _pimSize = -1;
    public String _myPlainJid;
    private boolean _notificationInFlight = false;
    private boolean _chatsAlreadySent = false;
    private FileUICallback _pickerCallback;
    private int _curXferProgress = 0;
    private int _curSyncState = 0;
    private int _curSyncProgress = 0;
    private Runnable contactSupportErrorCallback = null;

    public static synchronized FGApp getInstance() {
        if (_instance == null) {
            _instance = new FGApp();
        }
        return _instance;
    }

    public synchronized void initialize(final String launchJid) {
        if (this._initialized) {
            return;
        }
        this._launchJid = launchJid;
        long topTime = System.currentTimeMillis();
        try {
            Res.load("strings");
            Res.load("common");
        }
        catch (IOException ex) {
            throw new RuntimeException("res/load/io-error: " + ex.toString());
        }
        this._mStore = MessageStoreProvider.getMessageStore();
        this._chatHistoryCache = new ChatHistoryCache();
        Utilities.logData("created empty chat history cache");
        this.createLMClient();
        Utilities.logData("created local message client");
        Settings.addListener(new Settings.Listener(){

            public void onSettingChanged(int setting, boolean localOrigin) {
                if (!localOrigin) {
                    return;
                }
                try {
                    if (Settings.isSet(setting)) {
                        byte[] data = Settings.sendCacheUpdate(setting);
                        FGApp.this.sendToBG(data, (byte)18);
                    } else {
                        byte[] data = Settings.sendCacheRemove(setting);
                        FGApp.this.sendToBG(data, (byte)19);
                    }
                }
                catch (RecordStoreException recordStoreException) {
                    // empty catch block
                }
            }
        });
        this._favs = new Favorites();
        Thread t = new Thread(){

            public void run() {
                long favSleep = launchJid != null ? (launchJid.equals(Constants.ARG_NEW_CHAT_JID) ? 0L : 2500L) : 750L;
                try {
                    Thread.sleep(favSleep);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                FGApp.this._favs.initialize();
                if (FGApp.this._mainScreen != null && FGApp.this._mainScreen == FGApp.this._topPane) {
                    FGApp.this._mainScreen.tabNeedsRefresh(((FGApp)FGApp.this)._mainScreen._favsTab, false);
                }
            }
        };
        t.start();
        this._pickerCallback = new FileUICallback();
        this._pickerCallback.initialize();
        this._initialized = true;
        long bottomTime = System.currentTimeMillis();
        Utilities.logData("FGApp gross init time: " + (bottomTime - topTime));
    }

    public MessageStore getMessageStore() {
        return this._mStore;
    }

    public ChatHistoryCache getChatHistoryCache() {
        return this._chatHistoryCache;
    }

    public Favorites getFavs() {
        return this._favs;
    }

    public void setMainScreen(ContactListPane f) {
        this._mainScreen = f;
        if (this._chatsAlreadySent) {
            this._mainScreen.initialChatsLoadComplete();
        }
    }

    public ContactListPane getMainScreen() {
        return this._mainScreen;
    }

    public void setTopPane(Object o) {
        this._topPane = o;
    }

    public Object getTopPane() {
        return this._topPane;
    }

    public String getLaunchJid() {
        return this._launchJid;
    }

    public int getMMSState() {
        return this._curMMSState;
    }

    public void setMMSState(int newState) {
        this._curMMSState = newState;
    }

    public void setMyJid() {
        this._myPlainJid = ApplicationData.chatUserID() + "@" + "s.whatsapp.net";
    }

    public FileUICallback getPickerCallback() {
        return this._pickerCallback;
    }

    public int getXferProgress() {
        return this._curXferProgress;
    }

    public int getSyncState() {
        return this._curSyncState;
    }

    public synchronized void setSyncState(int newstate) {
        if (newstate != this._curSyncState) {
            this._curSyncProgress = 0;
            this._curSyncState = newstate;
            if (this._mainScreen != null) {
                this._mainScreen.tabNeedsRefresh(this._mainScreen._favsTab, true);
            }
        }
    }

    public int getSyncProgress() {
        return this._curSyncProgress;
    }

    public void requestContactChatState(String jid) {
        try {
            byte[] data = Serializer.serialize(jid);
            this.sendToBG(data, (byte)6);
        }
        catch (Throwable t) {
            Utilities.logData("problem requesting chat state from client: " + jid);
        }
    }

    public void sendNewMessage(FunXMPP.FMessage fmsg) {
        this._chatHistoryCache.newMessage(fmsg);
        try {
            byte[] data = Serializer.serialize(fmsg.key);
            this.sendToBG(data, (byte)1);
        }
        catch (Throwable t) {
            Utilities.logData("problem sending new msg from FGApp: " + fmsg.key.toString());
        }
    }

    public void sendNewMMSMessage(FunXMPP.FMessage fmsg, String filePath, String contentType) {
        this._chatHistoryCache.newMessage(fmsg);
        BGApp.MMSUploadInfo info = new BGApp.MMSUploadInfo();
        info.key = fmsg.key;
        info.fullPath = filePath;
        info.contentType = contentType;
        info.cryptoName = fmsg.media_name;
        try {
            byte[] data = Serializer.serialize(info);
            this.sendToBG(data, (byte)56);
        }
        catch (Throwable t) {
            Utilities.logData("problem sending new msg from FGApp: " + fmsg.key.toString());
        }
    }

    public void paneReadMessage(FunXMPP.FMessage fmessage) {
        fmessage.status &= 0xFFFFFF7F;
        final FunXMPP.FMessage fmsg = fmessage;
        Thread t = new Thread(){

            public void run() {
                FGApp.this._chatHistoryCache.messageReceipt(fmsg.key, fmsg.status);
                try {
                    BGApp.FmsgKeyStatus payload = new BGApp.FmsgKeyStatus(fmsg.key, fmsg.status);
                    byte[] data = Serializer.serialize(payload);
                    FGApp.this.sendToBG(data, (byte)5);
                }
                catch (Exception x) {
                    Utilities.logData("fail trying to serialize after status update: " + x.toString());
                }
            }
        };
        t.start();
    }

    public void sendCancelXfer() {
        Utilities.logData("user cancelled xfer");
        this._curMMSState = 2;
        this.sendZeroDataAlertToBG((byte)52);
    }

    public void sendZeroDataAlertToBG(byte alertCode) {
        byte[] data = new byte[]{0};
        this.sendToBG(data, alertCode);
    }

    public void refreshContacts() {
        if (this.getSyncState() != 0) {
            Alert alert = new Alert(Constants.STRING_EMPTY_STRING, Res.getString(133), null, AlertType.ERROR);
            ContactListMidlet.getInstance()._display.setCurrent(alert, (Displayable)this.getMainScreen());
            return;
        }
        Thread t = new Thread(){

            public void run() {
                long sTime = System.currentTimeMillis();
                FGApp.this.setSyncState(1);
                ContactInfoDetails.PIMCacher pimCacher = new ContactInfoDetails.PIMCacher(FGApp.this);
                boolean res = pimCacher.cacheAllPIMEntries();
                long fTime = System.currentTimeMillis();
                Utilities.logData("caching all PIMs in FG app took " + (fTime - sTime) + " to return " + res);
                if (res) {
                    FGApp.this.setSyncState(2);
                    FGApp.this.sendZeroDataAlertToBG((byte)14);
                } else {
                    FGApp.this.setSyncState(0);
                    String errorText = pimCacher.getErrorCode() == 1 ? Res.getString(139) : pimCacher.getErrorText();
                    Alert alert = new Alert(Res.getString(132), errorText, null, AlertType.ERROR);
                    FGApp.this.setTopPane(FGApp.this.getMainScreen());
                    ContactListMidlet.getInstance()._display.setCurrent(alert, (Displayable)FGApp.this.getMainScreen());
                }
            }
        };
        t.start();
    }

    private void preloadNames() {
        Thread t = new Thread(){

            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception x) {
                    // empty catch block
                }
                if (FGApp.this._favs != null) {
                    Vector v = FGApp.this._favs.getList();
                    int s = v.size();
                    for (int i = 0; i < s; ++i) {
                        String curJid = (String)v.elementAt(i);
                        String n = FGApp.this.getDisplayableNameFromJid(curJid);
                    }
                }
            }
        };
        t.start();
    }

    public ContactInfoDetails getDetailsFromJid(String jid) throws IOException {
        ContactStatusPIMKey cspk = this.getStatusPIMKeyFromJid(jid);
        if (cspk == null || cspk._pimKey == null) {
            return null;
        }
        ContactInfoDetails cid = (ContactInfoDetails)ContactInfoDetails.db.get(cspk._pimKey._index, this._pimCache);
        if (cid != null) {
            String phone = cid._phones[cspk._pimKey._phoneIndex];
            this._phoneHash.put(phone, jid);
        }
        return cid;
    }

    public String getDisplayableNameFromJid(String jid) {
        String res;
        if (jid == null) {
            return Constants.STRING_EMPTY_STRING;
        }
        ChatHistory curHist = this._chatHistoryCache.get(jid);
        if (curHist != null) {
            if (curHist._group != null) {
                return curHist._group._subject;
            }
            if (curHist._readableName != null) {
                return curHist._readableName;
            }
        }
        if ((res = (String)this._readableNameHash.get(jid)) == null) {
            res = ContactFileSystemStore.getByJid(jid);
            if (res == null) {
                res = ChatHistory.getDisplayablePlainJid(jid);
            }
            this._readableNameHash.put(jid, res);
        }
        return res;
    }

    public String getStatusFromJid(String jid) {
        ContactStatusPIMKey cspk = this.getStatusPIMKeyFromJid(jid);
        if (cspk == null) {
            return null;
        }
        return cspk._status;
    }

    public ContactStatusPIMKey getStatusPIMKeyFromJid(String jid) {
        if (jid == null) {
            return null;
        }
        ContactStatusPIMKey res = (ContactStatusPIMKey)this._statusHash.get(jid);
        if (res == null) {
            res = ContactFileSystemStore.getStatusPIMKeyByJid(jid);
            if (res == null) {
                Utilities.logData("fs struck out for status of " + jid);
                res = new ContactStatusPIMKey(null, -1, null);
            } else {
                Utilities.logData("disk hit found status " + res._status + " for " + jid);
            }
            this._statusHash.put(jid, res);
        }
        return res;
    }

    public String getJidFromPhone(String phone) {
        String res = (String)this._phoneHash.get(phone);
        if (res == null) {
            res = ContactFileSystemStore.getByPhone(phone);
            if (res == null) {
                res = Constants.STRING_EMPTY_STRING;
            }
            this._phoneHash.put(phone, res);
        }
        if (res == Constants.STRING_EMPTY_STRING) {
            res = null;
        }
        return res;
    }

    public int getPIMSize() throws IOException {
        if (this._pimSize == -1) {
            this._pimSize = ContactInfoDetails.db.exists() ? ContactInfoDetails.db.size() : 0;
        }
        return this._pimSize;
    }

    public synchronized void requestNotificationState(boolean value) {
        if (value) {
            this.sendToBG(new byte[]{1}, (byte)25);
            this._notificationInFlight = true;
        } else if (this._notificationInFlight) {
            this.sendToBG(new byte[]{0}, (byte)25);
            this._notificationInFlight = false;
        }
    }

    private void notifyOnMessage(FunXMPP.FMessage newMsg) {
        if ((newMsg.status & 0xF) == 6) {
            return;
        }
        Object curPane = this._topPane;
        if (curPane != null && curPane instanceof ChatPane) {
            ChatPane curTop = (ChatPane)curPane;
            if (!curTop._hidden) {
                return;
            }
        }
        this.requestNotificationState(true);
    }

    public void inviteContactByPhone(String phoneInput) {
        final ContactListMidlet mid = ContactListMidlet.getInstance();
        final Displayable currentScr = mid._display.getCurrent();
        if (phoneInput.length() > 0 && phoneInput.charAt(0) == '+') {
            phoneInput = phoneInput.substring(1);
        }
        String ccNumber = null;
        try {
            CountryPhoneInfo.Country country = CountryPhoneInfo.parseCCNumber('+' + phoneInput);
            String ccString = Integer.toString(country.cc);
            String number = phoneInput.substring(ccString.length());
            if (country.checkNumberLength(number)) {
                ccNumber = '+' + ccString + country.trimForSMS(number);
            }
        }
        catch (IOException ex) {
            Utilities.logData("invite/parse-cc/io-error: " + ex);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        if (ccNumber == null) {
            try {
                String ccString = Integer.toString(Settings.getInt(3));
                String number = phoneInput;
                CountryPhoneInfo.Country country = CountryPhoneInfo.parseCCNumber('+' + ccString + number);
                if (country.checkNumberLength(number)) {
                    ccNumber = '+' + ccString + country.trimForSMS(number);
                }
            }
            catch (RecordStoreException ex) {
                Utilities.logData("invite/rms-error: " + (Object)((Object)ex));
            }
            catch (IOException ex) {
                Utilities.logData("invite/parse-cc/io-error: " + ex);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (ccNumber == null) {
            Alert invalidNumberAlert = new Alert(null, Res.getString(193), null, AlertType.INFO);
            mid._display.setCurrent(invalidNumberAlert, currentScr);
            return;
        }
        final Alert sendingAlert = new Alert(null, Res.getString(196, ccNumber), null, AlertType.INFO);
        sendingAlert.addCommand(new Command(Res.getString(63), 6, 0));
        sendingAlert.setIndicator(new Gauge(null, false, -1, 2));
        SMSSender.Listener senderListener = new SMSSender.Listener(){

            public void onSMSSent() {
                Alert sentAlert = new Alert(null, Res.getString(197), null, AlertType.INFO);
                mid._display.setCurrent(sentAlert, currentScr);
            }

            public void onSMSSendError() {
                Alert errorAlert = new Alert(null, Res.getString(198), null, AlertType.WARNING);
                mid._display.setCurrent(errorAlert, currentScr);
            }
        };
        final SMSSender sender = new SMSSender(ccNumber, Res.getString(194), 0, 0, senderListener);
        sendingAlert.setCommandListener(new CommandListener(){

            public void commandAction(Command cmd, Displayable d) {
                sender.stop();
                mid._display.setCurrent(currentScr);
            }
        });
        Alert confirmAlert = new Alert(null, Res.getString(195, ccNumber), null, AlertType.CONFIRMATION);
        confirmAlert.addCommand(new Command(Res.getString(181), 4, 0));
        confirmAlert.addCommand(new Command(Res.getString(107), 3, 0));
        confirmAlert.setCommandListener(new CommandListener(){

            public void commandAction(Command cmd, Displayable d) {
                if (cmd.getCommandType() == 4) {
                    mid._display.setCurrent(sendingAlert, currentScr);
                    sender.start();
                } else {
                    mid._display.setCurrent(currentScr);
                }
            }
        });
        mid._display.setCurrent(confirmAlert, currentScr);
    }

    public void contactSupport() {
        final ContactListMidlet mid = ContactListMidlet.getInstance();
        this.contactSupportErrorCallback = new Runnable(){

            public void run() {
                mid._display.setCurrent(new Alert(Res.getString(90), Res.getString(54), null, AlertType.ERROR), mid.startupScreenflow());
            }
        };
        mid._display.setCurrent((Displayable)new ContactSupport());
    }

    public void sendToBG(byte[] data, byte msgType) {
        if (this._lmClient != null) {
            this._lmClient.sendData(data, msgType);
        } else {
            Utilities.logData("skipping send of LMP proto msg " + msgType + " we have no lm client");
        }
    }

    public void createLMClient() {
        Thread t = new Thread(){

            public void run() {
                for (int tries = 0; tries < 5; ++tries) {
                    try {
                        FGApp.this._lmConnection = (LocalMessageProtocolConnection)Connector.open((String)"localmsg://whatsapp");
                        FGApp.this._lmClient = new LocalMessageClient(FGApp.this._lmConnection, FGApp.this);
                        FGApp.this._lmClient.start();
                        Utilities.logData("LMP client started");
                        FGApp.this.sendZeroDataAlertToBG((byte)9);
                        FGApp.this.sendZeroDataAlertToBG((byte)51);
                        FGApp.this.sendZeroDataAlertToBG((byte)2);
                        Utilities.logData("requested chat histories");
                        break;
                    }
                    catch (ConnectionNotFoundException cnfx) {
                        Utilities.logData("try " + tries + " LMP client doesn't see connection: " + cnfx.toString());
                    }
                    catch (IOException ex) {
                        Utilities.logData("try " + tries + " createLMClient failed on " + ex.toString());
                    }
                    try {
                        Thread.sleep(tries * 150);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        t.start();
    }

    public void localMessageReceived(byte[] data, byte msgType) {
        Utilities.logData("fgApp got local message of type " + msgType);
        try {
            switch (msgType) {
                case 10: {
                    FunXMPP.FMessage newMessage = Serializer.unserializeFMSG(data);
                    this._chatHistoryCache.newMessage(newMessage);
                    this.notifyOnMessage(newMessage);
                    if (this._topPane instanceof MessageStore.Listener) {
                        MessageStore.Listener listener = (MessageStore.Listener)this._topPane;
                        listener.newFullMessage(newMessage);
                    }
                    break;
                }
                case 11: {
                    FunXMPP.FMessage newMessage = Serializer.unserializeFMSG(data);
                    this._chatHistoryCache.newMessage(newMessage);
                    this.notifyOnMessage(newMessage);
                    Utilities.logData("received new overflow message with type " + newMessage.media_wa_type);
                    if (this._topPane instanceof MessageStore.Listener) {
                        MessageStore.Listener listener = (MessageStore.Listener)this._topPane;
                        listener.newSkeletalMessage(newMessage);
                    }
                    break;
                }
                case 4: {
                    BGApp.ContactChatInfo ccInfo = Serializer.unserializeCCInfo(data);
                    this._chatHistoryCache.newContactChatState(ccInfo.jid, ccInfo.state);
                    if (this._topPane instanceof ChatState.Listener) {
                        ChatState.Listener listener = (ChatState.Listener)this._topPane;
                        listener.newContactChatState(ccInfo.jid, ccInfo.state, ccInfo.timestamp);
                    }
                    break;
                }
                case 5: {
                    BGApp.FmsgKeyStatus keyStatus = Serializer.unserializeKeyStatus(data);
                    this._chatHistoryCache.messageReceipt(keyStatus.key, keyStatus.status);
                    if (this._topPane instanceof MessageStore.Listener) {
                        MessageStore.Listener listener = (MessageStore.Listener)this._topPane;
                        listener.messageReceipt(keyStatus.key, keyStatus.status);
                    }
                    break;
                }
                case 12: {
                    this.setSyncState(0);
                    boolean success = data[0] != 0;
                    final InitForm initForm = this._topPane instanceof InitForm ? (InitForm)((Object)this._topPane) : null;
                    if (success) {
                        boolean recentChanges;
                        boolean bl = recentChanges = data[1] != 0;
                        if (recentChanges) {
                            Thread t = new Thread(){

                                public void run() {
                                    FGApp.this._statusHash.clear();
                                    FGApp.this._phoneHash.clear();
                                    FGApp.this._readableNameHash.clear();
                                    FGApp.this._pimCache.removeAllElements();
                                    FGApp.this._pimSize = -1;
                                    Favorites newFavs = new Favorites();
                                    newFavs.initialize();
                                    if (initForm != null) {
                                        newFavs.sort();
                                        newFavs.saveToDisk();
                                    }
                                    FGApp.this._favs = newFavs;
                                    if (initForm != null) {
                                        initForm.firstSyncDetected();
                                    } else if (FGApp.this._mainScreen != null && FGApp.this._topPane == FGApp.this._mainScreen) {
                                        FGApp.this._mainScreen.tabNeedsRefresh(((FGApp)FGApp.this)._mainScreen._favsTab, false);
                                    }
                                }
                            };
                            t.start();
                        }
                        break;
                    }
                    final byte errorCode = data[1];
                    final String errorText = data.length > 2 ? new String(data, 2, data.length - 2) : Constants.STRING_EMPTY_STRING;
                    if (initForm != null) {
                        Thread t = new Thread(){

                            public void run() {
                                initForm.syncFailDetected(errorCode, errorText);
                            }
                        };
                        t.start();
                        break;
                    }
                    String useText = errorCode == 1 ? Res.getString(139) : errorText;
                    Alert alert = new Alert(Res.getString(132), useText, null, AlertType.ERROR);
                    this.setTopPane(this._mainScreen);
                    ContactListMidlet.getInstance()._display.setCurrent(alert, (Displayable)this._mainScreen);
                    break;
                }
                case 18: {
                    Settings.receiveCacheUpdate(data);
                    break;
                }
                case 19: {
                    Settings.receiveCacheRemove(data);
                    break;
                }
                case 41: {
                    ChatHistory.GroupPlusMetadata metaD = Serializer.unserializeGroupMetaData(data);
                    this._chatHistoryCache.addGroupChat(metaD.gjid, metaD.owner, metaD.creation, metaD.subject, metaD.subject_t);
                    if (this._topPane != null && this._topPane instanceof MessageStore.Listener) {
                        MessageStore.Listener listener = (MessageStore.Listener)this._topPane;
                        listener.groupChatMetadataUpdate(metaD.gjid);
                    }
                    break;
                }
                case 17: {
                    this._chatHistoryCache.initialize(data);
                    if (this._mainScreen != null && this._chatHistoryCache.size() == 5) {
                        this._mainScreen.initialChatsLoadComplete();
                        this.preloadNames();
                    }
                    break;
                }
                case 20: {
                    if (this._mainScreen != null && this._chatHistoryCache.size() < 5) {
                        this._mainScreen.initialChatsLoadComplete();
                        this.preloadNames();
                    }
                    if (this._topPane instanceof ChatPane) {
                        ((ChatPane)this._topPane).initialChatsLoadComplete();
                    }
                    this._chatsAlreadySent = true;
                    this.IMSICheck();
                    break;
                }
                case 51: {
                    if (data.length >= 2) {
                        this._curMMSState = data[0];
                        this._curSyncState = data[1];
                    }
                    break;
                }
                case 53: {
                    this._curMMSState = 0;
                    this._curXferProgress = 0;
                    if (this._topPane != null && this._topPane instanceof ChatPane) {
                        String[] sArr = Serializer.unserializeStringArr(data, 3);
                        ((ChatPane)this._topPane).mmsDownloadFinished(true, sArr[0], sArr[1], sArr[2]);
                    }
                    break;
                }
                case 54: {
                    this._curMMSState = 0;
                    this._curXferProgress = 0;
                    if (this._topPane != null && this._topPane instanceof ChatPane) {
                        String[] sArr = Serializer.unserializeStringArr(data, 2);
                        ((ChatPane)this._topPane).mmsDownloadFinished(false, sArr[0], sArr[1], null);
                    }
                    break;
                }
                case 55: {
                    int percentComplete;
                    if (this._curMMSState == 2) {
                        Utilities.logData("disregarded progress in *cancelling* state");
                        break;
                    }
                    Object curPane = this._topPane;
                    this._curXferProgress = percentComplete = data[0];
                    if (curPane != null && curPane instanceof ChatPane) {
                        ChatPane curChat = (ChatPane)curPane;
                        curChat.mmsXferProgress(percentComplete);
                    }
                    break;
                }
                case 57: {
                    this._curMMSState = 0;
                    this._curXferProgress = 0;
                    Object curPane = this._topPane;
                    if (curPane != null && curPane instanceof ChatPane) {
                        ChatPane curChat = (ChatPane)curPane;
                        curChat.mmsUploadFinished(true);
                    }
                    break;
                }
                case 58: {
                    this._curMMSState = 0;
                    this._curXferProgress = 0;
                    String errText = new String(data);
                    Alert errAlert = new Alert(Constants.STRING_EMPTY_STRING, errText, null, AlertType.ERROR);
                    Displayable cur = ContactListMidlet.getInstance()._display.getCurrent();
                    ContactListMidlet.getInstance()._display.setCurrent(errAlert, cur);
                    Object curPane = this._topPane;
                    if (curPane != null && curPane instanceof ChatPane) {
                        ChatPane curChat = (ChatPane)curPane;
                        curChat.mmsUploadFinished(false);
                    }
                    break;
                }
                case 22: {
                    Runnable callback = this.contactSupportErrorCallback;
                    this.contactSupportErrorCallback = null;
                    if (callback != null) {
                        callback.run();
                    }
                    break;
                }
                case 24: {
                    int percentComplete = data[0];
                    this.setSyncState(2);
                    this._curSyncProgress = percentComplete;
                    Object curPane = this._topPane;
                    if (curPane instanceof InitForm) {
                        ((InitForm)((Object)curPane)).coldSyncUpdate(percentComplete);
                        break;
                    }
                    if (this._mainScreen != null) {
                        this._mainScreen.tabNeedsRefresh(this._mainScreen._favsTab, true);
                    }
                    break;
                }
                case 2: {
                    byte new_state = data[0];
                    if (new_state == 4) {
                        Runnable reRegAction = new Runnable(){

                            public void run() {
                                try {
                                    Settings.clear(5);
                                    PhoneRegBase.resetReg();
                                    ContactListMidlet.getInstance().startupScreenflow();
                                }
                                catch (RecordStoreException rsx) {
                                    Utilities.logData("zero out before rereg blowup: " + rsx.toString());
                                }
                            }
                        };
                        DialogAlert.show(1, Constants.STRING_EMPTY_STRING, Res.getString(82), reRegAction, null, null, ContactListMidlet.getInstance()._display, (Displayable)this._mainScreen, true);
                    }
                    break;
                }
                case 72: {
                    Object curPane = this._topPane;
                    if (curPane instanceof StatusForm) {
                        StatusForm sForm = (StatusForm)((Object)curPane);
                        if (data[0] == 0) {
                            String errorText = new String(data, 1, data.length - 1);
                            sForm.updateStatusFinished(false, errorText);
                            break;
                        }
                        sForm.updateStatusFinished(true, null);
                    }
                    break;
                }
                case 59: {
                    if (this._curMMSState == 2) {
                        Utilities.logData("disregarded process milestone in *cancelling* state");
                        break;
                    }
                    Object curPane = this._topPane;
                    if (curPane != null && curPane instanceof ChatPane) {
                        byte milestone = data[0];
                        ChatPane curChat = (ChatPane)curPane;
                        curChat.mmsProcessProgress(milestone);
                    }
                    break;
                }
                case 52: {
                    this._curMMSState = 0;
                    this._curXferProgress = 0;
                    Object curPane = this._topPane;
                    if (curPane != null && curPane instanceof ChatPane) {
                        ChatPane curChat = (ChatPane)curPane;
                        curChat.mmsXferCancelled();
                    }
                    break;
                }
                default: {
                    Utilities.logData("encountered unknown localmessage type: " + msgType);
                }
            }
        }
        catch (Throwable t) {
            Utilities.logData("blew up trying to process local message of type " + msgType + " with error " + t.toString());
        }
    }

    private void IMSICheck() {
        SafeThread t = new SafeThread("imsi check"){

            public void safeRun() {
                if (ApplicationData.checkIMSIMismatch()) {
                    Runnable reRegAction = new Runnable(){

                        public void run() {
                            try {
                                Settings.clear(5);
                                PhoneRegBase.resetReg();
                                ContactListMidlet.getInstance().startupScreenflow();
                            }
                            catch (RecordStoreException rsx) {
                                Utilities.logData("zero out before rereg blowup: " + rsx.toString());
                            }
                        }
                    };
                    Runnable clearIMSIAction = new Runnable(){

                        public void run() {
                            try {
                                Settings.set(12, System.getProperty(Constants.PROPERTY_IMSI));
                            }
                            catch (Exception x) {
                                Utilities.logData("imsi reset blowup: " + x.toString());
                            }
                        }
                    };
                    Displayable topD = ContactListMidlet.getInstance()._display.getCurrent();
                    DialogAlert.show(1, Constants.STRING_EMPTY_STRING, "Your SIM changed. Re-verify device?", reRegAction, clearIMSIAction, null, ContactListMidlet.getInstance()._display, topD, true);
                }
            }
        };
        t.start();
    }

    public void connectionClosed(int reason) {
        Utilities.logData("@@@@@@ LMP connection closed in FGApp! attempting reconnect");
        this._lmClient = null;
        this._lmConnection = null;
        this.createLMClient();
    }

    public void PimCacherProgress(int percentDone) {
        this._curSyncProgress = percentDone;
        if (this._mainScreen != null) {
            this._mainScreen.tabNeedsRefresh(this._mainScreen._favsTab, true);
        }
    }

    public static class XMPPJabberLast {
        public static String getFormattedTime(long stamp) {
            long current = System.currentTimeMillis();
            String dayWord = DateTimeUtilities.isSameDate(stamp, current) ? Res.getString(165) : (DateTimeUtilities.isSameDate(stamp, current - 86400000L) ? Res.getString(182) : DateTimeUtilities.simpleDayFormat(stamp));
            return Res.getString(162, dayWord, DateTimeUtilities.shortTimeFormat(stamp));
        }

        public static String getFormattedLastSeen(long timestamp) {
            long totalMillis = System.currentTimeMillis() - timestamp;
            if (totalMillis <= 0L) {
                return Res.getString(110);
            }
            return Res.getString(143, XMPPJabberLast.getFormattedTime(timestamp));
        }
    }
}

