/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.contacts.ContactInfoDetails;
import com.whatsapp.api.ui.Command;
import com.whatsapp.api.ui.FieldManager;
import com.whatsapp.api.ui.ListField;
import com.whatsapp.api.ui.Rect;
import com.whatsapp.api.ui.TextUtils;
import com.whatsapp.api.ui.UIField;
import com.whatsapp.client.CanvasScreen;
import com.whatsapp.client.ChatPane;
import com.whatsapp.client.ContactListItem;
import com.whatsapp.client.ContactListPane;
import com.whatsapp.client.FGApp;
import com.whatsapp.client.Res;
import com.whatsapp.client.test.ContactListMidlet;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ContactPane
extends CanvasScreen
implements ListField.Container {
    public static final int ROW_HEIGHT = 44;
    public static final Font FONT_NAME = Font.getFont((int)0);
    private final Command _backCmd = new Command(Res.getString(59), Command.BACK, 0);
    private final Command _selectCmd = new Command(Res.getString(144), Command.ITEM, 0);
    private final Command _inviteCmd = new Command(Res.getString(192), Command.ITEM, 0);
    private final ContactNameField _nameFld;
    private final ListField _clFld = new ListField(this);
    private final ContactInfoDetails _contact;
    private final String[] _jids;
    private final String[] _statuses;

    public ContactPane(ContactInfoDetails contact) {
        super(0xFFFFFF);
        FGApp fg = FGApp.getInstance();
        this._contact = contact;
        String[] phones = contact._phones;
        this._jids = new String[phones.length];
        this._statuses = new String[phones.length];
        for (int phoneIdx = 0; phoneIdx < phones.length; ++phoneIdx) {
            String phone = phones[phoneIdx];
            String jid = this._jids[phoneIdx] = fg.getJidFromPhone(phone);
            this._statuses[phoneIdx] = fg.getStatusFromJid(jid);
        }
        this._nameFld = new ContactNameField(contact.getFullName());
        this.addCommand(this._backCmd);
        FieldManager vfm = new FieldManager(0L, true);
        vfm.add(this._nameFld);
        vfm.add(this._clFld);
        this.addField(vfm);
        this.traverse(6);
        this.sizeChanged(this.getWidth(), this.getHeight());
        fg.setTopPane(this);
    }

    protected void onFocusChanged() {
        this.resetCmdState();
    }

    public boolean commandAction(Command cmd, UIField field) {
        FGApp fg = FGApp.getInstance();
        if (cmd == this._selectCmd) {
            int focusedIdx = this.getFocusedIndex();
            if (this.isWhatsAppContact(focusedIdx)) {
                ContactListMidlet.getInstance()._display.setCurrent((Displayable)new ChatPane(this._jids[focusedIdx]));
            }
        } else if (cmd == this._inviteCmd) {
            fg.inviteContactByPhone(this._contact._phones[this.getFocusedIndex()]);
        } else if (cmd == this._backCmd) {
            ContactListPane main = fg.getMainScreen();
            ContactListMidlet.getInstance()._display.setCurrent((Displayable)main);
            fg.setTopPane(main);
        } else {
            return super.commandAction(cmd, field);
        }
        return true;
    }

    private void resetCmdState() {
        if (this.getNumListItems() > 0) {
            if (this.isWhatsAppContact(this.getFocusedIndex())) {
                this._clFld.removeFieldCommand(this._inviteCmd);
                this._clFld.addFieldCommand(this._selectCmd);
            } else {
                this._clFld.addFieldCommand(this._inviteCmd);
                this._clFld.removeFieldCommand(this._selectCmd);
            }
        } else {
            this._clFld.removeFieldCommand(this._inviteCmd);
            this._clFld.removeFieldCommand(this._selectCmd);
        }
    }

    public int getHeightForList() {
        return -1;
    }

    public int getRowHeight() {
        return 44;
    }

    public int getNumListItems() {
        return this._contact._phones.length;
    }

    public boolean shouldListKeepFocus(int direction) {
        return true;
    }

    public Vector getListItems(int logicalStart, int numItems) {
        numItems = Math.max(0, Math.min(numItems, this._contact._phones.length - logicalStart));
        Vector<ContactListItem> ret = new Vector<ContactListItem>(numItems);
        for (int i = logicalStart; i < logicalStart + numItems; ++i) {
            String status = this._statuses[i];
            String catLabel = ContactInfoDetails.getPhoneCategoryLabel(this._contact._phoneCats[i]);
            String phone = this._contact._phones[i];
            ret.addElement(new ContactListItem(phone, status, catLabel, null));
        }
        return ret;
    }

    private int getFocusedIndex() {
        return this._clFld.getFocusedLogicalRow();
    }

    private boolean isWhatsAppContact(int idx) {
        return this._statuses[idx] != null;
    }

    private static class ContactNameField
    extends UIField {
        private final String _name;
        private Image _image = ContactListItem.defaultContactImg;

        public ContactNameField(String name) {
            super(0L);
            this._name = name;
        }

        public void layout(int width, int height) {
            this.setExtent(width, 44);
        }

        public void paint(Graphics g, int x, int y, int width, int height) {
            Rect clip = new Rect(g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight());
            g.clipRect(x, y, width, height);
            g.drawImage(this._image, x, y, 0);
            int imageWidth = this._image.getWidth();
            int nameX = x + imageWidth;
            int nameY = y + this.getHeight() / 2 - g.getFont().getHeight() / 2;
            int nameWidth = this.getWidth() - imageWidth;
            g.setFont(FONT_NAME);
            TextUtils.drawStringElided(g, this._name, nameX, nameY, nameWidth);
            g.setClip(clip.x, clip.y, clip.width, clip.height);
        }
    }
}

