/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.contacts.ContactInfoDetails;
import com.whatsapp.api.contacts.ContactPhotoCache;
import com.whatsapp.api.ui.Command;
import com.whatsapp.api.ui.DialogAlert;
import com.whatsapp.api.ui.ListField;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.ChatHistory;
import com.whatsapp.client.ChatHistoryCache;
import com.whatsapp.client.ChatPane;
import com.whatsapp.client.ChatsListItem;
import com.whatsapp.client.ContactListPane;
import com.whatsapp.client.EmptyMessageListItem;
import com.whatsapp.client.FGApp;
import com.whatsapp.client.Res;
import com.whatsapp.client.Serializer;
import com.whatsapp.client.TabState;
import com.whatsapp.client.test.ContactListMidlet;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;

public class ChatsTabState
extends TabState
implements ContactPhotoCache.ChangeListener {
    ChatHistoryCache _chatHistoryCache = FGApp.getInstance().getChatHistoryCache();
    private Vector _cmdPack = new Vector();
    private Vector _visibleImages;

    public ChatsTabState(ContactListPane parentScr, int index) {
        super(parentScr, index);
    }

    public void onContactPhotoChanged() {
        this._parentScr.tabNeedsRefresh(this, false);
    }

    private Vector filterByNames(Vector historyVec) {
        int s = historyVec.size();
        Vector<ChatHistory> res = new Vector<ChatHistory>();
        FGApp fgApp = FGApp.getInstance();
        for (int i = 0; i < s; ++i) {
            ChatHistory curHist = (ChatHistory)historyVec.elementAt(i);
            String name = curHist._readableName;
            if (name == null) {
                name = fgApp.getDisplayableNameFromJid(curHist._jid);
            }
            if (name != null && curHist._group != null) {
                if (!name.toLowerCase().startsWith(this._curFilter)) continue;
                res.addElement(curHist);
                continue;
            }
            if (!this.subnameCheck(name)) continue;
            res.addElement(curHist);
        }
        return res;
    }

    public void filterList(String filter, boolean forceRefresh) {
        if (filter == null || filter.length() == 0) {
            this._filteredList = null;
            this._curFilter = null;
        } else {
            String oldFilter = this._curFilter;
            this._curFilter = filter.toLowerCase();
            this._filteredList = !forceRefresh && oldFilter != null && this._curFilter.startsWith(oldFilter) ? this.filterByNames(this._filteredList) : this.filterByNames(this._chatHistoryCache.getSortedList());
        }
    }

    public int getNumListItems() {
        if (this._curFilter == null) {
            return this._chatHistoryCache.size();
        }
        return this._filteredList.size();
    }

    public Vector getListItems(int logicalStart, int numItems) {
        FGApp fg = FGApp.getInstance();
        Vector useSortedHistories = this._curFilter == null ? this._chatHistoryCache.getSortedList() : this._filteredList;
        Vector excerpt = this.safeExcerpt(useSortedHistories, logicalStart, numItems);
        Vector<ListField.Item> items = new Vector<ListField.Item>(numItems);
        Vector<Image> images = new Vector<Image>(numItems);
        ContactPhotoCache.stopAllGetAsync();
        for (int i = 0; i < excerpt.size(); ++i) {
            ChatsListItem newItem;
            ChatHistory curHist = (ChatHistory)excerpt.elementAt(i);
            Image photo = null;
            try {
                ContactInfoDetails cid = fg.getDetailsFromJid(curHist._jid);
                if (cid != null) {
                    photo = ContactPhotoCache.getAsync(cid._uid, this);
                }
            }
            catch (IOException ex) {
                Utilities.logData("chats-tab/get-photo/io-error: " + ex);
            }
            if (photo != null) {
                images.addElement(photo);
                newItem = new ChatsListItem(curHist, photo);
            } else {
                newItem = new ChatsListItem(curHist);
            }
            items.addElement(newItem);
        }
        if (items.isEmpty() && this._curFilter == null) {
            items.addElement(new EmptyMessageListItem(Res.getString(164)));
        }
        this._masterList = useSortedHistories;
        this._visibleImages = images;
        return items;
    }

    public String getTabText() {
        int dirtyCount = FGApp.getInstance().getChatHistoryCache().dirtyCount();
        String chats = Res.getString(20);
        if (dirtyCount > 0) {
            return chats + '(' + Integer.toString(dirtyCount) + ')';
        }
        return chats;
    }

    public void selectItem(int index) {
        if (this._masterList == null || index < 0 || index >= this._masterList.size()) {
            Utilities.logData("chats illegal select Item: index " + index + " list " + this._masterList);
            return;
        }
        ChatHistory curSelected = (ChatHistory)this._masterList.elementAt(index);
        ChatPane cp = new ChatPane(curSelected._jid);
        ContactListMidlet.getInstance()._display.setCurrent((Displayable)cp);
    }

    public Vector getCommands() {
        return this._cmdPack;
    }

    public boolean tabCommandHandler(Command cmd) {
        return false;
    }

    public void deleteItem(int index) {
        if (this._masterList == null || this._masterList.isEmpty()) {
            return;
        }
        String deleteJid = null;
        try {
            ChatHistory curSelected = (ChatHistory)this._masterList.elementAt(index);
            deleteJid = curSelected._jid;
            final FGApp fgApp = FGApp.getInstance();
            String niceName = fgApp.getDisplayableNameFromJid(deleteJid);
            String confirmText = curSelected._group != null ? Res.getString(79, niceName) : Res.getString(80, niceName);
            final String deleteMe = deleteJid;
            Runnable deleteAction = new Runnable(){

                public void run() {
                    fgApp.getChatHistoryCache().chatHistoryDeleted(deleteMe);
                    try {
                        fgApp.sendToBG(Serializer.serialize(deleteMe), (byte)8);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ChatsTabState.this._parentScr.tabNeedsRefresh(ChatsTabState.this, true);
                }
            };
            DialogAlert.show(1, Res.getString(78), confirmText, deleteAction, null, null, ContactListMidlet.getInstance()._display, (Displayable)this._parentScr, false);
        }
        catch (Throwable t) {
            Utilities.logData("error deleting chat history for " + deleteJid + " : " + t.toString());
        }
    }

    public boolean needsHighlight() {
        return FGApp.getInstance().getChatHistoryCache().dirtyCount() > 0;
    }
}

