/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.ui.ListField;
import com.whatsapp.api.ui.Rect;
import com.whatsapp.api.ui.TextUtils;
import com.whatsapp.api.util.DateTimeUtilities;
import com.whatsapp.client.ChatHistory;
import com.whatsapp.client.ContactListItem;
import com.whatsapp.client.FGApp;
import com.whatsapp.client.FunXMPP;
import com.whatsapp.client.MessageStatusIcon;
import com.whatsapp.client.Res;
import com.whatsapp.client.TabState;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ChatsListItem
implements ListField.Item {
    protected static final int ROW_HEIGHT = 44;
    public ChatHistory _hist;
    public final Image _photo;
    public static Font normalFont = Font.getFont((int)64, (int)0, (int)0);
    public static Font boldFont = Font.getFont((int)64, (int)1, (int)0);
    public static Font smallFont = Font.getFont((int)64, (int)0, (int)8);
    private static int _storedIconWidth = -1;
    private static int _storedIconHeight = -1;
    private static int _storedIconYAdjust = 0;

    public ChatsListItem(ChatHistory hist) {
        this(hist, hist._group == null ? ContactListItem.defaultContactImg : ContactListItem.defaultGroupImg);
    }

    public ChatsListItem(ChatHistory hist, Image photo) {
        this._hist = hist;
        this._photo = photo;
    }

    public static int getIconWidth() {
        if (_storedIconWidth < 0) {
            int ourWidth = smallFont.stringWidth("XX");
            if (ourWidth < 25) {
                ourWidth = 25;
            }
            _storedIconWidth = ourWidth;
        }
        return _storedIconWidth;
    }

    public static int getIconHeight() {
        if (_storedIconHeight < 0) {
            int iconFloorDim;
            int ourHeight = smallFont.getHeight();
            if (ourHeight < (iconFloorDim = 20)) {
                _storedIconYAdjust = (iconFloorDim - ourHeight) / 2;
                ourHeight = iconFloorDim;
            }
            _storedIconHeight = ourHeight;
        }
        return _storedIconHeight;
    }

    public static int getIconYAdjust() {
        return _storedIconYAdjust;
    }

    public void paintListRow(Graphics g, int x, int y, int width, int height, boolean focused) {
        boolean unread;
        Rect clip = new Rect(g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight());
        g.clipRect(x, y, width, height);
        if (focused) {
            TabState.paintFocusedBackground(g, x, y, width, height);
        }
        g.drawImage(this._photo, x, y, 0);
        if (!focused) {
            g.setColor(6591981);
        } else {
            g.setColor(0xFFFFFF);
        }
        int labelWidth = 0;
        if (this._hist._lastTimestamp > 0L) {
            String date = ChatsListItem.formattedStamp(this._hist._lastTimestamp);
            labelWidth = normalFont.stringWidth(date) + 2;
            g.setFont(normalFont);
            g.drawString(date, x + width - labelWidth, y, 20);
        }
        if (unread = this._hist.isDirty()) {
            g.setFont(boldFont);
        } else {
            g.setFont(normalFont);
        }
        String name = this._hist._readableName == null ? FGApp.getInstance().getDisplayableNameFromJid(this._hist._jid) : this._hist._readableName;
        int availWidth = width - (labelWidth + 3 + 44);
        if (!focused) {
            g.setColor(0);
        }
        TextUtils.drawStringElided(g, name, x + 44 + 1, y, availWidth);
        g.setFont(smallFont);
        if (this._hist._typing) {
            if (!focused) {
                g.setColor(32512);
            }
            g.drawString(Res.getString(99), x + 44, y + 22, 20);
        } else {
            if (!focused) {
                g.setColor(0x4D4D4D);
            }
            FunXMPP.FMessage.Key dummyKey = new FunXMPP.FMessage.Key(this._hist._jid, this._hist._lastFromMe, this._hist._lastID);
            FunXMPP.FMessage fmsg = new FunXMPP.FMessage(dummyKey);
            fmsg.status = this._hist._lastStatus;
            MessageStatusIcon.paintStatusIcon(g, fmsg, x + 44, y + 22 + ChatsListItem.getIconYAdjust(), ChatsListItem.getIconWidth(), ChatsListItem.getIconHeight(), false, unread, focused);
            String formattedExcerpt = this._hist._lastExcerpt;
            if (this._hist._group != null && this._hist._group._lastParty != null && (this._hist._lastStatus & 0xF) != 6) {
                formattedExcerpt = FGApp.getInstance().getDisplayableNameFromJid(this._hist._group._lastParty) + ": " + this._hist._lastExcerpt;
            }
            if (formattedExcerpt != null) {
                if (formattedExcerpt.length() > 40) {
                    formattedExcerpt = formattedExcerpt.substring(0, 40);
                }
                availWidth = width - (ChatsListItem.getIconWidth() + 2 + 44);
                TextUtils.drawStringElided(g, formattedExcerpt, ChatsListItem.getIconWidth() + x + 44, y + 22 + ChatsListItem.getIconYAdjust(), availWidth);
            }
        }
        g.setColor(0x808080);
        g.drawLine(x, y + 44 - 1, x + width, y + 44 - 1);
        g.setClip(clip.x, clip.y, clip.width, clip.height);
    }

    public static String formattedStamp(long stamp) {
        long current = System.currentTimeMillis();
        long sixDaysAgo = current - 518400000L;
        if (stamp < current - 31536000000L) {
            return DateTimeUtilities.dayOfYear(stamp);
        }
        if (stamp < sixDaysAgo && !DateTimeUtilities.isSameDate(stamp, sixDaysAgo)) {
            return DateTimeUtilities.simpleDayFormat(stamp);
        }
        if (current - stamp > 43200000L) {
            return DateTimeUtilities.weekdayTimeFormat(stamp);
        }
        return DateTimeUtilities.shortTimeFormat(stamp);
    }
}

