/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.ui.FieldManager;
import com.whatsapp.api.ui.Rect;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.ChatGroupBubble;
import com.whatsapp.client.ChatLine;
import com.whatsapp.client.FGApp;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class ChatVFM
extends FieldManager {
    public static final int BUBBLE_OFFSET = 25;
    public static final int BUBBLE_VERTICAL_MARGIN = 2;
    public static final int ARROW_OFFSET = 4;
    public static final int ARROW_HEIGHT = 10;
    public static final int ARROW_WIDTH = 10;
    public static final int COLOR_ARROW = 16759296;
    private final boolean isGroup;
    private final Hashtable colorMap;
    private ChatGroupBubble _firstChatBubble;
    private ChatGroupBubble _lastChatBubble;
    private boolean _showBottomWanted = true;
    private ChatLine _curHighlightLine = null;
    private int _curHighlightIndex = -1;
    private final Vector _chatLines = new Vector();
    public static final int LOW_SATURATION = 30;
    public static final int HIGH_SATURATION = 60;
    public static final int[] COLOR_PALETTE = new int[]{ChatVFM.hsvToRgb(0, 30, 100), ChatVFM.hsvToRgb(150, 30, 80), ChatVFM.hsvToRgb(300, 30, 100), ChatVFM.hsvToRgb(90, 30, 80), ChatVFM.hsvToRgb(240, 30, 100), ChatVFM.hsvToRgb(30, 30, 80), ChatVFM.hsvToRgb(180, 30, 100), ChatVFM.hsvToRgb(330, 30, 80), ChatVFM.hsvToRgb(120, 30, 100), ChatVFM.hsvToRgb(270, 30, 80), ChatVFM.hsvToRgb(60, 30, 100), ChatVFM.hsvToRgb(210, 30, 80)};

    public ChatVFM(int style, boolean isGroup) {
        super(style, true);
        this.isGroup = isGroup;
        this.colorMap = isGroup ? new Hashtable(10) : null;
    }

    public boolean isEmpty() {
        return this._chatLines.isEmpty();
    }

    public void snapTop() {
        this.setVerticalScroll(0);
        if (this._chatLines.size() > 0) {
            this.setHighlightLine(0);
        }
        this._showBottomWanted = false;
    }

    public void snapDown() {
        super.snapDown(this.getHeight());
        this._showBottomWanted = true;
        if (this._chatLines.size() > 0) {
            this.setHighlightLine(this._chatLines.size() - 1);
        }
    }

    public ChatLine getLastChatLine() {
        if (this._chatLines.size() > 0) {
            return (ChatLine)this._chatLines.lastElement();
        }
        return null;
    }

    public ChatLine getFirstChatLine() {
        if (this._chatLines.size() > 0) {
            return (ChatLine)this._chatLines.firstElement();
        }
        return null;
    }

    protected void appendChatLine(ChatLine chatLine) {
        ChatLine lastChatLine = this.getLastChatLine();
        if (lastChatLine == null || !lastChatLine.isGroupable(chatLine)) {
            this._lastChatBubble = this.chatBubbleFactory(chatLine);
            this.add(this._lastChatBubble);
        }
        if (this._firstChatBubble == null) {
            this._firstChatBubble = this._lastChatBubble;
        }
        this._lastChatBubble.appendChatLine(chatLine);
        this._chatLines.addElement(chatLine);
        if (this._showBottomWanted && this._curHighlightIndex != -1) {
            this.setHighlightLine(this._chatLines.size() - 1);
        }
    }

    protected void prependChatLine(ChatLine chatLine) {
        ChatLine firstChatLine = this.getFirstChatLine();
        if (firstChatLine == null || !firstChatLine.isGroupable(chatLine)) {
            ChatGroupBubble newBubble = this.chatBubbleFactory(chatLine);
            if (this._firstChatBubble == null) {
                this.add(newBubble);
            } else {
                this.insertBefore(newBubble, this._firstChatBubble);
            }
            this._firstChatBubble = newBubble;
        }
        if (this._lastChatBubble == null) {
            this._lastChatBubble = this._firstChatBubble;
        }
        this._firstChatBubble.prependChatLine(chatLine);
        this._chatLines.insertElementAt(chatLine, 0);
    }

    private ChatGroupBubble chatBubbleFactory(ChatLine chatLine) {
        ChatGroupBubble bubble;
        boolean fromMe = chatLine._fmsg.key.from_me;
        if ((chatLine._fmsg.status & 0xF) == 6) {
            bubble = new ChatGroupBubble(4L);
            bubble.setMargin(2, 1, 2, 1);
        } else {
            if (this.isGroup && !fromMe) {
                String userJid = chatLine._fmsg.remote_resource;
                bubble = new ChatGroupBubble(FGApp.getInstance().getDisplayableNameFromJid(userJid), 1L);
                bubble.setBackgroundColor(this.getColorForJid(userJid));
            } else {
                bubble = new ChatGroupBubble(fromMe ? 2L : 1L);
            }
            bubble.setMargin(2, fromMe ? 1 : 25, 2, fromMe ? 25 : 1);
        }
        return bubble;
    }

    public void notifyDataSetChanged() {
        this._curHighlightIndex = this._chatLines.indexOf(this._curHighlightLine);
        this._curHighlightLine.getManager().ensureVisible(this._curHighlightLine, 0);
    }

    public void paint(Graphics g, int x, int y, int width, int height) {
        if (this._showBottomWanted) {
            this.snapDown(this.getHeight());
        }
        if (this.hasFocus() && this._curHighlightLine != null) {
            int baseX;
            int pointX;
            Rect clip = new Rect(g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight());
            g.clipRect(x, y, width, height);
            int center = this.getHighlightY() - this.getVerticalScroll() + this.getHighlightHeight() - ChatLine.DESC_FONT.getHeight() / 2;
            int bottom = center + 5;
            int top = center - 5;
            if (this._curHighlightLine._fmsg.key.from_me) {
                pointX = this.getManagerX() + 25 - 4;
                baseX = pointX - 10;
            } else {
                pointX = this.getManagerX() + this.getWidth() - 25 - 1 + 4;
                baseX = pointX + 10;
            }
            g.setColor(16759296);
            g.fillTriangle(baseX, top, baseX, bottom, pointX, center);
            g.setClip(clip.x, clip.y, clip.width, clip.height);
        }
        super.paint(g, x, y, width, height);
    }

    protected boolean internalTraverse(int dir) {
        if (this.hasFocus() && dir == 1) {
            this._showBottomWanted = false;
        }
        if (this._curHighlightIndex == -1 || this._curHighlightLine == null) {
            if (this._chatLines.size() > 0) {
                if (dir == 1 || dir == 2) {
                    this.snapDown();
                } else {
                    this.snapTop();
                }
                return true;
            }
            this._showBottomWanted = true;
            return false;
        }
        if (!this.hasFocus()) {
            return true;
        }
        int paneHeight = this.getHeight();
        int curAbsY = this.getHighlightY();
        int curHeight = this.getHighlightHeight();
        int curVScroll = this.getAbsoluteY() + this.getVerticalScroll();
        if (curHeight > paneHeight) {
            int underhang;
            if (dir == 6) {
                int overhang = curAbsY + curHeight - (curVScroll + paneHeight);
                if (overhang > 0) {
                    this.adjustVerticalScroll(Math.min(paneHeight, overhang));
                    return true;
                }
            } else if (dir == 1 && (underhang = curVScroll - curAbsY) > 0) {
                int scrollDelta = -Math.min(paneHeight, underhang);
                this.adjustVerticalScroll(scrollDelta);
                return true;
            }
        }
        switch (dir) {
            case 1: {
                if (this._curHighlightIndex == 0) {
                    this._curHighlightIndex = -1;
                    this._curHighlightLine = null;
                    break;
                }
                this.setHighlightLine(this._curHighlightIndex - 1);
                int newAbsY = this.getHighlightY();
                int newHeight = this.getHighlightHeight();
                int newUnderhang = curVScroll - newAbsY;
                if (newAbsY <= curVScroll) {
                    if (newHeight > paneHeight) {
                        // empty if block
                    }
                    this.adjustVerticalScroll(-Math.min(paneHeight, newUnderhang));
                }
                return true;
            }
            case 6: {
                if (this._curHighlightIndex >= this._chatLines.size() - 1) {
                    this._curHighlightIndex = -1;
                    this._curHighlightLine = null;
                    this._showBottomWanted = true;
                    break;
                }
                this.setHighlightLine(this._curHighlightIndex + 1);
                int newAbsY = this.getHighlightY();
                int newHeight = this.getHighlightHeight();
                int newOverhang = newAbsY + newHeight - (curVScroll + paneHeight);
                if (newOverhang >= 0) {
                    if (newHeight > paneHeight) {
                        // empty if block
                    }
                    this.adjustVerticalScroll(Math.min(paneHeight, newOverhang));
                }
                return true;
            }
        }
        return false;
    }

    public ChatLine getHighlightLine() {
        return this._curHighlightLine;
    }

    public int getHighlightIndex() {
        return this._curHighlightIndex;
    }

    private void setHighlightLine(int newIndex) {
        this._curHighlightIndex = newIndex;
        this._curHighlightLine = (ChatLine)this._chatLines.elementAt(this._curHighlightIndex);
    }

    private int getHighlightHeight() {
        try {
            ChatGroupBubble bubble;
            if (this.isGroup && (bubble = (ChatGroupBubble)this._curHighlightLine.getManager()) != null && bubble.firstChatline() == this._curHighlightLine) {
                return bubble.getHeaderHeight() + this._curHighlightLine.getHeight();
            }
        }
        catch (Throwable t) {
            Utilities.logData("problem casting in getHighlightHeight: " + t.toString());
        }
        return this._curHighlightLine.getHeight();
    }

    private int getHighlightY() {
        try {
            ChatGroupBubble bubble;
            if (this.isGroup && (bubble = (ChatGroupBubble)this._curHighlightLine.getManager()) != null && bubble.firstChatline() == this._curHighlightLine) {
                return bubble.getAbsoluteY();
            }
        }
        catch (Throwable t) {
            Utilities.logData("problem casting in getHighlightY: " + t.toString());
        }
        return this._curHighlightLine.getAbsoluteY();
    }

    private static int hsvToRgb(int hue, int saturation, int value) {
        int r = 0;
        int g = 0;
        int b = 0;
        int f = hue % 60;
        int maxRGB = 255;
        int maxSat = 100;
        int maxVal = 100;
        int p = value * (100 - saturation) * 255 / 10000;
        int q = value * (100 - f * saturation / 60) * 255 / 10000;
        int t = value * (100 - (60 - f) * saturation / 60) * 255 / 10000;
        int av = value * 255 / 100;
        int hueIndex = hue / 60 % 6;
        switch (hueIndex) {
            case 0: {
                r = av;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = av;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = av;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = av;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = av;
                break;
            }
            case 5: {
                r = av;
                g = p;
                b = q;
            }
        }
        return (r << 16) + (g << 8) + (b << 0);
    }

    private int getColorForJid(String remoteJid) {
        if (remoteJid == null) {
            return 0xFFFFFF;
        }
        Integer res = (Integer)this.colorMap.get(remoteJid);
        if (res == null) {
            int paletteSize = COLOR_PALETTE.length;
            int color = COLOR_PALETTE[this.colorMap.size() % paletteSize];
            res = new Integer(color);
            this.colorMap.put(remoteJid, res);
        }
        return res;
    }
}

