/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.ui.Command;
import com.whatsapp.api.ui.FieldManager;
import com.whatsapp.api.ui.InputEditorField;
import com.whatsapp.api.ui.MenuCommand;
import com.whatsapp.api.ui.UIField;
import com.whatsapp.api.util.DateTimeUtilities;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.AudioDisplayForm;
import com.whatsapp.client.CameraForm;
import com.whatsapp.client.CanvasScreen;
import com.whatsapp.client.ChatGroupBubble;
import com.whatsapp.client.ChatHistory;
import com.whatsapp.client.ChatHistoryCache;
import com.whatsapp.client.ChatLine;
import com.whatsapp.client.ChatState;
import com.whatsapp.client.ChatVFM;
import com.whatsapp.client.Constants;
import com.whatsapp.client.ContactListPane;
import com.whatsapp.client.FGApp;
import com.whatsapp.client.FunXMPP;
import com.whatsapp.client.ImageDisplayForm;
import com.whatsapp.client.MMSCreator;
import com.whatsapp.client.MediaData;
import com.whatsapp.client.MediaDisplay;
import com.whatsapp.client.MessageStore;
import com.whatsapp.client.Res;
import com.whatsapp.client.Serializer;
import com.whatsapp.client.StatusBar;
import com.whatsapp.client.TabRow;
import com.whatsapp.client.VideoDisplayForm;
import com.whatsapp.client.test.ContactListMidlet;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.midlet.MIDlet;

public class ChatPane
extends CanvasScreen
implements MessageStore.Listener,
ChatState.Listener {
    private static final int COLOR_BACKGROUND = 0xCFCFCF;
    public static final Font INPUT_FONT = Font.getFont((int)0, (int)0, (int)8);
    private final FieldManager _screenVFM;
    private TabRow _tabRow;
    private final StatusBar _statusBar;
    private final ChatVFM _chatVFM;
    private final InputEditorField _inputEditor = new InputEditorField(this, INPUT_FONT, 150, 0, -1, 1, 3);
    boolean _hidden = false;
    private ChatLine _curDownloadingLine = null;
    private ChatLine _curUploadingLine = null;
    private ChatLine _unprocessedImageLine = null;
    private boolean _dontShowMore = false;
    private long _lastRepaint = 0L;
    private Timer _timer = null;
    private MMSCreator _curCreator;
    private boolean _serializedHistoriesComplete = false;
    private final Hashtable _receivedMsgs = new Hashtable();
    private Hashtable _sentMsgs;
    public final String _jid;
    public final String _nameArg;
    public final boolean _isGroup;
    private String[] _tabJids;
    private final Command _sendMessageCmd = new Command(Res.getString(145), Command.OK, 0, false);
    private final Command _downloadCmd = new Command(Res.getString(84), Command.ITEM, 1);
    private final Command _viewCmd = new Command(Res.getString(171), Command.ITEM, 1);
    private final Command _cancelDownloadCmd = new Command(Res.getString(63), Command.ITEM, 1);
    private final Command _snapDown = new Command(Res.getString(60), Command.ITEM, 0);
    private final Command _showInputCmd = new Command(Res.getString(135), Command.ITEM, 0);
    private final MenuCommand _sendImageMenuCmd = new MenuCommand(Res.getString(147), Command.SCREEN, 1);
    private final Command _sendImageInternalCmd = new Command(Res.getString(113), Command.SCREEN, 1);
    private final Command _sendImageExternalCmd = new Command(Res.getString(105), Command.SCREEN, 1);
    private final Command _sendImageCameraCmd = new Command(Res.getString(62), Command.SCREEN, 1);
    private final MenuCommand _sendVideoMenuCmd = new MenuCommand(Res.getString(151), Command.SCREEN, 1);
    private final Command _sendVideoInternalCmd = new Command(Res.getString(113), Command.SCREEN, 1);
    private final Command _sendVideoExternalCmd = new Command(Res.getString(105), Command.SCREEN, 1);
    private final MenuCommand _sendAudioMenuCmd = new MenuCommand(Res.getString(146), Command.SCREEN, 1);
    private final Command _sendAudioInternalCmd = new Command(Res.getString(113), Command.SCREEN, 1);
    private final Command _sendAudioExternalCmd = new Command(Res.getString(105), Command.SCREEN, 1);
    private final Command _kbdHelpCmd = new Command(Res.getString(95), Command.HELP, 0);
    private final Command _closeCmd = new Command(Res.getString(70), Command.BACK, 0);
    private final Command _retryCmd = new Command(Res.getString(136), Command.ITEM, 1);
    private final Command _moreMessagesCmd = new Command(Res.getString(101), Command.SCREEN, 1);
    private static final int SAFE_REPAINT_INTVL = 1400;

    public ChatPane(TabRow tabRow, String[] tabJids, int tabIdx) {
        this(tabJids[tabIdx], null, 8, false, tabRow, tabJids, tabIdx);
    }

    public ChatPane(String jid) {
        this(jid, false, false, null);
    }

    public ChatPane(String jid, boolean startedDirectly, boolean forceGroup, String forceTitle) {
        this(jid, forceTitle != null ? forceTitle : FGApp.getInstance().getDisplayableNameFromJid(jid), startedDirectly ? 10 : 20, forceGroup, null, null, -1);
    }

    private ChatPane(String jid, String name, int getCount, final boolean forceGroup, TabRow tabRow, String[] tabJids, int tabIdx) {
        super(0xCFCFCF);
        final FGApp fgApp = FGApp.getInstance();
        ChatHistoryCache cache = fgApp.getChatHistoryCache();
        this._jid = jid;
        this._nameArg = name;
        this._isGroup = forceGroup || cache.getGroupChat(jid, false) != null;
        this._screenVFM = new FieldManager(1L, true){

            public void setFocus(boolean focus) {
                ChatPane.this._tabRow.setFocus(focus);
                super.setFocus(focus);
            }
        };
        if (tabRow == null) {
            this._tabRow = null;
            this.resetTabRowState();
        } else {
            this._tabRow = new TabRow(tabRow, tabIdx);
            this._tabRow.setHighlight(tabIdx, false);
            this._tabJids = tabJids;
            this._screenVFM.insertAt(this._tabRow, 0);
        }
        this._statusBar = new StatusBar();
        this._screenVFM.add(this._statusBar);
        this._chatVFM = new ChatVFM(30, this._isGroup);
        this._screenVFM.add(this._chatVFM);
        fgApp.setTopPane(this);
        fgApp.getPickerCallback().clearPane();
        this._inputEditor.editor.setParent((Object)this);
        this._inputEditor.setListener(this);
        this.addField(this._inputEditor);
        this.addField(this._screenVFM);
        this.sizeChanged(this.getWidth(), this.getHeight());
        this.addCommand(this._closeCmd);
        this._sendImageMenuCmd.addCommand(this._sendImageInternalCmd);
        this._sendImageMenuCmd.addCommand(this._sendImageExternalCmd);
        this._sendImageMenuCmd.addCommand(this._sendImageCameraCmd);
        this.addCommand(this._sendImageMenuCmd);
        this._sendVideoMenuCmd.addCommand(this._sendVideoInternalCmd);
        this._sendVideoMenuCmd.addCommand(this._sendVideoExternalCmd);
        this.addCommand(this._sendVideoMenuCmd);
        this._sendAudioMenuCmd.addCommand(this._sendAudioInternalCmd);
        this._sendAudioMenuCmd.addCommand(this._sendAudioExternalCmd);
        this.addCommand(this._sendAudioMenuCmd);
        this.addCommand(this._kbdHelpCmd);
        this._chatVFM.addFieldCommand(this._showInputCmd);
        this._inputEditor.addFieldCommand(this._sendMessageCmd);
        MessageStore mStore = fgApp.getMessageStore();
        int[] remainingCountHolder = new int[1];
        Vector v = mStore.getMessagesBefore(this._jid, null, getCount, remainingCountHolder);
        this._dontShowMore = remainingCountHolder[0] == 0;
        for (int i = v.size() - 1; i >= 0; --i) {
            FunXMPP.FMessage curmsg = (FunXMPP.FMessage)v.elementAt(i);
            MediaData md = (MediaData)curmsg.thumb_image;
            if (md != null) {
                md.inflate();
            }
            ChatLine cl = new ChatLine(curmsg, this);
            if (md != null && (curmsg.status & 0x100) > 0) {
                this._curDownloadingLine = cl;
            } else if (curmsg.status == 1) {
                this._curUploadingLine = cl;
                if (curmsg.media_wa_type == 1) {
                    this._unprocessedImageLine = cl;
                }
            }
            this._chatVFM.appendChatLine(cl);
            if (curmsg.key.from_me) {
                if (this._sentMsgs == null) {
                    this._sentMsgs = new Hashtable();
                }
                this._sentMsgs.put(curmsg.key, curmsg);
                continue;
            }
            this._receivedMsgs.put(curmsg.key, curmsg.key);
        }
        ChatLine lastChatLine = this._chatVFM.getLastChatLine();
        if (lastChatLine != null && (lastChatLine._fmsg.status & 0x80) > 0) {
            fgApp.paneReadMessage(lastChatLine._fmsg);
        }
        this.moveFocus(this._inputEditor);
        Thread t = new Thread(new Runnable(){

            public void run() {
                if (ChatPane.this._isGroup) {
                    if (forceGroup) {
                        FGApp.getInstance().getChatHistoryCache().getGroupChat(ChatPane.this._jid, true);
                    }
                } else {
                    fgApp.requestContactChatState(ChatPane.this._jid);
                }
            }
        });
        t.start();
    }

    public void initialChatsLoadComplete() {
        this.resetTabRowState();
        this.doRepaint();
    }

    public void resetTabRowState() {
        int i;
        FGApp fgApp = FGApp.getInstance();
        ChatHistoryCache cache = fgApp.getChatHistoryCache();
        int tabNaturalIdx = cache.getNaturalIndexOfJid(this._jid);
        int naturalOffset = tabNaturalIdx == -1 ? 1 : 0;
        int tabCount = cache.size() + naturalOffset;
        int tabIdx = tabNaturalIdx + naturalOffset;
        this._tabJids = new String[tabCount];
        String[] tabNames = new String[tabCount];
        boolean[] highlighted = new boolean[tabCount];
        for (i = 0; i < tabCount; ++i) {
            if (i != tabIdx) {
                ChatHistory chat = cache.getNatural(i - naturalOffset);
                this._tabJids[i] = chat._jid;
                tabNames[i] = fgApp.getDisplayableNameFromJid(chat._jid);
                highlighted[i] = chat.isDirty();
                continue;
            }
            this._tabJids[i] = this._jid;
            tabNames[i] = this._nameArg;
            highlighted[i] = false;
        }
        if (this._tabRow != null) {
            this._screenVFM.remove(this._tabRow);
        }
        this._tabRow = new TabRow(tabNames, tabIdx, true, false);
        this._screenVFM.insertAt(this._tabRow, 0);
        for (i = 0; i < tabCount; ++i) {
            this._tabRow.setHighlight(i, highlighted[i]);
        }
    }

    public void setTimestamp(String timestamp) {
        this._statusBar.setRightText(timestamp);
        this.doRepaint();
    }

    private void setStatus(String status) {
        this._statusBar.setLeftText(status);
        this.doRepaint();
    }

    private void openTab(int off) {
        if (this._tabJids.length < 2) {
            return;
        }
        int newTabIdx = (this._tabRow.getCenter() + off + this._tabJids.length) % this._tabJids.length;
        ContactListMidlet.getInstance()._display.setCurrent((Displayable)new ChatPane(this._tabRow, this._tabJids, newTabIdx));
    }

    private void showMoreMessages() {
        MessageStore mStore = FGApp.getInstance().getMessageStore();
        FunXMPP.FMessage markerMessage = this._chatVFM.getFirstChatLine()._fmsg;
        int[] remainingCountHolder = new int[1];
        Vector v = mStore.getMessagesBefore(this._jid, markerMessage, 20, remainingCountHolder);
        this._dontShowMore = remainingCountHolder[0] == 0;
        for (int i = 0; i < v.size(); ++i) {
            FunXMPP.FMessage curmsg = (FunXMPP.FMessage)v.elementAt(i);
            MediaData md = (MediaData)curmsg.thumb_image;
            if (md != null) {
                md.inflate();
            }
            ChatLine cl = new ChatLine(curmsg, this);
            this._chatVFM.prependChatLine(cl);
        }
        if (v.size() > 0) {
            this.doRelayout();
            this._chatVFM.notifyDataSetChanged();
            this.doRepaint();
            this.onHighlightChanged();
        } else {
            this._dontShowMore = true;
        }
    }

    protected void doRepaint() {
        this._lastRepaint = System.currentTimeMillis();
        super.doRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeRepaint() {
        long now = System.currentTimeMillis();
        long curIntvl = 0L;
        ChatPane chatPane = this;
        synchronized (chatPane) {
            curIntvl = now - this._lastRepaint;
            if (curIntvl > 1400L) {
                this.doRepaint();
                return;
            }
        }
        if (this._timer == null) {
            this._timer = new Timer();
        }
        this._timer.schedule(new TimerTask(){

            public void run() {
                ChatPane.this.safeRepaint();
            }
        }, 1400L - curIntvl / 2L);
    }

    protected void onFocusChanged() {
        if (this._cmdBar.hasFocus()) {
            this._inputEditor.pauseFocus();
        } else {
            this._inputEditor.resumeFocus();
        }
        if (this._chatVFM.hasFocus()) {
            this.onHighlightChanged();
        } else {
            this.resetTimestamp();
        }
    }

    protected void onHighlightChanged() {
        this.resetCmdState();
        this.resetTimestamp();
    }

    private boolean mmsLimitCheck() {
        if (FGApp.getInstance().getMMSState() != 0) {
            Alert tooMany = new Alert(Constants.STRING_EMPTY_STRING, Res.getString(121), null, AlertType.WARNING);
            ContactListMidlet.getInstance()._display.setCurrent(tooMany, (Displayable)this);
            return true;
        }
        return false;
    }

    public boolean commandAction(Command cmd, UIField field) {
        if (cmd == this._snapDown) {
            this._chatVFM.snapDown();
            this.doRepaint();
        } else if (cmd == this._closeCmd) {
            FGApp fgApp = FGApp.getInstance();
            Utilities.logData("chat screen closed");
            ContactListPane main = fgApp.getMainScreen();
            main.tabNeedsRefresh(main._chatsTab, true);
            Display.getDisplay((MIDlet)ContactListMidlet.getInstance()).setCurrent((Displayable)main);
            fgApp.setTopPane(main);
            fgApp.getPickerCallback().clearPane();
        } else if (cmd == this._showInputCmd) {
            this.moveFocus(this._inputEditor);
        } else if (cmd == this._sendImageExternalCmd) {
            if (!this.mmsLimitCheck()) {
                FGApp.getInstance().getPickerCallback().launchPicker(this, (byte)1, false);
            }
        } else if (cmd == this._sendImageInternalCmd) {
            if (!this.mmsLimitCheck()) {
                FGApp.getInstance().getPickerCallback().launchPicker(this, (byte)1, true);
            }
        } else if (cmd == this._sendVideoExternalCmd) {
            if (!this.mmsLimitCheck()) {
                FGApp.getInstance().getPickerCallback().launchPicker(this, (byte)3, false);
            }
        } else if (cmd == this._sendVideoInternalCmd) {
            if (!this.mmsLimitCheck()) {
                FGApp.getInstance().getPickerCallback().launchPicker(this, (byte)3, true);
            }
        } else if (cmd == this._sendAudioExternalCmd) {
            if (!this.mmsLimitCheck()) {
                FGApp.getInstance().getPickerCallback().launchPicker(this, (byte)2, false);
            }
        } else if (cmd == this._sendAudioInternalCmd) {
            if (!this.mmsLimitCheck()) {
                FGApp.getInstance().getPickerCallback().launchPicker(this, (byte)2, true);
            }
        } else if (cmd == this._sendImageCameraCmd) {
            if (!this.mmsLimitCheck()) {
                CameraForm camForm = new CameraForm(this);
                FGApp.getInstance().setTopPane((Object)camForm);
                ContactListMidlet.getInstance()._display.setCurrent((Displayable)camForm);
            }
        } else if (cmd == this._kbdHelpCmd) {
            Alert a = new Alert(Res.getString(100), Res.getString(127), null, AlertType.INFO);
            ContactListMidlet.getInstance()._display.setCurrent(a, (Displayable)this);
        } else if (cmd == this._sendMessageCmd) {
            this.sendNewMessage();
        } else if (cmd == this._downloadCmd) {
            if (!this.mmsLimitCheck()) {
                FGApp.getInstance().setMMSState(1);
                ChatLine curHighlightLine = this._chatVFM.getHighlightLine();
                try {
                    byte[] data = Serializer.serializeSkeleton(curHighlightLine._fmsg);
                    this._curDownloadingLine = curHighlightLine;
                    FGApp.getInstance().sendToBG(data, (byte)50);
                    curHighlightLine._fmsg.status |= 0x100;
                    this.resetCmdState();
                    this.mmsXferProgress(0);
                }
                catch (Exception x) {
                    Utilities.logData("couldn't serialize stub for download req: " + x.toString());
                }
            }
        } else if (cmd == this._cancelDownloadCmd) {
            FGApp.getInstance().sendCancelXfer();
            if (this._curDownloadingLine != null) {
                this._curDownloadingLine.setLabel(Res.getString(64));
                this.doRepaint();
            } else if (this._curUploadingLine != null) {
                this._curUploadingLine.setLabel(Res.getString(64));
                this.doRepaint();
            }
        } else if (cmd == this._retryCmd) {
            if (!this.mmsLimitCheck()) {
                ChatLine curHighlightLine = this._chatVFM.getHighlightLine();
                try {
                    FGApp fgApp = FGApp.getInstance();
                    fgApp.setMMSState(1);
                    byte[] data = Serializer.serialize(curHighlightLine._fmsg.key);
                    fgApp.sendToBG(data, (byte)60);
                    curHighlightLine._fmsg.status = 1;
                    this._curUploadingLine = curHighlightLine;
                    this._curUploadingLine.setLabel(Res.getString(125) + "0%");
                    if (this._curUploadingLine._fmsg.media_wa_type == 1) {
                        this._unprocessedImageLine = this._curUploadingLine;
                    }
                    this.resetCmdState();
                    this.doRepaint();
                }
                catch (Throwable t) {
                    Utilities.logData("problem doing upload retry from chatpane: " + t.toString());
                }
            }
        } else if (cmd == this._viewCmd) {
            Runtime r = Runtime.getRuntime();
            Utilities.logData("in ChatPane, free mem before view media: " + r.freeMemory());
            ChatLine curHighlightLine = this._chatVFM.getHighlightLine();
            final MediaData md = (MediaData)curHighlightLine._fmsg.thumb_image;
            curHighlightLine._fmsg.acceptVisitor(new FunXMPP.FMessageVisitor(){

                public void undefined(FunXMPP.FMessage fMessage) {
                }

                public void image(FunXMPP.FMessage fMessage) {
                    String useFilename = md.scaledFilename;
                    if (useFilename == null) {
                        Alert failAlrt = new Alert(Constants.STRING_EMPTY_STRING, Res.getString(96), null, AlertType.INFO);
                        ContactListMidlet.getInstance()._display.setCurrent(failAlrt, (Displayable)ChatPane.this);
                    } else {
                        ImageDisplayForm idForm = new ImageDisplayForm((Displayable)ChatPane.this, fMessage.timestamp, useFilename, null);
                        FGApp.getInstance().setTopPane((Object)idForm);
                        ContactListMidlet.getInstance()._display.setCurrent((Displayable)idForm);
                    }
                }

                public void audio(FunXMPP.FMessage fMessage) {
                    AudioDisplayForm audForm = new AudioDisplayForm((Displayable)ChatPane.this, fMessage.timestamp, md.filename, md.mimeType, null);
                    FGApp.getInstance().setTopPane((Object)audForm);
                    ContactListMidlet.getInstance()._display.setCurrent((Displayable)audForm);
                }

                public void video(FunXMPP.FMessage fMessage) {
                    VideoDisplayForm vidForm = new VideoDisplayForm((Displayable)ChatPane.this, fMessage.timestamp, md.filename, md.mimeType, null);
                    FGApp.getInstance().setTopPane((Object)vidForm);
                    ContactListMidlet.getInstance()._display.setCurrent((Displayable)vidForm);
                }

                public void contact(FunXMPP.FMessage fMessage) {
                }

                public void location(FunXMPP.FMessage fMessage) {
                    try {
                        String gmapURL = "http://maps.google.com/maps?f=q&source=s_q&geocode=&q=" + fMessage.latitude + "," + fMessage.longitude + "&z=17";
                        boolean exitNeeded = ContactListMidlet.getInstance().platformRequest(gmapURL);
                        if (exitNeeded) {
                            ContactListMidlet.getInstance().notifyDestroyed();
                        }
                    }
                    catch (ConnectionNotFoundException ex) {
                        Utilities.logData("couldn't launch external maps URL error: " + ex.toString());
                    }
                }

                public void system(FunXMPP.FMessage fMessage) {
                }
            });
        } else if (cmd == this._moreMessagesCmd) {
            Thread t = new Thread(){

                public void run() {
                    try {
                        Utilities.logData("tring to show more messages in chatpane");
                        ChatPane.this.showMoreMessages();
                    }
                    catch (Throwable t) {
                        Utilities.logData("more messaeges blowup: " + t.toString());
                    }
                }
            };
            t.start();
        } else {
            return super.commandAction(cmd, field);
        }
        return true;
    }

    private void sendNewMessage() {
        String body = this._inputEditor.editor.getContent().trim();
        if (body == null || body.length() == 0) {
            return;
        }
        this._inputEditor.editor.delete(0, this._inputEditor.editor.size());
        final FunXMPP.FMessage fmsg = new FunXMPP.FMessage(this._jid, body, null);
        ChatLine cl = new ChatLine(fmsg, this);
        this._chatVFM.appendChatLine(cl);
        this._chatVFM.snapDown();
        if (this._sentMsgs == null) {
            this._sentMsgs = new Hashtable();
        }
        this._sentMsgs.put(fmsg.key, fmsg);
        this.doRepaint();
        FGApp.getInstance().getMessageStore().putMessageToTemp(fmsg, new MessageStore.CompletionCallback(){

            public void operationCompleted() {
                FGApp.getInstance().sendNewMessage(fmsg);
            }
        });
    }

    public void sendNewMMSMessage(final MediaData md) {
        ChatLine cl;
        Utilities.logData("sending new MMS message from FG to " + this._jid);
        this._curUploadingLine = cl = new ChatLine(md.fmsg, this);
        cl.setLabel(Res.getString(125) + "0%");
        if (md.fmsg.media_wa_type == 1) {
            this._unprocessedImageLine = cl;
        }
        this._chatVFM.appendChatLine(cl);
        this._chatVFM.snapDown();
        if (this._sentMsgs == null) {
            this._sentMsgs = new Hashtable();
        }
        this._sentMsgs.put(md.fmsg.key, md.fmsg);
        this.doRepaint();
        FGApp.getInstance().getMessageStore().putMessageToTemp(md.fmsg, new MessageStore.CompletionCallback(){

            public void operationCompleted() {
                FGApp.getInstance().sendNewMMSMessage(md.fmsg, md.filename, md.mimeType);
            }
        });
    }

    public void mmsXferCancelled() {
        if (this._curDownloadingLine != null) {
            this._curDownloadingLine.setLabel(Res.getString(86, MediaDisplay.getLocalizedFMessageType(this._curDownloadingLine._fmsg)));
            this._curDownloadingLine._fmsg.status &= 0xFFFFFEFF;
            this._curDownloadingLine = null;
            this.resetCmdState();
            this.doRepaint();
        } else if (this._curUploadingLine != null) {
            this._curUploadingLine.setLabel("not uploaded");
            this._curUploadingLine._fmsg.status = 0;
            this._curUploadingLine = null;
            this.resetCmdState();
            this.doRepaint();
        }
    }

    public void mmsDownloadFinished(boolean success, String url, String payload, String payload2) {
        if (success) {
            Utilities.logData("chat pane sees successful dl finished for " + url + " with payloads " + payload + " ; " + payload2);
        }
        if (this._curDownloadingLine != null && url.equals(this._curDownloadingLine._fmsg.media_url)) {
            MediaData md = (MediaData)this._curDownloadingLine._fmsg.thumb_image;
            this._curDownloadingLine._fmsg.status &= 0xFFFFFEFF;
            if (success) {
                md.setFilename(new String[]{payload, payload2});
            } else {
                Alert failAlrt = new Alert(Res.getString(85), payload, null, AlertType.ERROR);
                ContactListMidlet.getInstance()._display.setCurrent(failAlrt, (Displayable)this);
            }
            this._curDownloadingLine.updateMMSLabel();
            this._curDownloadingLine = null;
            this.resetCmdState();
            this.doRepaint();
            return;
        }
    }

    public void mmsXferProgress(int percentComplete) {
        if (this._curDownloadingLine != null) {
            this._curDownloadingLine.setLabel(Res.getString(87) + percentComplete + '%');
            this.doRepaint();
        } else if (this._curUploadingLine != null) {
            this._curUploadingLine.setLabel(Res.getString(169) + percentComplete + '%');
            this.doRepaint();
        }
    }

    public void mmsProcessProgress(int milestone) {
        if (this._curUploadingLine != null) {
            if (milestone == 1) {
                this._curUploadingLine.setLabel(Res.getString(125) + "20%");
                this._curUploadingLine.reloadFMsg();
                this.doRepaint();
            } else if (milestone == 3) {
                this._curUploadingLine.setLabel(Res.getString(125) + "70%");
                this.doRepaint();
            } else if (milestone == 2) {
                this._curUploadingLine.reloadFMsg();
                this._unprocessedImageLine = null;
            }
        } else if (this._unprocessedImageLine != null && milestone == 2) {
            this._unprocessedImageLine.reloadFMsg();
            this._unprocessedImageLine = null;
        }
    }

    public void mmsUploadFinished(boolean success) {
        if (this._curUploadingLine != null) {
            this._curUploadingLine.reloadFMsg();
            this._curUploadingLine.updateMMSLabel();
            this._curUploadingLine = null;
            this.resetCmdState();
            this.doRepaint();
        }
    }

    private void showNewMessage(FunXMPP.FMessage message) {
        MediaData md = (MediaData)message.thumb_image;
        if (md != null) {
            md.inflate();
        }
        ChatLine cl = new ChatLine(message, this);
        this._chatVFM.appendChatLine(cl);
        this._receivedMsgs.put(message.key, message.key);
        if (!this._isGroup) {
            this.setStatus(Res.getString(110));
        }
        FGApp.getInstance().paneReadMessage(message);
        if (this._chatVFM.getHighlightLine() == cl) {
            this.onHighlightChanged();
        }
        this.doRepaint();
    }

    private boolean irrelevantRedundantCheck(FunXMPP.FMessage message) {
        String remote_jid = message.key.remote_jid;
        if (this._jid.equals(remote_jid)) {
            return !message.key.from_me && this._receivedMsgs.containsKey(message.key);
        }
        boolean needsRepaint = false;
        for (int i = 0; i < this._tabJids.length; ++i) {
            if (!this._tabJids[i].equals(remote_jid)) continue;
            this._tabRow.setHighlight(i, true);
            needsRepaint = true;
        }
        if (needsRepaint) {
            this.doRepaint();
        }
        return true;
    }

    public void newFullMessage(FunXMPP.FMessage message) {
        if (!this.irrelevantRedundantCheck(message)) {
            this.showNewMessage(message);
        }
    }

    public void newSkeletalMessage(FunXMPP.FMessage message) {
        if (!this.irrelevantRedundantCheck(message)) {
            FunXMPP.FMessage realMessage;
            if (message.media_wa_type == 0 || message.media_wa_type == 1 || message.media_wa_type == 3 || message.media_wa_type == 5) {
                realMessage = FGApp.getInstance().getMessageStore().getMessage(message.key);
                if (realMessage == null) {
                    Utilities.logData("ERROR skeletal said to get message with key " + message.key + " but it wwasn't in store.");
                    return;
                }
            } else {
                realMessage = message;
            }
            this.showNewMessage(realMessage);
        }
    }

    public void messageReceipt(FunXMPP.FMessage.Key msgKey, int status) {
        if (this._sentMsgs == null || !msgKey.remote_jid.equals(this._jid)) {
            return;
        }
        FunXMPP.FMessage fmsg = (FunXMPP.FMessage)this._sentMsgs.get(msgKey);
        if (fmsg != null) {
            fmsg.status = status;
            this.safeRepaint();
        } else {
            Utilities.logData("receipt message " + msgKey.toString() + " not found in sent table.");
        }
    }

    public void chatHistoryDeleted(String jid) {
        Utilities.logData("history " + jid + " deleted while chat pane for " + this._jid + " on screen?");
    }

    public void groupChatMetadataUpdate(String gjid) {
        if (gjid.equals(this._jid)) {
            this._tabRow.setName(this._tabRow.getCenter(), FGApp.getInstance().getDisplayableNameFromJid(this._jid));
        }
    }

    public void contactsLoadedNameReset() {
        if (this._isGroup) {
            int s = this._chatVFM.getNumChildren();
            FGApp fgApp = FGApp.getInstance();
            for (int i = 0; i < s; ++i) {
                UIField f = this._chatVFM.getChildAt(i);
                if (!(f instanceof ChatGroupBubble)) continue;
                ChatGroupBubble cgB = (ChatGroupBubble)f;
                ChatLine firstCL = cgB.firstChatline();
                cgB.setText(fgApp.getDisplayableNameFromJid(firstCL._fmsg.remote_resource));
            }
            this.doRepaint();
        }
    }

    public void newChatState(int newState) {
        if (this._isGroup) {
            return;
        }
        FGApp fgApp = FGApp.getInstance();
        if (newState != 0) {
            this.setStatus(null);
        } else {
            fgApp.requestContactChatState(this._jid);
        }
    }

    public void newContactChatState(String jid, int newState, long timestamp) {
        if (this._jid.equals(jid)) {
            String formattedState;
            switch (newState) {
                default: {
                    if (timestamp == 0L) {
                        formattedState = Constants.STRING_EMPTY_STRING;
                        break;
                    }
                    formattedState = FGApp.XMPPJabberLast.getFormattedLastSeen(timestamp);
                    break;
                }
                case 1: {
                    formattedState = Res.getString(110);
                    break;
                }
                case 0: {
                    formattedState = Res.getString(166);
                }
            }
            this.setStatus(formattedState);
        }
    }

    protected boolean handleKeyPressed(int keycode) {
        if (super.handleKeyPressed(keycode)) {
            return true;
        }
        switch (keycode) {
            case 82: 
            case 114: {
                this.moveFocus(this._inputEditor);
                return true;
            }
            case 66: 
            case 98: {
                this._chatVFM.snapDown();
                this.onHighlightChanged();
                this.doRepaint();
                return true;
            }
            case 84: 
            case 116: {
                this._chatVFM.snapTop();
                this.onHighlightChanged();
                this.doRepaint();
                return true;
            }
            case -4: {
                this.openTab(1);
                return true;
            }
            case -3: {
                this.openTab(-1);
                return true;
            }
        }
        return false;
    }

    public void inputAction(InputEditorField inputEditor, int actions) {
        if ((actions & 1) != 0) {
            boolean enabled;
            int idx;
            boolean containsNewline = false;
            while ((idx = this._inputEditor.editor.getContent().indexOf(10)) != -1) {
                this._inputEditor.editor.delete(idx, 1);
                containsNewline = true;
            }
            if (containsNewline) {
                this.sendNewMessage();
            }
            boolean bl = enabled = this._inputEditor.editor.size() > 0;
            if (enabled != this._sendMessageCmd.isEnabled()) {
                this._sendMessageCmd.setEnabled(enabled);
                this.doRepaint();
            }
        }
        super.inputAction(inputEditor, actions);
    }

    protected void hideNotify() {
        this._hidden = true;
        this._inputEditor.setVisible(false);
    }

    protected void showNotify() {
        this._hidden = false;
        FGApp.getInstance().requestNotificationState(false);
        this._inputEditor.setVisible(true);
    }

    private void downloadableCommandSet(FunXMPP.FMessage fMessage) {
        MediaData md = (MediaData)fMessage.thumb_image;
        if (md == null) {
            return;
        }
        if (fMessage.status == 1) {
            this._chatVFM.removeFieldCommand(this._retryCmd);
            this._chatVFM.removeFieldCommand(this._viewCmd);
            this._chatVFM.removeFieldCommand(this._downloadCmd);
            this._chatVFM.setDefaultCommand(this._cancelDownloadCmd);
        } else if (fMessage.key.from_me && (fMessage.media_url == null || fMessage.media_url.length() == 0)) {
            this._chatVFM.removeFieldCommand(this._viewCmd);
            this._chatVFM.removeFieldCommand(this._downloadCmd);
            this._chatVFM.removeFieldCommand(this._cancelDownloadCmd);
            this._chatVFM.setDefaultCommand(this._retryCmd);
        } else if (md.downloaded) {
            this._chatVFM.removeFieldCommand(this._retryCmd);
            this._chatVFM.removeFieldCommand(this._cancelDownloadCmd);
            this._chatVFM.removeFieldCommand(this._downloadCmd);
            this._chatVFM.setDefaultCommand(this._viewCmd);
        } else {
            this._chatVFM.removeFieldCommand(this._retryCmd);
            if ((fMessage.status & 0x100) > 0) {
                this._chatVFM.removeFieldCommand(this._viewCmd);
                this._chatVFM.removeFieldCommand(this._downloadCmd);
                this._chatVFM.setDefaultCommand(this._cancelDownloadCmd);
            } else {
                this._chatVFM.removeFieldCommand(this._viewCmd);
                this._chatVFM.removeFieldCommand(this._cancelDownloadCmd);
                this._chatVFM.setDefaultCommand(this._downloadCmd);
            }
        }
    }

    private void resetTimestamp() {
        ChatLine line = this._chatVFM.getHighlightLine();
        if (line != null && this._chatVFM.hasFocus()) {
            this.setTimestamp(DateTimeUtilities.formatTimestamp(line._fmsg.timestamp));
        } else {
            this.setTimestamp(null);
        }
    }

    private void resetCmdState() {
        ChatLine curHighlightLine = this._chatVFM.getHighlightLine();
        int curHighlightIndex = this._chatVFM.getHighlightIndex();
        if (curHighlightLine == null) {
            Utilities.logData("reset command state doesn't see highlighted line");
            return;
        }
        if (curHighlightIndex == 0 && !this._dontShowMore) {
            this._chatVFM.setDefaultCommand(this._moreMessagesCmd);
        } else {
            this._chatVFM.removeFieldCommand(this._moreMessagesCmd);
        }
        FunXMPP.FMessage fmsg = curHighlightLine._fmsg;
        fmsg.acceptVisitor(new FunXMPP.FMessageVisitor(){

            public void undefined(FunXMPP.FMessage fMessage) {
                ChatPane.this._chatVFM.removeFieldCommand(ChatPane.this._viewCmd);
                ChatPane.this._chatVFM.removeFieldCommand(ChatPane.this._cancelDownloadCmd);
                ChatPane.this._chatVFM.removeFieldCommand(ChatPane.this._downloadCmd);
                ChatPane.this._chatVFM.removeFieldCommand(ChatPane.this._retryCmd);
            }

            public void image(FunXMPP.FMessage fMessage) {
                ChatPane.this.downloadableCommandSet(fMessage);
            }

            public void audio(FunXMPP.FMessage fMessage) {
                ChatPane.this.downloadableCommandSet(fMessage);
            }

            public void video(FunXMPP.FMessage fMessage) {
                ChatPane.this.downloadableCommandSet(fMessage);
            }

            public void contact(FunXMPP.FMessage fMessage) {
                ChatPane.this._chatVFM.removeFieldCommand(ChatPane.this._cancelDownloadCmd);
                ChatPane.this._chatVFM.removeFieldCommand(ChatPane.this._downloadCmd);
                ChatPane.this._chatVFM.removeFieldCommand(ChatPane.this._retryCmd);
                ChatPane.this._chatVFM.setDefaultCommand(ChatPane.this._viewCmd);
            }

            public void location(FunXMPP.FMessage fMessage) {
                ChatPane.this._chatVFM.removeFieldCommand(ChatPane.this._cancelDownloadCmd);
                ChatPane.this._chatVFM.removeFieldCommand(ChatPane.this._downloadCmd);
                ChatPane.this._chatVFM.removeFieldCommand(ChatPane.this._retryCmd);
                ChatPane.this._chatVFM.setDefaultCommand(ChatPane.this._viewCmd);
            }

            public void system(FunXMPP.FMessage fMessage) {
                ChatPane.this._chatVFM.removeFieldCommand(ChatPane.this._viewCmd);
                ChatPane.this._chatVFM.removeFieldCommand(ChatPane.this._cancelDownloadCmd);
                ChatPane.this._chatVFM.removeFieldCommand(ChatPane.this._downloadCmd);
                ChatPane.this._chatVFM.removeFieldCommand(ChatPane.this._retryCmd);
            }
        });
    }

    public void gotMMSFileSelected(byte waType, String mimeType, String displayName, String URL2, long size) {
        if (waType == 1) {
            this._curCreator = new MMSCreator.ImageCreator(this, URL2);
            this._curCreator.postChoiceProcessFile();
        } else if (waType == 3) {
            this._curCreator = new MMSCreator.VideoCreator(this, URL2);
            this._curCreator.prePreviewProcessFile();
        } else if (waType == 2) {
            this._curCreator = new MMSCreator.AudioCreator(this, URL2);
            this._curCreator.prePreviewProcessFile();
        }
    }
}

