/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.ui.Command;
import com.whatsapp.api.ui.CommandBarField;
import com.whatsapp.api.ui.FieldManager;
import com.whatsapp.api.ui.InputEditorField;
import com.whatsapp.api.ui.S40TextEditor;
import com.whatsapp.api.ui.UIField;
import com.whatsapp.api.ui.UIOverlay;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class CanvasScreen
extends Canvas
implements InputEditorField.Listener,
Command.Listener {
    protected final CommandBarField _cmdBar = new CommandBarField();
    protected final FieldManager _screenMgr = new FieldManager(40L, true);
    protected final int backgroundColor;
    protected int width;
    protected int height;

    public CanvasScreen(int backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.setFullScreenMode(true);
        this._cmdBar.setParent(this);
        this._cmdBar.setCommandListener(this);
        this._screenMgr.setCommandBar(this._cmdBar);
        this._screenMgr.add(this._cmdBar);
        this.doRelayout();
    }

    public void addField(UIField field) {
        this._screenMgr.add(field);
    }

    public void insertFieldAt(UIField field, int index) {
        this._screenMgr.insertAt(field, Math.max(1, index));
    }

    public void removeField(UIField field) {
        this._screenMgr.remove(field);
    }

    public void addOverlay(UIOverlay overlay) {
        this._screenMgr.addOverlay(overlay);
    }

    public void removeOverlay(UIOverlay overlay) {
        this._screenMgr.removeOverlay(overlay);
    }

    public void moveFocus(UIField field) {
        this._screenMgr.moveFocus(field);
        this.onFocusChanged();
    }

    public void traverse(int dir) {
        if (!this._screenMgr.traverse(dir)) {
            this._screenMgr.traverse(dir == 1 ? 6 : 1);
        }
        this.onFocusChanged();
    }

    public void addCommand(Command cmd) {
        this._cmdBar.addCommand(cmd);
    }

    public void removeCommand(Command cmd) {
        this._cmdBar.removeCommand(cmd);
    }

    protected void onFocusChanged() {
    }

    public boolean commandAction(Command cmd, UIField field) {
        if (cmd == this._cmdBar.optionsCmd || cmd == this._cmdBar.menuCloseCmd) {
            this.onFocusChanged();
        }
        return false;
    }

    protected void keyPressed(int keycode) {
        if (!this.handleKeyPressed(keycode)) {
            super.keyPressed(keycode);
        }
    }

    protected void keyRepeated(int keycode) {
        if (!this.handleKeyPressed(keycode)) {
            super.keyRepeated(keycode);
        }
    }

    protected boolean handleKeyPressed(int keycode) {
        if (this._cmdBar.keyPressed(keycode)) {
            return true;
        }
        switch (keycode) {
            case -1: {
                this.traverse(1);
                this.doRepaint();
                return true;
            }
            case -2: {
                this.traverse(6);
                this.doRepaint();
                return true;
            }
        }
        return false;
    }

    public void inputAction(InputEditorField inputEditor, int actions) {
        S40TextEditor s40Editor;
        if ((actions & 0x80) != 0) {
            this.doRepaint();
        }
        if ((actions & 0x20) != 0) {
            this.doRepaint();
        }
        if ((actions & 1) != 0 && inputEditor.needsLayout()) {
            this.doRepaint();
        }
        if ((actions & 0x10) != 0) {
            this.keyPressed(-2);
        }
        if ((actions & 8) != 0) {
            this.keyPressed(-1);
        }
        if ((s40Editor = inputEditor.s40Editor) != null) {
            if ((actions & s40Editor.getConstant(11)) != 0) {
                this.keyPressed(-3);
            }
            if ((actions & s40Editor.getConstant(12)) != 0) {
                this.keyPressed(-4);
            }
        }
    }

    protected void sizeChanged(int width, int height) {
        this.width = width;
        this.height = height;
        this.doRepaint();
    }

    protected void doRelayout() {
        this._screenMgr.layout(this.width, this.height);
    }

    protected void doRepaint() {
        this.doRelayout();
        this.repaint();
    }

    protected void paint(Graphics g) {
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.width, this.height);
        this._screenMgr.paint(g, 0, 0, this.width, this.height);
    }
}

