/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.nokia.mid.s40.bg.BGUtils;
import com.nokia.mid.s40.io.LocalMessageProtocolConnection;
import com.nokia.mid.s40.io.LocalMessageProtocolServerConnection;
import com.nokia.mid.ui.DeviceControl;
import com.nokia.mid.ui.lcdui.Indicator;
import com.nokia.mid.ui.lcdui.IndicatorManager;
import com.whatsapp.api.contacts.ColdSyncer;
import com.whatsapp.api.contacts.Favorites;
import com.whatsapp.api.contacts.StatusUpdater;
import com.whatsapp.api.contacts.Syncer;
import com.whatsapp.api.sapi.ActiveStandby;
import com.whatsapp.api.sapi.ActiveStandbyListener;
import com.whatsapp.api.sapi.NMS;
import com.whatsapp.api.sapi.NMSListener;
import com.whatsapp.api.sapi.PhoneStatus;
import com.whatsapp.api.sapi.PhoneStatusListener;
import com.whatsapp.api.sapi.Profiles;
import com.whatsapp.api.sapi.ProfilesListener;
import com.whatsapp.api.sapi.SAPIContactListener;
import com.whatsapp.api.util.DateTimeUtilities;
import com.whatsapp.api.util.LocalMessageClient;
import com.whatsapp.api.util.LocalMessageListener;
import com.whatsapp.api.util.SafeThread;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.ApplicationData;
import com.whatsapp.client.BGMMSCreator;
import com.whatsapp.client.ChatHistory;
import com.whatsapp.client.ChatHistoryCache;
import com.whatsapp.client.ChatState;
import com.whatsapp.client.CommonFileMessageStore;
import com.whatsapp.client.Constants;
import com.whatsapp.client.FunXMPP;
import com.whatsapp.client.FunXMPPRunner;
import com.whatsapp.client.MMSDownloader;
import com.whatsapp.client.MediaData;
import com.whatsapp.client.MessageStore;
import com.whatsapp.client.MessageStoreProvider;
import com.whatsapp.client.OfflineMessages;
import com.whatsapp.client.Res;
import com.whatsapp.client.Serializer;
import com.whatsapp.client.Settings;
import com.whatsapp.client.test.WhatsAppBG;
import com.whatsapp.org.bouncycastle.util.encoders.Base64Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.rms.RecordStoreException;

public class BGApp
implements FunXMPP.Listener,
FunXMPP.GroupListener,
LocalMessageListener,
PhoneStatusListener,
SAPIContactListener,
Syncer.Listener,
StatusUpdater.Listener {
    private static BGApp _instance = null;
    private boolean _initialized = false;
    private MessageStore _mStore = null;
    private OfflineMessages _offliners;
    private long _initTime;
    private LocalMessageProtocolServerConnection _lmServer;
    private LocalMessageProtocolConnection _lmConnection;
    public LocalMessageClient _lmClient;
    public boolean _systemConnectedWifi = false;
    public String _systemNetworkStatus = null;
    private PhoneStatus _phoneStatus;
    public FunXMPPRunner _xmppRunner;
    public ChatState _chatState;
    private long _lastXMPPRunnerKill = 0L;
    private MMSDownloader _mmsDownloader;
    public Hashtable _xmppRoster = new Hashtable();
    private Long _senderThreadStartTime = null;
    private Vector _pendingSendMsgs = null;
    private Object _senderThreadLock = new Object();
    private Object _xmppSendLock = new Object();
    private boolean _xmppSending = false;
    private boolean _gotGroups = false;
    public ChatHistoryCache _chatHistoryCache;
    private long _lastHotSyncStart = 0L;
    private long _lastColdSyncStart = 0L;
    private long _lastHotSyncCompletion = 0L;
    private long _lastColdSyncCompletion = 0L;
    private int _syncsLastHour = 0;
    public long _lastServerPropertiesTimestamp = 0L;
    public int _lastServerPropertiesVersion = 0;
    public String _myPlainJid;
    public static final int STATE_CHATS_REQUESTED = 4;
    public static final int STATE_CHAT_CACHE_LOADED = 8;
    private int _chatCacheLoadState = 0;
    private Indicator _unreadMessageIndicator;
    private ActiveStandby _activeStandby;
    private StandbyCallback _activeStandbyMgr;
    private Profiles _profiles;
    private ProfilesCallback _profilesMgr;

    public static synchronized BGApp getInstance() {
        if (_instance == null) {
            _instance = new BGApp();
        }
        return _instance;
    }

    public synchronized void initialize() {
        if (this._initialized) {
            return;
        }
        this._initTime = System.currentTimeMillis();
        try {
            Res.load("bg-strings");
            Res.load("common");
        }
        catch (IOException ex) {
            Utilities.logData("res/load/io-error: " + ex);
        }
        Utilities.logData("bg creating local message server");
        if (this.createLMServer()) {
            this.processIncomingLMConnections();
        } else {
            Utilities.logData("CRITICAL: LMP init failed in BG init");
        }
        Settings.addListener(new Settings.Listener(){

            public void onSettingChanged(int setting, boolean localOrigin) {
                if (!localOrigin) {
                    return;
                }
                try {
                    if (Settings.isSet(setting)) {
                        byte[] data = Settings.sendCacheUpdate(setting);
                        BGApp.this.sendToFG(data, (byte)18);
                    } else {
                        byte[] data = Settings.sendCacheRemove(setting);
                        BGApp.this.sendToFG(data, (byte)19);
                    }
                }
                catch (RecordStoreException recordStoreException) {
                    // empty catch block
                }
            }
        });
        boolean expired = ApplicationData.checkExpired(Utilities.getMidletVersion(), true);
        if (expired) {
            Utilities.logData("BGApp sees expired, no xmpp connection");
        }
        Utilities.logData("bg initializing message store");
        this._mStore = MessageStoreProvider.getMessageStore();
        CommonFileMessageStore.makeExternalThumbnailDir();
        this._offliners = new OfflineMessages();
        if (!expired) {
            this._offliners.populate();
        }
        Utilities.logData("bg initializing chat state");
        this._chatState = ChatState.initialize();
        if (!expired) {
            Utilities.logData("bg registering system listeners");
            try {
                this.registerSystemListeners();
            }
            catch (Throwable t) {
                Utilities.logData("major fail in system listeners: " + t.toString());
            }
        }
        Utilities.logData("bg registering indicator");
        try {
            this._unreadMessageIndicator = new Indicator(0, Image.createImage((String)Constants.IMAGE_ICON_INDICATOR));
            IndicatorManager indMgr = IndicatorManager.getIndicatorManager();
            int n = indMgr.appendIndicator(this._unreadMessageIndicator, false);
        }
        catch (Exception x) {
            Utilities.logData("register indicator problem: " + x.toString());
            this._unreadMessageIndicator = null;
        }
        Utilities.logData("bg initializing chat history cache");
        this._chatHistoryCache = new ChatHistoryCache();
        this._chatHistoryCache.initialize(this._mStore);
        if (!expired) {
            this._chatState._startupTaskState |= 1;
            this.setIndicatorVisible(this._chatHistoryCache.dirtyCount() > 0);
            this._activeStandbyMgr.doASUpdate();
            this.chatCacheLoaded();
        }
        Utilities.logData("bg creating fun runner");
        this._xmppRunner = new FunXMPPRunner(this);
        Utilities.logData("bg starting fun runner thread in pause");
        this._xmppRunner.start();
        this._chatState._startupTaskState |= 0x20;
        this._initialized = true;
        if (!ApplicationData.emptyChatUserID()) {
            this._myPlainJid = ApplicationData.chatUserID() + "@" + "s.whatsapp.net";
            if (!expired && ApplicationData.didFirstSync()) {
                this.initialXMPPConnection();
            }
        }
    }

    public void initialXMPPConnection() {
        SafeThread t = new SafeThread(){

            public void safeRun() {
                try {
                    Thread.sleep(4000L);
                    Utilities.logData("waking up xmpp");
                    BGApp.this._chatState.doConnect(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        t.start();
    }

    private void registerSystemListeners() {
        Runtime r = Runtime.getRuntime();
        try {
            this._phoneStatus = new PhoneStatus(this);
            Utilities.logData("trying to connect to phoneStatus with free mem " + r.freeMemory());
            this._phoneStatus.connect();
            Utilities.logData("phoneStatus connected with free " + r.freeMemory());
            this._phoneStatus.enableOrDisableNotifications(false, true, true);
            this._phoneStatus.getPhoneStatus();
        }
        catch (IOException ex) {
            this._phoneStatus.closeConnection();
        }
        catch (Throwable t) {
            Utilities.logData("uncaught throwable in register system listeners: " + t.toString());
        }
        try {
            Utilities.logData("free before AS: " + r.freeMemory());
            this._activeStandbyMgr = new StandbyCallback();
            Utilities.logData("free after AS mgr callback " + r.freeMemory());
            this._activeStandby = new ActiveStandby(this._activeStandbyMgr);
            this._activeStandby.connect();
            Utilities.logData("free after AS connect " + r.freeMemory());
        }
        catch (IOException ex) {
            this._activeStandby.closeConnection();
        }
        try {
            Utilities.logData("free before Profiles: " + r.freeMemory());
            this._profilesMgr = new ProfilesCallback();
            this._profilesMgr.start();
            this._profiles = new Profiles(this._profilesMgr);
            this._profiles.connect();
            Utilities.logData("free after Profiles connect " + r.freeMemory());
        }
        catch (IOException iox) {
            this._profiles.closeConnection();
        }
        this._mmsDownloader = new MMSDownloader();
        Utilities.logData("free after downloader: " + r.freeMemory());
    }

    public void setIndicatorVisible(boolean val) {
        if (this._unreadMessageIndicator != null) {
            this._unreadMessageIndicator.setActive(val);
        }
    }

    private boolean isFGMidletRunning() {
        int[] running = BGUtils.getRunningMIDlets((String)WhatsAppBG.midletVendor, (String)WhatsAppBG.midletName);
        for (int i = 0; i < running.length; ++i) {
            if (running[i] != 2) continue;
            return true;
        }
        return false;
    }

    private String buildChatArgs(String jid, ChatHistory hist) {
        String args = ';' + Constants.ARG_LAUNCH_JID + '=' + jid;
        if (!jid.equals(Constants.ARG_NEW_CHAT_JID) && hist != null) {
            if (hist._group != null) {
                args = args + ';' + Constants.ARG_IS_GROUP + '=' + '1' + ';' + Constants.ARG_CHAT_TITLE + '=' + hist._group._subject;
            } else {
                String name = hist._readableName;
                if (name == null) {
                    name = ChatHistory.getDisplayablePlainJid(jid);
                }
                args = args + ';' + Constants.ARG_CHAT_TITLE + '=' + name;
            }
        }
        return args;
    }

    private static String toUTF8(String str) {
        if (str == null) {
            return null;
        }
        try {
            return new String(str.getBytes(Constants.CHARSET_UTF8));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    private void launchFG(final String prompt, final String args) {
        SafeThread t = new SafeThread(){

            public void safeRun() {
                boolean res = BGUtils.launchIEMIDlet((String)WhatsAppBG.midletVendor, (String)WhatsAppBG.midletName, (int)2, (String)BGApp.toUTF8(prompt), (String)args);
            }
        };
        t.start();
    }

    private void newMessageAlert(FunXMPP.FMessage fmsg) {
        String useName;
        String jidArg = null;
        String jid = fmsg.key.remote_jid;
        ChatHistory curHist = this._chatHistoryCache.get(jid);
        if (curHist._group != null) {
            ChatHistory userHist = this._chatHistoryCache.get(fmsg.remote_resource);
            if (userHist != null) {
                String friendName = userHist._readableName;
                if (friendName == null) {
                    friendName = ChatHistory.getDisplayablePlainJid(fmsg.remote_resource);
                }
                useName = friendName + " @ \"" + curHist._group._subject + "\"";
            } else {
                useName = "group \"" + curHist._group._subject + "\"";
            }
        } else {
            useName = curHist._readableName;
            if (useName == null) {
                useName = ChatHistory.getDisplayablePlainJid(curHist._jid);
            }
        }
        String prompt = useName != null ? Res.getString(7, useName) + '\n' : Res.getString(8) + '\n';
        prompt = prompt + DateTimeUtilities.shortTimeFormat(fmsg.timestamp) + " " + ChatHistory.getPreviewText(fmsg, 25);
        if (jid != null) {
            jidArg = this.buildChatArgs(jid, curHist);
        }
        this._profilesMgr.playSoundAlert();
        this.launchFG(prompt, jidArg);
    }

    public void sendOfflineMessages() {
        this._offliners.sendAll(this);
    }

    public void clearSoftRosters() {
        this._xmppRoster.clear();
    }

    public boolean gotGroups() {
        return this._gotGroups;
    }

    private synchronized void chatsRequested() {
        if ((this._chatCacheLoadState & 8) > 0) {
            this.sendChats();
        } else {
            this._chatCacheLoadState |= 4;
        }
    }

    private synchronized void chatCacheLoaded() {
        this._chatCacheLoadState |= 8;
        if ((this._chatCacheLoadState & 4) > 0) {
            this.sendChats();
        }
    }

    private void sendChats() {
        SafeThread t = new SafeThread(){

            public void safeRun() {
                Vector v = BGApp.this._chatHistoryCache.getSortedList();
                int s = v.size();
                for (int i = 0; i < s; ++i) {
                    if (i > 6) {
                        try {
                            Thread.sleep(i * 10);
                        }
                        catch (Exception x) {
                            // empty catch block
                        }
                    }
                    ChatHistory curHist = (ChatHistory)v.elementAt(i);
                    try {
                        byte[] payload = Serializer.serialize(curHist);
                        BGApp.this.sendToFG(payload, (byte)17);
                        continue;
                    }
                    catch (Exception x) {
                        Utilities.logData("failed to send chat history " + x.toString());
                    }
                }
                BGApp.this.sendToFG(new byte[]{0}, (byte)20);
            }
        };
        t.start();
    }

    public boolean canConnect() {
        return ApplicationData.dataWhileRoaming() || this._systemConnectedWifi || this._systemNetworkStatus != null && !this._systemNetworkStatus.equals("Roam");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessageForMe(final FunXMPP.FMessage message, boolean duplicate) throws IOException {
        Utilities.logData("new incoming message " + message.key.id + " from " + message.key.remote_jid);
        if (message.wants_receipt) {
            Object object = this._xmppSendLock;
            synchronized (object) {
                try {
                    this._xmppSending = true;
                    FunXMPP.Connection fConn = this._xmppRunner._connection;
                    if (fConn != null) {
                        fConn.sendMessageReceived(message);
                    }
                }
                catch (Exception x) {
                    Utilities.logData("error trying to send receipt for " + message.key.id);
                }
                finally {
                    this._xmppSending = false;
                }
            }
        }
        if (duplicate) {
            return;
        }
        if (!message.key.from_me) {
            message.status |= 0x80;
        }
        final boolean overflowSizeMsg = message.data != null && message.data.length() > 200;
        this._mStore.putMessage(message, new MessageStore.CompletionCallback(){

            public void operationCompleted() {
                block6: {
                    BGApp.this._chatHistoryCache.newMessage(message);
                    BGApp.this.setIndicatorVisible(true);
                    boolean fgMidletRunning = BGApp.this.isFGMidletRunning();
                    if (fgMidletRunning) {
                        try {
                            if (overflowSizeMsg) {
                                byte[] skelData = Serializer.serializeSkeleton(message);
                                Utilities.logData("sending " + skelData.length + " bytes of serialized skeletal overflow");
                                BGApp.this.sendToFG(skelData, (byte)11);
                                break block6;
                            }
                            byte[] fullData = Serializer.serialize(message);
                            BGApp.this.sendToFG(fullData, (byte)10);
                        }
                        catch (Exception x) {
                            Utilities.logData("skeleton serialize fail: " + x.toString());
                        }
                    } else if (!message.offline || !BGApp.this._chatState._didOneOfflineAlert) {
                        BGApp.this.newMessageAlert(message);
                        BGApp.this._chatState._didOneOfflineAlert = true;
                    }
                }
                BGApp.this._activeStandbyMgr.doASUpdate();
                Utilities.logData("delivery complete for " + message.key.id);
            }
        });
    }

    public void onMessageStatusUpdate(final FunXMPP.FMessage message) {
        if (message.status == 4 || message.status == 5) {
            this._offliners.remove(message);
        }
        this._mStore.updateMessageStatus(message, false, new MessageStore.CompletionCallback(){

            public void operationCompleted() {
                try {
                    byte[] data = Serializer.serialize(new FmsgKeyStatus(message));
                    BGApp.this.sendToFG(data, (byte)5);
                }
                catch (Exception x) {
                    Utilities.logData("fail trying to serialize after status update: " + x.toString());
                }
            }
        });
        this._chatHistoryCache.messageReceipt(message.key, message.status);
    }

    public void onMessageError(FunXMPP.FMessage msg, int code) {
        Utilities.logData("message error received for " + msg.key.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPing(String id2) throws IOException {
        Object object = this._xmppSendLock;
        synchronized (object) {
            this._xmppSending = true;
            FunXMPP.Connection fconn = this._xmppRunner._connection;
            if (fconn != null) {
                try {
                    Utilities.logData("got ping id " + id2 + ", sending pong");
                    fconn.sendPong(id2);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            this._xmppSending = false;
        }
    }

    public void onPingResponseReceived() {
        Utilities.logData("ping response received");
    }

    public void onAvailable(String jid, boolean what) {
        int state;
        long lastSeen;
        String nakedJid = FunXMPP.removeResourceFromJID(jid);
        ContactRosterInfo roster = (ContactRosterInfo)this._xmppRoster.get(nakedJid);
        if (roster == null) {
            roster = new ContactRosterInfo();
            roster._subSent = true;
            this._xmppRoster.put(nakedJid, roster);
        } else {
            roster._subSent = true;
        }
        if (what) {
            lastSeen = 0L;
            state = 1;
            Utilities.logData("here: " + nakedJid);
        } else {
            lastSeen = System.currentTimeMillis();
            state = 2;
            Utilities.logData("gone: " + nakedJid);
        }
        roster._lastSeen = lastSeen;
        try {
            byte[] msgdata = Serializer.serialize(new ContactChatInfo(nakedJid, state, lastSeen));
            this.sendToFG(msgdata, (byte)4);
        }
        catch (Exception x) {
            Utilities.logData("failed to serialize contact chat info for " + jid);
        }
    }

    public void onClientConfigReceived(String push_id) {
        Utilities.logData("client config received with id " + push_id);
    }

    public void onLastSeen(String jid, int seconds, String status) {
        String nakedJid = FunXMPP.removeResourceFromJID(jid);
        Utilities.logData("last seen info for " + nakedJid + ", " + seconds + " seconds");
        ContactRosterInfo roster = (ContactRosterInfo)this._xmppRoster.get(nakedJid);
        if (roster != null && roster._lastSeen == 0L) {
            Utilities.logData("login/status race for user " + nakedJid + "? not overwriting last seen");
            return;
        }
        long millis = (long)seconds * 1000L;
        long lastSeen = System.currentTimeMillis() - millis;
        if (roster == null) {
            roster = new ContactRosterInfo();
            this._xmppRoster.put(nakedJid, roster);
        }
        roster._lastSeen = lastSeen;
        try {
            byte[] msgdata = Serializer.serialize(new ContactChatInfo(nakedJid, 2, lastSeen));
            this.sendToFG(msgdata, (byte)4);
        }
        catch (Exception x) {
            Utilities.logData("failed to serialize contact chat info for " + jid);
        }
    }

    public void onIsTyping(String jid, boolean what) {
        String nakedJid = FunXMPP.removeResourceFromJID(jid);
        ContactRosterInfo roster = (ContactRosterInfo)this._xmppRoster.get(nakedJid);
        if (roster == null || roster._lastSeen != 0L) {
            return;
        }
        int stateCode = what ? 0 : 1;
        this._chatHistoryCache.newContactChatState(jid, stateCode);
        try {
            byte[] msgdata = Serializer.serialize(new ContactChatInfo(nakedJid, stateCode, 0L));
            this.sendToFG(msgdata, (byte)4);
        }
        catch (Exception x) {
            Utilities.logData("failed to serialize contact chat info for " + jid);
        }
    }

    public void onAccountChange(int account_type, long expiration_date) {
    }

    public void onPrivacyBlockListAdd(String jid) {
    }

    public void onPrivacyBlockListClear() {
    }

    public void onDirty(Hashtable categories) {
    }

    public void onDirtyResponse(Hashtable categories) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGroupAddUser(String gjid, String jid) {
        Utilities.logData("GRP seeing group add user " + jid + " for " + gjid);
        if (jid.equals(this._myPlainJid)) {
            this._chatHistoryCache.addGroupChat(gjid, null, 0, null, 0);
            Object object = this._xmppSendLock;
            synchronized (object) {
                this._xmppSending = true;
                FunXMPP.Connection fConn = this._xmppRunner._connection;
                if (fConn != null) {
                    try {
                        fConn.sendGetGroupInfo(gjid);
                        fConn.sendGetParticipants(gjid);
                    }
                    catch (Exception x) {
                        Utilities.logData("error requesting group info or participants after being added: " + gjid);
                    }
                }
                this._xmppSending = false;
            }
        }
        if (this._chatHistoryCache.groupChatAddUser(gjid, jid)) {
            this._mStore.addGroupUser(gjid, jid);
            this.participantChangeSystemMessage(gjid, jid, true);
        }
    }

    public void onGroupRemoveUser(String gjid, String jid) {
        Utilities.logData("GRP seeing group remove user " + jid + " for " + gjid);
        if (this._chatHistoryCache.groupChatRemoveUser(gjid, jid)) {
            this._mStore.removeGroupUser(gjid, jid);
            this.participantChangeSystemMessage(gjid, jid, false);
        }
    }

    public void onGroupNewSubject(String gjid, String ujid, String subject, int timestamp) {
        Utilities.logData("GRP subject for " + gjid + " is " + subject + " user " + ujid);
        this._mStore.putGroupSubject(gjid, subject);
        this._chatHistoryCache.addGroupChat(gjid, null, 0, subject, timestamp);
        try {
            byte[] msgdata = Serializer.serializeGroupMetadata(gjid, null, subject, null, timestamp, 0);
            this.sendToFG(msgdata, (byte)41);
        }
        catch (Exception x) {
            Utilities.logData("failed to serialize group chat info for " + gjid);
        }
        final FunXMPP.FMessage newMsg = this.createSystemMessage(gjid, ujid, "nsub-", 47, subject);
        newMsg.status |= 0x80;
        this._mStore.putMessage(newMsg, new MessageStore.CompletionCallback(){

            public void operationCompleted() {
                BGApp.this._chatHistoryCache.newMessage(newMsg);
                BGApp.this.setIndicatorVisible(true);
                boolean fgMidletRunning = BGApp.this.isFGMidletRunning();
                if (fgMidletRunning) {
                    try {
                        byte[] fullData = Serializer.serialize(newMsg);
                        BGApp.this.sendToFG(fullData, (byte)10);
                    }
                    catch (Exception x) {
                        Utilities.logData("system message serialize fail: " + x.toString());
                    }
                } else {
                    BGApp.this.newMessageAlert(newMsg);
                }
                BGApp.this._activeStandbyMgr.doASUpdate();
                Utilities.logData("delivery complete for " + newMsg.key.id);
            }
        });
    }

    public void onServerProperties(int version, Hashtable nameValueMap) {
        Utilities.logData("GRP seeing server properties version " + version);
        this._lastServerPropertiesVersion = version;
        this._lastServerPropertiesTimestamp = System.currentTimeMillis();
        try {
            int maxParticipants = Integer.parseInt((String)nameValueMap.get("max_participants"));
            int maxSubject = Integer.parseInt((String)nameValueMap.get("max_subject"));
            int maxGroups = Integer.parseInt((String)nameValueMap.get("max_groups"));
            if (ApplicationData.groupMaxGropups() != maxGroups) {
                Settings.set(15, maxGroups);
            }
            if (ApplicationData.groupMaxParticipants() != maxParticipants) {
                Settings.set(13, maxParticipants);
            }
            if (ApplicationData.groupMaxSubject() != maxSubject) {
                Settings.set(14, maxSubject);
            }
        }
        catch (Throwable t) {
            Utilities.logData("server properties blowup: " + t.toString());
        }
    }

    public void onGroupCreated(String gjid, String subject) {
    }

    public void onGroupInfo(String gjid, String owner, String subject, String subject_owner_jid, int subject_t, int creation) {
        Utilities.logData("GRP group info for " + gjid + " subject " + subject);
        String oldSub = this._chatHistoryCache.addGroupChat(gjid, owner, creation, subject, subject_t);
        if (subject != null && !subject.equals(oldSub)) {
            this._mStore.putGroupSubject(gjid, subject);
        }
        try {
            byte[] msgdata = Serializer.serializeGroupMetadata(gjid, owner, subject, subject_owner_jid, subject_t, creation);
            this.sendToFG(msgdata, (byte)41);
        }
        catch (Exception x) {
            Utilities.logData("failed to serialize group chat info for " + gjid);
        }
    }

    public void onGroupInfoFromList(String gjid, String owner, String subject, String subject_owner_jid, int subject_t, int creation) {
        this.onGroupInfo(gjid, owner, subject, subject_owner_jid, subject_t, creation);
    }

    public void onOwningGroups(Vector groups) {
        if (groups != null) {
            Utilities.logData("GRP seeing owning groups " + groups.size());
        }
    }

    public void onSetSubject(String gjid) {
    }

    public void onAddGroupParticipants(String gjid, Vector successJids, Hashtable failTable) {
    }

    public void onRemoveGroupParticipants(String gjid, Vector successVector, Hashtable failTable) {
    }

    public void onGetParticipants(String gjid, Vector participants) {
        int i;
        int size = participants.size();
        Utilities.logData("GRP got " + size + " participants for " + gjid);
        ChatHistory.Group curGroup = this._chatHistoryCache.getGroupChat(gjid, false);
        if (curGroup == null) {
            Utilities.logData("ASSERT FAIL: no group in cache when we got participants " + gjid);
            return;
        }
        Vector adds = new Vector();
        Vector drops = new Vector();
        curGroup.computeAddDropSets(participants, adds, drops);
        for (i = 0; i < drops.size(); ++i) {
            String goneJid = (String)drops.elementAt(i);
            curGroup.removeParticipant(goneJid);
            this._mStore.removeGroupUser(gjid, goneJid);
            this.participantChangeSystemMessage(gjid, goneJid, false);
            Utilities.logData("getParticipants group set compare resulted in remove of " + goneJid);
        }
        for (i = 0; i < adds.size(); ++i) {
            String newJid = (String)adds.elementAt(i);
            curGroup.addParticipant(newJid);
            this._mStore.addGroupUser(gjid, newJid);
            this.participantChangeSystemMessage(gjid, newJid, true);
            Utilities.logData("getParticipants group set compare resulted in add of " + newJid);
        }
    }

    public void onParticipatingGroups(final Vector groups) {
        Utilities.logData("GRP particpating in " + groups.size() + " groups");
        final FunXMPP.Connection fConn = this._xmppRunner._connection;
        if (fConn != null) {
            SafeThread t = new SafeThread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void safeRun() {
                    Object object = BGApp.this._xmppSendLock;
                    synchronized (object) {
                        BGApp.this._xmppSending = true;
                        try {
                            for (int i = 0; i < groups.size(); ++i) {
                                String curJid = (String)groups.elementAt(i);
                                String cachedSubject = BGApp.this._chatHistoryCache.addGroupChat(curJid, null, 0, null, 0);
                                if (cachedSubject == null) {
                                    Utilities.logData("sending general GRP query about " + curJid);
                                    fConn.sendGetGroupInfo(curJid);
                                }
                                fConn.sendGetParticipants(curJid);
                            }
                            fConn.sendClearDirty(Constants.DIRTY_CATEGORY_GROUPS);
                            BGApp.this._gotGroups = true;
                        }
                        catch (Throwable t) {
                            Utilities.logData("get group error: " + t.toString());
                        }
                        BGApp.this._xmppSending = false;
                    }
                }
            };
            t.start();
        }
    }

    public void onLeaveGroup(String from) {
        Utilities.logData("GRP " + from + " left group");
    }

    public FunXMPP.FMessage createSystemMessage(String jid, String resource, String keyBit, int messageId) {
        return this.createSystemMessage(jid, resource, keyBit, messageId, Constants.STRING_EMPTY_STRING);
    }

    public FunXMPP.FMessage createSystemMessage(String jid, String resource, String keyBit, int messageId, String arg0) {
        long now = System.currentTimeMillis();
        String actorName = this._chatHistoryCache.getBGReadableName(resource);
        FunXMPP.FMessage.Key key = new FunXMPP.FMessage.Key(jid, false, "sys-" + Long.toString(now) + '-' + keyBit);
        FunXMPP.FMessage msg = new FunXMPP.FMessage(key);
        msg.media_wa_type = (byte)7;
        msg.timestamp = now;
        msg.status = 6;
        msg.data = Res.getString(messageId, actorName, arg0);
        msg.remote_resource = resource;
        msg.media_size = messageId;
        msg.media_url = arg0;
        Utilities.logData("created new system message with key " + msg.key + " and data: " + msg.data);
        return msg;
    }

    private void participantChangeSystemMessage(String gjid, String ujid, boolean addUser) {
        String idStub = addUser ? "add-" : "rem-";
        int strResID = addUser ? 48 : 49;
        final FunXMPP.FMessage newMsg = this.createSystemMessage(gjid, ujid, idStub, strResID);
        this._mStore.putMessage(newMsg, new MessageStore.CompletionCallback(){

            public void operationCompleted() {
                BGApp.this._chatHistoryCache.newMessage(newMsg);
                boolean fgMidletRunning = BGApp.this.isFGMidletRunning();
                if (fgMidletRunning) {
                    try {
                        byte[] fullData = Serializer.serialize(newMsg);
                        BGApp.this.sendToFG(fullData, (byte)10);
                    }
                    catch (Exception x) {
                        Utilities.logData("system message serialize fail: " + x.toString());
                    }
                }
                BGApp.this._activeStandbyMgr.doASUpdate();
                Utilities.logData("delivery complete for " + newMsg.key.id);
            }
        });
    }

    public void sendToFG(byte[] data, byte msgType) {
        if (this._lmClient != null) {
            this._lmClient.sendData(data, msgType);
        }
    }

    public void reportMMSDownloadComplete(String URL2, String localFilename, String scaledFilename) {
        Utilities.logData("bgapp reporting on completed dl for URL " + URL2 + " with filename " + localFilename + " and scaled " + scaledFilename);
        try {
            byte[] data = Serializer.serializeStringArr(new String[]{URL2, localFilename, scaledFilename});
            this.sendToFG(data, (byte)53);
        }
        catch (Exception x) {
            Utilities.logData("mms download serialize fail: " + x.toString());
        }
    }

    public void reportMMSDownloadFail(String URL2, String errorText) {
        try {
            byte[] data = Serializer.serializeStringArr(new String[]{URL2, errorText});
            this.sendToFG(data, (byte)54);
        }
        catch (Exception x) {
            Utilities.logData("mms fail serialize fail: " + x.toString());
        }
    }

    public void reportMMSXferCancelled() {
        try {
            this.sendToFG(new byte[]{0, 0}, (byte)52);
        }
        catch (Exception x) {
            Utilities.logData("mms cancel serialize fail: " + x.toString());
        }
    }

    public void reportMMSUploadFail(String remote_jid, String errorText) {
        if (errorText == null) {
            errorText = Constants.STRING_EMPTY_STRING;
        }
        String fullErr = Res.getString(17, errorText);
        if (this.isFGMidletRunning()) {
            this.sendToFG(fullErr.getBytes(), (byte)58);
        } else {
            ChatHistory hist = this._chatHistoryCache.get(remote_jid);
            this.launchFG(fullErr, this.buildChatArgs(remote_jid, hist));
        }
    }

    boolean createLMServer() {
        for (int i = 0; i < 5; ++i) {
            try {
                this._lmServer = (LocalMessageProtocolServerConnection)Connector.open((String)"localmsg://:whatsapp");
                return true;
            }
            catch (IOException ex) {
                Utilities.logData("failed to create server socket for LMP on " + ex.toString());
                ex.printStackTrace();
                try {
                    Thread.sleep(i * 100);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        return false;
    }

    void processIncomingLMConnections() {
        Thread t = new Thread(){

            public void run() {
                try {
                    BGApp.this._lmConnection = BGApp.this._lmServer.acceptAndOpen();
                    Utilities.logData("connection to FG over LMP accepted");
                    if (BGApp.this._profilesMgr != null) {
                        BGApp.this._profilesMgr.haltSoundAlert();
                    }
                    BGApp.this._lmClient = new LocalMessageClient(BGApp.this._lmConnection, BGApp.this);
                    BGApp.this._lmClient.start();
                }
                catch (IOException ex) {
                    Utilities.logData("IO error launching LMP listener: " + ex.toString());
                }
                catch (Throwable t) {
                    Utilities.logData("process incoming LMP launcher blew up on " + t.toString());
                }
            }
        };
        t.start();
    }

    public void localMessageReceived(byte[] data, byte msgType) {
        Utilities.logData("bgApp got local message of type " + msgType);
        try {
            switch (msgType) {
                case 1: {
                    FunXMPP.FMessage.Key newKey = Serializer.unserializeKey(data);
                    this.doSendNewMessage(newKey);
                    break;
                }
                case 6: {
                    String jid = Utilities.safeIntern(Serializer.unserializeString(data));
                    this.doStateRequest(jid);
                    break;
                }
                case 8: {
                    String jid = Utilities.safeIntern(Serializer.unserializeString(data));
                    this.doDeleteLeaveGroup(jid);
                    break;
                }
                case 7: {
                    FunXMPP.FMessage.Key delKey = Serializer.unserializeKey(data);
                    FunXMPP.FMessage stub = new FunXMPP.FMessage(delKey);
                    this._mStore.deleteMessage(stub);
                    break;
                }
                case 14: {
                    this.manualColdSync();
                    break;
                }
                case 5: {
                    FmsgKeyStatus keyStatus = Serializer.unserializeKeyStatus(data);
                    FunXMPP.FMessage stub = new FunXMPP.FMessage(keyStatus.key);
                    stub.status = keyStatus.status;
                    this._mStore.updateMessageStatus(stub, false, null);
                    this._chatHistoryCache.messageReceipt(keyStatus.key, keyStatus.status);
                    this.setIndicatorVisible(this._chatHistoryCache.dirtyCount() > 0);
                    this._activeStandbyMgr.doASUpdate();
                    break;
                }
                case 15: {
                    if (ApplicationData.phoneNumberConfirmed() && !ApplicationData.emptyChatUserID()) {
                        this._myPlainJid = ApplicationData.chatUserID() + "@" + "s.whatsapp.net";
                        this.launchColdSync("user_registered_phone");
                        break;
                    }
                    Utilities.logData("ASSERT FAIL: FG sent registered signal but settings have no data");
                    break;
                }
                case 9: {
                    this.chatsRequested();
                    break;
                }
                case 18: {
                    this.doSettingsUpdate(data, false);
                    break;
                }
                case 19: {
                    this.doSettingsUpdate(data, true);
                    break;
                }
                case 51: {
                    byte mmsState = 0;
                    if (this._mmsDownloader != null && this._mmsDownloader.isActive()) {
                        mmsState = 1;
                    }
                    if (BGMMSCreator.isActive()) {
                        mmsState = 1;
                    }
                    byte syncState = 0;
                    if (Syncer.getRunningSyncs() > 0) {
                        syncState = 2;
                    }
                    this.sendToFG(new byte[]{mmsState, syncState}, (byte)51);
                    break;
                }
                case 50: {
                    FunXMPP.FMessage stub = Serializer.unserializeFMSG(data);
                    if (this._mmsDownloader == null) {
                        this.reportMMSDownloadFail(stub.media_url, Res.getString(10));
                        break;
                    }
                    boolean res = this._mmsDownloader.requestDownload(stub);
                    if (!res) {
                        this.reportMMSDownloadFail(stub.media_url, Res.getString(12));
                    }
                    break;
                }
                case 21: {
                    EmailCallback emailCallback = new EmailCallback(new String(data));
                    break;
                }
                case 23: {
                    this.initialXMPPConnection();
                    break;
                }
                case 25: {
                    if (this._profilesMgr != null) {
                        if (data[0] == 0) {
                            this._profilesMgr.haltSoundAlert();
                            break;
                        }
                        this._profilesMgr.playSoundAlert();
                    }
                    break;
                }
                case 2: {
                    this.sendToFG(new byte[]{(byte)this._chatState._state}, (byte)2);
                    break;
                }
                case 71: {
                    StatusUpdater sUpdater = new StatusUpdater(null, true, this);
                    sUpdater.start();
                    break;
                }
                case 70: {
                    String newStatus = new String(data);
                    StatusUpdater sUpdater = new StatusUpdater(newStatus, false, this);
                    sUpdater.start();
                    break;
                }
                case 56: {
                    MMSUploadInfo newInfo = Serializer.unserializeMMSUploadInfo(data);
                    Utilities.logData("got MMS upload req with info fullpath: " + newInfo.fullPath + " content type: " + newInfo.contentType + " key: " + newInfo.key);
                    FunXMPP.FMessage newMsg = this._mStore.getTempMessage(newInfo.key);
                    if (newMsg == null) {
                        Utilities.logData("couldnt find new message to send " + newInfo.key.toString());
                        return;
                    }
                    this._mStore.putMessage(newMsg, null);
                    BGMMSCreator.requestUpload(newMsg, newInfo, false);
                    break;
                }
                case 60: {
                    FunXMPP.FMessage.Key newKey = Serializer.unserializeKey(data);
                    FunXMPP.FMessage newMsg = this._mStore.getMessage(newKey);
                    Utilities.logData("got upload retry req for key " + newKey);
                    BGMMSCreator.requestUpload(newMsg, null, true);
                    break;
                }
                case 52: {
                    if (this._mmsDownloader != null && this._mmsDownloader.isActive()) {
                        Utilities.logData("trying to cancel active download");
                        this._mmsDownloader.cancelDownload();
                        break;
                    }
                    if (BGMMSCreator.isActive()) {
                        Utilities.logData("trying to cancel active upload");
                        BGMMSCreator.cancelUpload();
                        break;
                    }
                    this.reportMMSXferCancelled();
                    break;
                }
                case 73: {
                    this._chatState.doConnect(7);
                    break;
                }
                default: {
                    Utilities.logData("encountered unknown localmessage type: " + msgType);
                }
            }
        }
        catch (Throwable t) {
            Utilities.logData("bg app blew up receiving local msg type " + msgType + " error " + t.toString());
        }
    }

    public void connectionClosed(int reason) {
        Utilities.logData("LMP closed, re-entering accept. reason was " + reason);
        this.processIncomingLMConnections();
    }

    public void networkChanged(String status) {
        if (status != null && !status.equals("None")) {
            Utilities.logData("carrier [" + System.getProperty("com.nokia.mid.ons") + "] spn [" + System.getProperty("com.nokia.mid.spn") + "] networkID " + System.getProperty("com.nokia.mid.networkID"));
        }
        if (this._systemNetworkStatus != null && !this._systemNetworkStatus.equals(status)) {
            Utilities.logData("system listener network status changed from " + this._systemNetworkStatus + " to " + status);
        }
        if (this._systemNetworkStatus != null && this._systemNetworkStatus.equals("None") && status != null && !status.equals("None")) {
            boolean runnerHasNoConn = this._xmppRunner != null && this._xmppRunner._connection == null;
            boolean registered = ApplicationData.phoneNumberConfirmed() && !ApplicationData.emptyChatUserID();
            Utilities.logData("BGApp sees network coverage wakeup  with connless runner " + runnerHasNoConn + " and registered " + registered);
            if (status.equals("Roam") && !ApplicationData.dataWhileRoaming() && !this._systemConnectedWifi) {
                Utilities.logData("not waking up fun runner for wifi-off roam network per settings");
            } else if (runnerHasNoConn && registered) {
                Utilities.logData("kicking off delayed cellnet connect attempt");
                SafeThread t = new SafeThread(){

                    public void safeRun() {
                        try {
                            Thread.sleep(35000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        BGApp.this._chatState.doConnect(1);
                    }
                };
                t.start();
            }
        }
        this._systemNetworkStatus = status;
    }

    public void phoneStatusReceived(byte remainingBattery, boolean isCharging, String networkStatus, boolean isWifiConnected) {
        Utilities.logData("system status: battery:" + remainingBattery + ", isCharging:" + isCharging + ", networkStatus:" + networkStatus + ", wifiConn:" + isWifiConnected);
        this._systemConnectedWifi = isWifiConnected;
        this._systemNetworkStatus = networkStatus;
        Utilities.logData("carrier [" + System.getProperty("com.nokia.mid.ons") + "] spn [" + System.getProperty("com.nokia.mid.spn") + "] networkID " + System.getProperty("com.nokia.mid.networkID"));
    }

    public void batteryChanged(byte status, boolean isCharging) {
    }

    public void wifiChanged(boolean isConnected) {
        boolean runnerActive = this._xmppRunner._connection != null;
        boolean registered = ApplicationData.phoneNumberConfirmed() && !ApplicationData.emptyChatUserID();
        Utilities.logData("BGApp sees wifi changed to " + isConnected + " with active runnner " + runnerActive + " and registered " + registered);
        this._systemConnectedWifi = isConnected;
        if (isConnected && this._chatState._state == 1) {
            long curStateHeld = (System.currentTimeMillis() - this._chatState._timeChanged) / 1000L;
            Utilities.logData("LOCKED? Wifi came up but chat is already in socket connect for seconds: " + curStateHeld);
            if (curStateHeld > ChatState.SentinelTask.MAX_SILENT_INTERVAL && System.currentTimeMillis() - this._lastXMPPRunnerKill > 3L * ChatState.SentinelTask.MAX_SILENT_INTERVAL) {
                FunXMPPRunner oldRunner = this._xmppRunner;
                FunXMPPRunner newRunner = new FunXMPPRunner(this);
                if (oldRunner != null && oldRunner.killWithConfirmation()) {
                    Utilities.logData("killed old fun runner");
                    this._xmppRunner = newRunner;
                    this._chatState.setState(3);
                    newRunner.start();
                    this._lastXMPPRunnerKill = System.currentTimeMillis();
                } else {
                    Utilities.logData("attempted fun runner kill was denied");
                }
            }
        }
        if (isConnected && this._xmppRunner != null && this._xmppRunner._connection == null && registered) {
            Utilities.logData("kicking off delayed wifi connect attempt");
            SafeThread t = new SafeThread(){

                public void safeRun() {
                    try {
                        Thread.sleep(35000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    BGApp.this._chatState.doConnect(1);
                }
            };
            t.start();
        }
    }

    public void systemMessageReceived(String message) {
        Utilities.logData("got new system message " + message);
    }

    public void phoneConnectionClosed(String message) {
        Utilities.logData("phone connection closed with message " + message);
    }

    public void contactsSystemMessageReceived(String message) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void contactsConnectionClosed(String message) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void contactAdded(Hashtable contact) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void contactDeleted(Hashtable contact) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void contactUpdated(Hashtable contact) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void doStateRequest(final String jid) {
        SafeThread t = new SafeThread("state request"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void safeRun() {
                Object object;
                ContactRosterInfo roster = (ContactRosterInfo)BGApp.this._xmppRoster.get(jid);
                FunXMPP.Connection fConn = BGApp.this._xmppRunner._connection;
                if (roster == null) {
                    Utilities.logData(jid + " was a last-seen query but not on roster, sending sub req");
                    if (fConn != null) {
                        if (BGApp.this._xmppSending) {
                            Utilities.logData("state req sees send-side locked, DISCARDING");
                            return;
                        }
                        object = BGApp.this._xmppSendLock;
                        synchronized (object) {
                            try {
                                BGApp.this._xmppSending = true;
                                fConn.sendPresenceSubscriptionRequest(jid);
                                roster = new ContactRosterInfo();
                                roster._subSent = true;
                                BGApp.this._xmppRoster.put(jid, roster);
                            }
                            catch (Exception x) {
                                Utilities.logData("error sending sub req: " + x.toString());
                                return;
                            }
                            finally {
                                BGApp.this._xmppSending = false;
                            }
                        }
                    }
                }
                if (roster != null && roster._lastSeen >= 0L) {
                    ContactChatInfo ccInfo = new ContactChatInfo(jid);
                    ccInfo.timestamp = roster._lastSeen;
                    ccInfo.state = roster._lastSeen == 0L ? 1 : 2;
                    try {
                        byte[] data = Serializer.serialize(ccInfo);
                        BGApp.this.sendToFG(data, (byte)4);
                        return;
                    }
                    catch (Exception x) {
                        Utilities.logData("couldn't serialize state info for " + jid);
                        return;
                    }
                }
                if (fConn == null) return;
                if (BGApp.this._xmppSending) {
                    Utilities.logData("last-seen req sees send-side locked, DISCARDING");
                    return;
                }
                object = BGApp.this._xmppSendLock;
                synchronized (object) {
                    try {
                        BGApp.this._xmppSending = true;
                        Utilities.logData("sending last request for " + jid);
                        fConn.sendQueryLastOnline(jid);
                    }
                    catch (Exception x) {
                        Utilities.logData("error sending last request for " + jid);
                    }
                    finally {
                        BGApp.this._xmppSending = false;
                    }
                    return;
                }
            }
        };
        t.start();
    }

    private void startAsyncMessageSenderThread() {
        if (this._senderThreadStartTime != null) {
            return;
        }
        this._senderThreadStartTime = new Long(System.currentTimeMillis());
        SafeThread thread = new SafeThread("sender thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void safeRun() {
                while (true) {
                    Object[] msgs;
                    Object object = BGApp.this._senderThreadLock;
                    synchronized (object) {
                        if (BGApp.this._pendingSendMsgs == null) {
                            BGApp.this._senderThreadStartTime = null;
                            break;
                        }
                        msgs = new FunXMPP.FMessage[BGApp.this._pendingSendMsgs.size()];
                        BGApp.this._pendingSendMsgs.copyInto(msgs);
                        BGApp.this._pendingSendMsgs = null;
                    }
                    object = BGApp.this._xmppSendLock;
                    synchronized (object) {
                        BGApp.this._xmppSending = true;
                        for (int i = 0; i < msgs.length; ++i) {
                            FunXMPP.Connection fConn = BGApp.this._xmppRunner._connection;
                            try {
                                if (fConn != null) {
                                    fConn.sendMessage((FunXMPP.FMessage)msgs[i]);
                                    if (BGApp.this._xmppRoster.containsKey(((FunXMPP.FMessage)msgs[i]).key.remote_jid) || BGApp.this._chatHistoryCache.getGroupChat(((FunXMPP.FMessage)msgs[i]).key.remote_jid, false) != null) continue;
                                    Utilities.logData(((FunXMPP.FMessage)msgs[i]).key.remote_jid + " struck out in roster, sending sub req");
                                    fConn.sendPresenceSubscriptionRequest(((FunXMPP.FMessage)msgs[i]).key.remote_jid);
                                    continue;
                                }
                                BGApp.this._chatState.userTypingWakeup();
                                Utilities.logData("no connection in bgApp's funrunner, trying typing wakeup");
                                break;
                            }
                            catch (IOException iox) {
                                Utilities.logData("message send error: " + iox.toString());
                                break;
                            }
                            finally {
                                Utilities.logData("done sending " + ((FunXMPP.FMessage)msgs[i]).key.id);
                            }
                        }
                        BGApp.this._xmppSending = false;
                    }
                }
            }
        };
        thread.start();
    }

    public void doSendMMSMessage(FunXMPP.FMessage.Key newKey, String mimeType, String mediaURL, long mediaSize, final BGMMSCreator bgMmsCreator) {
        Utilities.logData("bg app informed of new mms message with mimeType " + mimeType + " URL " + mediaURL + " size " + mediaSize + " remote jid " + newKey.remote_jid);
        bgMmsCreator.urlWriteBackToggle(true);
        FunXMPP.FMessage newMsg = this._mStore.getMessage(newKey);
        if (newMsg == null) {
            Utilities.logData("couldnt find new MMS message to send " + newKey.toString());
            return;
        }
        newMsg.status = 0;
        newMsg.media_size = mediaSize;
        newMsg.media_url = mediaURL;
        newMsg.media_mime_type = mimeType;
        this._mStore.updateMessageStatus(newMsg, true, new MessageStore.CompletionCallback(){

            public void operationCompleted() {
                bgMmsCreator.urlWriteBackToggle(false);
                BGApp.this.sendToFG(new byte[]{0}, (byte)57);
            }
        });
        MediaData md = (MediaData)newMsg.thumb_image;
        if ((newMsg.data == null || newMsg.data.length() == 0) && md.externalThumbCount > 0) {
            String externalThumb = this._mStore.getExternalThumbnailFile(newKey, 1);
            byte[] jpegData = Utilities.getFileAsByteArray(externalThumb);
            ByteArrayOutputStream baOS = new ByteArrayOutputStream();
            Base64Encoder encoder = new Base64Encoder();
            try {
                encoder.encode(jpegData, 0, jpegData.length, baOS);
            }
            catch (Throwable t) {
                Utilities.logData("couldnt base64 " + externalThumb + " on err " + t.toString());
            }
            newMsg.data = new String(baOS.toByteArray());
            Utilities.logData("soft add of base64 payload size " + newMsg.data.length());
        }
        this._offliners.add(newMsg);
        this._chatHistoryCache.newMessage(newMsg);
        this._activeStandbyMgr.doASUpdate();
        Utilities.logData("new outgoing mms message to " + newKey.remote_jid + "with URL " + newMsg.media_url + " makes offline count: " + this._offliners._totalCount);
        Utilities.logData("media_name: " + newMsg.media_name);
        Utilities.logData("media_size: " + newMsg.media_size);
        Utilities.logData("media_mime_type: " + newMsg.media_mime_type);
        this.addMessageToSenderThread(newMsg);
    }

    private void doSendNewMessage(FunXMPP.FMessage.Key newKey) {
        FunXMPP.FMessage newMsg = this._mStore.getTempMessage(newKey);
        if (newMsg == null) {
            Utilities.logData("couldnt find new message to send " + newKey.toString());
            return;
        }
        this._mStore.putMessage(newMsg, null);
        this._offliners.add(newMsg);
        this._chatHistoryCache.newMessage(newMsg);
        this._activeStandbyMgr.doASUpdate();
        Utilities.logData("new outgoing message to " + newKey.remote_jid + " makes offline count: " + this._offliners._totalCount);
        this.addMessageToSenderThread(newMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageToSenderThread(FunXMPP.FMessage fmsg) {
        Object object = this._senderThreadLock;
        synchronized (object) {
            if (this._pendingSendMsgs == null) {
                this._pendingSendMsgs = new Vector();
            }
            this._pendingSendMsgs.addElement(fmsg);
            Utilities.logData("new message makes pending send queue " + this._pendingSendMsgs.size());
            this.startAsyncMessageSenderThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendXMPPPing(boolean fullPing) {
        if (this._xmppSending) {
            Utilities.logData("ping sees xmpp sender lock held, DISCARDING");
            return;
        }
        Object object = this._senderThreadLock;
        synchronized (object) {
            this._xmppSending = true;
            FunXMPP.Connection fConn = this._xmppRunner._connection;
            try {
                if (fConn != null) {
                    if (fullPing) {
                        fConn.sendPing();
                    } else {
                        fConn.sendNop();
                    }
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            this._xmppSending = false;
        }
    }

    private void doDeleteLeaveGroup(final String jid) {
        SafeThread t = new SafeThread("leave group"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void safeRun() {
                ChatHistory.Group grp = BGApp.this._chatHistoryCache.getGroupChat(jid, false);
                if (grp != null) {
                    Object object = BGApp.this._xmppSendLock;
                    synchronized (object) {
                        BGApp.this._xmppSending = true;
                        try {
                            FunXMPP.Connection fConn;
                            if (BGApp.this._xmppRunner != null && (fConn = BGApp.this._xmppRunner._connection) != null) {
                                fConn.sendLeaveGroup(jid);
                            }
                        }
                        catch (Throwable t) {
                            Utilities.logData("problems leaving group " + jid + " : " + t.toString());
                        }
                        BGApp.this._xmppSending = false;
                    }
                }
                BGApp.this._mStore.deleteChatHistory(jid);
                BGApp.this._chatHistoryCache.chatHistoryDeleted(jid);
                BGApp.this.setIndicatorVisible(BGApp.this._chatHistoryCache.dirtyCount() > 0);
                BGApp.this._activeStandbyMgr.doASUpdate();
            }
        };
        t.start();
    }

    private void doSettingsUpdate(final byte[] data, final boolean remove) {
        SafeThread t = new SafeThread("received settings update"){

            public void safeRun() {
                try {
                    if (remove) {
                        Settings.receiveCacheRemove(data);
                    } else {
                        FunXMPP.Connection fConn;
                        Settings.receiveCacheUpdate(data);
                        if (BGApp.this._xmppRunner != null && (fConn = BGApp.this._xmppRunner._connection) != null) {
                            fConn.setPushName(Settings.getString(0));
                        }
                    }
                }
                catch (RecordStoreException ex) {
                    Utilities.logData("record blowup trying to receive settings " + ex.toString());
                }
            }
        };
        t.start();
    }

    public void coldSyncFinished(long mostRecentChange, boolean success, boolean wasFirst, byte errorCode, String errorText) {
        Utilities.logData("cold sync finished with success code " + success + " and most recent change " + mostRecentChange);
        long previousColdSync = this._lastColdSyncCompletion;
        if (success) {
            if (this._lastColdSyncStart - mostRecentChange * 1000L > previousColdSync) {
                this.sendToFG(new byte[]{1, 1}, (byte)12);
            } else {
                this.sendToFG(new byte[]{1, 0}, (byte)12);
            }
            this._lastColdSyncCompletion = System.currentTimeMillis();
            if (wasFirst) {
                try {
                    Settings.set(6, true);
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            this._chatHistoryCache.updateReadableNames();
            this._activeStandbyMgr.doASUpdate();
        } else {
            Utilities.logData("trying to send sync fail to fg with code " + errorCode + " and text " + errorText);
            byte[] errArr = errorText != null && errorText.length() > 0 ? errorText.getBytes() : new byte[]{};
            byte[] sendData = new byte[errArr.length + 2];
            sendData[0] = 0;
            sendData[1] = errorCode;
            if (errArr.length > 0) {
                System.arraycopy(errArr, 0, sendData, 2, errArr.length);
            }
            this.sendToFG(sendData, (byte)12);
        }
    }

    public void hotSyncFinished(long mostRecentChange, boolean success, Throwable lastError) {
        long previousHotSync = this._lastHotSyncCompletion;
        long previousColdSync = this._lastColdSyncCompletion;
        if (success) {
            if (this._lastColdSyncStart - mostRecentChange * 1000L > previousColdSync && this._lastHotSyncStart - mostRecentChange * 1000L > previousHotSync) {
                this.sendToFG(new byte[]{0}, (byte)13);
            }
            this._lastHotSyncCompletion = System.currentTimeMillis();
        }
    }

    public void syncProgress(int percentDone) {
        this.sendToFG(new byte[]{(byte)percentDone}, (byte)24);
    }

    public void statusUpdateFinished(boolean success, String errorMsg) {
        byte[] data;
        if (success) {
            data = new byte[]{1};
        } else {
            byte[] errData = errorMsg.getBytes();
            data = new byte[errData.length + 1];
            data[0] = 0;
            System.arraycopy(errData, 0, data, 1, errData.length);
        }
        this.sendToFG(data, (byte)72);
    }

    private void launchColdSync(String reason) {
        if (Syncer.getRunningSyncs() > 0) {
            Utilities.logData("syncer thinks it's running a sync, not launching cold sync");
            return;
        }
        Utilities.logData("launching cold sync. reason: " + reason + " syncs this hour: " + this._syncsLastHour);
        long now = System.currentTimeMillis();
        this._syncsLastHour = now - this._lastColdSyncStart > 3600000L ? 1 : ++this._syncsLastHour;
        this._lastColdSyncStart = now;
        ColdSyncer syncer = new ColdSyncer(this, Integer.toString(ApplicationData.countryCallingCode()), ApplicationData.phoneNumber(), !ApplicationData.didFirstSync(), this._myPlainJid);
        syncer.start();
    }

    public void periodicSystemColdSync() {
        long now = System.currentTimeMillis();
        if (!this.canConnect()) {
            return;
        }
        if (now - this._lastColdSyncStart > 86400000L) {
            this.launchColdSync("periodic");
        }
    }

    public void manualColdSync() {
        long now = System.currentTimeMillis();
        if (now - this._lastColdSyncStart < 3600000L && (long)this._syncsLastHour >= 3L) {
            Utilities.logData("cold sync disallowed because of hourly total");
            this.sendToFG(new byte[]{1, 0}, (byte)12);
            return;
        }
        this.launchColdSync("user request");
    }

    public static class MMSUploadInfo {
        public FunXMPP.FMessage.Key key;
        public String fullPath;
        public String contentType;
        public String cryptoName;
    }

    private static class ContactRosterInfo {
        public boolean _subSent = false;
        public long _lastSeen = -1L;

        private ContactRosterInfo() {
        }
    }

    private class ProfilesCallback
    extends SafeThread
    implements ProfilesListener,
    PlayerListener {
        private String _ringingTone;
        private int _ringintToneVolume;
        private String _messageAlertType;
        private String _messageAlertTone;
        boolean _vibrationEnabled;
        boolean _appTonesEnabled;
        String _fileToPlay = null;
        Player _player = null;
        boolean _playing = false;
        private int _actionState = 0;
        private final int ACTION_STOP;
        private final int ACTION_START;

        private ProfilesCallback() {
            this.ACTION_STOP = 1;
            this.ACTION_START = 2;
        }

        private String getRoot() {
            return System.getProperty(Constants.PROPERTY_FILECONN_PRIVATE_DIR) + "WA_alerts";
        }

        public void profilesSystemMessageReceived(String message) {
            Utilities.logData("profiles system message: " + message);
        }

        public void profilesServerReady() {
            BGApp.this._profiles.requestCurrentProfileInfo();
            BGApp.this._profiles.receiveProfileNotifications(true);
        }

        public void profilesServerClosed(int reason) {
            Utilities.logData("profiles closed because " + reason);
        }

        public void profilesInfoReceived(String ringingTone, byte ringintToneVolume, String messageAlertType, String messageAlertTone, boolean vibrationEnabled, boolean applicationToneEnabled) {
            this._ringingTone = ringingTone;
            this._ringintToneVolume = ringintToneVolume + 1;
            this._messageAlertType = messageAlertType;
            this._messageAlertTone = messageAlertTone;
            this._vibrationEnabled = vibrationEnabled;
            this._appTonesEnabled = applicationToneEnabled;
            this.decideFileToPlay();
            Utilities.logData("got profile info with type/tone/vol/apptones " + messageAlertType + "/" + messageAlertTone + "/" + this._ringintToneVolume + "/" + applicationToneEnabled + ", decided to play: " + this._fileToPlay);
        }

        private void decideFileToPlay() {
            if (!this._appTonesEnabled) {
                this._fileToPlay = null;
            } else if (this._messageAlertType.equals("None")) {
                this._fileToPlay = null;
            } else if (this._messageAlertType.equals("File")) {
                this._fileToPlay = Constants.PROTOCOL_PREFIX_FILE + this._messageAlertTone + Constants.NOTIFICATIONS_APPENDER;
            } else if (this._messageAlertType.equals("Standard")) {
                this._fileToPlay = this.getRoot() + Constants.AUDIO_TONE_STANDARD + Constants.NOTIFICATIONS_APPENDER;
            } else if (this._messageAlertType.equals("Ascending")) {
                this._fileToPlay = this.getRoot() + Constants.AUDIO_TONE_ASCENDING + Constants.NOTIFICATIONS_APPENDER;
            } else if (this._messageAlertType.equals("BeepOnce")) {
                this._fileToPlay = this.getRoot() + Constants.AUDIO_TONE_BEEP_ONCE + Constants.NOTIFICATIONS_APPENDER;
            } else if (this._messageAlertType.equals("Special")) {
                this._fileToPlay = this.getRoot() + Constants.AUDIO_TONE_SPECIAL + Constants.NOTIFICATIONS_APPENDER;
            } else {
                Utilities.logData("unknown file to play for alert type " + this._messageAlertType);
            }
        }

        public String getFileToPlay() {
            return this._fileToPlay;
        }

        private boolean allAlertsOff() {
            return this._fileToPlay == null && !this._vibrationEnabled;
        }

        public void playSoundAlert() {
            if (this._playing || this.allAlertsOff()) {
                Utilities.logData("not playing sound because playing: " + this._playing + " curfile: " + this._fileToPlay + " vibrations: " + this._vibrationEnabled);
                return;
            }
            this.wakeupForPlay();
        }

        private void startSound() {
            if (!this._playing) {
                boolean playerLaunched;
                Utilities.logData("trying to start sound with fileToPlay " + this._fileToPlay + " vibrations " + this._vibrationEnabled);
                this._playing = true;
                if (this._fileToPlay != null) {
                    this._player = null;
                    playerLaunched = true;
                    try {
                        this._player = Manager.createPlayer((String)this._fileToPlay);
                        this._player.addPlayerListener((PlayerListener)this);
                        this._player.realize();
                        try {
                            VolumeControl volControl = (VolumeControl)this._player.getControl("VolumeControl");
                            volControl.setLevel(this._ringintToneVolume * 20);
                        }
                        catch (Throwable volT) {
                            // empty catch block
                        }
                        this._player.start();
                    }
                    catch (Throwable t) {
                        Utilities.logData("alert player blowup: " + t.toString());
                        if (this._player != null) {
                            this._player.close();
                            this._player = null;
                        }
                        playerLaunched = false;
                    }
                } else {
                    playerLaunched = false;
                }
                try {
                    if (this._vibrationEnabled) {
                        DeviceControl.startVibra((int)80, (long)750L);
                    }
                }
                catch (Throwable t) {
                    Utilities.logData("alert player vibration blowup: " + t.toString());
                }
                if (!playerLaunched) {
                    this._playing = false;
                }
            }
        }

        public void haltSoundAlert() {
            if (this._playing) {
                this.wakeupForStop();
            }
        }

        public void playerUpdate(Player p, String event, Object o) {
            if (event == "endOfMedia" && this._playing && this._player == p) {
                try {
                    p.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                this.playerClosed(p);
            }
        }

        private synchronized int awaitAction() {
            if (this._actionState == 0) {
                try {
                    this.wait();
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            int res = this._actionState;
            this._actionState = 0;
            return res;
        }

        private synchronized void playerClosed(Player player) {
            if (this._player == player) {
                this._player = null;
                this._playing = false;
                this._actionState &= 0xFFFFFFFE;
            }
        }

        private synchronized void wakeupForPlay() {
            this._actionState |= 2;
            this.notify();
        }

        private synchronized void wakeupForStop() {
            this._actionState |= 1;
            this.notify();
        }

        public void safeRun() {
            this.copyTonesToDisk();
            while (true) {
                int curActions;
                if (((curActions = this.awaitAction()) & 1) > 0) {
                    Player lPlayer = this._player;
                    if (this._playing && lPlayer != null) {
                        Utilities.logData("trying to stop running player...");
                        try {
                            lPlayer.stop();
                            lPlayer.close();
                        }
                        catch (Throwable t) {
                            Utilities.logData("problem trying to halt running player: " + t.toString());
                        }
                        this.playerClosed(lPlayer);
                    }
                }
                if ((curActions & 2) <= 0) continue;
                this.startSound();
                this._actionState &= 0xFFFFFFFD;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copyTonesToDisk() {
            String[] cannedFiles = new String[]{Constants.AUDIO_TONE_ASCENDING, Constants.AUDIO_TONE_BEEP_ONCE, Constants.AUDIO_TONE_SPECIAL, Constants.AUDIO_TONE_STANDARD};
            try {
                FileConnection rootC = (FileConnection)Connector.open((String)this.getRoot(), (int)3);
                if (!rootC.exists()) {
                    rootC.mkdir();
                }
                rootC.close();
            }
            catch (Throwable t) {
                Utilities.logData("alert file local root blowup: " + t.toString());
            }
            for (int i = 0; i < cannedFiles.length; ++i) {
                FileConnection destFileC = null;
                String baseName = cannedFiles[i];
                InputStream srcIS = null;
                OutputStream destOS = null;
                try {
                    destFileC = (FileConnection)Connector.open((String)(this.getRoot() + baseName), (int)3);
                    if (!destFileC.exists()) {
                        destFileC.create();
                    }
                    if (destFileC.fileSize() > 0L) continue;
                    srcIS = this.getClass().getResourceAsStream(baseName);
                    destOS = destFileC.openOutputStream();
                    int c = -1;
                    while ((c = srcIS.read()) != -1) {
                        destOS.write(c);
                    }
                    destOS.flush();
                    continue;
                }
                catch (Throwable t) {
                    Utilities.logData("alert file copyout blowup on " + baseName + " : " + t.toString());
                    continue;
                }
                finally {
                    if (destOS != null) {
                        try {
                            destOS.close();
                        }
                        catch (Exception x) {}
                    }
                    if (srcIS != null) {
                        try {
                            srcIS.close();
                        }
                        catch (Exception x) {}
                    }
                    if (destFileC != null) {
                        try {
                            destFileC.close();
                        }
                        catch (Exception x) {}
                    }
                }
            }
        }
    }

    private class EmailCallback
    implements NMSListener {
        private NMS _nms;
        private final String msg;
        private boolean triedAttach = false;

        public EmailCallback(String msg) {
            this.msg = msg;
            SafeThread t = new SafeThread(){

                public void safeRun() {
                    EmailCallback.this._nms = new NMS(EmailCallback.this);
                    try {
                        EmailCallback.this._nms.connect();
                    }
                    catch (IOException ex) {
                        Utilities.logData("NMS failed in EmailCallback on " + ex.toString());
                        BGApp.this.sendToFG(ex.toString().getBytes(), (byte)22);
                        EmailCallback.this._nms = null;
                    }
                }
            };
            t.start();
        }

        public void NMSsystemMessageReceived(String message) {
            Utilities.logData("NMS Email system message: " + message);
        }

        private String buildSupportInfo(int numAttachments) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.msg);
            sb.append("\n");
            sb.append("\n");
            sb.append("WhatsApp Version: ");
            sb.append(Utilities.getMidletVersion());
            sb.append("\n");
            sb.append("Device: ");
            sb.append(System.getProperty("microedition.platform"));
            sb.append("\n");
            sb.append("Locale: ");
            sb.append(System.getProperty("microedition.locale"));
            sb.append("\n");
            sb.append("Phone: ");
            sb.append(ApplicationData.countryCallingCode());
            sb.append(ApplicationData.phoneNumber());
            sb.append("\n");
            sb.append("App EOL: ");
            long expDate = ApplicationData.installDate() + 7776000000L;
            sb.append(DateTimeUtilities.dayOfYear(expDate));
            sb.append(' ');
            sb.append(DateTimeUtilities.shortTimeFormat(expDate));
            sb.append("\n");
            sb.append("App EOLH: ");
            sb.append(DateTimeUtilities.dayOfYear(1324319075000L));
            sb.append(' ');
            sb.append(DateTimeUtilities.shortTimeFormat(1324319075000L));
            sb.append("\n");
            sb.append("EOL: ");
            sb.append(ApplicationData.expired());
            sb.append("\n");
            sb.append("App start: ");
            sb.append(DateTimeUtilities.logTimeFormat(BGApp.this._initTime));
            sb.append("\n");
            sb.append("Last crash sent: ");
            long crashUploadDate = ApplicationData.crashUploadDate();
            if (crashUploadDate == 0L) {
                sb.append("never");
            } else {
                sb.append(DateTimeUtilities.dayOfYear(crashUploadDate));
                sb.append(' ');
                sb.append(DateTimeUtilities.shortTimeFormat(crashUploadDate));
            }
            sb.append("\n");
            if (!ApplicationData.phoneNumberConfirmed() || !ApplicationData.didFirstSync()) {
                sb.append("Init progress: ");
                if (!ApplicationData.phoneNumberConfirmed()) {
                    sb.append("Not Confirmed.");
                } else {
                    sb.append("Not Cold Synced.");
                }
                sb.append("\n");
            }
            sb.append("Favs/Contacts: ");
            Favorites favs = new Favorites();
            favs.initialize();
            int totalContacts = ColdSyncer.getContactsExpectedCount();
            sb.append(favs.size());
            sb.append("/");
            sb.append(totalContacts);
            sb.append("\n");
            if (!this.triedAttach) {
                sb.append("Attached: ");
            } else {
                sb.append("Failed to attach: ");
            }
            sb.append(numAttachments);
            sb.append(" files\n");
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int checkAvailLogs(String[] outFiles) {
            String fgFilename = Utilities.getLogfilePath() + "FG-" + "WhatsAppLog.txt";
            String bgFilename = Utilities.getLogfilePath() + "BG-" + "WhatsAppLog.txt";
            String[] all = new String[]{fgFilename, bgFilename};
            int found = 0;
            for (int i = 0; i < all.length; ++i) {
                String testFile = all[i];
                FileConnection fileC = null;
                try {
                    fileC = (FileConnection)Connector.open((String)testFile, (int)1);
                    if (!fileC.exists()) continue;
                    outFiles[found++] = testFile;
                    continue;
                }
                catch (Throwable t) {
                    Utilities.logData("blowup checking if logs exist: " + t.toString());
                    continue;
                }
                finally {
                    if (fileC != null) {
                        try {
                            fileC.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            return found;
        }

        public void NMSServerReady() {
            Utilities.logData("Email server is ready.");
            this.composeSupportEmail();
        }

        private void composeSupportEmail() {
            String[] allTextTypes = new String[]{Constants.MEDIA_MIME_TYPE_TEXT_PLAIN_UTF8, Constants.MEDIA_MIME_TYPE_TEXT_PLAIN_UTF8, Constants.MEDIA_MIME_TYPE_TEXT_PLAIN_UTF8, Constants.MEDIA_MIME_TYPE_TEXT_PLAIN_UTF8};
            String[] availableFiles = new String[4];
            int numAttachments = this.checkAvailLogs(availableFiles);
            Utilities.logData("Sending email with " + numAttachments + " attachments");
            this._nms.composeEmail(Constants.SUPPORT_EMAIL, "Nokia S40 support for +" + ApplicationData.countryCallingCode() + ApplicationData.phoneNumber() + (ApplicationData.emptyChatUserID() ? " [Not Registered]" : Constants.STRING_EMPTY_STRING), this.buildSupportInfo(numAttachments), availableFiles, allTextTypes, !this.triedAttach ? numAttachments : 0);
        }

        public void NMSServerClosed(int reason) {
            Utilities.logData("Email server closed because " + reason);
        }

        public void composeEmailFailed(short transid, String reason) {
            Utilities.logData("Email server compose failed because " + reason);
            if (!this.triedAttach) {
                this.triedAttach = true;
                this.composeSupportEmail();
            } else {
                this._nms.closeConnection();
                BGApp.this.sendToFG(reason.getBytes(), (byte)22);
            }
        }

        public void composerClosed(String exitCode) {
            Utilities.logData("Email server composer closed, attempting FG relaunch.");
            this._nms.closeConnection();
            if (!BGApp.this.isFGMidletRunning()) {
                BGApp.this.launchFG(null, null);
            }
        }
    }

    private class StandbyCallback
    implements ActiveStandbyListener {
        private int _state = 2;
        private static final int STATE_CLEAN = 0;
        private static final int STATE_ONE_DIRTY = 1;
        private static final int STATE_MULTI_DIRTY = 2;
        private static final int STATE_NOT_REGISTERED = 2;
        private static final int INDEX_NEW_CHAT = -2;
        private static final int INDEX_CHATS = -1;
        private byte[] _icon = Utilities.getResourceAsByteArray(Constants.IMAGE_ICON_INDICATOR_22_COLOR);
        private int _chatIndex = -2;
        private boolean _active = false;
        private String _oneDirtyJid = null;
        private int _rowCount = 2;

        private StandbyCallback() {
        }

        public void registrationSuccess(long transId) {
            Utilities.logData("Active standby reg success");
        }

        public void registrationError(long transId, String statusError) {
            Utilities.logData("Active standby reg fail on: " + statusError);
        }

        public void activeStandbySystemMessageReceived(String message) {
            Utilities.logData("Active standby message recv: " + message);
        }

        public void activeStandbyConnectionClosed(String message) {
            Utilities.logData("Active standby conn closed on: " + message);
            this._active = false;
        }

        public void activated(byte rowCount, short resolutionWidth, short resolutionHeight) {
            Utilities.logData("Active standby activated with " + rowCount + " rows. " + " icon is size " + this._icon.length);
            this._active = true;
            this._rowCount = rowCount;
            this.doASUpdate();
        }

        public void deActivated() {
            Utilities.logData("Active standby deactivated by user");
            this._active = false;
        }

        private void launchFromActive() {
            String launchJid = null;
            ChatHistory curHist = null;
            if (this._state == 0) {
                if (this._chatIndex == -2) {
                    launchJid = Constants.ARG_NEW_CHAT_JID;
                } else if (this._chatIndex != -1 && (curHist = BGApp.this._chatHistoryCache.getNatural(this._chatIndex)) != null) {
                    launchJid = curHist._jid;
                }
            } else if (this._state == 1) {
                launchJid = this._oneDirtyJid;
                curHist = BGApp.this._chatHistoryCache.get(launchJid);
            }
            String jidArg = null;
            if (launchJid != null) {
                jidArg = BGApp.this.buildChatArgs(launchJid, curHist);
            }
            BGApp.this.launchFG(null, jidArg);
        }

        public void keyPressed(String key) {
            if (key.equals("MSK")) {
                this.launchFromActive();
            } else if (this._state == 0) {
                if (key.equals("RightScrollKey")) {
                    ++this._chatIndex;
                } else if (key.equals("LeftScrollKey")) {
                    --this._chatIndex;
                } else {
                    return;
                }
                if (this._chatIndex < -2 || this._chatIndex >= BGApp.this._chatHistoryCache.size()) {
                    this._chatIndex = -2;
                }
                this.doASUpdate();
            }
        }

        public void updateError(long transid, String status) {
            Utilities.logData("Active Standby update error w status: " + status);
        }

        public void updateSuccess(long transid) {
        }

        public synchronized void doASUpdate() {
            String summaryText;
            boolean registered;
            boolean allowKeyScroll = false;
            if (!this._active) {
                return;
            }
            boolean bl = registered = ApplicationData.phoneNumberConfirmed() && !ApplicationData.emptyChatUserID();
            if (!registered) {
                summaryText = Res.getString(13);
                this._state = 2;
            } else if (BGApp.this._chatHistoryCache == null) {
                summaryText = Res.getString(14);
                this._state = 2;
            } else {
                ChatHistory[] oneDirty = new ChatHistory[1];
                int dirtyCount = BGApp.this._chatHistoryCache.dirtyCountWithPayload(oneDirty);
                if (dirtyCount == 1) {
                    String fromTxt;
                    this._state = 1;
                    this._oneDirtyJid = oneDirty[0]._jid;
                    if (oneDirty[0]._group != null) {
                        fromTxt = oneDirty[0]._group._subject;
                    } else {
                        fromTxt = oneDirty[0]._readableName;
                        if (fromTxt == null) {
                            fromTxt = ChatHistory.getDisplayablePlainJid(this._oneDirtyJid);
                        }
                    }
                    summaryText = Res.getString(15, fromTxt);
                } else if (dirtyCount > 1) {
                    this._state = 2;
                    summaryText = Res.getString(18, dirtyCount) + '\n';
                } else {
                    allowKeyScroll = true;
                    this._state = 0;
                    if (this._chatIndex == -2) {
                        summaryText = Res.getString(19);
                    } else if (this._chatIndex == -1) {
                        summaryText = Res.getString(6);
                    } else {
                        ChatHistory curHist = BGApp.this._chatHistoryCache.getNatural(this._chatIndex);
                        if (curHist == null) {
                            this._chatIndex = -2;
                            summaryText = Res.getString(19);
                        } else if (curHist._group != null) {
                            summaryText = this.makeGroupSummaryText(curHist);
                        } else {
                            summaryText = BGApp.this._chatHistoryCache.getBGReadableName(curHist._jid) + '\n';
                            if (curHist._lastExcerpt != null) {
                                summaryText = summaryText + curHist._lastExcerpt;
                            }
                        }
                    }
                }
            }
            BGApp.this._activeStandby.updateActiveStandby(this._icon, Constants.MEDIA_MIME_TYPE_PNG, summaryText, Constants.STRING_EMPTY_STRING, allowKeyScroll);
        }

        private String makeGroupSummaryText(ChatHistory curHist) {
            String fromTxt;
            String useExcerpt;
            String string = useExcerpt = curHist._lastExcerpt != null ? curHist._lastExcerpt : Constants.STRING_EMPTY_STRING;
            if ((curHist._lastStatus & 0xF) == 6) {
                fromTxt = curHist._group._subject;
            } else {
                String actorName;
                String string2 = actorName = curHist._lastFromMe ? Res.getString(52) : BGApp.this._chatHistoryCache.getBGReadableName(curHist._group._lastParty);
                if (this._rowCount == 2) {
                    fromTxt = actorName + " @ " + curHist._group._subject;
                } else {
                    fromTxt = curHist._group._subject;
                    useExcerpt = actorName + ": " + useExcerpt;
                }
            }
            return fromTxt + '\n' + useExcerpt;
        }
    }

    public static class ContactChatInfo {
        public String jid;
        public int state;
        public long timestamp;

        public ContactChatInfo(String j) {
            this.jid = j;
        }

        public ContactChatInfo(String j, int s, long t) {
            this.jid = j;
            this.state = s;
            this.timestamp = t;
        }
    }

    public static class FmsgKeyStatus {
        public FunXMPP.FMessage.Key key;
        public int status;

        public FmsgKeyStatus(FunXMPP.FMessage fmsg) {
            this.key = fmsg.key;
            this.status = fmsg.status;
        }

        public FmsgKeyStatus(FunXMPP.FMessage.Key k, int s) {
            this.key = k;
            this.status = s;
        }
    }
}

