/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.util.AppManager;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.CommonFileMessageStore;
import com.whatsapp.client.FunXMPP;
import com.whatsapp.client.MessageStore;
import java.util.Vector;

public class AsyncFileMessageStore
extends CommonFileMessageStore
implements MessageStore {
    private final Object _workerLock = new Object();
    private Vector _tasks = new Vector();
    private Long _workerThreadStartTime = null;
    private boolean _errorFlag = false;

    private void startAsyncWorkerThread() {
        if (this._workerThreadStartTime != null) {
            return;
        }
        this._workerThreadStartTime = new Long(System.currentTimeMillis());
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    block10: while (true) {
                        Object[] myTasks;
                        Object object = AsyncFileMessageStore.this._workerLock;
                        synchronized (object) {
                            if (AsyncFileMessageStore.this._tasks.isEmpty()) {
                                AsyncFileMessageStore.this._workerThreadStartTime = null;
                                break;
                            }
                            myTasks = new DBTask[AsyncFileMessageStore.this._tasks.size()];
                            AsyncFileMessageStore.this._tasks.copyInto(myTasks);
                            AsyncFileMessageStore.this._tasks = new Vector();
                        }
                        int i = 0;
                        while (true) {
                            if (i >= myTasks.length) continue block10;
                            Object curTask = myTasks[i];
                            myTasks[i] = null;
                            boolean taskResult = false;
                            int j = 0;
                            do {
                                if (!(taskResult = ((DBTask)curTask).execute())) {
                                    if (++j >= 7) {
                                        Utilities.logData("DROP? giving up on db task " + ((DBTask)curTask).toString());
                                        AsyncFileMessageStore.this._errorFlag = false;
                                        break;
                                    }
                                    AsyncFileMessageStore.this._errorFlag = true;
                                    Utilities.logData("async with cur taskq progress " + (i + 1) + " of " + myTasks.length + " and latent " + AsyncFileMessageStore.this._tasks.size() + " failed and retrying on " + ((DBTask)curTask).toString());
                                    try {
                                        Thread.sleep(300L);
                                    }
                                    catch (Exception x) {}
                                    continue;
                                }
                                AsyncFileMessageStore.this._errorFlag = false;
                                if (((DBTask)curTask)._callback == null) continue;
                                ((DBTask)curTask)._callback.operationCompleted();
                            } while (!taskResult);
                            ++i;
                        }
                        break;
                    }
                }
                catch (Throwable t) {
                    Utilities.logData("db worker thread blew up with " + t.toString());
                    Object object = AsyncFileMessageStore.this._workerLock;
                    synchronized (object) {
                        AsyncFileMessageStore.this._workerThreadStartTime = null;
                    }
                }
            }
        });
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTaskAndKickOff(DBTask newTask) {
        Object object = this._workerLock;
        synchronized (object) {
            this._tasks.addElement(newTask);
            this.startAsyncWorkerThread();
        }
    }

    public Vector getChats() {
        return super.getChats();
    }

    public Vector getAllOfflineMessages() {
        return super.getAllOfflineMessages();
    }

    public FunXMPP.FMessage getMessage(FunXMPP.FMessage.Key key) {
        return super.getMessage(key);
    }

    public Vector getMessages(String jid, String sinceID) {
        return super.getMessages(jid, sinceID);
    }

    public boolean putMessage(FunXMPP.FMessage fmsg, MessageStore.CompletionCallback callback) {
        if (AppManager.isForeground()) {
            return false;
        }
        this.addTaskAndKickOff(new PutMessageTask(fmsg, callback));
        return true;
    }

    public boolean deleteMessage(FunXMPP.FMessage fmsg) {
        if (AppManager.isForeground()) {
            return false;
        }
        this.addTaskAndKickOff(new DeleteMessageTask(fmsg));
        return true;
    }

    public boolean updateMessageStatus(FunXMPP.FMessage fmsg, boolean includeMMSKey, MessageStore.CompletionCallback callback) {
        if (AppManager.isForeground()) {
            return false;
        }
        this.addTaskAndKickOff(new UpdateMessageStatusTask(fmsg, includeMMSKey, callback));
        return true;
    }

    public boolean deleteChatHistory(String jid) {
        if (AppManager.isForeground()) {
            return false;
        }
        this.addTaskAndKickOff(new DeleteHistoryTask(jid));
        return true;
    }

    public boolean putMessageToTemp(FunXMPP.FMessage fmsg, MessageStore.CompletionCallback callback) {
        if (!AppManager.isForeground()) {
            return false;
        }
        this.addTaskAndKickOff(new PutMessageToTempTask(fmsg, callback));
        return true;
    }

    public FunXMPP.FMessage getTempMessage(FunXMPP.FMessage.Key key) {
        return super.getTempMessage(key);
    }

    public boolean putGroupSubject(String gjid, String subject) {
        if (AppManager.isForeground()) {
            return false;
        }
        this.addTaskAndKickOff(new PutGroupSubjectTask(gjid, subject));
        return true;
    }

    public boolean addGroupUser(String gjid, String ujid) {
        if (AppManager.isForeground()) {
            return false;
        }
        this.addTaskAndKickOff(new AddGroupUserTask(gjid, ujid));
        return true;
    }

    public boolean removeGroupUser(String gjid, String ujid) {
        if (AppManager.isForeground()) {
            return false;
        }
        this.addTaskAndKickOff(new RemoveGroupUserTask(gjid, ujid));
        return true;
    }

    public boolean addMMSFilename(String MMSFilename, String scaledMMSFilename, MessageStore.MMSKeyStoreCallback callback) {
        this.addTaskAndKickOff(new AddMMSFilenameTask(MMSFilename, scaledMMSFilename, callback));
        return true;
    }

    public boolean addExternalThumbnail(FunXMPP.FMessage.Key key, byte[] imgData, MessageStore.CompletionCallback callback) {
        this.addTaskAndKickOff(new AddThumbnailTask(key, imgData, callback));
        return true;
    }

    public boolean recentError() {
        return this._errorFlag;
    }

    public int queueSize() {
        return this._tasks.size();
    }

    private class AddThumbnailTask
    extends DBTask {
        private FunXMPP.FMessage.Key _key;
        private byte[] _data;

        public AddThumbnailTask(FunXMPP.FMessage.Key key, byte[] data, MessageStore.CompletionCallback callback) {
            super(null, callback);
            this._key = key;
            this._data = data;
        }

        public boolean execute() {
            return AsyncFileMessageStore.super.addExternalThumbnail(this._key, this._data);
        }
    }

    private class AddMMSFilenameTask
    extends DBTask {
        private String _MMSFilename;
        private String _scaledMMSFilename;
        MessageStore.MMSKeyStoreCallback _keyStoreCallback;

        public AddMMSFilenameTask(String MMSFilename, String scaledFilename, MessageStore.MMSKeyStoreCallback callback) {
            super(null, callback);
            this._MMSFilename = MMSFilename;
            this._scaledMMSFilename = scaledFilename;
            this._keyStoreCallback = callback;
        }

        public boolean execute() {
            long res = AsyncFileMessageStore.super.addMMSFilename(this._MMSFilename, this._scaledMMSFilename);
            this._keyStoreCallback.setOffset(res);
            return res != -1L;
        }
    }

    private class RemoveGroupUserTask
    extends DBTask {
        private String _gjid;
        private String _ujid;

        public RemoveGroupUserTask(String gjid, String ujid) {
            this._gjid = gjid;
            this._ujid = ujid;
        }

        public boolean execute() {
            return AsyncFileMessageStore.super.removeGroupUser(this._gjid, this._ujid);
        }
    }

    private class AddGroupUserTask
    extends DBTask {
        private String _gjid;
        private String _ujid;

        public AddGroupUserTask(String gjid, String ujid) {
            this._gjid = gjid;
            this._ujid = ujid;
        }

        public boolean execute() {
            return AsyncFileMessageStore.super.addGroupUser(this._gjid, this._ujid);
        }
    }

    private class PutGroupSubjectTask
    extends DBTask {
        private String _gjid;
        private String _subject;

        public PutGroupSubjectTask(String gjid, String subject) {
            this._gjid = gjid;
            this._subject = subject;
        }

        public boolean execute() {
            return AsyncFileMessageStore.super.putGroupSubject(this._gjid, this._subject);
        }
    }

    private class DeleteHistoryTask
    extends DBTask {
        private String _jid;

        public DeleteHistoryTask(String jid) {
            this._jid = jid;
        }

        public boolean execute() {
            return AsyncFileMessageStore.super.deleteChatHistory(this._jid);
        }
    }

    private class DeleteMessageTask
    extends DBTask {
        private FunXMPP.FMessage _fmsg;

        public DeleteMessageTask(FunXMPP.FMessage fmsg) {
            this._fmsg = fmsg;
        }

        public boolean execute() {
            return AsyncFileMessageStore.super.deleteMessage(this._fmsg);
        }
    }

    private class PutMessageToTempTask
    extends DBTask {
        private FunXMPP.FMessage _fmsg;

        public PutMessageToTempTask(FunXMPP.FMessage fmsg, MessageStore.CompletionCallback callback) {
            super(null, callback);
            this._fmsg = fmsg;
        }

        public boolean execute() {
            return AsyncFileMessageStore.super.putMessageToTemp(this._fmsg);
        }
    }

    private class UpdateMessageStatusTask
    extends DBTask {
        private FunXMPP.FMessage _fmsg;
        private boolean _includeMMSKey;

        public UpdateMessageStatusTask(FunXMPP.FMessage fmsg, boolean includeMMSKey, MessageStore.CompletionCallback callback) {
            super("update of " + fmsg.key + " to status " + fmsg.status, callback);
            this._fmsg = fmsg;
            this._includeMMSKey = includeMMSKey;
        }

        public boolean execute() {
            return AsyncFileMessageStore.super.updateMessageStatus(this._fmsg, this._includeMMSKey);
        }
    }

    private class PutMessageTask
    extends DBTask {
        private FunXMPP.FMessage _fmsg;

        public PutMessageTask(FunXMPP.FMessage fmsg, MessageStore.CompletionCallback callback) {
            super("put of " + fmsg.key, callback);
            this._fmsg = fmsg;
        }

        public boolean execute() {
            Runtime r = Runtime.getRuntime();
            long startMem = r.freeMemory();
            boolean res = AsyncFileMessageStore.super.putMessage(this._fmsg);
            long endMem = r.freeMemory();
            return res;
        }
    }

    private abstract class DBTask {
        public String _debugDesc;
        public MessageStore.CompletionCallback _callback;

        public DBTask() {
        }

        public DBTask(String desc, MessageStore.CompletionCallback callback) {
            this._debugDesc = desc;
            this._callback = callback;
        }

        public abstract boolean execute();

        public String toString() {
            if (this._debugDesc != null) {
                return this._debugDesc;
            }
            return super.toString();
        }
    }
}

