/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.contacts.FileUploader;
import com.whatsapp.api.util.DateTimeUtilities;
import com.whatsapp.api.util.SafeThread;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.Constants;
import com.whatsapp.client.Settings;
import java.util.Vector;
import javax.microedition.rms.RecordStoreException;

public final class ApplicationData {
    public static boolean checkExpired(String curVersion, boolean writeVals) {
        long now = System.currentTimeMillis();
        long killDate = Utilities.getAndClearKillAlert(false);
        if (killDate > 0L) {
            SafeThread delayedKill = new SafeThread("delayed delete of kill alert"){

                public void safeRun() {
                    try {
                        Thread.sleep(300000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Utilities.getAndClearKillAlert(true);
                }
            };
            delayedKill.start();
        }
        long installDate = ApplicationData.installDate();
        String lastVersionRunAs = ApplicationData.lastVersionRunAs();
        if (now > 1324319075000L) {
            boolean writeVersion;
            boolean bl = writeVersion = !curVersion.equals(lastVersionRunAs);
            if (writeVals) {
                try {
                    Settings.set(9, true);
                    if (writeVersion) {
                        Settings.set(8, curVersion);
                    }
                }
                catch (Exception x) {
                    Utilities.logData("couldnt write expired on hard date: " + x.toString());
                }
            }
            return true;
        }
        if (installDate == 0L || !curVersion.equals(lastVersionRunAs)) {
            if (installDate > 0L) {
                Utilities.logData("resetting install stamp, old version was " + lastVersionRunAs + " at " + DateTimeUtilities.logTimeFormat(installDate));
            } else {
                Utilities.logData("setting install stamp on new install");
            }
            if (writeVals) {
                try {
                    Settings.set(7, now);
                    Settings.set(8, curVersion);
                    Settings.set(9, false);
                }
                catch (Exception x) {
                    Utilities.logData("couldnt write version/timetamp settings: " + x.toString());
                }
            }
        } else {
            if (installDate + 7776000000L < now) {
                if (writeVals) {
                    try {
                        Settings.set(9, true);
                    }
                    catch (Exception x) {
                        Utilities.logData("couldnt write expired setting: " + x.toString());
                    }
                }
                return true;
            }
            if (killDate > 0L) {
                Utilities.logData("App was killed on " + DateTimeUtilities.logTimeFormat(killDate));
                ApplicationData.sendCrashLogs(true);
            }
        }
        return false;
    }

    public static synchronized void sendCrashLogs(boolean delay) {
        long prevUploadDate;
        long now = System.currentTimeMillis();
        if (now - (prevUploadDate = ApplicationData.crashUploadDate()) < 21600000L) {
            Utilities.logData("no crash log upload... last was at: " + DateTimeUtilities.logTimeFormat(prevUploadDate));
            return;
        }
        try {
            Settings.set(10, now);
        }
        catch (Exception x) {
            Utilities.logData("no upload because couldn't set crash stamp on err " + x.toString());
            return;
        }
        String fgFilename = Utilities.getLogfilePath() + "FG-" + "WhatsAppLog.txt";
        String bgFilename = Utilities.getLogfilePath() + "BG-" + "WhatsAppLog.txt";
        String oldBGFilename = Utilities.makeOldLogFileName(bgFilename);
        String[] sendFiles = new String[]{oldBGFilename, bgFilename};
        Vector<String> params = new Vector<String>();
        Vector<String> vals = new Vector<String>();
        params.addElement("from");
        String myID = ApplicationData.chatUserID();
        vals.addElement(myID == null ? Constants.STRING_EMPTY_STRING : myID);
        final FileUploader uploader = new FileUploader(Utilities.decodeString(Constants.URL_CRASHLOG_UPLOAD), "file", "BG-WhatsAppLog.txt", Constants.MEDIA_MIME_TYPE_TEXT_PLAIN, sendFiles, params, vals);
        if (delay) {
            SafeThread t = new SafeThread("delayed crashlog upload"){

                public void safeRun() {
                    try {
                        Thread.sleep(180000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    uploader.start();
                }
            };
            t.start();
        } else {
            uploader.start();
        }
    }

    public static boolean checkIMSIMismatch() {
        String systemImsi = System.getProperty(Constants.PROPERTY_IMSI);
        if (systemImsi == null || systemImsi.length() == 0) {
            return false;
        }
        String ourImsi = ApplicationData.lastIMSIVerified();
        if (ourImsi == null || ourImsi.length() == 0) {
            try {
                Settings.set(12, systemImsi);
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
            return false;
        }
        return !ourImsi.equals(systemImsi);
    }

    public static boolean didFirstSync() {
        try {
            return Settings.getBoolean(6);
        }
        catch (Exception x) {
            return false;
        }
    }

    public static String chatUserID() {
        try {
            return Settings.getString(5);
        }
        catch (Exception x) {
            return null;
        }
    }

    public static boolean emptyChatUserID() {
        try {
            String res = Settings.getString(5);
            return res == null || res.length() == 0;
        }
        catch (Exception x) {
            return true;
        }
    }

    public static int phoneRegStep() {
        try {
            return Settings.getInt(4);
        }
        catch (Exception x) {
            return 0;
        }
    }

    public static boolean phoneNumberConfirmed() {
        try {
            return Settings.getInt(4) == -1;
        }
        catch (Exception x) {
            return false;
        }
    }

    public static String phoneNumber() {
        try {
            return Settings.getString(2);
        }
        catch (Exception x) {
            return null;
        }
    }

    public static boolean emptyPhoneNumber() {
        try {
            String res = Settings.getString(2);
            return res == null || res.length() == 0;
        }
        catch (Exception x) {
            return true;
        }
    }

    public static int countryCallingCode() {
        try {
            return Settings.getInt(3);
        }
        catch (Exception x) {
            return -1;
        }
    }

    public static boolean emptyCountryCallingCode() {
        try {
            return Settings.getInt(3) == -1;
        }
        catch (Exception x) {
            return true;
        }
    }

    public static String pushName() {
        try {
            return Settings.getString(0);
        }
        catch (Exception x) {
            return null;
        }
    }

    public static boolean emptyPushName() {
        try {
            String res = Settings.getString(0);
            return res == null || res.length() == 0;
        }
        catch (Exception x) {
            return true;
        }
    }

    public static boolean dataWhileRoaming() {
        try {
            return Settings.getInt(1) == 1;
        }
        catch (Exception x) {
            return false;
        }
    }

    public static long installDate() {
        try {
            return Settings.getLong(7);
        }
        catch (Exception x) {
            return 0L;
        }
    }

    public static String lastVersionRunAs() {
        try {
            return Settings.getString(8);
        }
        catch (Exception x) {
            return null;
        }
    }

    public static boolean expired() {
        try {
            return Settings.getBoolean(9);
        }
        catch (Exception x) {
            return false;
        }
    }

    public static long crashUploadDate() {
        try {
            return Settings.getLong(10);
        }
        catch (Exception x) {
            return 0L;
        }
    }

    public static String status() {
        try {
            return Settings.getString(11);
        }
        catch (Exception x) {
            return Constants.STRING_EMPTY_STRING;
        }
    }

    public static String lastIMSIVerified() {
        try {
            return Settings.getString(12);
        }
        catch (Exception x) {
            return null;
        }
    }

    public static int groupMaxParticipants() {
        try {
            return Settings.getInt(13);
        }
        catch (Exception x) {
            return 10;
        }
    }

    public static int groupMaxSubject() {
        try {
            return Settings.getInt(14);
        }
        catch (Exception x) {
            return 25;
        }
    }

    public static int groupMaxGropups() {
        try {
            return Settings.getInt(15);
        }
        catch (Exception x) {
            return 10;
        }
    }
}

