/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.contacts.ContactInfoDetails;
import com.whatsapp.api.contacts.ContactPhotoCache;
import com.whatsapp.api.ui.Command;
import com.whatsapp.api.ui.ListField;
import com.whatsapp.api.util.FileNotFoundException;
import com.whatsapp.api.util.RandomAccessDatabase;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.ChatPane;
import com.whatsapp.client.Constants;
import com.whatsapp.client.ContactListItem;
import com.whatsapp.client.ContactListPane;
import com.whatsapp.client.ContactPane;
import com.whatsapp.client.EmptyMessageListItem;
import com.whatsapp.client.FGApp;
import com.whatsapp.client.Res;
import com.whatsapp.client.TabState;
import com.whatsapp.client.test.ContactListMidlet;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;

class AllContactsTabState
extends TabState
implements RandomAccessDatabase.Filter,
ContactPhotoCache.ChangeListener {
    private final Vector _cmdPack = new Vector(1);
    private Command _reloadCmd = new Command(Res.getString(128), Command.SCREEN, 3);
    private int lastFilteredIdx = -1;
    private boolean filteredListComplete;
    private Vector visibleImages;

    public AllContactsTabState(ContactListPane parentScr, int index) {
        super(parentScr, index);
        this._cmdPack.addElement(this._reloadCmd);
        this._masterList = FGApp.getInstance()._pimCache;
    }

    public void onContactPhotoChanged() {
        this._parentScr.tabNeedsRefresh(this, false);
    }

    public Vector getCommands() {
        return this._cmdPack;
    }

    public boolean tabCommandHandler(Command cmd) {
        if (cmd != this._reloadCmd) {
            return false;
        }
        FGApp.getInstance().refreshContacts();
        return true;
    }

    public void filterList(String filter, boolean forceRefresh) {
        if (filter == null || filter.length() == 0) {
            this._curFilter = null;
            this._filteredList = null;
        } else {
            this._curFilter = filter.toLowerCase();
            this._filteredList = new Vector();
        }
        this.lastFilteredIdx = -1;
        this.filteredListComplete = false;
    }

    public boolean accept(int index, Object obj) {
        ContactInfoDetails contact = (ContactInfoDetails)obj;
        if (this.subnameCheck(contact.getFullName())) {
            this._filteredList.addElement(obj);
            this.lastFilteredIdx = index;
            return true;
        }
        return false;
    }

    public ContactInfoDetails getContact(int idx) {
        if (this._curFilter != null) {
            return (ContactInfoDetails)this._filteredList.elementAt(idx);
        }
        return (ContactInfoDetails)this._masterList.elementAt(idx);
    }

    public int getNumListItems() {
        if (this._curFilter != null && this.filteredListComplete) {
            return this._filteredList.size();
        }
        try {
            return FGApp.getInstance().getPIMSize();
        }
        catch (IOException ex) {
            Utilities.logData("all-contacts/get-count/io-error: " + ex);
            return 0;
        }
    }

    public Vector getListItems(int logicalStart, int numItems) {
        Vector list;
        if (this._curFilter != null && !this.filteredListComplete) {
            ++numItems;
        }
        numItems = Math.max(0, Math.min(this.getNumListItems() - logicalStart, numItems));
        try {
            if (this._curFilter != null) {
                int start = this.lastFilteredIdx + 1;
                int extraCount = logicalStart - this._filteredList.size();
                int count = numItems + extraCount;
                if (count > 0) {
                    int found = Math.max(0, ContactInfoDetails.db.search(start, count, this._masterList, this) - extraCount);
                    if (found < numItems) {
                        this.filteredListComplete = true;
                    }
                    numItems = found;
                }
            } else {
                numItems = ContactInfoDetails.db.fetch(logicalStart, numItems, this._masterList);
            }
        }
        catch (FileNotFoundException ex) {
            numItems = 0;
        }
        catch (IOException ex) {
            Utilities.logData("all-contacts/get-contacts/load/io-error: " + ex);
        }
        Vector<ListField.Item> ret = new Vector<ListField.Item>(numItems);
        Vector<Image> images = new Vector<Image>(numItems);
        ContactPhotoCache.stopAllGetAsync();
        for (int i = logicalStart; i < logicalStart + numItems && i < (list = this._curFilter != null ? this._filteredList : this._masterList).size(); ++i) {
            ContactListItem item;
            Image image;
            ContactInfoDetails contact = (ContactInfoDetails)list.elementAt(i);
            if (contact == null) {
                ret.addElement(new ContactListItem(Constants.STRING_EMPTY_STRING, null, null));
                continue;
            }
            String name = contact.getFullName();
            String[] phones = contact._phones;
            String status = null;
            for (int j = 0; j < phones.length; ++j) {
                String phoneStatus;
                String phone = phones[j];
                String jid = FGApp.getInstance().getJidFromPhone(phone);
                if (jid == null || (phoneStatus = FGApp.getInstance().getStatusFromJid(jid)) == null) continue;
                if (status == null) {
                    status = phoneStatus;
                    continue;
                }
                status = Res.getString(191);
                break;
            }
            if ((image = ContactPhotoCache.getAsync(contact._uid, this)) != null) {
                images.addElement(image);
                item = new ContactListItem(name, status, null, image);
            } else {
                item = new ContactListItem(name, status, null);
            }
            ret.addElement(item);
        }
        this.visibleImages = images;
        if (ret.isEmpty() && this._curFilter == null) {
            ret.addElement(new EmptyMessageListItem(Res.getString(199)));
        }
        return ret;
    }

    public String getTabText() {
        return Res.getString(190);
    }

    public void selectItem(int index) {
        String phone;
        String jid;
        String status;
        Vector list;
        if (index >= this.getNumListItems()) {
            Utilities.logData("all-contacts/select/bad-idx");
            return;
        }
        Vector vector = list = this._curFilter != null ? this._filteredList : this._masterList;
        if (list == null || index >= list.size()) {
            Utilities.logData("all-contacts/select/item-not-loaded");
            return;
        }
        FGApp fg = FGApp.getInstance();
        ContactInfoDetails contact = this.getContact(index);
        if (contact._phones.length == 1 && (status = fg.getStatusFromJid(jid = fg.getJidFromPhone(phone = contact._phones[0]))) != null) {
            ContactListMidlet.getInstance()._display.setCurrent((Displayable)new ChatPane(jid));
            return;
        }
        ContactListMidlet.getInstance()._display.setCurrent((Displayable)new ContactPane(contact));
    }

    public void deleteItem(int index) {
    }
}

