/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.util;

import com.whatsapp.api.util.ConnectionThread;
import com.whatsapp.api.util.Utilities;
import java.io.IOException;
import java.io.InterruptedIOException;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.TextMessage;

public class SMSSender
extends ConnectionThread {
    private final String smsNumber;
    private final String text;
    private final int srcPort;
    private final int dstPort;
    private final Listener listener;

    public SMSSender(String smsNumber, String text, int srcPort, int dstPort, Listener listener) {
        this.smsNumber = smsNumber;
        this.text = text;
        this.srcPort = srcPort;
        this.dstPort = dstPort;
        this.listener = listener;
    }

    public void run() {
        if (this.send()) {
            if (this.listener != null) {
                this.listener.onSMSSent();
            }
        } else if (!this.stopped && this.listener != null) {
            this.listener.onSMSSendError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send() {
        Utilities.logData("sms/send/start");
        MessageConnection conn = null;
        try {
            TextMessage msg;
            String dstAddr = "sms://" + this.smsNumber;
            if (this.dstPort > 0) {
                dstAddr = dstAddr + ':' + Integer.toString(this.dstPort);
            }
            if (this.srcPort > 0) {
                String srcAddr = "sms://:" + Integer.toString(this.srcPort);
                conn = (MessageConnection)this.openConnection(srcAddr);
                msg = (TextMessage)conn.newMessage("text", dstAddr);
            } else {
                conn = (MessageConnection)this.openConnection(dstAddr);
                msg = (TextMessage)conn.newMessage("text");
            }
            msg.setPayloadText(this.text);
            Utilities.logData("sms/send");
            conn.send((Message)msg);
            Utilities.logData("sms/sent");
            boolean bl = true;
            return bl;
        }
        catch (InterruptedIOException ex) {
            if (!this.stopped) {
                Utilities.logData("sms/send/interrupted");
            }
        }
        catch (IOException ex) {
            if (!this.stopped) {
                Utilities.logData("sms/send/io-error: " + ex);
            }
        }
        catch (SecurityException ex) {
            Utilities.logData("sms/send/permission-denied: " + ex);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (IOException ex) {
                    Utilities.logData("sms/send/close/io-error: " + ex);
                }
            }
        }
        return false;
    }

    public static interface Listener {
        public void onSMSSent();

        public void onSMSSendError();
    }
}

