/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.util;

import com.nokia.mid.s40.io.LocalMessageProtocolConnection;
import com.whatsapp.api.util.LocalMessageListener;
import com.whatsapp.api.util.SafeThread;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class LocalMessageClient
extends SafeThread {
    private LocalMessageListener listener;
    private LocalMessageProtocolConnection connection;

    public LocalMessageClient(LocalMessageProtocolConnection con, LocalMessageListener listr) {
        super("LM Client");
        if (con == null) {
            throw new IllegalArgumentException("Connection can't be null");
        }
        if (listr == null) {
            throw new IllegalArgumentException("LocalMessageListener can't be null");
        }
        this.listener = listr;
        this.connection = con;
    }

    public synchronized void sendData(byte[] data, byte msgType) {
        if (this.connection != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                dos.writeByte(msgType);
                dos.writeInt(data.length);
                byte[] header = baos.toByteArray();
                this.connection.send(header, 0, header.length);
                this.connection.send(data, 0, data.length);
                dos.close();
                baos.close();
                header = null;
            }
            catch (IOException ex) {
                this.closeSafely(-2);
            }
        }
    }

    public synchronized void close() {
        this.closeSafely(0);
    }

    public void safeRun() {
        LocalMessageProtocolConnection lConnection = this.connection;
        LocalMessageListener lListener = this.listener;
        if (lConnection == null || lListener == null) {
            return;
        }
        try {
            while (true) {
                byte[] header = new byte[5];
                lConnection.receive(header);
                ByteArrayInputStream bais = new ByteArrayInputStream(header);
                DataInputStream dis = new DataInputStream(bais);
                byte msgType = dis.readByte();
                int size = dis.readInt();
                byte[] msg = new byte[size];
                lConnection.receive(msg);
                lListener.localMessageReceived(msg, msgType);
                dis.close();
                bais.close();
                msg = null;
                header = null;
            }
        }
        catch (IOException ex) {
            this.closeSafely(-1);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void closeSafely(int reason) {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.connection = null;
            }
        }
        if (this.listener != null) {
            this.listener.connectionClosed(reason);
            this.listener = null;
        }
    }
}

