/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.util;

import java.util.Stack;

public class JobQueue {
    private final Stack workers = new Stack();
    private final Runnable[] queue;
    private int head = 0;
    private int tail = 0;

    public JobQueue(int size) {
        this.queue = new Runnable[size];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Runnable[] runnableArray = this.queue;
        synchronized (this.queue) {
            while (this.tail != this.head) {
                this.queue[this.tail] = null;
                this.tail = (this.tail + 1) % this.queue.length;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Runnable job) {
        Runnable[] runnableArray = this.queue;
        synchronized (this.queue) {
            this.queue[this.head] = job;
            this.head = (this.head + 1) % this.queue.length;
            if (this.head == this.tail) {
                this.tail = (this.tail + 1) % this.queue.length;
            }
            this.queue.notify();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Runnable pop() throws InterruptedException {
        Runnable[] runnableArray = this.queue;
        synchronized (this.queue) {
            while (this.head == this.tail) {
                this.queue.wait();
            }
            Runnable job = this.queue[this.tail];
            this.queue[this.tail] = null;
            this.tail = (this.tail + 1) % this.queue.length;
            if (this.head != this.tail) {
                this.queue.notify();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return job;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int workerCount() {
        Stack stack = this.workers;
        synchronized (stack) {
            return this.workers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWorker() {
        Worker worker = new Worker();
        worker.start();
        Stack stack = this.workers;
        synchronized (stack) {
            this.workers.push(worker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWorker() {
        Worker worker;
        Stack stack = this.workers;
        synchronized (stack) {
            if (this.workers.empty()) {
                return;
            }
            worker = (Worker)this.workers.pop();
        }
        worker.stop();
        worker.interrupt();
    }

    private class Worker
    extends Thread {
        private volatile boolean stopped = false;

        private Worker() {
        }

        public void stop() {
            this.stopped = true;
        }

        public void run() {
            try {
                while (!this.stopped) {
                    JobQueue.this.pop().run();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

