/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.util;

import com.whatsapp.client.Res;
import java.util.Calendar;
import java.util.Date;

public class DateTimeUtilities {
    public static final int ONESECOND = 1000;
    public static final long ONEMINUTE = 60000L;
    public static final long ONEHOUR = 3600000L;
    public static final long ONEDAY = 86400000L;
    public static final long ONEWEEK = 604800000L;
    public static final long ONEYEAR = 31536000000L;
    public static final int[] MONTH_LABELS = new int[]{28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    public static final int[] WEEKDAY_LABELS = new int[]{40, 41, 42, 43, 44, 45, 46};

    public static boolean isSameDate(long d1, long d2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(new Date(d1));
        c2.setTime(new Date(d2));
        return c1.get(1) == c2.get(1) && c1.get(2) == c2.get(2) && c1.get(5) == c2.get(5);
    }

    public static String formatTimestamp(long stamp) {
        long now = System.currentTimeMillis();
        long diff = now - stamp;
        if (diff / 60000L == 0L) {
            return Res.getString(51);
        }
        if (diff / 3600000L == 0L) {
            return Res.getString(50, (int)(diff / 60000L));
        }
        if (diff / 86400000L == 0L) {
            return DateTimeUtilities.shortTimeFormat(stamp);
        }
        if (diff / 604800000L == 0L) {
            return DateTimeUtilities.weekdayTimeFormat(stamp) + " @ " + DateTimeUtilities.shortTimeFormat(stamp);
        }
        return DateTimeUtilities.formatDate(stamp, true) + " @ " + DateTimeUtilities.shortTimeFormat(stamp);
    }

    public static String dayOfYear(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(time));
        return Res.getString(MONTH_LABELS[cal.get(2)]) + ' ' + cal.get(5) + ' ' + cal.get(1);
    }

    public static String simpleDayFormat(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(time));
        return Res.getString(MONTH_LABELS[cal.get(2)]) + ' ' + cal.get(5);
    }

    public static String shortTimeFormat(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(time));
        int rawMinute = cal.get(12);
        String fillerZero = rawMinute < 10 ? "0" : "";
        int rawHour = cal.get(11);
        String fillerHourZero = rawHour == 0 ? "0" : "";
        return fillerHourZero + rawHour + ":" + fillerZero + rawMinute;
    }

    public static String timeFormatMS(long time) {
        long minute = time / 60000L % 60L;
        long second = time / 1000L % 60L;
        String minuteStr = Long.toString(minute);
        String secondStr = Long.toString(second);
        if (second < 10L) {
            secondStr = '0' + secondStr;
        }
        return minuteStr + ':' + secondStr;
    }

    public static String formatDate(long time, boolean showYear) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(time));
        long month = cal.get(2) + 1;
        long day = cal.get(5);
        String monthDay = "" + month + '/' + Long.toString(day);
        if (showYear) {
            int year = cal.get(1);
            return "" + year + '/' + monthDay;
        }
        return monthDay;
    }

    public static String logTimeFormat(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(time));
        int rawMonth = cal.get(2) + 1;
        int rawDay = cal.get(5);
        int rawHour = cal.get(11);
        String fillerHourZero = rawHour == 0 ? "0" : "";
        int rawMinute = cal.get(12);
        String fillerMinZero = rawMinute < 10 ? "0" : "";
        int rawSecond = cal.get(13);
        String fillerSecZero = rawSecond < 10 ? "0" : "";
        int rawMillis = cal.get(14);
        String fillerMillisZeros = rawMillis < 10 ? "00" : (rawMillis < 100 ? "0" : "");
        return rawMonth + "/" + rawDay + " " + fillerHourZero + rawHour + ":" + fillerMinZero + rawMinute + ":" + fillerSecZero + rawSecond + "." + fillerMillisZeros + rawMillis;
    }

    public static String weekdayTimeFormat(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(time));
        int rawDay = cal.get(7);
        return Res.getString(WEEKDAY_LABELS[rawDay - 1]);
    }

    public static String readableElapsedTime(long millis) {
        StringBuffer working = new StringBuffer();
        long hours = millis / 3600000L;
        if (millis > 3600000L) {
            working.append(hours);
            working.append(':');
            millis %= 3600000L;
        }
        if (millis > 60000L) {
            long minutes = millis / 60000L;
            if (hours > 0L && minutes < 10L) {
                working.append('0');
            }
            working.append(minutes);
            millis %= 60000L;
        }
        working.append(':');
        if (millis > 1000L) {
            long seconds = millis / 1000L;
            if (seconds < 10L) {
                working.append("0");
            }
            working.append(seconds);
        } else {
            working.append("00");
        }
        return working.toString();
    }
}

