/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.ui;

import com.whatsapp.api.ui.Command;
import com.whatsapp.api.ui.MenuCommand;
import com.whatsapp.api.ui.Rect;
import com.whatsapp.api.ui.UIField;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class CommandMenuField
extends UIField {
    private static final int H_PADDING = 3;
    private static final int V_PADDING = 3;
    private static final int ARROW_V_PADDING = 2;
    private static final int ARROW_LEFT_PADDING = 8;
    private static final int ARROW_WIDTH = 6;
    public final Command cmd;
    public Character shortcut = null;
    private static final Font labelFont = Font.getFont((int)0, (int)0, (int)8);

    public CommandMenuField(Command cmd) {
        super(1L);
        this.cmd = cmd;
    }

    public String getLabel() {
        if (this.shortcut != null) {
            return this.shortcut.toString() + ' ' + this.cmd.label;
        }
        return this.cmd.label;
    }

    public void layout(int width, int height) {
        int usedHeight = labelFont.getHeight() + 6;
        int usedWidth = labelFont.stringWidth(this.getLabel()) + 6;
        if (this.cmd.getBaseCommand() instanceof MenuCommand) {
            usedWidth += 14;
        }
        this.setExtent(Math.min(usedWidth, width), Math.min(usedHeight, height));
    }

    public void paint(Graphics g, int x, int y, int width, int height) {
        width = this.getManager().getWidth();
        Rect oldClip = new Rect(g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight());
        g.clipRect(x, y, width, height);
        if (this.hasFocus()) {
            g.setColor(8959184);
            g.fillRect(x, y, width, height);
        }
        g.setColor(0);
        if (this.cmd.getBaseCommand() instanceof MenuCommand) {
            int arrowLeft = x + width - 3 - 6;
            int arrowRight = x + width - 3;
            int arrowVPadding = 5;
            int arrowTop = y + arrowVPadding;
            int arrowBottom = y + height - arrowVPadding;
            int arrowCenter = arrowTop + (arrowBottom - arrowTop) / 2;
            g.fillTriangle(arrowLeft, arrowTop, arrowLeft, arrowBottom, arrowRight, arrowCenter);
        }
        g.setFont(labelFont);
        g.drawString(this.getLabel(), x + 3, y + 3, 20);
        g.setColor(0xF8FCF8);
        g.drawLine(x, y + height - 1, x + width, y + height - 1);
        g.setClip(oldClip.x, oldClip.y, oldClip.width, oldClip.height);
    }
}

