/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.sapi;

import com.nokia.mid.s40.codec.DataDecoder;
import com.nokia.mid.s40.codec.DataEncoder;
import com.nokia.mid.s40.io.LocalMessageProtocolConnection;
import com.whatsapp.api.sapi.FileUIListener;
import com.whatsapp.api.sapi.LocalSAPIMessageListener;
import com.whatsapp.api.sapi.SAPIClient;
import com.whatsapp.api.util.Utilities;
import java.io.IOException;
import javax.microedition.io.Connector;

public class FileUI
implements LocalSAPIMessageListener {
    public static final String FILE_TYPE_ALL = "All";
    public static final String FILE_TYPE_PICTURE = "Picture";
    public static final String FILE_TYPE_VIDEO = "Video";
    public static final String FILE_TYPE_MUSIC = "Music";
    public static final String FILE_TYPE_WALLPAPER = "Wallpaper";
    public static final String FILE_TYPE_RINGTONE = "Ringtone";
    public static final String FILE_TYPE_SOUND = "Sound";
    public static final String MEMORY_LOCATION_ALL = "All";
    public static final String MEMORY_LOCATION_INTERNAL = "Internal";
    public static final String MEMORY_LOCATION_EXTERNAL = "External";
    private LocalMessageProtocolConnection messageUIConnection;
    private String VERSION = "1.0";
    private String serverURL = "localmsg://nokia.file-ui";
    private int byteSize = 500;
    private SAPIClient client;
    FileUIListener listener;

    public FileUI(FileUIListener listr) {
        this.listener = listr;
    }

    public void connect() throws IOException {
        this.messageUIConnection = (LocalMessageProtocolConnection)Connector.open((String)this.serverURL);
        this.client = new SAPIClient(this.messageUIConnection, this, this.VERSION, this.byteSize);
    }

    public void closeConnection() {
        if (this.client != null) {
            this.client.close();
        }
    }

    public short openFileUI(String MEMORY_LOCATION, String MEDIA_TYPE, String STARTING_URL) {
        short transid = (short)(System.currentTimeMillis() % 255L);
        if (this.client != null) {
            try {
                byte[] data_out = null;
                DataEncoder encoder = new DataEncoder("Conv-BEB");
                encoder.putStart(14, "event");
                encoder.put(13, "name", "FileSelect");
                encoder.put(5, "trans_id", (long)transid);
                encoder.put(10, "memory", MEMORY_LOCATION);
                encoder.put(10, "media_type", MEDIA_TYPE);
                encoder.put(0, "multiple_selection", false);
                encoder.put(10, "starting_url", STARTING_URL);
                encoder.putEnd(14, "event");
                data_out = encoder.getData();
                if (data_out != null) {
                    this.client.sendData(data_out);
                    Utilities.logData("Requested File UI to OPen:  Location=" + MEMORY_LOCATION + " Type=" + MEDIA_TYPE);
                }
                data_out = null;
                encoder = null;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return transid;
    }

    public void localSAPIMessageReceived(String method, DataDecoder decoder) {
        if ((method = method.toLowerCase()).equals("fileselect")) {
            try {
                this.decodeFileSelectMessage(decoder);
            }
            catch (IOException ex) {
                this.listener.FileUIError(ex.getMessage());
            }
        }
    }

    public void SAPIconnectionClosed(int reason) {
        this.listener.FileUIServerClosed(reason);
    }

    public void commonSAPIMessageReceived(String msg) {
        this.listener.FileUIsystemMessageReceived(msg);
    }

    public void SAPIready() {
        this.listener.FileUIServerReady();
    }

    private void decodeFileSelectMessage(DataDecoder decoder) throws IOException {
        short transid = (short)decoder.getInteger(5);
        String status = decoder.getString(10);
        if (status.toLowerCase().equals("ok")) {
            String mymeType = null;
            String displayName = null;
            String URL2 = null;
            boolean sharedAllowed = false;
            long size = -1L;
            decoder.getStart(16);
            boolean array_end = false;
            while (!array_end) {
                try {
                    decoder.getStart(14);
                    mymeType = decoder.getString(10);
                    displayName = decoder.getString(11);
                    URL2 = decoder.getString(11);
                    sharedAllowed = decoder.getBoolean();
                    size = decoder.getInteger(7);
                    decoder.getEnd(14);
                }
                catch (IOException e) {
                    array_end = true;
                }
            }
            decoder.getEnd(16);
            if (mymeType != null) {
                this.listener.fileSelected(transid, mymeType, displayName, URL2, sharedAllowed, size);
            }
        } else {
            this.listener.FileUIError(status);
        }
    }
}

