/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.sapi;

import com.nokia.mid.s40.codec.DataDecoder;
import com.nokia.mid.s40.codec.DataEncoder;
import com.nokia.mid.s40.io.LocalMessageProtocolConnection;
import com.whatsapp.api.sapi.ActiveStandbyListener;
import com.whatsapp.api.sapi.LocalSAPIMessageListener;
import com.whatsapp.api.sapi.SAPIClient;
import com.whatsapp.api.util.Utilities;
import java.io.IOException;
import javax.microedition.io.Connector;

public class ActiveStandby
implements LocalSAPIMessageListener {
    private LocalMessageProtocolConnection activeStandbyConnection;
    private String VERSION = "1.[0-10]";
    private String serverURL = "localmsg://nokia.active-standby";
    private int byteSize = 500;
    private SAPIClient client;
    ActiveStandbyListener listener;
    private String client_id = "java/WhatsappMIDlet/Whatsapp";
    private String personalise_view_text = "WhatsApp";
    private boolean registrationError = false;

    public ActiveStandby(ActiveStandbyListener listr) {
        this.listener = listr;
    }

    public void connect() throws IOException {
        this.activeStandbyConnection = (LocalMessageProtocolConnection)Connector.open((String)this.serverURL);
        this.client = new SAPIClient(this.activeStandbyConnection, this, this.VERSION, this.byteSize);
    }

    public void closeConnection() {
        if (this.client != null) {
            this.client.close();
        }
    }

    private long register() {
        return this.sendRegistrationMessage(true);
    }

    public long deRegister() {
        return this.sendRegistrationMessage(false);
    }

    private long sendRegistrationMessage(boolean register) {
        long transid = -1L;
        if (this.client != null) {
            try {
                byte[] data_out = null;
                DataEncoder encoder = new DataEncoder("Conv-BEB");
                encoder.putStart(14, "event");
                encoder.put(13, "name", "Register");
                encoder.put(10, "client_id", this.client_id);
                encoder.put(11, "personalise_view_text", this.personalise_view_text);
                encoder.put(0, "activate_scroll_events", true);
                encoder.putEnd(14, "event");
                data_out = encoder.getData();
                if (data_out != null) {
                    this.client.sendData(data_out);
                    Utilities.logData("Active Standby Registration Requested");
                }
                data_out = null;
                encoder = null;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return transid;
    }

    public long updateActiveStandby(byte[] icon, String iconMimeType, String text, String softkeyText, boolean activateLeftRightScroll) {
        long transid = -1L;
        if (this.client != null) {
            try {
                byte[] data_out = null;
                DataEncoder encoder = new DataEncoder("Conv-BEB");
                encoder.putStart(14, "event");
                encoder.put(13, "name", "Update");
                encoder.put(10, "client_id", this.client_id);
                encoder.put(11, "personalise_view_text", this.personalise_view_text);
                encoder.put(0, "activate_scroll_events", activateLeftRightScroll);
                encoder.put("content_icon", icon, icon.length);
                encoder.put(10, "mime_type", iconMimeType);
                encoder.put(11, "context_text", text);
                encoder.putEnd(14, "event");
                data_out = encoder.getData();
                if (data_out != null) {
                    this.client.sendData(data_out);
                }
                data_out = null;
                encoder = null;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return transid;
    }

    public void localSAPIMessageReceived(String method, DataDecoder decoder) {
        if (method.equals("Register") || method.equals("Deregister")) {
            try {
                this.decodeRegisterMessage(decoder, method);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else if (method.equals("Activated")) {
            try {
                this.decodeActivatedMessage(decoder);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else if (method.equals("KeySelected")) {
            try {
                this.decodeKeySelectedMessage(decoder);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else if (method.equals("Update")) {
            try {
                this.decodeUpdateMessage(decoder);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else if (method.equals("Deactivated")) {
            this.listener.deActivated();
        } else {
            Utilities.logData("SAPI unhandled Active Standby method: " + method);
        }
    }

    public void SAPIconnectionClosed(int reason) {
        if (this.registrationError) {
            this.listener.activeStandbyConnectionClosed("-4");
        } else {
            this.listener.activeStandbyConnectionClosed("" + reason);
        }
    }

    public void commonSAPIMessageReceived(String msg) {
        this.listener.activeStandbySystemMessageReceived(msg);
    }

    public void SAPIready() {
        this.register();
    }

    private void decodeRegisterMessage(DataDecoder decoder, String method) throws IOException {
        long transid = -1L;
        String receivedClientId = decoder.getString(11);
        if (receivedClientId.equals(this.client_id)) {
            String status = decoder.getString(10);
            Utilities.logData("RegisterResponse:" + status);
            if (method.equals("Register") && status.equals("OK")) {
                this.listener.registrationSuccess(transid);
            } else if (method.equals("Register") && status.equals("ClientAlreadyRegistered")) {
                this.listener.registrationSuccess(transid);
            } else if (method.equals("Register")) {
                this.listener.registrationError(transid, status);
                this.registrationError = true;
                this.closeConnection();
            }
        }
    }

    private void decodeActivatedMessage(DataDecoder decoder) throws IOException {
        long transid = -1L;
        String receivedClientId = decoder.getString(11);
        if (receivedClientId.equals(this.client_id)) {
            decoder.getStart(15);
            while (decoder.listHasMoreItems()) {
                String mimetype = decoder.getString(10);
                Utilities.logData("Active Standby MimeType=" + mimetype);
            }
            decoder.getEnd(15);
            byte rowCount = (byte)decoder.getInteger(2);
            boolean active = false;
            String focusMove = "";
            boolean visible = false;
            short resolutionWidth = (short)decoder.getInteger(4);
            short resolutionHeight = (short)decoder.getInteger(4);
            Utilities.logData("resolution:" + resolutionWidth + "X" + resolutionHeight);
            this.listener.activated(rowCount, resolutionWidth, resolutionHeight);
        }
    }

    private void decodeKeySelectedMessage(DataDecoder decoder) throws IOException {
        long transid = -1L;
        String receivedClientId = decoder.getString(11);
        if (receivedClientId.equals(this.client_id)) {
            String key = decoder.getString(10);
            this.listener.keyPressed(key);
        }
    }

    private void decodeUpdateMessage(DataDecoder decoder) throws IOException {
        long transid = -1L;
        String receivedClientId = decoder.getString(11);
        if (receivedClientId.equals(this.client_id)) {
            String status = decoder.getString(10);
            if (status.equals("OK")) {
                this.listener.updateSuccess(transid);
            } else {
                this.listener.updateError(transid, status);
            }
        }
    }
}

