/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.contacts;

import com.whatsapp.api.contacts.Syncer;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.ApplicationData;
import com.whatsapp.client.Constants;
import com.whatsapp.client.Settings;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.rms.RecordStoreException;

public class StatusUpdater
extends Thread {
    private boolean _clear;
    private String _newStatus;
    private Listener _listener;

    public StatusUpdater(String newStatus, boolean clear, Listener listener) {
        this._clear = clear;
        this._newStatus = newStatus;
        this._listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        HttpConnection httpConn = null;
        OutputStream httpOS = null;
        boolean success = false;
        String errorText = null;
        String countryCode = String.valueOf(ApplicationData.countryCallingCode());
        String me = countryCode + ApplicationData.phoneNumber();
        try {
            httpConn = (HttpConnection)Connector.open((String)Utilities.decodeString(Constants.URL_UPDATE_MY_STATUS), (int)3, (boolean)true);
            httpConn.setRequestProperty(Constants.HTTP_REQUEST_PROPERTY_USER_AGENT, Syncer.getUserAgent());
            httpConn.setRequestMethod("POST");
            httpConn.setRequestProperty(Constants.HTTP_REQUEST_PROPERTY_CONTENT_TYPE, Constants.HTTP_REQUEST_PROPERTY_CONTENT_TYPE_VALUE_FORM_URL_ENCODED);
            httpOS = httpConn.openOutputStream();
            Syncer.UTF8URLEncoder.appendPair("v", "1", false, httpOS);
            Syncer.UTF8URLEncoder.appendPair("cc", countryCode, false, httpOS);
            Syncer.UTF8URLEncoder.appendPair("me", me, false, httpOS);
            if (this._clear) {
                Syncer.UTF8URLEncoder.appendPair("clear", "1", false, httpOS);
            } else {
                Syncer.UTF8URLEncoder.appendPair("s", this._newStatus, false, httpOS);
            }
            httpOS.flush();
            int responseCode = httpConn.getResponseCode();
            if (responseCode == 200) {
                try {
                    if (this._clear) {
                        Settings.clear(11);
                    } else {
                        Settings.set(11, this._newStatus);
                    }
                    success = true;
                }
                catch (RecordStoreException rmsx) {
                    Utilities.logData("status update failed on record store: " + rmsx.toString());
                    errorText = "failed to set on phone";
                }
            } else {
                Utilities.logData("status update got http response code " + responseCode);
                errorText = "server refused update";
            }
        }
        catch (Throwable t) {
            errorText = "communication error";
            Utilities.logData("status update blowup: " + t.toString());
        }
        finally {
            if (httpOS != null) {
                try {
                    httpOS.close();
                }
                catch (Exception x) {}
            }
            if (httpConn != null) {
                try {
                    httpConn.close();
                }
                catch (Exception x) {}
            }
            this._listener.statusUpdateFinished(success, errorText);
        }
    }

    public static interface Listener {
        public void statusUpdateFinished(boolean var1, String var2);
    }
}

