/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.contacts;

import com.whatsapp.api.contacts.FileUploader;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.BGApp;
import com.whatsapp.client.BGMMSCreator;
import com.whatsapp.client.Constants;
import com.whatsapp.client.FunXMPP;
import com.whatsapp.client.MessageStore;
import com.whatsapp.client.MessageStoreProvider;
import com.whatsapp.client.Res;
import com.whatsapp.org.it.yup.xml.KXmlParser;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Vector;

public class MMSUploader
extends FileUploader {
    public Hashtable _results = new Hashtable();
    public FunXMPP.FMessage.Key _myKey;
    private String _resultMime;
    private String _resultURL;
    private BGMMSCreator _creator;

    public MMSUploader(String localFilePath, String contentType, String from, FunXMPP.FMessage.Key myKey, String cryptoFilename, BGMMSCreator creator) {
        super(Utilities.decodeString(Constants.URL_MMS_UPLOAD), "file", cryptoFilename, contentType, new String[]{localFilePath}, new Vector(), new Vector());
        this.addParamPair("from", from);
        this.addParamPair("to", myKey.remote_jid);
        this._myKey = myKey;
        this._creator = creator;
    }

    public void progress(int percentComplete) {
        super.progress(percentComplete);
        BGApp.getInstance().sendToFG(new byte[]{(byte)percentComplete}, (byte)55);
    }

    public void handleResponseBody(Reader reader) {
        Utilities.logData("trying to handle mms upload response");
        try {
            Thread.sleep(300L);
            KXmlParser parser = new KXmlParser();
            parser.setInput(reader);
            if (this.isCancelled()) {
                return;
            }
            Runtime r = Runtime.getRuntime();
            parser.nextTag();
            parser.require(2, null, "plist");
            parser.nextTag();
            parser.require(2, null, "dict");
            parser.nextTag();
            while (parser.getEventType() != 3) {
                parser.require(2, null, "key");
                parser.nextToken();
                parser.require(4, null, null);
                String key = parser.getText();
                parser.nextTag();
                parser.require(3, null, "key");
                parser.nextTag();
                parser.require(2, null, "string");
                parser.nextToken();
                parser.require(4, null, null);
                String val = parser.getText();
                this._results.put(key, val);
                parser.nextToken();
                parser.require(3, null, "string");
                parser.nextTag();
            }
            parser.require(3, null, "dict");
            parser.nextTag();
            parser.require(3, null, "plist");
        }
        catch (Throwable t) {
            Utilities.logData("error in parsing mms response: " + t.toString());
            throw new IllegalStateException(Res.getString(16));
        }
        this._resultMime = (String)this._results.get(Constants.MMS_KEY_TYPE);
        if (this._resultMime == null) {
            Utilities.logData("missing vital mms component mimeType");
            throw new IllegalStateException(Res.getString(16));
        }
        this._resultURL = (String)this._results.get(Constants.MMS_KEY_URL);
        if (this._resultURL == null) {
            Utilities.logData("missing vital mms component url");
            throw new IllegalStateException(Res.getString(16));
        }
    }

    public void finished(boolean success, final String errorText) {
        final BGApp bgApp = BGApp.getInstance();
        BGMMSCreator.creatorDone(this._creator);
        this._creator._fmsg.status = 0;
        if (this.isCancelled()) {
            MessageStoreProvider.getMessageStore().updateMessageStatus(this._creator._fmsg, false, null);
            bgApp.reportMMSXferCancelled();
        } else if (success) {
            bgApp.doSendMMSMessage(this._myKey, this._resultMime, this._resultURL, this.getTotalFilesize(), this._creator);
        } else {
            this._creator.urlWriteBackToggle(true);
            MessageStoreProvider.getMessageStore().updateMessageStatus(this._creator._fmsg, false, new MessageStore.CompletionCallback(){

                public void operationCompleted() {
                    MMSUploader.this._creator.urlWriteBackToggle(false);
                    bgApp.reportMMSUploadFail(((MMSUploader)MMSUploader.this)._creator._fmsg.key.remote_jid, errorText);
                }
            });
        }
    }

    public void cancel() {
        super.cancel();
    }

    public boolean isCancelled() {
        return super.isCancelled() || this._creator.isCancelled();
    }
}

