/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.contacts;

import com.whatsapp.api.util.ImageDisplay;
import com.whatsapp.api.util.JobQueue;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.Constants;
import com.whatsapp.org.bouncycastle.util.encoders.Base64Encoder;
import java.io.ByteArrayOutputStream;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Image;
import javax.microedition.pim.Contact;
import javax.microedition.pim.ContactList;
import javax.microedition.pim.PIM;
import javax.microedition.pim.PIMItem;

public class ContactPhotoCache {
    private static final JobQueue _jobQueue = new JobQueue(10);
    private static final Hashtable _photosHash = new Hashtable();
    private static final Hashtable _strikeoutHash = new Hashtable();
    public static final int THUMB_WIDTH = 44;
    public static final Image DEFAULT_IMAGE = ContactPhotoCache.initImageFromResource(Constants.IMAGE_ICON_DEFAULT_CONTACT);

    private static Image initImageFromResource(String name) {
        Image res;
        try {
            res = Image.createImage((String)name);
        }
        catch (Exception x) {
            Utilities.logData("failure initializing image: " + name);
            res = Image.createImage((int)0, (int)0);
        }
        return res;
    }

    public static void stopAllGetAsync() {
        _jobQueue.clear();
    }

    public static Image getAsync(final String uid, final ChangeListener listener) {
        Image image = ContactPhotoCache.peek(uid);
        if (image != null) {
            return image;
        }
        if (_jobQueue.workerCount() == 0) {
            _jobQueue.startWorker();
        }
        _jobQueue.add(new Runnable(){

            public void run() {
                Image image = ContactPhotoCache.get(uid);
                if (listener != null) {
                    listener.onContactPhotoChanged();
                }
            }
        });
        return null;
    }

    public static synchronized Image peek(String uid) {
        if (uid == null || _strikeoutHash.get(uid) == uid) {
            return DEFAULT_IMAGE;
        }
        WeakReference ref = (WeakReference)_photosHash.get(uid);
        if (ref != null) {
            return (Image)ref.get();
        }
        return null;
    }

    public static Image get(String uid) {
        Image curImg = ContactPhotoCache.peek(uid);
        if (curImg != null) {
            return curImg;
        }
        curImg = ContactPhotoCache.getFromPIM(uid);
        ContactPhotoCache.put(uid, curImg);
        return curImg;
    }

    private static synchronized void put(String uid, Image image) {
        if (image == null) {
            _strikeoutHash.put(uid, uid);
        } else {
            _photosHash.put(uid, new WeakReference<Image>(image));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Image getFromPIM(String uid) {
        PIM pim = PIM.getInstance();
        ContactList contacts = null;
        try {
            contacts = (ContactList)pim.openPIMList(1, 1);
            Contact qbeContact = contacts.createContact();
            qbeContact.addString(117, 0, uid);
            Enumeration hits = contacts.items((PIMItem)qbeContact);
            while (hits.hasMoreElements()) {
                String curUid;
                Contact curHit = (Contact)hits.nextElement();
                if (curHit.countValues(117) <= 0 || (curUid = curHit.getString(117, 0)) == null || !curUid.equals(uid)) continue;
                if (curHit.countValues(110) <= 0) {
                    Utilities.logData("no image on file for uid " + uid);
                    Image image = null;
                    return image;
                }
                byte[] photoEncoded = curHit.getBinary(110, 0);
                if (photoEncoded != null && photoEncoded.length > 0) {
                    Base64Encoder decoder = new Base64Encoder();
                    ByteArrayOutputStream baOS = new ByteArrayOutputStream();
                    decoder.decode(photoEncoded, 0, photoEncoded.length, baOS);
                    byte[] binData = baOS.toByteArray();
                    Image res = Image.createImage((byte[])binData, (int)0, (int)binData.length);
                    Image image = res = ImageDisplay.scaleImage(res, 44, 44, true);
                    return image;
                }
                Utilities.logData("bad returned image from pim for " + uid);
                Image image = null;
                return image;
            }
            Utilities.logData("couldnt find uid " + uid + " on qbe PIM search for image");
            return null;
        }
        catch (Throwable t) {
            Utilities.logData("failed to get image for " + uid + " with error " + t.toString());
            return null;
        }
        finally {
            try {
                if (contacts != null) {
                    contacts.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static interface ChangeListener {
        public void onContactPhotoChanged();
    }
}

