/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.contacts;

import com.whatsapp.api.contacts.ContactFileSystemStore;
import com.whatsapp.api.util.RandomAccessDatabase;
import com.whatsapp.api.util.Serializer;
import com.whatsapp.api.util.Sort;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.Constants;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.microedition.pim.Contact;
import javax.microedition.pim.ContactList;
import javax.microedition.pim.PIM;
import javax.microedition.pim.PIMException;

public class ContactInfoDetails {
    private static final String ROOT = ContactFileSystemStore.getRoot();
    public static final String CID_FILE_STORAGE = ROOT + "WA_cids";
    public static final String PIM_INDEX_FILE = ROOT + "WA_pim_index";
    public static final String PIM_COUNT_FILE = ROOT + "WA_pim_count";
    public static final RandomAccessDatabase db = new RandomAccessDatabase(PIM_INDEX_FILE, CID_FILE_STORAGE, PIM_COUNT_FILE, new Serializer(){

        public void serializeToDOS(Object obj, DataOutputStream dos) throws IOException {
            ((ContactInfoDetails)obj).serializeToDOS(dos);
        }

        public Object unserializeFromDIS(DataInputStream dis) throws IOException {
            return ContactInfoDetails.unserializeFromDIS(dis);
        }
    });
    public String _uid;
    public String _firstName;
    public String _lastName;
    public String _formattedName;
    public String _companyName;
    public String[] _phones;
    public int[] _phoneCats;

    public String getFullName() {
        if (this._formattedName != null) {
            return this._formattedName;
        }
        if (this._companyName != null) {
            return this._companyName;
        }
        if (this._phones.length > 0) {
            return this._phones[0];
        }
        return "[empty]";
    }

    public int compareTo(ContactInfoDetails other) {
        return this.getFullName().toUpperCase().compareTo(other.getFullName().toUpperCase());
    }

    public static ContactInfoDetails loadFromPIM(ContactList cList, Contact c) {
        ContactInfoDetails res = new ContactInfoDetails();
        if (cList.isSupportedField(117) && c.countValues(117) > 0) {
            res._uid = c.getString(117, 0);
        }
        if (cList.isSupportedField(106) && c.countValues(106) > 0) {
            String[] name = c.getStringArray(106, 0);
            if (cList.isSupportedArrayElement(106, 0) && name[0] != null) {
                res._lastName = name[0];
            }
            if (cList.isSupportedArrayElement(106, 1) && name[1] != null) {
                res._firstName = name[1];
            }
        }
        if (cList.isSupportedField(105) && c.countValues(105) > 0) {
            res._formattedName = c.getString(105, 0);
        }
        if (cList.isSupportedField(109) && c.countValues(109) > 0) {
            res._companyName = c.getString(109, 0);
        }
        if (cList.isSupportedField(115)) {
            int phoneCount = c.countValues(115);
            res._phones = new String[phoneCount];
            res._phoneCats = new int[phoneCount];
            for (int i = 0; i < phoneCount; ++i) {
                res._phoneCats[i] = c.getAttributes(115, i);
                res._phones[i] = c.getString(115, i);
            }
        } else {
            res._phones = new String[0];
            res._phoneCats = new int[0];
        }
        return res;
    }

    public static String getPhoneCategoryLabel(int cat) {
        switch (cat) {
            case 4: {
                return "Fax";
            }
            case 8: {
                return "Home";
            }
            case 16: {
                return "Mobile";
            }
            case 0: {
                return "General";
            }
            case 64: {
                return "Pager";
            }
            case 512: {
                return "Work";
            }
            case 32: {
                return "Other";
            }
        }
        return "U" + cat;
    }

    protected void serializeToDOS(DataOutputStream dOS) throws IOException {
        Utilities.safeStringOut(this._uid, dOS);
        Utilities.safeStringOut(this._firstName, dOS);
        Utilities.safeStringOut(this._lastName, dOS);
        Utilities.safeStringOut(this._formattedName, dOS);
        Utilities.safeStringOut(this._companyName, dOS);
        if (this._phones != null) {
            int i;
            int plen = this._phones.length;
            dOS.writeInt(plen);
            for (i = 0; i < plen; ++i) {
                dOS.writeUTF(this._phones[i]);
            }
            for (i = 0; i < plen; ++i) {
                dOS.writeInt(this._phoneCats[i]);
            }
        } else {
            dOS.writeInt(0);
        }
    }

    protected static ContactInfoDetails unserializeFromDIS(DataInputStream dIS) throws IOException {
        int i;
        ContactInfoDetails cid = new ContactInfoDetails();
        cid._uid = Utilities.readBlankAsNull(dIS);
        cid._firstName = Utilities.readBlankAsNull(dIS);
        cid._lastName = Utilities.readBlankAsNull(dIS);
        cid._formattedName = Utilities.readBlankAsNull(dIS);
        cid._companyName = Utilities.readBlankAsNull(dIS);
        int plen = dIS.readInt();
        cid._phones = new String[plen];
        cid._phoneCats = new int[plen];
        for (i = 0; i < plen; ++i) {
            cid._phones[i] = dIS.readUTF();
        }
        for (i = 0; i < plen; ++i) {
            cid._phoneCats[i] = dIS.readInt();
        }
        return cid;
    }

    public static class PIMCacher {
        private Listener _listener;
        private byte _errorCode = 0;
        private String _errorText;
        private int _totalContacts;

        public PIMCacher(Listener listener) {
            this._listener = listener;
        }

        public byte getErrorCode() {
            return this._errorCode;
        }

        public String getErrorText() {
            return this._errorText;
        }

        private void onError(Throwable t) {
            Utilities.logData("blew up writing PIM cache: " + t.toString());
            this._errorText = t.toString();
        }

        public int getTotalContact() {
            return this._totalContacts;
        }

        public static int logScaledPercentage(int curVal, int chunk) {
            int completeChunks = curVal / chunk;
            int fakePercent = 0;
            int curPercentGroup = 50;
            for (int i = 0; i < completeChunks; ++i) {
                fakePercent += curPercentGroup;
                curPercentGroup /= 2;
            }
            int incompleteChunkVal = curVal % chunk * curPercentGroup / chunk;
            return fakePercent + incompleteChunkVal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cacheAllPIMEntries() {
            final ContactEnumeration pimEnum = new ContactEnumeration();
            Enumeration en = new Enumeration(){
                int lastAlerted = 0;
                int count = 0;

                public Object nextElement() {
                    try {
                        ContactInfoDetails cid = pimEnum.nextElement();
                        ++this.count;
                        if (PIMCacher.this._listener != null && this.count > this.lastAlerted + 10) {
                            PIMCacher.this._listener.PimCacherProgress(PIMCacher.logScaledPercentage(this.count, 100));
                            this.lastAlerted = this.count;
                        }
                        return cid;
                    }
                    catch (Throwable ex) {
                        throw new NoSuchElementException(ex.toString());
                    }
                }

                public boolean hasMoreElements() {
                    try {
                        return pimEnum.hasMoreElements();
                    }
                    catch (Throwable ex) {
                        PIMCacher.this.onError(ex);
                        return false;
                    }
                }
            };
            try {
                ContactFileSystemStore.setUpRoots();
                this._totalContacts = db.write(en);
                Utilities.logData("PIMCacher total contacts: " + this._totalContacts);
                boolean bl = true;
                return bl;
            }
            catch (IOException iox) {
                if (iox.toString().indexOf(Constants.SYSTEM_ERROR_DISK_SPACE) != -1) {
                    this._errorCode = 1;
                } else {
                    Utilities.logData("blew up writing PIM cache: " + iox.toString());
                    this._errorText = iox.toString();
                }
                boolean bl = false;
                return bl;
            }
            catch (Throwable t) {
                Utilities.logData("blew up writing PIM cache: " + t.toString());
                this._errorText = t.toString();
                boolean bl = false;
                try {
                    pimEnum.close();
                }
                catch (Exception x) {
                    // empty catch block
                }
                return bl;
            }
            finally {
                try {
                    pimEnum.close();
                }
                catch (Exception x) {}
            }
        }

        public static interface Listener {
            public void PimCacherProgress(int var1);
        }
    }

    private static class ContactEnumeration {
        private boolean initialized = false;
        private PIM pim;
        private int listCount;
        private ContactList[] lists;
        private Enumeration[] enums;
        private ContactInfoDetails[] curContacts;

        private ContactEnumeration() {
        }

        public void initialize() throws PIMException {
            this.pim = PIM.getInstance();
            String[] listNames = this.pim.listPIMLists(1);
            this.listCount = listNames.length;
            this.lists = new ContactList[this.listCount];
            this.enums = new Enumeration[this.listCount];
            this.curContacts = new ContactInfoDetails[this.listCount];
            this.initialized = true;
            for (int listIdx = 0; listIdx < this.listCount; ++listIdx) {
                Enumeration en;
                ContactList list;
                this.lists[listIdx] = list = (ContactList)this.pim.openPIMList(1, 1, listNames[listIdx]);
                this.enums[listIdx] = en = list.items();
                this.popFromList(listIdx);
            }
        }

        private void popFromList(int listIdx) {
            ContactList list = this.lists[listIdx];
            Enumeration en = this.enums[listIdx];
            this.curContacts[listIdx] = en.hasMoreElements() ? ContactInfoDetails.loadFromPIM(list, (Contact)en.nextElement()) : null;
        }

        public boolean hasMoreElements() throws PIMException {
            if (!this.initialized) {
                this.initialize();
            }
            for (int listIdx = 0; listIdx < this.listCount; ++listIdx) {
                ContactInfoDetails curContact = this.curContacts[listIdx];
                if (curContact == null) continue;
                return true;
            }
            return false;
        }

        public ContactInfoDetails nextElement() throws PIMException {
            ContactInfoDetails nextContact = null;
            int nextContactListIdx = -1;
            for (int listIdx = 0; listIdx < this.listCount; ++listIdx) {
                ContactInfoDetails curContact = this.curContacts[listIdx];
                if (curContact == null || nextContact != null && curContact.compareTo(nextContact) >= 0) continue;
                nextContact = curContact;
                nextContactListIdx = listIdx;
            }
            if (nextContact == null) {
                throw new NoSuchElementException();
            }
            this.popFromList(nextContactListIdx);
            return nextContact;
        }

        public void close() throws PIMException {
            if (!this.initialized) {
                return;
            }
            PIMException throwEx = null;
            for (int listIdx = 0; listIdx < this.listCount; ++listIdx) {
                ContactList list = this.lists[listIdx];
                if (list == null) continue;
                try {
                    list.close();
                    continue;
                }
                catch (PIMException ex) {
                    throwEx = ex;
                }
            }
            if (throwEx != null) {
                throw throwEx;
            }
        }
    }

    public static class Comparator
    implements Sort.Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 == null && o2 != null) {
                return 1;
            }
            if (o1 != null && o2 == null) {
                return -1;
            }
            if (o1 == null && o2 == null) {
                return 0;
            }
            ContactInfoDetails cid1 = (ContactInfoDetails)o1;
            ContactInfoDetails cid2 = (ContactInfoDetails)o2;
            return cid1.compareTo(cid2);
        }
    }
}

