/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.contacts;

import com.whatsapp.api.contacts.ContactStatusPIMKey;
import com.whatsapp.api.contacts.ContactTempDetails;
import com.whatsapp.api.contacts.Syncer;
import com.whatsapp.api.util.Serializer;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.Constants;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class ContactFileSystemStore {
    public static String getRoot() {
        return System.getProperty(Constants.PROPERTY_FILECONN_PRIVATE_DIR) + "cache/";
    }

    private static String getTempDetailsRoot() {
        return ContactFileSystemStore.getRoot() + "tempDetails/";
    }

    private static String getPhoneRoot() {
        return ContactFileSystemStore.getRoot() + "byPhone/";
    }

    private static String getJidRoot() {
        return ContactFileSystemStore.getRoot() + "byJid/";
    }

    private static String getStatusRoot() {
        return ContactFileSystemStore.getRoot() + "status/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setUpRoot(String rootPath) {
        FileConnection fileC = null;
        try {
            fileC = (FileConnection)Connector.open((String)rootPath, (int)3);
            if (!fileC.exists()) {
                fileC.mkdir();
            }
        }
        catch (Throwable t) {
            Utilities.logData("set up root fail on root " + rootPath + " : " + t.toString());
        }
        finally {
            try {
                if (fileC != null) {
                    fileC.close();
                }
            }
            catch (Exception x) {}
        }
    }

    public static void setUpRoots() {
        ContactFileSystemStore.setUpRoot(ContactFileSystemStore.getRoot());
        ContactFileSystemStore.setUpRoot(ContactFileSystemStore.getTempDetailsRoot());
        ContactFileSystemStore.setUpRoot(ContactFileSystemStore.getPhoneRoot());
        ContactFileSystemStore.setUpRoot(ContactFileSystemStore.getJidRoot());
        ContactFileSystemStore.setUpRoot(ContactFileSystemStore.getStatusRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String getDataFromFile(String fullFile) {
        String string;
        InputStream is;
        FileConnection fileC;
        block28: {
            block26: {
                String string2;
                block27: {
                    fileC = null;
                    is = null;
                    fileC = (FileConnection)Connector.open((String)fullFile, (int)1);
                    if (fileC.exists()) break block26;
                    string2 = null;
                    if (is == null) break block27;
                    try {
                        is.close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                if (fileC != null) {
                    try {
                        fileC.close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                return string2;
            }
            byte[] rawData = new byte[(int)fileC.fileSize()];
            is = fileC.openInputStream();
            is.read(rawData);
            string = new String(rawData, Constants.CHARSET_UTF8);
            if (is == null) break block28;
            try {
                is.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (fileC != null) {
            try {
                fileC.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        return string;
        catch (Throwable t) {
            try {
                Utilities.logData("error reading file " + fullFile + " = " + t.toString());
                String string3 = null;
                return string3;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception x) {}
                }
                if (fileC != null) {
                    try {
                        fileC.close();
                    }
                    catch (Exception x) {}
                }
            }
        }
    }

    private static ContactTempDetails getCTPFromFile(String fullFile) {
        return (ContactTempDetails)ContactFileSystemStore.getFromFile(fullFile, ContactTempDetails.SERIALIZER);
    }

    private static ContactStatusPIMKey getCSPKFromFile(String fullFile) {
        return (ContactStatusPIMKey)ContactFileSystemStore.getFromFile(fullFile, ContactStatusPIMKey.SERIALIZER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Object getFromFile(String fullFile, Serializer serializer) {
        Object object;
        FilterInputStream dIS;
        InputStream is;
        FileConnection fileC;
        block39: {
            block37: {
                Object var5_5;
                block38: {
                    fileC = null;
                    is = null;
                    dIS = null;
                    fileC = (FileConnection)Connector.open((String)fullFile, (int)1);
                    if (fileC.exists()) break block37;
                    var5_5 = null;
                    if (dIS == null) break block38;
                    try {
                        dIS.close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                if (fileC != null) {
                    try {
                        fileC.close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                return var5_5;
            }
            is = fileC.openInputStream();
            dIS = new DataInputStream(is);
            object = serializer.unserializeFromDIS((DataInputStream)dIS);
            if (dIS == null) break block39;
            try {
                dIS.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (fileC != null) {
            try {
                fileC.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        return object;
        catch (Throwable t) {
            try {
                Utilities.logData("error reading file " + fullFile + " = " + t.toString());
                Object var6_14 = null;
                return var6_14;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (dIS != null) {
                    try {
                        dIS.close();
                    }
                    catch (Exception x) {}
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception x) {}
                }
                if (fileC != null) {
                    try {
                        fileC.close();
                    }
                    catch (Exception x) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean putDataToFile(String fullFile, String payload) throws Syncer.SyncerError {
        FileConnection fileC = null;
        OutputStream os = null;
        if (payload == null) {
            return false;
        }
        try {
            fileC = (FileConnection)Connector.open((String)fullFile, (int)3);
            if (!fileC.exists()) {
                fileC.create();
            }
            os = fileC.openOutputStream(0L);
            byte[] bytes = payload.getBytes(Constants.CHARSET_UTF8);
            os.write(bytes);
            os.flush();
            fileC.truncate((long)bytes.length);
            boolean bl = true;
            return bl;
        }
        catch (IOException iox) {
            if (iox.toString().indexOf(Constants.SYSTEM_ERROR_DISK_SPACE) != -1) {
                if (fileC != null) {
                    Utilities.logData("out of space seen in CFStore, system avail says " + fileC.availableSize());
                }
                throw new Syncer.SyncerError(1, Constants.STRING_EMPTY_STRING);
            }
            Utilities.logData("cache error writing file " + fullFile + " = " + iox.toString());
            boolean bl = false;
            return bl;
        }
        catch (IllegalArgumentException nameX) {
            boolean bl = false;
            return bl;
        }
        catch (Throwable t) {
            boolean bl;
            block36: {
                Utilities.logData("cache error writing file " + fullFile + " = " + t.toString());
                bl = false;
                if (os == null) break block36;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    os.close();
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            if (fileC != null) {
                try {
                    fileC.close();
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            return bl;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception x) {}
            }
            if (fileC != null) {
                try {
                    fileC.close();
                }
                catch (Exception x) {}
            }
        }
    }

    private static boolean putCTPToFile(String fullFile, ContactTempDetails ctp) throws Syncer.SyncerError {
        return ContactFileSystemStore.putToFile(fullFile, ctp, ContactTempDetails.SERIALIZER);
    }

    private static boolean putCSPKToFile(String fullFile, ContactStatusPIMKey cspk) throws Syncer.SyncerError {
        return ContactFileSystemStore.putToFile(fullFile, cspk, ContactStatusPIMKey.SERIALIZER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean putToFile(String fullFile, Object obj, Serializer serializer) throws Syncer.SyncerError {
        FileConnection fileC = null;
        OutputStream os = null;
        FilterOutputStream dOS = null;
        if (obj == null) {
            return false;
        }
        try {
            fileC = (FileConnection)Connector.open((String)fullFile, (int)3);
            if (!fileC.exists()) {
                fileC.create();
            }
            fileC.truncate(0L);
            os = fileC.openOutputStream(0L);
            dOS = new DataOutputStream(os);
            serializer.serializeToDOS(obj, (DataOutputStream)dOS);
            ((DataOutputStream)dOS).flush();
            boolean bl = true;
            return bl;
        }
        catch (IOException iox) {
            if (iox.toString().indexOf(Constants.SYSTEM_ERROR_DISK_SPACE) != -1) {
                if (fileC != null) {
                    Utilities.logData("out of space seen in CFStore, system avail says " + fileC.availableSize());
                }
                throw new Syncer.SyncerError(1, Constants.STRING_EMPTY_STRING);
            }
            Utilities.logData("cache error writing file " + fullFile + " = " + iox.toString());
            boolean bl = false;
            return bl;
        }
        catch (IllegalArgumentException nameX) {
            boolean bl = false;
            return bl;
        }
        catch (Throwable t) {
            boolean bl;
            block48: {
                Utilities.logData("cache error writing file " + fullFile + " = " + t.toString());
                bl = false;
                if (dOS == null) break block48;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    dOS.close();
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            if (fileC != null) {
                try {
                    fileC.close();
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            return bl;
        }
        finally {
            if (dOS != null) {
                try {
                    dOS.close();
                }
                catch (Exception x) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception x) {}
            }
            if (fileC != null) {
                try {
                    fileC.close();
                }
                catch (Exception x) {}
            }
        }
    }

    public static boolean storeByPhone(String phone, String payload) throws Syncer.SyncerError {
        String fullFile = ContactFileSystemStore.getPhoneRoot() + phone;
        return ContactFileSystemStore.putDataToFile(fullFile, payload);
    }

    public static boolean storeByJid(String jid, String payload) throws Syncer.SyncerError {
        String fullFile = ContactFileSystemStore.getJidRoot() + jid;
        return ContactFileSystemStore.putDataToFile(fullFile, payload);
    }

    public static String getByPhone(String phone) {
        String fullFile = ContactFileSystemStore.getPhoneRoot() + phone;
        return ContactFileSystemStore.getDataFromFile(fullFile);
    }

    public static String getByJid(String jid) {
        String fullFile = ContactFileSystemStore.getJidRoot() + jid;
        return ContactFileSystemStore.getDataFromFile(fullFile);
    }

    public static ContactStatusPIMKey getStatusPIMKeyByJid(String jid) {
        String fullFile = ContactFileSystemStore.getStatusRoot() + jid;
        return ContactFileSystemStore.getCSPKFromFile(fullFile);
    }

    public static boolean storeStatusPIMKeyByJid(String jid, ContactStatusPIMKey cspk) throws Syncer.SyncerError {
        String fullFile = ContactFileSystemStore.getStatusRoot() + jid;
        return ContactFileSystemStore.putCSPKToFile(fullFile, cspk);
    }

    public static ContactTempDetails getTempDetailsByPhone(String phone) {
        String fullFile = ContactFileSystemStore.getTempDetailsRoot() + phone;
        return ContactFileSystemStore.getCTPFromFile(fullFile);
    }

    public static boolean storeTempDetailsByPhone(String phone, ContactTempDetails ctp) throws Syncer.SyncerError {
        String fullFile = ContactFileSystemStore.getTempDetailsRoot() + phone;
        return ContactFileSystemStore.putCTPToFile(fullFile, ctp);
    }
}

