/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.contacts;

import com.whatsapp.api.contacts.ContactFileSystemStore;
import com.whatsapp.api.contacts.ContactInfoDetails;
import com.whatsapp.api.contacts.ContactPIMKey;
import com.whatsapp.api.contacts.ContactStatusDetails;
import com.whatsapp.api.contacts.ContactStatusPIMKey;
import com.whatsapp.api.contacts.ContactTempDetails;
import com.whatsapp.api.contacts.Favorites;
import com.whatsapp.api.contacts.Syncer;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.Constants;
import com.whatsapp.client.Settings;
import com.whatsapp.org.it.yup.xml.KXmlParser;
import com.whatsapp.org.xmlpull.v1.XmlPullParserException;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpsConnection;
import javax.microedition.io.file.FileConnection;
import javax.microedition.rms.RecordStoreException;

public class ColdSyncer
extends Syncer {
    private static final int CHUNK_SIZE = 100;
    private static final int SETUP_PERCENT_SPAN = 20;
    private static final int CLEANUP_PERCENT_SPAN = 6;
    private static final int SYNC_HALF_PERCENT_SPAN = 74;
    private Syncer.Listener _listener;
    private boolean _firstTime;
    private boolean _accurateProgress = false;
    private int _contactsExpected;
    private int _chunksExpected;
    private String _jid;
    Favorites _favs = new Favorites();
    int _outPhoneCount = 0;
    int _lastAlertedPercent = 0;
    int _totalAlertTicks = 0;
    int _totalPhones = 0;
    long _mostRecentChange = Long.MAX_VALUE;

    public ColdSyncer(Syncer.Listener listener, String countryCode, String phoneNumber, boolean firstTime, String jid) {
        this._listener = listener;
        this._countryCode = countryCode;
        this._phoneNumber = phoneNumber;
        this._firstTime = firstTime;
        this._jid = jid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        HttpsConnection httpsConn = null;
        FileConnection fileC = null;
        InputStream is = null;
        FilterInputStream dIS = null;
        OutputStream httpOS = null;
        InputStream httpIS = null;
        int chunkSpan = 0;
        boolean oneGoodChunk = false;
        boolean oneFailedChunk = false;
        String errorText = Constants.STRING_EMPTY_STRING;
        byte errorCode = 0;
        String filename = null;
        try {
            ColdSyncer.addRunningSync();
            ContactFileSystemStore.setUpRoots();
            boolean res = this._favs.initialize();
            if (res) {
                Utilities.logData("cold sync initialized favorites");
            } else {
                Utilities.logData("cold sync failed to init favs");
            }
            this._listener.syncProgress(5);
            Runtime r = Runtime.getRuntime();
            long prePimFree = r.freeMemory();
            this._contactsExpected = ColdSyncer.getContactsExpectedCount();
            if (this._contactsExpected > 0) {
                this._accurateProgress = true;
                this._chunksExpected = this._contactsExpected / 100;
                if (this._contactsExpected % 100 > 0) {
                    ++this._chunksExpected;
                }
                chunkSpan = 74 / this._chunksExpected;
                Utilities.logData("cold sync expecting contacts total: " + this._contactsExpected + " chunks: " + this._chunksExpected);
            }
            this._listener.syncProgress(10);
            filename = ContactInfoDetails.CID_FILE_STORAGE;
            fileC = (FileConnection)Connector.open((String)filename, (int)1);
            if (!fileC.exists()) {
                throw new IllegalStateException(filename + " missing");
            }
            is = fileC.openInputStream();
            dIS = new DataInputStream(is);
            long postPimAndContactsFree = r.freeMemory();
            Utilities.logData("cold sync contacts, mem " + prePimFree + Constants.STRING_ARROW + postPimAndContactsFree);
            this._listener.syncProgress(20);
            boolean endOfPIMReached = false;
            int pimIdx = -1;
            int chunkCount = 0;
            while (!endOfPIMReached) {
                httpsConn = (HttpsConnection)Connector.open((String)Utilities.decodeString(Constants.URL_QUERY_STATUS), (int)3, (boolean)true);
                httpsConn.setRequestProperty(Constants.HTTP_REQUEST_PROPERTY_USER_AGENT, ColdSyncer.getUserAgent());
                httpsConn.setRequestMethod("POST");
                httpsConn.setRequestProperty(Constants.HTTP_REQUEST_PROPERTY_CONTENT_TYPE, Constants.HTTP_REQUEST_PROPERTY_CONTENT_TYPE_VALUE_FORM_URL_ENCODED);
                long postHttpsConnOpen = r.freeMemory();
                Utilities.logData("cold sync mem opened httpsconn and headers " + postPimAndContactsFree + Constants.STRING_ARROW + postHttpsConnOpen);
                httpOS = httpsConn.openOutputStream();
                Syncer.UTF8URLEncoder.appendPair("v", "3", false, httpOS);
                Syncer.UTF8URLEncoder.appendPair("cc", this._countryCode, false, httpOS);
                Syncer.UTF8URLEncoder.appendPair("me", this._phoneNumber, false, httpOS);
                int curChunkContactCount = 0;
                int curChunkPhoneCount = 0;
                if (chunkCount == 0) {
                    Syncer.UTF8URLEncoder.appendPair("u[]", this._phoneNumber, false, httpOS);
                    ++curChunkContactCount;
                    ++curChunkPhoneCount;
                    if (this._firstTime) {
                        Syncer.UTF8URLEncoder.appendPair("bbfr", "1", false, httpOS);
                    }
                }
                try {
                    while (curChunkContactCount < 100) {
                        int newPercent;
                        ContactInfoDetails newCID = ContactInfoDetails.unserializeFromDIS((DataInputStream)dIS);
                        ++pimIdx;
                        int phoneCount = newCID._phones.length;
                        for (int i = 0; i < phoneCount; ++i) {
                            String curPhone = newCID._phones[i];
                            ContactTempDetails tempDetails = new ContactTempDetails(new ContactPIMKey(pimIdx, i), newCID.getFullName(), newCID._phoneCats[i]);
                            if (!ContactFileSystemStore.storeTempDetailsByPhone(curPhone, tempDetails)) continue;
                            Syncer.UTF8URLEncoder.appendPair("u[]", curPhone, true, httpOS);
                            ++this._totalPhones;
                            ++curChunkPhoneCount;
                        }
                        if (this._accurateProgress) {
                            newPercent = 20 + chunkCount * chunkSpan + curChunkContactCount * chunkSpan / 200;
                        } else {
                            ++this._totalAlertTicks;
                            newPercent = 20 + ContactInfoDetails.PIMCacher.logScaledPercentage(this._totalAlertTicks, 200) * 74 / 100;
                        }
                        if (newPercent > this._lastAlertedPercent + 1) {
                            this._listener.syncProgress(newPercent);
                            this._lastAlertedPercent = newPercent;
                        }
                        ++curChunkContactCount;
                    }
                }
                catch (EOFException eofx) {
                    Utilities.logData("reached end of CID storage found phone count " + this._totalPhones);
                    endOfPIMReached = true;
                }
                if (curChunkContactCount > 0) {
                    httpOS.flush();
                    Utilities.logData("cold sync sent http query, numbers: " + curChunkPhoneCount);
                    int responseCode = httpsConn.getResponseCode();
                    httpOS.close();
                    httpOS = null;
                    if (responseCode == 200) {
                        Utilities.logData("cold sync got http ok");
                        httpIS = httpsConn.openInputStream();
                        try {
                            this.parseChunkHttpResults(httpIS, chunkCount, chunkSpan, curChunkPhoneCount);
                            oneGoodChunk = true;
                        }
                        catch (Syncer.SyncerError sx) {
                            oneFailedChunk = true;
                            throw sx;
                        }
                        catch (Throwable t) {
                            oneFailedChunk = true;
                        }
                    } else {
                        Utilities.logData("cold sync encountered http error " + responseCode);
                        oneFailedChunk = true;
                    }
                } else {
                    oneGoodChunk = true;
                }
                if (httpIS != null) {
                    httpIS.close();
                    httpIS = null;
                }
                if (httpOS != null) {
                    httpOS.close();
                    httpOS = null;
                }
                httpsConn.close();
                httpsConn = null;
                ++chunkCount;
            }
            this._listener.syncProgress(94);
        }
        catch (Syncer.SyncerError sx) {
            errorCode = sx.errorCode;
            errorText = sx.getMessage();
        }
        catch (Throwable t) {
            Utilities.logData("blew up in sync: " + t.toString());
            errorText = t.toString();
            this._mostRecentChange = 0L;
        }
        finally {
            this._favs.saveToDisk();
            if (dIS != null) {
                try {
                    dIS.close();
                }
                catch (Exception x) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception x) {}
            }
            if (fileC != null) {
                try {
                    fileC.close();
                }
                catch (Exception x) {}
            }
            if (httpIS != null) {
                try {
                    httpIS.close();
                }
                catch (Exception x) {}
            }
            if (httpOS != null) {
                try {
                    httpOS.close();
                }
                catch (Exception x) {}
            }
            if (httpsConn != null) {
                try {
                    httpsConn.close();
                }
                catch (Exception x) {}
            }
            ColdSyncer.stopRunningSync();
            this._listener.coldSyncFinished(this._mostRecentChange, oneGoodChunk, this._firstTime, errorCode, errorText);
        }
    }

    private void parseChunkHttpResults(InputStream httpIS, int chunkCount, int chunkSpan, int curChunkTotalPhones) throws UnsupportedEncodingException, XmlPullParserException, IOException, Syncer.SyncerError {
        KXmlParser parser = new KXmlParser();
        Utilities.logData("parsing chunk result for chunk " + chunkCount + " with total phones " + curChunkTotalPhones + "  || chunk progress span is " + chunkSpan);
        InputStreamReader reader = new InputStreamReader(httpIS, Constants.CHARSET_UTF8);
        parser.setInput(reader);
        parser.nextTag();
        parser.require(2, null, "statusreport");
        parser.nextTag();
        int curChunkPhoneCount = 0;
        while (parser.getEventType() != 3) {
            int newPercent;
            ContactTempDetails tempDetails;
            ++curChunkPhoneCount;
            ContactStatusDetails newCSD = ColdSyncer.parseXMLEntry(parser);
            boolean isMe = newCSD._jid.equals(this._jid);
            if (isMe) {
                try {
                    Settings.set(11, newCSD._status);
                }
                catch (RecordStoreException ex) {
                    // empty catch block
                }
            }
            if ((tempDetails = ContactFileSystemStore.getTempDetailsByPhone(newCSD._phoneNumber)) == null) {
                Utilities.logData("error retrieving temp record for parsed phone " + newCSD._phoneNumber);
                continue;
            }
            if (!newCSD._isHoldout) {
                if (!isMe) {
                    this._favs.autoAdd(newCSD._jid);
                }
                if (newCSD._timeSinceSet < this._mostRecentChange) {
                    this._mostRecentChange = newCSD._timeSinceSet;
                }
            }
            ContactStatusPIMKey cspk = new ContactStatusPIMKey(newCSD._status, tempDetails._legacyCategory, tempDetails._pimKey);
            ContactFileSystemStore.storeByJid(newCSD._jid, tempDetails._readableName);
            ContactFileSystemStore.storeStatusPIMKeyByJid(newCSD._jid, cspk);
            ContactFileSystemStore.storeByPhone(newCSD._phoneNumber, newCSD._jid);
            ++this._outPhoneCount;
            if (this._accurateProgress) {
                newPercent = 20 + chunkCount * chunkSpan + chunkSpan / 2 + curChunkPhoneCount * chunkSpan / (curChunkTotalPhones * 2);
            } else {
                ++this._totalAlertTicks;
                newPercent = 20 + ContactInfoDetails.PIMCacher.logScaledPercentage(this._totalAlertTicks, 200) * 74 / 100;
            }
            if (newPercent <= this._lastAlertedPercent + 1) continue;
            this._listener.syncProgress(newPercent);
            this._lastAlertedPercent = newPercent;
        }
    }

    public static int getContactsExpectedCount() {
        try {
            return ContactInfoDetails.db.size();
        }
        catch (Throwable t) {
            Utilities.logData("couldn't get pim count before cold sync on: " + t.toString());
            return 0;
        }
    }
}

